/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpls.pwoam;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.uflight.qxprotocol.definitions.Output;

class PwOamState {
    private String pwIndex;
    private String localRunState = "-";
    private String localTroubleType = "-";
    private String localDisableTime = "-";
    private String localTroublePosition = "255.255.255.255";
    private String remoteRunState = "-";
    private String remoteTroubleType = "-";
    private String remoteDisableTime = "-";
    private String remoteTroublePosition = "255.255.255.255";

    public PwOamState(Output[] outputs) {
        for (int j = 0; j < outputs.length; ++j) {
            this.pwIndex = outputs[j].getPartValue("pwIndex");
            if (this.pwIndex == null) continue;
            String localRemoteState = outputs[j].getPartValue("localRemoteState");
            if (localRemoteState.equalsIgnoreCase("0") || localRemoteState.equalsIgnoreCase("1") || localRemoteState.equalsIgnoreCase("2") || localRemoteState.equalsIgnoreCase("3") || localRemoteState.equalsIgnoreCase("4")) {
                this.localRunState = outputs[j].getPartValue("localRemoteState");
                this.localTroubleType = outputs[j].getPartValue("defectType");
                this.localDisableTime = outputs[j].getPartValue("unalvailableTime");
                this.localTroublePosition = IPAddressUtil.convertIPLongToStr((long)Long.parseLong(outputs[j].getPartValue("defectPosition")));
                continue;
            }
            this.remoteRunState = outputs[j].getPartValue("localRemoteState");
            this.remoteTroubleType = outputs[j].getPartValue("defectType");
            this.remoteDisableTime = outputs[j].getPartValue("unalvailableTime");
            this.remoteTroublePosition = IPAddressUtil.convertIPLongToStr((long)Long.parseLong(outputs[j].getPartValue("defectPosition")));
        }
    }

    public void setOutputParam(BussinessParams bp) {
        for (int i = 0; i < bp.getRowParamsCount(); ++i) {
            String pwIndexParam = bp.getRowParams(i).getParam("pwIndex").getValue();
            if (pwIndexParam == null || !this.pwIndex.equalsIgnoreCase(pwIndexParam)) continue;
            bp.getRowParams(i).getParam("localRunState").setValue(this.localRunState);
            bp.getRowParams(i).getParam("localTroubleType").setValue(this.localTroubleType);
            bp.getRowParams(i).getParam("localDisableTime").setValue(this.localDisableTime);
            bp.getRowParams(i).getParam("localTroublePosition").setValue(this.localTroublePosition);
            bp.getRowParams(i).getParam("remoteRunState").setValue(this.remoteRunState);
            bp.getRowParams(i).getParam("remoteTroubleType").setValue(this.remoteTroubleType);
            bp.getRowParams(i).getParam("remoteDisableTime").setValue(this.remoteDisableTime);
            bp.getRowParams(i).getParam("remoteTroublePosition").setValue(this.remoteTroublePosition);
            return;
        }
    }
}

