/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpls.mspw;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;

public class TEMSPWCreateBean
extends TENEExplorerBean {
    private static final String CES_SERVICE = "1";
    private static final String ATM_SERVICE = "2";
    private static final String ETH_SERVICE = "3";
    private static final int SERVICE_TYPE_ROW_INDEX = 2;
    private static final String FORWARD_PW = "0";
    private static final String BACKWARD_PW = "1";
    private static final String EGRESS_DIRCTION = "2";
    private static final int CREATE_MSPW_INPUT_ROW_INDEX = 2;
    private static final String SET_LSP_MODE_CMD = "NSCMD_PTN_QOS_SET_PW_LSPMODE";
    private static final String DO_NOT_AUTO_PW_INDEX = "0";
    private ArrayList<Operation> createPWOperList = new ArrayList();
    private ArrayList<Operation> setPWParaOperList = new ArrayList();
    private ArrayList<Operation> createMSPWOperList = new ArrayList();
    private String fpwindex = "";
    private String bpwindex = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.operationList = new ArrayList();
            this.outputData = new Datainterface();
            int result = this.createPW();
            if (result == 0) {
                result = this.setPWParam();
                if (result == 0) {
                    result = this.createMSPW();
                    if (result != 0) {
                        this.handleMessage(neid, this.createMSPWOperList, subFunc);
                    }
                } else {
                    this.handleMessage(neid, this.setPWParaOperList, subFunc);
                }
            } else {
                this.handleMessage(neid, this.createPWOperList, subFunc);
            }
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errList = new ArrayList<Integer>();
        errList.add(42293);
        return errList;
    }

    private int createPW() {
        this.createPWOperList.clear();
        RowParams[] rParams = this.inputData.getBussinessParams().getRowParams();
        if (rParams.length == 0) {
            return 2;
        }
        Param serviceTypeParam = rParams[2].getParam("servicetype");
        if (null == serviceTypeParam) {
            return 2;
        }
        String serviceType = serviceTypeParam.getValue();
        ArrayList<String> createPWList = new ArrayList<String>();
        createPWList.add("NSCMD_PTN_MPLS_PW_ADD_STCUCPW");
        createPWList.add("NSCMD_PTN_MPLS_PW_BOUND_EGRESS_TNL");
        ArrayList<String> setPWParamList = this.getSetPWParamOperList(serviceType);
        Datainterface pwInputData = new Datainterface();
        pwInputData.setBussinessParams(new BussinessParams());
        for (int i = 0; i < rParams.length; ++i) {
            Param pwSignalTypeParam = rParams[i].getParam("pwSignalType");
            if (null == pwSignalTypeParam) continue;
            pwInputData.getBussinessParams().clearRowParams();
            pwInputData.getBussinessParams().addRowParams(rParams[i]);
            ArrayList onePWOperList = TEDataConverter.convertToOperation(null, (Datainterface)pwInputData, (int)this.neid, (ArrayList)((ArrayList)createPWList.clone()));
            this.createPWOperList.addAll(onePWOperList);
            ArrayList onePWParamOperList = TEDataConverter.convertToOperation(null, (Datainterface)pwInputData, (int)this.neid, (ArrayList)((ArrayList)setPWParamList.clone()));
            this.setPWParaOperList.addAll(onePWParamOperList);
        }
        if (this.createPWOperList.isEmpty()) {
            return 2;
        }
        Operation transBegin = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_TRANSACTION_BEGIN");
        Operation transEnd = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_TRANSACTION_END");
        this.createPWOperList.add(0, transBegin);
        this.createPWOperList.add(transEnd);
        int result = this.sendMessage(this.neid, this.createPWOperList);
        if (result == 0) {
            return this.handleCreatePWMessage(this.createPWOperList);
        }
        return result;
    }

    private ArrayList<String> getSetPWParamOperList(String mspwServiceType) {
        String[] neVersions;
        ArrayList<String> operNameList = new ArrayList<String>();
        operNameList.add("NSCMD_CFG_TRANSACTION_BEGIN");
        boolean addCommandFlag = true;
        TENE currentNE = TENEListMgr.getInstance().getNE(this.neid);
        int neType = currentNE.getNEType();
        if ((neType == 76 || neType == 77 || neType == 114 || neType == 83 || neType == 95) && ((neVersions = currentNE.getShowNEVersion().split("\\.")).length > 3 && neVersions[2].compareTo("03") > 0 || "03".equals(neVersions[2]) && neVersions[3].compareTo("30") >= 0)) {
            addCommandFlag = false;
        }
        if (addCommandFlag) {
            operNameList.add("NSCMD_PTN_QOS_SET_PW_EXP");
        }
        if (!"1".equals(mspwServiceType)) {
            Operation setCWVCCVOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_SET_CW_VCCV");
            if (null != setCWVCCVOper) {
                operNameList.add("NSCMD_PTN_MPLS_PW_SET_CW_VCCV");
            } else {
                operNameList.add("NSCMD_PTN_MPLS_PW_SET_CW");
                operNameList.add("NSCMD_PTN_MPLS_PW_SET_VCCV");
            }
        } else {
            operNameList.add("NSCMD_PTN_MPLS_PW_SET_CES_RTPEN");
            operNameList.add(" NSCMD_PTN_MPLS_PW_SET_CES_EMULPARA");
            operNameList.add(" NSCMD_PTN_MPLS_PW_SET_CES_LOADTIME");
            operNameList.add(" NSCMD_PTN_MPLS_PW_SET_CES_JITTER");
            operNameList.add("NSCMD_PTN_MPLS_PW_SET_CES_SNMODE");
        }
        if ("2".equals(mspwServiceType)) {
            operNameList.add(" NSCMD_PTN_MPLS_PW_SET_ATM_CONCAT");
        }
        if (ETH_SERVICE.equals(mspwServiceType) || "2".equals(mspwServiceType)) {
            operNameList.add(" NSCMD_PTN_QOS_CRT_PW_QUEUE");
            operNameList.add(" NSCMD_PTN_MPLS_PW_SET_ETH_REQVLAN");
        }
        operNameList.add("NSCMD_CFG_TRANSACTION_END");
        return operNameList;
    }

    private int handleCreatePWMessage(List<Operation> operList) {
        int transactionCode = this.getTransactionErrorCode(operList);
        if (0 != transactionCode) {
            return 2;
        }
        this.fpwindex = this.getPWIndex(operList, "0");
        this.bpwindex = this.getPWIndex(operList, "1");
        if ("".equals(this.fpwindex) || "".equals(this.bpwindex)) {
            return 2;
        }
        Operation pwParamOper = null;
        String partName = "";
        int size = this.setPWParaOperList.size();
        for (int i = 0; i < size; ++i) {
            pwParamOper = this.setPWParaOperList.get(i);
            String cmdName = pwParamOper.getName();
            Part[] paramPartArr = pwParamOper.getInput().getPart();
            for (int j = 0; j < paramPartArr.length; ++j) {
                partName = paramPartArr[j].getName();
                if (partName.toLowerCase().indexOf("auto") != -1) {
                    paramPartArr[j].setValue("0");
                    continue;
                }
                if (!partName.equalsIgnoreCase("pwIndex")) continue;
                if ("0".equals(paramPartArr[j].getValue())) {
                    paramPartArr[j].setValue(this.fpwindex);
                    continue;
                }
                paramPartArr[j].setValue(this.bpwindex);
            }
            if (!SET_LSP_MODE_CMD.equals(cmdName)) continue;
            pwParamOper.getInput().setPartValue("direction", "2");
        }
        this.createMSPWOperList.clear();
        Operation createMSPWOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_ADD_MSPW");
        this.fillOperData(createMSPWOper, this.inputData.getBussinessParams().getRowParams()[2]);
        createMSPWOper.getInput().setPartValue("fpwindex", this.fpwindex);
        createMSPWOper.getInput().setPartValue("bpwindex", this.bpwindex);
        Operation setMSPWNameOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_SET_MSPWNAME");
        this.fillOperData(setMSPWNameOper, this.inputData.getBussinessParams().getRowParams()[2]);
        Operation transBegin = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_TRANSACTION_BEGIN");
        Operation transEnd = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_TRANSACTION_END");
        this.createMSPWOperList.add(transBegin);
        this.createMSPWOperList.add((Operation)createMSPWOper.clone());
        this.createMSPWOperList.add((Operation)setMSPWNameOper.clone());
        this.createMSPWOperList.add(transEnd);
        return 0;
    }

    private int setPWParam() {
        if (this.setPWParaOperList.isEmpty()) {
            return 2;
        }
        int result = this.sendMessage(this.neid, this.setPWParaOperList);
        if (result != 0) {
            return result;
        }
        return this.handleSetPWParamMessage(this.setPWParaOperList);
    }

    private int handleSetPWParamMessage(List<Operation> operList) {
        Operation oper = null;
        int size = operList.size();
        for (int i = 0; i < size; ++i) {
            oper = operList.get(i);
            String operName = oper.getName();
            if ("NSCMD_CFG_TRANSACTION_BEGIN".equals(operName) || "NSCMD_CFG_TRANSACTION_END".equals(operName)) continue;
            String errCode = oper.getOutput()[0].getFault()[0].getCode();
            if (String.valueOf(0).equals(errCode)) continue;
            this.rollback();
            return 2;
        }
        return 0;
    }

    private int createMSPW() {
        if (this.createMSPWOperList.isEmpty()) {
            this.rollback();
            return 2;
        }
        int result = this.sendMessage(this.neid, this.createMSPWOperList);
        if (result != 0) {
            return result;
        }
        return this.handleCreateMSPW();
    }

    private int handleCreateMSPW() {
        Operation oper = null;
        int size = this.createMSPWOperList.size();
        for (int i = 0; i < size; ++i) {
            String errCode;
            oper = this.createMSPWOperList.get(i);
            String operName = oper.getName();
            if ("NSCMD_CFG_TRANSACTION_BEGIN".equals(operName) || "NSCMD_CFG_TRANSACTION_END".equals(operName) || (errCode = oper.getOutput()[0].getFault()[0].getCode()).equals(String.valueOf(0))) continue;
            this.rollback();
            return 2;
        }
        return 0;
    }

    private void fillOperData(Operation oper, RowParams rParams) {
        Part[] partArr = oper.getInput().getPart();
        for (int i = 0; i < partArr.length; ++i) {
            String partName = partArr[i].getName();
            Param param = rParams.getParam(partName);
            if (param == null) continue;
            String partValue = param.getValue();
            partArr[i].setValue(partValue);
        }
    }

    private int getTransactionErrorCode(List<Operation> operList) {
        Operation oper = null;
        int size = operList.size();
        for (int i = 0; i < size; ++i) {
            oper = operList.get(i);
            String operName = oper.getName();
            if (!"NSCMD_CFG_TRANSACTION_END".equals(operName)) continue;
            String errCode = oper.getOutput()[0].getFault()[0].getCode();
            return Integer.valueOf(errCode);
        }
        return 0;
    }

    private String getPWIndex(List<Operation> operList, String pwDirction) {
        String pwId = this.getPWIDFromInput(pwDirction);
        Operation oper = null;
        int size = operList.size();
        for (int i = 0; i < size; ++i) {
            String errCode;
            oper = operList.get(i);
            if (!"NSCMD_PTN_MPLS_PW_ADD_STCUCPW".equals(oper.getName()) || !(errCode = oper.getOutput()[0].getFault()[0].getCode()).equals(String.valueOf(0)) || !oper.getInput().getPartValue("pwID").equals(pwId)) continue;
            return oper.getOutput()[0].getPartValue("pwIndex");
        }
        return "";
    }

    private String getPWIDFromInput(String pwDirection) {
        RowParams[] rParams = this.inputData.getBussinessParams().getRowParams();
        for (int i = 0; i < rParams.length; ++i) {
            Param pwIDParam;
            Param pwDirectionParam = rParams[i].getParam("pwDirection");
            if (null == pwDirectionParam || !pwDirectionParam.getValue().equals(pwDirection) || null == (pwIDParam = rParams[i].getParam("pwId"))) continue;
            return pwIDParam.getValue();
        }
        return "";
    }

    private void rollback() {
        ArrayList<Object> delPWOperList = new ArrayList<Object>();
        Operation delPWOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_DEL_PW");
        Operation transBegin = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_TRANSACTION_BEGIN");
        Operation transEnd = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_TRANSACTION_END");
        delPWOperList.add(transBegin);
        delPWOper.getInput().setPartValue("pwIndex", this.fpwindex);
        delPWOperList.add(delPWOper.clone());
        delPWOper.getInput().setPartValue("pwIndex", this.bpwindex);
        delPWOperList.add(delPWOper.clone());
        delPWOperList.add(transEnd);
        this.sendMessage(this.neid, delPWOperList);
    }
}

