/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpls.mplstpoam;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.security.TESecurityVerify;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEMplsTpOamTunnelSetMep
extends TECommonWriteLogBean {
    private boolean isAllTransactionFalied = false;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            ArrayList results;
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            RowParams[] rows = inputData.getBussinessParams().getRowParams();
            this.modifyInputParams();
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(rows);
            int result = -1;
            if (null != this.operationList && !this.operationList.isEmpty()) {
                result = this.sendMessage(neid);
            }
            if (!(results = this.sendMegidTypeMessage(rows)).isEmpty() && this.operationList != null) {
                if (result == -1) {
                    result = 0;
                }
                this.operationList.addAll(results);
            }
            if (this.operationList == null || this.operationList.isEmpty()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            this.modifyOutputParams();
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    public ArrayList getOperation(RowParams[] rows) {
        ArrayList<Object> operationList = new ArrayList<Object>();
        Operation operation = null;
        RowParams row = null;
        Input input = null;
        String tunnelindex = "";
        String megtype = "";
        for (int i = 0; i < rows.length; ++i) {
            row = rows[i];
            tunnelindex = row.getParam("tunnelindex").getValue();
            megtype = row.getParam("megtype").getValue();
            if (this.isValuable("reversetunnel", row).booleanValue()) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SET_ETHN_TUNNEL_SENDREVERSETUNNEL");
                input = operation.getInput();
                input.setPartValue("tunnelindex", tunnelindex);
                input.setPartValue("reversetunnel", row.getParam("reversetunnel").getValue());
                operationList.add(operation.clone());
            }
            String oamstat = "";
            if (this.isValuable("oamstat", row).booleanValue()) {
                String temmegidtype = row.getParam("temmegidtype").getValue();
                oamstat = row.getParam("oamstat").getValue();
                if ("1".equals(temmegidtype)) {
                    operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_SET_IP_BASED_TPOAM_ENABLE");
                    input = operation.getInput();
                    input.setPartValue("megtype", megtype);
                    input.setPartValue("tunnelindex", tunnelindex);
                    input.setPartValue("oamstat", oamstat);
                } else {
                    operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_ICC_CUSTOMER_TPOAM_ENABLE");
                    input = operation.getInput();
                    input.setPartValue("temmegidtype", temmegidtype);
                    input.setPartValue("megtype", megtype);
                    input.setPartValue("tunnelindex", tunnelindex);
                    input.setPartValue("oamstat", oamstat);
                }
                operationList.add(operation.clone());
            }
            if (this.isValuable("megid", row).booleanValue() && !this.isValuable("megidtype", row).booleanValue()) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_SET_MEGID");
                input = operation.getInput();
                input.setPartValue("megtype", megtype);
                input.setPartValue("tunnelindex", tunnelindex);
                input.setPartValue("megid", row.getParam("megid").getValue());
                operationList.add(operation.clone());
            }
            if (this.isValuable("meglevel", row).booleanValue()) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_SET_MEL");
                input = operation.getInput();
                input.setPartValue("megtype", megtype);
                input.setPartValue("tunnelindex", tunnelindex);
                input.setPartValue("meglevel", row.getParam("meglevel").getValue());
                operationList.add(operation.clone());
            }
            if (this.isValuable("mepormipid", row).booleanValue() && !this.isValuable("megidtype", row).booleanValue()) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_SET_MEPID");
                input = operation.getInput();
                input.setPartValue("megtype", megtype);
                input.setPartValue("tunnelindex", tunnelindex);
                input.setPartValue("mepormipid", row.getParam("mepormipid").getValue());
                operationList.add(operation.clone());
            }
            if (this.isValuable("rmepormipid", row).booleanValue() && !this.isValuable("megidtype", row).booleanValue()) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_SET_PEER_MEPID");
                input = operation.getInput();
                input.setPartValue("megtype", megtype);
                input.setPartValue("tunnelindex", tunnelindex);
                input.setPartValue("rmepormipid", row.getParam("rmepormipid").getValue());
                operationList.add(operation.clone());
            }
            if (this.isValuable("detectionmode", row).booleanValue()) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_SET_CHECKWAY");
                input = operation.getInput();
                input.setPartValue("megtype", megtype);
                input.setPartValue("tunnelindex", tunnelindex);
                input.setPartValue("detectionmode", row.getParam("detectionmode").getValue());
                operationList.add(operation.clone());
            }
            if (this.isValuable("ccpri", row).booleanValue() || this.isValuable("ccperiod", row).booleanValue()) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_SET_MEG_CC");
                input = operation.getInput();
                input.setPartValue("megtype", megtype);
                input.setPartValue("tunnelindex", tunnelindex);
                input.setPartValue("ccperiod", row.getParam("ccperiod").getValue());
                input.setPartValue("ccpri", row.getParam("ccpri").getValue());
                operationList.add(operation.clone());
            }
            if (this.isValuable("lockstatus", row).booleanValue()) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_SET_LCK");
                input = operation.getInput();
                input.setPartValue("megtype", megtype);
                input.setPartValue("megindex", tunnelindex);
                input.setPartValue("lockstatus", row.getParam("lockstatus").getValue());
                operationList.add(operation.clone());
            }
            if (this.isValuable("aisstatus", row).booleanValue()) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_SET_AISEN");
                input = operation.getInput();
                input.setPartValue("megtype", megtype);
                input.setPartValue("tunnelindex", tunnelindex);
                input.setPartValue("aisstatus", row.getParam("aisstatus").getValue());
                operationList.add(operation.clone());
            }
            if (this.isValuable("sdthreshold", row).booleanValue() || this.isValuable("sfthreshold", row).booleanValue()) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_SET_SDSF");
                input = operation.getInput();
                input.setPartValue("megtype", megtype);
                input.setPartValue("tunnelindex", tunnelindex);
                input.setPartValue("sfthreshold", row.getParam("sfthreshold").getValue());
                input.setPartValue("sdthreshold", row.getParam("sdthreshold").getValue());
                operationList.add(operation.clone());
            }
            if (this.isValuable("lsrId", row).booleanValue() || this.isValuable("sendpwID", row).booleanValue()) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_SET_PW_REMOTEPWINFO");
                input = operation.getInput();
                input.setPartValue("tunnelindex", tunnelindex);
                input.setPartValue("lsrId", row.getParam("lsrId").getValue());
                input.setPartValue("sendpwID", row.getParam("sendpwID").getValue());
                operationList.add(operation.clone());
            }
            if (this.isValuable("galenable", row).booleanValue()) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_SET_PW_GALEN");
                input = operation.getInput();
                input.setPartValue("tunnelindex", tunnelindex);
                input.setPartValue("galenable", row.getParam("galenable").getValue());
                if ("1".equals(oamstat)) {
                    operationList.add(0, operation.clone());
                } else {
                    operationList.add(operation.clone());
                }
            }
            if (this.isValuable("lmmode", row).booleanValue()) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_SET_LMMODE");
                input = operation.getInput();
                input.setPartValue("megtype", megtype);
                input.setPartValue("megindex", tunnelindex);
                input.setPartValue("lmmode", row.getParam("lmmode").getValue());
                operationList.add(operation.clone());
            }
            if (!this.isValuable("galmode", row).booleanValue()) continue;
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_SET_GALMODE");
            input = operation.getInput();
            input.setPartValue("megtype", megtype);
            input.setPartValue("megindex", tunnelindex);
            input.setPartValue("galmode", row.getParam("galmode").getValue());
            operationList.add(operation.clone());
        }
        return operationList;
    }

    private ArrayList sendMegidTypeMessage(RowParams[] rows) {
        RowParams row2 = null;
        ArrayList operations = new ArrayList();
        Operation oper = null;
        ArrayList<Object> sendList = null;
        Operation tmpOper = null;
        int countErr = 0;
        int countSendRow = 0;
        for (RowParams row2 : rows) {
            if (!this.isValuable("megidtype", row2).booleanValue()) continue;
            ++countSendRow;
            sendList = new ArrayList<Object>();
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_TRANSACTION_BEGIN");
            sendList.add(oper.clone());
            String megidtype = row2.getParam("megidtype").getValue();
            String qxcmd = "";
            if ("2".equals(megidtype)) {
                qxcmd = "NSCMD_MPLSTP_OAM_CRT_ICC_BASED_MEPINFO";
            } else if ("3".equals(megidtype)) {
                qxcmd = "NSCMD_MPLSTP_OAM_CRT_CUSTOMER_BASED_MEPINFO";
            }
            if (!qxcmd.isEmpty()) {
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)qxcmd);
                Input input1 = oper.getInput();
                input1.getPart("megtype").setValue(row2.getParam("megtype").getValue());
                input1.getPart("tunnelindex").setValue(row2.getParam("tunnelindex").getValue());
                input1.getPart("megid").setValue(row2.getParam("megid").getValue());
                input1.getPart("mepormipid").setValue(row2.getParam("mepormipid").getValue());
                input1.getPart("rmepormipid").setValue(row2.getParam("rmepormipid").getValue());
                sendList.add(oper.clone());
            }
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_MPLSTP_OAM_SWITCH_MEGIDTYPE");
            Input input = oper.getInput();
            input.getPart("megtype").setValue(row2.getParam("megtype").getValue());
            input.getPart("tunnelindex").setValue(row2.getParam("tunnelindex").getValue());
            input.getPart("megidtype").setValue(row2.getParam("megidtype").getValue());
            sendList.add(oper.clone());
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_TRANSACTION_END");
            sendList.add(oper.clone());
            int errCode = this.sendMessage(this.neid, sendList);
            if (errCode != 0) continue;
            operations.addAll(sendList);
            tmpOper = (Operation)sendList.get(sendList.size() - 1);
            if (tmpOper.getOutput(0).getFault(0).getCode().equals("0")) continue;
            ++countErr;
        }
        if (countSendRow != 0 && countErr == countSendRow) {
            this.isAllTransactionFalied = true;
        }
        return operations;
    }

    private Boolean isValuable(String paramName, RowParams row) {
        Param tmppara = row.getParam(paramName);
        if (tmppara != null && !tmppara.getValue().isEmpty()) {
            return true;
        }
        return false;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = this.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList);
    }

    private Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        ArrayList errorData = TEDataConverter.joinOperation((int)neid, (SubFunc)subfunc, (ArrayList)operationList, filterErrorCodeList);
        Operation operation = null;
        if (null == operationList || operationList.isEmpty()) {
            return null;
        }
        RowParams rowparams = null;
        Input input = null;
        Output output = null;
        boolean succ = false;
        boolean fault = false;
        boolean row_succ = false;
        boolean verify_succ = true;
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        int len = operationList.size();
        block0: for (int iIndex = 0; iIndex < len; ++iIndex) {
            operation = (Operation)operationList.get(iIndex);
            TEDataConverter.handleSpecialStr((Operation)operation);
            input = operation.getInput();
            if (operation.getOutputCount() == 0) {
                succ = true;
            }
            int size = operation.getOutputCount();
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                output = operation.getOutput(rowIndex);
                rowparams = new RowParams();
                row_succ = TEDataConverter.handleRowError((Output)output, filterErrorCodeList);
                if (row_succ) {
                    succ = true;
                    boolean flagInfo = false;
                    int errorSize = output.getFaultCount();
                    for (int a = 0; a < errorSize; ++a) {
                        if (filterErrorCodeList.contains(Integer.valueOf(output.getFault(a).getCode()))) continue;
                        flagInfo = true;
                        break;
                    }
                    if (!flagInfo) continue block0;
                    TEDataConverter.handleRowData((int)neid, (SubFunc)subfunc, (RowParams)rowparams, (Input)input, (Output)output);
                    flagInfo = false;
                } else if (1 == operation.getOutputCount()) {
                    boolean hasDefault = true;
                    int count = operation.getOutput(0).getPartCount();
                    for (int index = 0; index < count; ++index) {
                        if (operation.getOutput(0).getPart(index).hasDefault()) continue;
                        hasDefault = false;
                        break;
                    }
                    if (hasDefault) {
                        TEDataConverter.handleRowData((int)neid, (SubFunc)subfunc, (RowParams)rowparams, (Input)input, (Output)output);
                    }
                }
                if (0 != rowparams.getParamCount()) {
                    outputData.getBussinessParams().addRowParams(rowparams);
                }
                row_succ = false;
            }
        }
        if (null != errorData && !errorData.isEmpty()) {
            fault = true;
            rowparams = new RowParams();
            RowErrors rErrors = null;
            int size = errorData.size();
            for (int i = 0; i < size; ++i) {
                rErrors = (RowErrors)errorData.get(i);
                rowparams.addRowErrors(rErrors);
                if (!this.isAllTransactionFalied) continue;
                verify_succ = false;
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (succ && !fault) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!succ && fault || !verify_succ) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        return outputData;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
        String BASE_PATH = "ip" + File.separator + "ptn" + File.separator + "res";
        String STRING_SOURCE = BASE_PATH + File.separator + "mpls" + File.separator + "mpls_" + LANGUAGE + ".ini";
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        try {
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = TESecurityVerify.getSuperUserID();
                }
            }
            this.subfunc = subfunc;
            this.outputData = outputData;
            String operObj = this.getOperObj();
            String operName = this.getOperateName();
            List loginfoList = this.getLogInfoList(inputData);
            TELogInfo loginfo = null;
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                loginfo = (TELogInfo)loginfoList.get(i);
                loginfo.setCmdID(subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserID(userID);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateName(operName);
                loginfo.setOperateObject(operObj);
                if (((TELogInfo)loginfoList.get(i)).getErrCode() == 0) {
                    String mergeValue;
                    RowParams row = inputData.getBussinessParams().getRowParams(0);
                    if (this.isValuable("lmmode", row).booleanValue()) {
                        String lmmode = row.getParam("lmmode").getValue();
                        mergeValue = loginfo.getOperateDesc() + ":" + resourceUtil.getString("lmmode") + ":" + resourceUtil.getString("lmmode_" + lmmode);
                        ((TELogInfo)loginfoList.get(i)).setOperateDesc(mergeValue);
                    }
                    if (this.isValuable("galmode", row).booleanValue()) {
                        String galmode = row.getParam("galmode").getValue();
                        mergeValue = loginfo.getOperateDesc() + ":" + resourceUtil.getString("galmode") + ":" + resourceUtil.getString("galmode_" + galmode);
                        ((TELogInfo)loginfoList.get(i)).setOperateDesc(mergeValue);
                    }
                }
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }
}

