/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpls.mplstpoam;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.QxMapping;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class TEMplsTpOamTunnelQueryMep
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "ip" + File.separator + "ptn" + File.separator + "res" + File.separator;
    private static final String STRING_SOURCE = BASE_PATH + "mpls" + File.separator + "mpls_" + LANGUAGE + ".ini";
    protected TEResourceUtil resourceUtil = null;
    protected HashMap<String, Output> tunnelInfos = new HashMap();
    protected HashMap<String, Output> pwInfos = new HashMap();
    protected HashMap<String, Output> mspwInfos = new HashMap();
    protected HashMap<String, Output> reversetunnelInfos = new HashMap();
    protected String location = "";
    protected String megtype = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.location = inputData.getBussinessParams().getRowParams(0).getParam("location").getValue();
        this.megtype = inputData.getBussinessParams().getRowParams(0).getParam("megtype").getValue();
        QxMapping qx1 = subFunc.getQxMapping(1);
        QxMapping qx2 = subFunc.getQxMapping(2);
        QxMapping qx3 = subFunc.getQxMapping(3);
        if (this.megtype.equals("2") || this.megtype.equals("4") || this.location.equals("2")) {
            subFunc.removeQxMapping(qx1);
        }
        if (this.megtype.equals("2") && this.location.equals("1") && TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_CFG_PTN_MPLSTUNNEL_BSCFG", "MPLS_ATTR_SUPPORT_GALMODE")) {
            subFunc.addQxMapping(new QxMapping("NSCMD_MPLSTP_OAM_GET_GALMODE"));
        }
        if (this.megtype.equals("1") || this.megtype.equals("4")) {
            subFunc.removeQxMapping(qx2);
            subFunc.removeQxMapping(qx3);
        }
        if (TESpecialAttrMgr.getInstance().isNENotSupport(neid, "TE_FUNC_CFG_PTN_MPLSTUNNEL_BSCFG", "MPLS_ATTR_SUPPORT_LCKSTATE")) {
            int len = subFunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                QxMapping qx = subFunc.getQxMapping(i);
                if (!subFunc.getQxMapping(i).getContent().equalsIgnoreCase("NSCMD_MPLSTP_OAM_GET_LCK")) continue;
                subFunc.removeQxMapping(qx);
                break;
            }
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = this.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList);
    }

    public Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        ArrayList errorData = TEDataConverter.joinOperation((int)neid, (SubFunc)subfunc, (ArrayList)operationList, filterErrorCodeList);
        Operation operation = null;
        if (null == operationList || 0 == operationList.size()) {
            return null;
        }
        RowParams rowparams = null;
        Input input = null;
        Output output = null;
        boolean succ = false;
        boolean fault = false;
        boolean row_succ = false;
        boolean verify_succ = true;
        Datainterface tmpOutputData = new Datainterface();
        tmpOutputData.setBussinessParams(new BussinessParams());
        Operation tmp = (Operation)operationList.get(0);
        if (tmp.getOutputCount() > 0) {
            if (this.megtype.equals("1")) {
                this.getTunnelInfo();
            } else if (this.megtype.equals("4")) {
                this.getMSPWInfo();
            } else {
                this.getPWInfo();
            }
            if (this.megtype.equals("1") && this.location.equals("1")) {
                this.getReversetunnelInfo();
            }
        }
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        int len = operationList.size();
        block0: for (int i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            TEDataConverter.handleSpecialStr((Operation)operation);
            input = operation.getInput();
            if (operation.getOutputCount() == 0) {
                succ = true;
            }
            int size = operation.getOutputCount();
            for (int row = 0; row < size; ++row) {
                output = operation.getOutput(row);
                rowparams = new RowParams();
                row_succ = TEDataConverter.handleRowError((Output)output, filterErrorCodeList);
                if (row_succ) {
                    succ = true;
                    boolean flag = false;
                    int errorSize = output.getFaultCount();
                    for (int a = 0; a < errorSize; ++a) {
                        if (filterErrorCodeList.contains(Integer.valueOf(output.getFault(a).getCode()))) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue block0;
                    this.handleRowData(neid, subfunc, rowparams, input, output);
                    flag = false;
                } else if (1 == operation.getOutputCount()) {
                    boolean hasDefault = true;
                    int count = operation.getOutput(0).getPartCount();
                    for (int index = 0; index < count; ++index) {
                        if (operation.getOutput(0).getPart(index).hasDefault()) continue;
                        hasDefault = false;
                        break;
                    }
                    if (hasDefault) {
                        this.handleRowData(neid, subfunc, rowparams, input, output);
                    }
                }
                if (0 != rowparams.getParamCount()) {
                    tmpOutputData.getBussinessParams().addRowParams(rowparams);
                }
                row_succ = false;
            }
        }
        if (null != errorData && 0 != errorData.size()) {
            fault = true;
            rowparams = new RowParams();
            RowErrors rErrors = null;
            int size = errorData.size();
            for (int i = 0; i < size; ++i) {
                rErrors = (RowErrors)errorData.get(i);
                rowparams.addRowErrors(rErrors);
            }
            tmpOutputData.getBussinessParams().addRowParams(rowparams);
        }
        tmpOutputData.setErrorMessage(new ErrorMessage());
        if (succ && !fault) {
            tmpOutputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!succ && fault || !verify_succ) {
            tmpOutputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            tmpOutputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        return tmpOutputData;
    }

    private void getTunnelInfo() {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_MPLS_GET_STATICTUNNEL");
        Input input = operation.getInput();
        input.getPart("tunnelindex").setValue("0");
        operations.add(operation);
        int result = this.sendMessage(this.neid, operations);
        Output out = null;
        if (result == 0) {
            Operation oper = (Operation)operations.get(0);
            out = oper.getOutput(0);
            if (!out.getFault(0).getCode().equals("0")) {
                return;
            }
            String tunnelindex = null;
            int len = oper.getOutputCount();
            for (int i = 0; i < len; ++i) {
                out = oper.getOutput(i);
                tunnelindex = out.getPartValue("tunnelindex");
                this.tunnelInfos.put(tunnelindex, out);
            }
        }
    }

    private void getMSPWInfo() {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_GET_MSPW");
        Input input = operation.getInput();
        input.getPart("mspwindex").setValue("0");
        operations.add(operation);
        int result = this.sendMessage(this.neid, operations);
        Output out = null;
        if (result == 0) {
            Operation oper = (Operation)operations.get(0);
            out = oper.getOutput(0);
            if (!out.getFault(0).getCode().equals("0")) {
                return;
            }
            String tunnelindex = null;
            int len = oper.getOutputCount();
            for (int i = 0; i < len; ++i) {
                out = oper.getOutput(i);
                tunnelindex = out.getPartValue("mspwindex");
                this.mspwInfos.put(tunnelindex, out);
            }
        }
    }

    private void getPWInfo() {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_GET_PW");
        Input input = operation.getInput();
        input.getPart("pwIndex").setValue("0");
        operations.add(operation);
        int result = this.sendMessage(this.neid, operations);
        Output out = null;
        if (result == 0) {
            Operation oper = (Operation)operations.get(0);
            out = oper.getOutput(0);
            if (!out.getFault(0).getCode().equals("0")) {
                return;
            }
            String tunnelindex = null;
            int len = oper.getOutputCount();
            for (int i = 0; i < len; ++i) {
                out = oper.getOutput(i);
                tunnelindex = out.getPartValue("pwIndex");
                this.pwInfos.put(tunnelindex, out);
            }
        }
    }

    private void getReversetunnelInfo() {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_GET_ETHN_TUNNEL_SENDREVERSETUNNEL");
        Input input = operation.getInput();
        input.getPart("tunnelindex").setValue("0");
        operations.add(operation);
        int result = this.sendMessage(this.neid, operations);
        Output out = null;
        if (result == 0) {
            Operation oper = (Operation)operations.get(0);
            out = oper.getOutput(0);
            if (!out.getFault(0).getCode().equals("0")) {
                return;
            }
            String tunnelindex = null;
            int len = oper.getOutputCount();
            for (int i = 0; i < len; ++i) {
                out = oper.getOutput(i);
                tunnelindex = out.getPartValue("tunnelindex");
                this.reversetunnelInfos.put(tunnelindex, out);
            }
        }
    }

    protected void handleRowData(int neid, SubFunc subfunc, RowParams rowparams, Input input, Output output) {
        Param param = null;
        Output tunnelinfo = null;
        Output reversetunnelInfo = null;
        String tunnelindex = output.getPartValue("megindex");
        param = new Param();
        param.setName("tunnelindex");
        param.setValue(tunnelindex);
        rowparams.addParam(param);
        tunnelinfo = this.tunnelInfos.get(tunnelindex);
        String tunnelid = "-";
        String name = "-";
        String nodetype = "-";
        String direction = "-";
        String srcnode = "-";
        String snknode = "-";
        String lsrId = "-";
        String sendpwID = "-";
        String galenable = "-";
        if (null != tunnelinfo) {
            tunnelid = tunnelinfo.getPartValue("tunnelid");
            name = IOStreamConvertor.replaceSpecialStr((String)tunnelinfo.getPartValue("name"));
            nodetype = tunnelinfo.getPartValue("nodetype");
            direction = tunnelinfo.getPartValue("direction");
            srcnode = tunnelinfo.getPartValue("srcnode");
            snknode = tunnelinfo.getPartValue("snknode");
        }
        if (null != (tunnelinfo = this.pwInfos.get(tunnelindex))) {
            tunnelid = tunnelinfo.getPartValue("pwID");
            nodetype = tunnelinfo.getPartValue("serviceType");
            lsrId = output.getPartValue("lsrId");
            sendpwID = output.getPartValue("sendpwID");
            galenable = output.getPartValue("galenable");
        }
        if (null != (tunnelinfo = this.mspwInfos.get(tunnelindex))) {
            tunnelid = tunnelinfo.getPartValue("mspwid");
            nodetype = tunnelinfo.getPartValue("servicetype");
            name = IOStreamConvertor.replaceSpecialStr((String)tunnelinfo.getPartValue("mspwname"));
        }
        rowparams.addParam(new Param("tunnelid", tunnelid));
        if (this.megtype.equals("2") && this.location.equals("1")) {
            rowparams.addParam(new Param("pwIndex", tunnelindex));
            rowparams.addParam(new Param("pwID", tunnelid));
        }
        rowparams.addParam(new Param("name", name));
        rowparams.addParam(new Param("nodetype", nodetype));
        rowparams.addParam(new Param("direction", direction));
        reversetunnelInfo = this.reversetunnelInfos.get(tunnelindex);
        String reversetunnel = "-";
        String rTunnelIndex = "-";
        if (null != reversetunnelInfo && direction.equals("0")) {
            rTunnelIndex = reversetunnelInfo.getPartValue("rtunnelindex");
            if (!"4294967295".equals(rTunnelIndex)) {
                Output tmpTunnel = this.tunnelInfos.get(rTunnelIndex);
                String tmpTunnelid = tmpTunnel.getPartValue("tunnelid");
                String tmpSrcnode = tmpTunnel.getPartValue("srcnode");
                String tmpSnknode = tmpTunnel.getPartValue("snknode");
                tmpSrcnode = IPAddressUtil.convertIPLongToStr((long)Long.parseLong(tmpSrcnode));
                tmpSnknode = IPAddressUtil.convertIPLongToStr((long)Long.parseLong(tmpSnknode));
                StringBuffer sb = new StringBuffer();
                sb.append(tmpTunnelid);
                sb.append("(");
                sb.append(this.resourceUtil.getString("sourcenode")).append(":");
                sb.append(tmpSrcnode).append(",");
                sb.append(this.resourceUtil.getString("sinknode")).append(":");
                sb.append(tmpSnknode).append(")");
                reversetunnel = sb.toString();
            } else {
                reversetunnel = "";
            }
        }
        rowparams.addParam(new Param("reversetunnel", reversetunnel));
        rowparams.addParam(new Param("rTunnelIndex", rTunnelIndex));
        String oamstat = output.getPartValue("oamstat");
        rowparams.addParam(new Param("oamstat", oamstat));
        String megidtype = output.getPartValue("megidtype");
        rowparams.addParam(new Param("megidtype", megidtype));
        String megid = output.getPartValue("megid");
        rowparams.addParam(new Param("megid", megid));
        String meglevel = output.getPartValue("meglevel");
        rowparams.addParam(new Param("meglevel", meglevel));
        String mepormipid = output.getPartValue("mepormipid");
        rowparams.addParam(new Param("mepormipid", mepormipid));
        String rmepormipid = output.getPartValue("rmepormipid");
        rowparams.addParam(new Param("rmepormipid", rmepormipid));
        String detectionmode = output.getPartValue("detectionmode");
        rowparams.addParam(new Param("detectionmode", detectionmode));
        String ccstatus = output.getPartValue("ccstatus");
        rowparams.addParam(new Param("ccstatus", ccstatus));
        String ccpri = output.getPartValue("ccpri");
        rowparams.addParam(new Param("ccpri", ccpri));
        String ccperiod = output.getPartValue("ccperiod");
        rowparams.addParam(new Param("ccperiod", ccperiod));
        String lockstatus = output.getPartValue("lockstatus");
        lockstatus = lockstatus == null ? "" : lockstatus;
        rowparams.addParam(new Param("lockstatus", lockstatus));
        String aisstatus = output.getPartValue("aisstatus");
        if (this.location.equals("2") || this.megtype.equals("2") || this.megtype.equals("4")) {
            aisstatus = "-";
        }
        rowparams.addParam(new Param("aisstatus", aisstatus));
        rowparams.addParam(new Param("lspstat", "-"));
        rowparams.addParam(new Param("lspdefecttype", "-"));
        rowparams.addParam(new Param("disablelspduration", "-"));
        rowparams.addParam(new Param("lspdefectloc", "-"));
        rowparams.addParam(new Param("lspstat_far", "-"));
        rowparams.addParam(new Param("lspdefecttype_far", "-"));
        rowparams.addParam(new Param("disablelspduration_far", "-"));
        rowparams.addParam(new Param("lspdefectloc_far", "-"));
        String sdthreshold = output.getPartValue("sdthreshold");
        rowparams.addParam(new Param("sdthreshold", sdthreshold));
        String sfthreshold = output.getPartValue("sfthreshold");
        rowparams.addParam(new Param("sfthreshold", sfthreshold));
        rowparams.addParam(new Param("srcnode", srcnode));
        rowparams.addParam(new Param("snknode", snknode));
        rowparams.addParam(new Param("lsrId", lsrId));
        rowparams.addParam(new Param("sendpwID", sendpwID));
        rowparams.addParam(new Param("galenable", galenable));
        rowparams.addParam(new Param("lmmode", "-"));
        String galmode = output.getPartValue("galmode");
        galmode = galmode == null ? "" : galmode;
        rowparams.addParam(new Param("galmode", galmode));
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(38662);
        errorList.add(37898);
        errorList.add(38737);
        return errorList;
    }
}

