/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpls.mplstpoam;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TLongArrayList;
import java.util.ArrayList;

public class TEGetMplstpOAMTunnel
extends TENEExplorerBean {
    private TIntHashSet logicPortSet = new TIntHashSet();
    public static final int BIDIRECTION = 1;
    private TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();

    public int getTimeOut() {
        return 30;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Operation oper = (Operation)((Operation)operationList.get(2)).clone();
        super.handleMessage(neid, operationList, subfunc);
        int nodeType = -1;
        RowParams[] rowParamses = this.inputData.getBussinessParams().getRowParams();
        for (int i = rowParamses.length - 1; i >= 0; --i) {
            nodeType = Integer.valueOf(rowParamses[i].getParam("nodetype").getValue());
        }
        this.getTunnelByApsProtection(oper, nodeType);
        this.handleTunnel(nodeType);
        this.getAllTunnels();
        this.queryLogicPortName();
    }

    private void handleTunnel(int nodeType) {
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        RowParams rowParams = null;
        for (int i = rowParamses.length - 1; i >= 0; --i) {
            rowParams = rowParamses[i];
            rowParams.addParam("lsrID", rowParams.getParam("snknode").getValue());
            rowParams.addParam("exp", "-1");
            rowParams.addParam("bandwidthremain", rowParams.getParam("bandwidth").getValue());
        }
    }

    private void getTunnelByApsProtection(Operation oper, int nodeType) {
        TLongArrayList usedTunnelByApsPro = new TLongArrayList();
        int errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
        if (0 == errCode) {
            Output output = null;
            int m = oper.getOutputCount();
            for (int i = 0; i < m; ++i) {
                output = oper.getOutput(i);
                usedTunnelByApsPro.add(Long.valueOf(output.getPartValue("poutindex")).longValue());
                usedTunnelByApsPro.add(Long.valueOf(output.getPartValue("pinindex")).longValue());
            }
        }
        int rtnNodeType = -1;
        RowParams rowParams = null;
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        for (int j = rowParamses.length - 1; j >= 0; --j) {
            rowParams = rowParamses[j];
            if (rowParams.getRowErrorsCount() <= 0) {
                rtnNodeType = Integer.valueOf(rowParams.getParam("nodetype").getValue());
                if ("".equals(rowParams.getParam("tunnelid").getValue().trim())) {
                    this.outputData.getBussinessParams().removeRowParams(j);
                    continue;
                }
                if (rtnNodeType != 2) {
                    this.outputData.getBussinessParams().removeRowParams(j);
                    continue;
                }
                long tunnelIndex = Long.valueOf(rowParams.getParam("tunnelindex").getValue());
                if (rtnNodeType == nodeType && !usedTunnelByApsPro.contains(tunnelIndex)) continue;
                this.outputData.getBussinessParams().removeRowParams(j);
                continue;
            }
            this.outputData.getBussinessParams().removeRowParams(j);
        }
    }

    private void getAllTunnels() {
        int slotId = -1;
        int boardType = -1;
        String boardName = "";
        String portName = "";
        int portId = -1;
        int nodetype = -1;
        int derection = -1;
        RowParams rowParams = null;
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        for (int i = rowParamses.length - 1; i >= 0; --i) {
            rowParams = rowParamses[i];
            if (rowParams.getRowErrorsCount() > 0) continue;
            nodetype = Integer.valueOf(rowParams.getParam("nodetype").getValue());
            derection = Integer.valueOf(rowParams.getParam("direction").getValue());
            if (nodetype == 3) {
                String inslotid = rowParams.getParam("inslotid").getValue();
                if (inslotid != null && !inslotid.isEmpty()) {
                    slotId = Integer.valueOf(inslotid);
                    boardType = this.cfgMgr.getBoardType(this.neid, slotId);
                    boardName = this.cfgMgr.getBoardTypeName(this.neid, boardType);
                    portId = Integer.valueOf(rowParams.getParam("inport").getValue());
                    portName = this.cfgMgr.getPortNameForPTN(this.neid, slotId, boardType, portId);
                    rowParams.addParam("inportname", portName);
                    if (65535L == (long)slotId) {
                        this.logicPortSet.add(portId);
                        boardName = "";
                        rowParams.getParam("inslotid").setValue("");
                    }
                    rowParams.addParam("inboardname", boardName);
                    if (derection == 1) {
                        rowParams.getParam("outslotid").setValue(inslotid);
                        rowParams.addParam("outportname", portName);
                        rowParams.addParam("outboardname", boardName);
                    }
                    rowParams.getParam("signaltype").setValue(String.valueOf(1));
                    continue;
                }
                rowParams.getParam("inportname").setValue("-");
                rowParams.getParam("inboardname").setValue("");
                rowParams.getParam("signaltype").setValue(String.valueOf(2));
                continue;
            }
            String outslotid = rowParams.getParam("outslotid").getValue();
            if (outslotid != null && !outslotid.equals("")) {
                slotId = Integer.valueOf(outslotid);
                boardType = this.cfgMgr.getBoardType(this.neid, slotId);
                boardName = this.cfgMgr.getBoardTypeName(this.neid, boardType);
                portId = Integer.valueOf(rowParams.getParam("outport").getValue());
                portName = this.cfgMgr.getPortNameForPTN(this.neid, slotId, boardType, portId);
                rowParams.getParam("outportname").setValue(portName);
                if (65535L == (long)slotId) {
                    this.logicPortSet.add(portId);
                    boardName = "";
                    rowParams.getParam("outslotid").setValue("");
                }
                rowParams.getParam("outboardname").setValue(boardName);
                if (derection == 1) {
                    rowParams.getParam("inslotid").setValue(outslotid);
                    rowParams.addParam("inportname", portName);
                    rowParams.addParam("inboardname", boardName);
                }
                rowParams.getParam("signaltype").setValue(String.valueOf(1));
            } else {
                rowParams.getParam("outportname").setValue("-");
                rowParams.getParam("outboardname").setValue("");
                rowParams.getParam("signaltype").setValue(String.valueOf(2));
            }
            rowParams.getParam("bandwidthremain").setValue(rowParams.getParam("bandwidth").getValue());
        }
    }

    private void queryLogicPortName() {
        int errCode;
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME");
        Input input = oper.getInput();
        input.setPartValue("slotid", String.valueOf(65535L));
        this.operationList.clear();
        TIntIterator iter = this.logicPortSet.iterator();
        while (iter.hasNext()) {
            input.setPartValue("port", String.valueOf(iter.next()));
            this.operationList.add(oper.clone());
        }
        if (this.operationList.size() > 0 && 0 == (errCode = this.sendMessage(this.neid))) {
            Output output = null;
            RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
            int m = this.operationList.size();
            for (int i = 0; i < m; ++i) {
                oper = (Operation)this.operationList.get(i);
                output = oper.getOutput(0);
                errCode = Integer.valueOf(output.getFault(0).getCode());
                if (0 != errCode) continue;
                int n = rowParamses.length;
                for (int j = 0; j < n; ++j) {
                    this.setPortName(rowParamses[j], output.getPartValue("port"), IOStreamConvertor.replaceSpecialStr((String)output.getPartValue("PTNIF_PORT_ATTR_PORTNAME")));
                }
            }
        }
    }

    private void setPortName(RowParams rowParams, String port, String name) {
        String portName = null;
        Param param = null;
        if (rowParams.getParam("inslotid") != null && rowParams.getParam("inport") != null && "".equals(rowParams.getParam("inslotid").getValue()) && rowParams.getParam("inport").getValue().equals(port)) {
            param = rowParams.getParam("inportname");
            portName = param.getValue();
            portName = portName.substring(0, portName.indexOf("-") + 1) + name + ")";
            param.setValue(portName);
        }
        if (rowParams.getParam("outslotid") != null && rowParams.getParam("outport") != null && "".equals(rowParams.getParam("outslotid").getValue()) && rowParams.getParam("outport").getValue().equals(port)) {
            param = rowParams.getParam("outportname");
            portName = param.getValue();
            portName = portName.substring(0, portName.indexOf("-") + 1) + name + ")";
            param.setValue(portName);
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

