/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpls;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEBatchSendMessageBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntLongHashMap;
import gnu.trove.TIntLongIterator;
import gnu.trove.TLongIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEQueryStaticUnicastTunnel
extends TECommonWriteLogBean {
    private static final int QUERY_TIME_OUT = 30;
    private static final long INVALID_SLOT = 65535L;
    private static final long INVALID_BANDWIDTH = 0xFFFFFFFFL;
    private TIntHashSet logicPortSet = new TIntHashSet();
    private TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
    private boolean isSupportPirEdit = false;

    public int getTimeOut() {
        return 30;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.isSupportPirEdit = TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_CFG_TUNNEL", "TE_ATTR_SUPPORT_TUNNEL_PIR_EDIT");
        Operation oper = null;
        Iterator iterator = operationList.iterator();
        while (iterator.hasNext()) {
            Operation tmpOper = (Operation)iterator.next();
            if (!"NSCMD_PTN_GET_APSPG".equals(tmpOper.getName())) continue;
            oper = tmpOper;
            iterator.remove();
        }
        super.handleMessage(neid, operationList, subfunc);
        this.getApsForTunnel(oper);
        this.calcTunnelRemainderBw();
        this.queryLogicPortName();
    }

    private void getApsForTunnel(Operation oper) {
        HashMap apsMap = new HashMap();
        int errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
        if (0 == errCode) {
            ArrayList<String> indexList = null;
            Output output = null;
            int m = oper.getOutputCount();
            for (int i = 0; i < m; ++i) {
                indexList = new ArrayList<String>();
                output = oper.getOutput(i);
                indexList.add(output.getPartValue("woutindex"));
                indexList.add(output.getPartValue("winindex"));
                indexList.add(output.getPartValue("poutindex"));
                indexList.add(output.getPartValue("pinindex"));
                apsMap.put(output.getPartValue("apsid"), indexList);
            }
        }
        Map.Entry entry2 = null;
        Iterator iter = null;
        RowParams rowParams = null;
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        block1: for (int j = rowParamses.length - 1; j >= 0; --j) {
            rowParams = rowParamses[j];
            if (rowParams.getRowErrorsCount() > 0) continue;
            if ("".equals(rowParams.getParam("tunnelid").getValue().trim())) {
                this.outputData.getBussinessParams().removeRowParams(j);
                continue;
            }
            for (Map.Entry entry2 : apsMap.entrySet()) {
                if (!((List)entry2.getValue()).contains(rowParams.getParam("tunnelindex").getValue())) continue;
                rowParams.getParam("apsid").setValue((String)entry2.getKey());
                continue block1;
            }
        }
    }

    private TLongIntHashMap getAllTunnels() {
        int slotId = -1;
        int boardType = -1;
        String boardName = "";
        int portId = -1;
        RowParams rowParams = null;
        TLongIntHashMap indexMap = new TLongIntHashMap();
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        int m = rowParamses.length;
        for (int i = 0; i < m; ++i) {
            rowParams = rowParamses[i];
            if (rowParams.getRowErrorsCount() > 0) continue;
            slotId = Integer.valueOf(rowParams.getParam("inslotid").getValue());
            boardType = this.cfgMgr.getBoardType(this.neid, slotId);
            boardName = this.cfgMgr.getBoardTypeName(this.neid, boardType);
            portId = Integer.valueOf(rowParams.getParam("inport").getValue());
            rowParams.addParam("inportname", this.cfgMgr.getPortNameForPTN(this.neid, slotId, boardType, portId));
            if (65535L == (long)slotId) {
                this.logicPortSet.add(portId);
                boardName = "";
                rowParams.getParam("inslotid").setValue("");
            }
            rowParams.addParam("inboardname", boardName);
            this.judgeSpecialPortAndRefact(rowParams, slotId, portId, "in");
            slotId = Integer.valueOf(rowParams.getParam("outslotid").getValue());
            boardType = this.cfgMgr.getBoardType(this.neid, slotId);
            boardName = this.cfgMgr.getBoardTypeName(this.neid, boardType);
            portId = Integer.valueOf(rowParams.getParam("outport").getValue());
            rowParams.addParam("outportname", this.cfgMgr.getPortNameForPTN(this.neid, slotId, boardType, portId));
            if (65535L == (long)slotId) {
                this.logicPortSet.add(portId);
                boardName = "";
                rowParams.getParam("outslotid").setValue("");
            }
            rowParams.addParam("outboardname", boardName);
            this.judgeSpecialPortAndRefact(rowParams, slotId, portId, "out");
            rowParams.getParam("bandwidthremain").setValue(rowParams.getParam("bandwidth").getValue());
            if (!this.isSupportPirEdit) {
                rowParams.addParam(new Param("pir", "-"));
            } else {
                rowParams.addParam(new Param("pir", rowParams.getParam("pir").getValue()));
            }
            rowParams.addParam(new Param("cbs", "-"));
            rowParams.addParam(new Param("pbs", "-"));
            rowParams.addParam(new Param("mtu", "-"));
            rowParams.getParam("bandwidthused").setValue("0");
            indexMap.put(Long.valueOf(rowParams.getParam("tunnelindex").getValue()).longValue(), i);
        }
        return indexMap;
    }

    public int sendMessage(int neid, ArrayList operationList, int timeout) {
        if (operationList.size() > 50) {
            TENEBatchSendMessageBean batcher = new TENEBatchSendMessageBean();
            batcher.setTimeout(80);
            return batcher.sendMessageBatch(neid, operationList, 200);
        }
        return super.sendMessage(neid, operationList, timeout);
    }

    private TIntLongHashMap getPWUsedTunnel() {
        TIntLongHashMap pwIndexMap = new TIntLongHashMap();
        TLongIntHashMap indexMap = this.getAllTunnels();
        if (indexMap.size() > 0) {
            this.operationList.clear();
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_GET_PW");
            Input input = oper.getInput();
            input.setPartValue("pwIndex", "0");
            this.operationList.add(oper);
            int errCode = this.sendMessage(this.neid);
            if (0 == errCode && 0 == (errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode()).intValue())) {
                long pwIndex = 0L;
                long tunnelIndex = 0L;
                int tunnelCount = 0;
                Output output = null;
                int m = oper.getOutputCount();
                for (int i = 0; i < m; ++i) {
                    output = oper.getOutput(i);
                    pwIndex = Long.valueOf(output.getPartValue("pwIndex"));
                    tunnelCount = Integer.valueOf(output.getPartValue("tunnelCount"));
                    byte[] bValue = output.getPartValue("tunnelIndexList").getBytes();
                    int nCount = 8;
                    int nPos = 0;
                    int nParaSize = tunnelCount * nCount;
                    while (nPos + nCount <= nParaSize) {
                        tunnelIndex = IOStreamConvertor.readPositiveLong((byte[])bValue, (int)nPos);
                        if (indexMap.containsKey(tunnelIndex)) {
                            pwIndexMap.put(indexMap.get(tunnelIndex), pwIndex);
                        }
                        nPos += nCount;
                    }
                }
            }
        }
        return pwIndexMap;
    }

    private TIntLongHashMap countTunnelUsedBw() {
        TIntLongHashMap cirMap = new TIntLongHashMap();
        TIntLongHashMap pwIndexMap = this.getPWUsedTunnel();
        if (pwIndexMap.size() > 0) {
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_QOS_GET_PW_QOSINFO");
            Input input = oper.getInput();
            input.setPartValue("direction", "1");
            this.operationList.clear();
            TIntLongIterator iter = pwIndexMap.iterator();
            while (iter.hasNext()) {
                iter.advance();
                input.setPartValue("pwIndex", String.valueOf(iter.value()));
                this.operationList.add(oper.clone());
            }
            int errCode = this.sendMessage(this.neid);
            if (0 == errCode) {
                int m = this.operationList.size();
                block1: for (int i = 0; i < m; ++i) {
                    oper = (Operation)this.operationList.get(i);
                    errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
                    if (0 != errCode) continue;
                    long pwIndex = 0L;
                    long cir = 0L;
                    Output output = oper.getOutput(0);
                    pwIndex = Long.valueOf(output.getPartValue("pwIndex"));
                    cir = Long.valueOf(output.getPartValue("cir"));
                    iter = pwIndexMap.iterator();
                    while (iter.hasNext()) {
                        iter.advance();
                        if (iter.value() != pwIndex) continue;
                        cirMap.put(iter.key(), cir);
                        continue block1;
                    }
                }
            }
        }
        return cirMap;
    }

    private void calcTunnelRemainderBw() {
        int index = -1;
        long bandwidth = 0L;
        RowParams rowParams = null;
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        TIntLongIterator iter = this.countTunnelUsedBw().iterator();
        while (iter.hasNext()) {
            iter.advance();
            index = iter.key();
            long usedbw = 0xFFFFFFFFL == iter.value() ? 0L : iter.value();
            rowParams = bussinessParams.getRowParams(index);
            bandwidth = Long.valueOf(rowParams.getParam("bandwidth").getValue());
            rowParams.getParam("bandwidthremain").setValue(String.valueOf(bandwidth > usedbw ? bandwidth - usedbw : 0L));
            rowParams.getParam("bandwidthused").setValue(String.valueOf(usedbw));
        }
    }

    private void queryLogicPortName() {
        int errCode;
        Operation tempOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME");
        Input input = tempOper.getInput();
        input.setPartValue("slotid", String.valueOf(65535L));
        this.operationList.clear();
        TIntIterator iter = this.logicPortSet.iterator();
        while (iter.hasNext()) {
            input.setPartValue("port", String.valueOf(iter.next()));
            this.operationList.add(tempOper.clone());
        }
        if (this.operationList.size() > 0 && 0 == (errCode = this.sendMessage(this.neid))) {
            Output output = null;
            RowParams[] rowParams = this.outputData.getBussinessParams().getRowParams();
            int m = this.operationList.size();
            for (int i = 0; i < m; ++i) {
                tempOper = (Operation)this.operationList.get(i);
                output = tempOper.getOutput(0);
                errCode = Integer.valueOf(output.getFault(0).getCode());
                if (0 != errCode) continue;
                int n = rowParams.length;
                for (int j = 0; j < n; ++j) {
                    this.setPortName(rowParams[j], output.getPartValue("port"), IOStreamConvertor.replaceSpecialStr((String)output.getPartValue("PTNIF_PORT_ATTR_PORTNAME")));
                }
            }
        }
    }

    private void setPortName(RowParams params, String port, String name) {
        String portName = null;
        Param param = null;
        if (String.valueOf(65535L).equals(params.getParam("inslotid").getValue()) && params.getParam("inport").getValue().equals(port)) {
            param = params.getParam("inportname");
            portName = param.getValue();
            portName = portName.substring(0, portName.indexOf(45) + 1) + name + ")";
            param.setValue(portName);
        }
        if (String.valueOf(65535L).equals(params.getParam("outslotid").getValue()) && params.getParam("outport").getValue().equals(port)) {
            param = params.getParam("outportname");
            portName = param.getValue();
            portName = portName.substring(0, portName.indexOf(45) + 1) + name + ")";
            param.setValue(portName);
        }
    }

    private void judgeSpecialPortAndRefact(RowParams row, int slotid, int port, String prefix) {
        if (!(10240 <= port && 12288 >= port || 4096 <= port && 6144 >= port)) {
            return;
        }
        String bdSlot = prefix + "slotid";
        String bdName = prefix + "boardname";
        Param param = row.getParam(bdSlot);
        if (param != null) {
            param.setValue(String.valueOf(slotid));
        }
        if ((param = row.getParam(bdName)) != null) {
            if (4096 <= port && 6144 >= port) {
                param.setValue("ML-PPP");
            } else {
                param.setValue("Virtual Ethernet");
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38737);
        list.add(38662);
        list.add(37898);
        return list;
    }
}

