/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpls;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nemgr.ip.ptn.mpls.TEPWTestReportIF;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEPWPingTestReport
implements TEPWTestReportIF {
    private static final int INGRESS_NODE = 1;
    private static final int TRANSIT_NODE = 2;
    private static final int EGRESS_NODE = 3;
    private TEPingRespondReportHandler handlereventrespond = null;
    private TEPingTimeoutReportHandler handlereventtimeout = null;
    private TEPingResultReportHandler handlereventresult = null;
    private int neID;
    private Operation oper;
    private boolean hasRegister = false;
    private static Map<String, TEPWPingTestReport> reportMap = new HashMap<String, TEPWPingTestReport>();
    private BussinessParams bussinessParams = new BussinessParams();
    private Datainterface reportedData = new Datainterface();
    private List<String> cmdList = new ArrayList<String>();
    private String indexName = "";
    private static final String NSCMD_TRACEROUTE_LSP = "NSEVT_MPLS_LSP_TRACEROUTE_OVERTIME";
    private static final String NSCMD_TRACEROUTE_PW = "NSEVT_MPLS_PW_TRACEROUTE_OVERTIME";
    private static final String nonvalueStr = "-";

    private TEPWPingTestReport(int neID, String indexName) {
        this.neID = neID;
        this.indexName = indexName;
        this.reportedData.setBussinessParams(this.bussinessParams);
        this.cmdList.clear();
        if (indexName.equals("tunnelindex")) {
            this.cmdList.add("NSEVT_MPLS_LSP_PING_RSP");
            this.cmdList.add("NSEVT_MPLS_LSP_PING_OVERTIME");
            this.cmdList.add("NSEVT_MPLS_LSP_PING_STATISTIC");
        } else if (indexName.equals("pwIndex")) {
            this.cmdList.add("NSEVT_MPLS_PW_PING_RSP");
            this.cmdList.add("NSEVT_MPLS_PW_PING_OVERTIME");
            this.cmdList.add("NSEVT_MPLS_PW_PING_STATISTIC");
        }
    }

    public void register() {
        if (this.cmdList.isEmpty()) {
            return;
        }
        this.handlereventrespond = new TEPingRespondReportHandler();
        this.handlereventtimeout = new TEPingTimeoutReportHandler();
        this.handlereventresult = new TEPingResultReportHandler();
        this.oper = TECreateObjectFactory.getOperation((int)this.neID, (String)this.cmdList.get(0));
        TENECommMgr.getInstance().registerListener(this.oper, (NoticeHandler)this.handlereventrespond);
        boolean FLAG_1 = true;
        this.oper = TECreateObjectFactory.getOperation((int)this.neID, (String)this.cmdList.get(1));
        TENECommMgr.getInstance().registerListener(this.oper, (NoticeHandler)this.handlereventtimeout);
        int FLAG_2 = 2;
        this.oper = TECreateObjectFactory.getOperation((int)this.neID, (String)this.cmdList.get(2));
        TENECommMgr.getInstance().registerListener(this.oper, (NoticeHandler)this.handlereventresult);
        this.hasRegister = true;
    }

    public boolean hasRegisterd() {
        return this.hasRegister;
    }

    public void unregister() {
        this.oper = TECreateObjectFactory.getOperation((int)this.neID, (String)this.cmdList.get(0));
        TENECommMgr.getInstance().unregisterListener(this.oper, (NoticeHandler)this.handlereventrespond);
        boolean FLAG_1 = true;
        this.oper = TECreateObjectFactory.getOperation((int)this.neID, (String)this.cmdList.get(1));
        TENECommMgr.getInstance().unregisterListener(this.oper, (NoticeHandler)this.handlereventtimeout);
        this.oper = TECreateObjectFactory.getOperation((int)this.neID, (String)this.cmdList.get(2));
        TENECommMgr.getInstance().unregisterListener(this.oper, (NoticeHandler)this.handlereventresult);
        this.hasRegister = false;
    }

    private void addParam(Output outPut, String retrunParam, RowParams row) {
        Part partTemp = outPut.getPart(retrunParam);
        if (partTemp == null || partTemp.getValue() == null) {
            return;
        }
        String tmpVar = partTemp.getValue();
        if (retrunParam.equals("nodetype")) {
            int tmpNode = Integer.parseInt(partTemp.getValue());
            tmpVar = this.convertNodeType(tmpNode);
        }
        if (retrunParam.equals("rtnCode")) {
            int tmpCode = Integer.parseInt(partTemp.getValue());
            tmpVar = TEPWPingTestReport.convertReturnCode(tmpCode);
        }
        if (null == row.getParam(retrunParam)) {
            Param param = new Param(retrunParam, tmpVar);
            row.addParam(param);
        } else {
            row.getParam(retrunParam).setValue(tmpVar);
        }
    }

    private String convertNodeType(int nodeType) {
        String tmpnode = "";
        if (nodeType == 1) {
            tmpnode = "Ingress";
        } else if (nodeType == 2) {
            tmpnode = "Transit";
        } else if (nodeType == 3) {
            tmpnode = "Egress";
        }
        return tmpnode;
    }

    public static String convertReturnCode(int rtnCode) {
        String tmpcode = "";
        switch (rtnCode) {
            case 0: {
                tmpcode = "No return code";
                break;
            }
            case 1: {
                tmpcode = "Malformed echo request received";
                break;
            }
            case 2: {
                tmpcode = "One or more of the TLVs was not understood";
                break;
            }
            case 3: {
                tmpcode = "Replying router is an egress for the FEC at stack-depth";
                break;
            }
            case 4: {
                tmpcode = "Replying router has no mapping for the FEC at stack-depth";
                break;
            }
            case 5: {
                tmpcode = "Downstream Mapping Mismatch";
                break;
            }
            case 6: {
                tmpcode = "Upstream Interface Index Unknown";
                break;
            }
            case 7: {
                tmpcode = "Reserved";
                break;
            }
            case 8: {
                tmpcode = "Label switched at stack-depth";
                break;
            }
            case 9: {
                tmpcode = "Label switched but no MPLS forwarding at stack-depth";
                break;
            }
            case 10: {
                tmpcode = "Mapping for this FEC is not the given label at stack-depth";
                break;
            }
            case 11: {
                tmpcode = "No label entry at stack-depth";
                break;
            }
            case 12: {
                tmpcode = "Protocol not associated with interface at FEC stack-depth";
                break;
            }
            case 13: {
                tmpcode = "Premature termination of ping due to label stack shrinking to a single label";
                break;
            }
            default: {
                tmpcode = rtnCode + "";
            }
        }
        return tmpcode;
    }

    public static void addParamForIP(Output outPut, String retrunParam, RowParams row) {
        Part part = outPut.getPart(retrunParam);
        if (part == null || part.getValue() == null) {
            return;
        }
        long tmpvar = Long.valueOf(part.getValue());
        String tmpip = IPAddressUtil.convertIPLongToStr((long)tmpvar);
        if (null == row.getParam(retrunParam)) {
            Param param = new Param(retrunParam, tmpip);
            row.addParam(param);
        } else {
            row.getParam(retrunParam).setValue(tmpip);
        }
    }

    private void addOneParam(String paramName, String value, RowParams row) {
        if (null == row.getParam(paramName)) {
            Param param = new Param(paramName, value);
            row.addParam(param);
        } else {
            row.getParam(paramName).setValue(value);
        }
    }

    @Override
    public Datainterface getReportData() {
        return this.reportedData;
    }

    public static TEPWPingTestReport getPWPingTestReporter(int neid, String index, String indexName, String type) {
        String key = neid + nonvalueStr + index + type;
        TEPWPingTestReport ptr = null;
        if (reportMap.containsKey(key)) {
            return reportMap.get(key);
        }
        ptr = new TEPWPingTestReport(neid, indexName);
        reportMap.put(key, ptr);
        return ptr;
    }

    public void setTracerouteTestCMDList() {
        this.cmdList.clear();
        this.cmdList.add("NSEVT_MPLS_LSP_TRACEROUTE_RESPONSE");
        this.cmdList.add(NSCMD_TRACEROUTE_LSP);
        this.cmdList.add("NSEVT_MPLS_LSP_TRACEROUTE_END");
    }

    public void setPWTracerouteTestCMDList() {
        this.cmdList.clear();
        this.cmdList.add("NSEVT_MPLS_PW_TRACEROUTE_RESPONSE");
        this.cmdList.add(NSCMD_TRACEROUTE_PW);
        this.cmdList.add("NSEVT_MPLS_PW_TRACEROUTE_END");
    }

    class TEPingResultReportHandler
    implements NoticeHandler {
        TEPingResultReportHandler() {
        }

        public void handleNotice(int cmdKey, int neID, Operation oper) {
            Output outPut = oper.getOutput(0);
            RowParams row = new RowParams();
            TEPWPingTestReport.this.bussinessParams.addRowParams(row);
            Param param = new Param("eventType", "2");
            row.addParam(param);
            param = new Param("indexName", TEPWPingTestReport.this.indexName);
            row.addParam(param);
            TEPWPingTestReport.this.addParam(outPut, TEPWPingTestReport.this.indexName, row);
            TEPWPingTestReport.this.addParam(outPut, "sendNum", row);
            TEPWPingTestReport.this.addParam(outPut, "revNum", row);
            TEPWPingTestReport.this.addParam(outPut, "lostPer", row);
            TEPWPingTestReport.this.addParam(outPut, "minTimeout", row);
            TEPWPingTestReport.this.addParam(outPut, "maxTimeout", row);
            TEPWPingTestReport.this.addParam(outPut, "averageTimeout", row);
        }
    }

    class TEPingTimeoutReportHandler
    implements NoticeHandler {
        TEPingTimeoutReportHandler() {
        }

        public void handleNotice(int cmdKey, int neID, Operation oper) {
            Output outPut = oper.getOutput(0);
            RowParams row = new RowParams();
            TEPWPingTestReport.this.bussinessParams.addRowParams(row);
            Param param = new Param("eventType", "1");
            row.addParam(param);
            param = new Param("indexName", TEPWPingTestReport.this.indexName);
            row.addParam(param);
            TEPWPingTestReport.this.addParam(outPut, TEPWPingTestReport.this.indexName, row);
            TEPWPingTestReport.this.addParam(outPut, "serialNo", row);
            if (oper.getName().equals(TEPWPingTestReport.NSCMD_TRACEROUTE_LSP) || oper.getName().equals(TEPWPingTestReport.NSCMD_TRACEROUTE_PW)) {
                TEPWPingTestReport.this.addOneParam("lsrId", TEPWPingTestReport.nonvalueStr, row);
                TEPWPingTestReport.this.addOneParam("time", TEPWPingTestReport.nonvalueStr, row);
                TEPWPingTestReport.this.addOneParam("nodetype", TEPWPingTestReport.nonvalueStr, row);
                TEPWPingTestReport.this.addOneParam("downstreamlsrid", TEPWPingTestReport.nonvalueStr, row);
                TEPWPingTestReport.this.addOneParam("downstreamlabel", TEPWPingTestReport.nonvalueStr, row);
                TEPWPingTestReport.this.addOneParam("ttl", TEPWPingTestReport.nonvalueStr, row);
            }
        }
    }

    class TEPingRespondReportHandler
    implements NoticeHandler {
        TEPingRespondReportHandler() {
        }

        public void handleNotice(int cmdKey, int neID, Operation oper) {
            Output outPut = oper.getOutput(0);
            RowParams row = new RowParams();
            TEPWPingTestReport.this.bussinessParams.addRowParams(row);
            Param param = new Param("eventType", "0");
            row.addParam(param);
            param = new Param("indexName", TEPWPingTestReport.this.indexName);
            row.addParam(param);
            TEPWPingTestReport.this.addParam(outPut, TEPWPingTestReport.this.indexName, row);
            TEPWPingTestReport.addParamForIP(outPut, "lsrId", row);
            TEPWPingTestReport.this.addParam(outPut, "packageNum", row);
            TEPWPingTestReport.this.addParam(outPut, "serialNo", row);
            TEPWPingTestReport.this.addParam(outPut, "time", row);
            TEPWPingTestReport.this.addParam(outPut, "ttl", row);
            TEPWPingTestReport.this.addParam(outPut, "rtnCode", row);
            TEPWPingTestReport.this.addParam(outPut, "subRtnCode", row);
            TEPWPingTestReport.this.addParam(outPut, "nodetype", row);
            TEPWPingTestReport.addParamForIP(outPut, "downstreamlsrid", row);
            TEPWPingTestReport.this.addParam(outPut, "downstreamlabel", row);
        }
    }
}

