/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpls;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEBatchSendMessageBean;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TENETunnelLableMgr
extends TENEExplorerBean {
    private static final int INVALID_SLOT_ID = 0;
    private static final String IN_LABEL = "in";
    private static final String OUT_LABEL = "out";
    private static final String IN_SLOT_ID_NAME = "inslot";
    private static final String OUT_SLOT_ID_NAME = "outslot";
    private static final String INVALID_VALUE = "-";
    private static final int SLOT_OF_VIRTUAL_PORT = 65535;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        Operation oper = null;
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            oper = (Operation)operationList.get(i);
            if (!oper.getName().equals("NSCMD_CFG_MPLS_GET_TUNNELCROSS")) continue;
            Output[] outputArr = oper.getOutput();
            for (int j = 0; j < outputArr.length; ++j) {
                Output output = outputArr[j];
                String errorCode = output.getFault(0).getCode();
                if (!errorCode.equals(String.valueOf(0))) continue;
                this.processSlotParam(output, IN_SLOT_ID_NAME, IN_LABEL);
                this.processSlotParam(output, OUT_SLOT_ID_NAME, OUT_LABEL);
            }
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
    }

    public int sendMessage(int neid, ArrayList operationList, int timeout) {
        if (operationList.size() > 50) {
            TENEBatchSendMessageBean batcher = new TENEBatchSendMessageBean();
            batcher.setTimeout(60);
            return batcher.sendMessageBatch(neid, operationList, 200);
        }
        return super.sendMessage(neid, operationList, timeout);
    }

    private void processSlotParam(Output output, String paramName, String paramPreName) {
        int slot = Integer.parseInt(output.getPartValue(paramName));
        if (0 == slot) {
            output.getPart(paramName).setValue(INVALID_VALUE);
        } else if (65535 == slot) {
            this.handelVirtualPort(output, paramPreName);
        } else {
            this.fillParamInOutput(output, paramPreName, slot);
        }
    }

    private void handelVirtualPort(Output output, String paramPreName) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME");
        if (oper == null) {
            return;
        }
        String port = output.getPartValue(paramPreName + "Port");
        Input input = oper.getInput();
        input.setPartValue("slotid", String.valueOf(65535));
        input.setPartValue("subslotid", "255");
        input.setPartValue("port", port);
        ArrayList<Object> queryList = new ArrayList<Object>();
        queryList.add(oper.clone());
        int result = this.sendMessage(this.neid, queryList);
        if (result == 0) {
            Output virtualPortOutput = ((Operation)queryList.get(0)).getOutput(0);
            if (String.valueOf(0).equals(virtualPortOutput.getFault(0).getCode())) {
                TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
                int boardType = cfgMgr.getBoardType(this.neid, 65535);
                String mpPortDefName = cfgMgr.getPortNameForPTN(this.neid, 65535, boardType, Integer.parseInt(port));
                Part tempPart = new Part();
                tempPart.setName(paramPreName + "PortName");
                tempPart.setValue(IOStreamConvertor.replaceSpecialStr((String)mpPortDefName));
                output.addPart(tempPart);
            }
        }
        output.removePart(output.getPart(paramPreName + "slot"));
    }

    private void fillParamInOutput(Output output, String paramPreName, int slotid) {
        TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
        int inBoardType = cfgMgr.getBoardType(this.neid, slotid);
        String inBoardName = cfgMgr.getBoardTypeName(this.neid, inBoardType);
        int inPort = Integer.parseInt(output.getPartValue(paramPreName + "Port"));
        String inPortName = cfgMgr.getPortNameForPTN(this.neid, slotid, inBoardType, inPort);
        Part tempPart = new Part();
        tempPart.setName(paramPreName + "BoardName");
        tempPart.setValue(inBoardName);
        output.addPart(tempPart);
        tempPart = new Part();
        tempPart.setName(paramPreName + "PortName");
        tempPart.setValue(inPortName);
        output.addPart(tempPart);
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errCodeList = new ArrayList<Integer>();
        errCodeList.add(38662);
        return errCodeList;
    }
}

