/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpls;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEBatchSendMessageBean;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class TENEQueryPWSuperBean
extends TENEExplorerBean {
    protected static final String QUERY_PW_CMD = "NSCMD_PTN_MPLS_PW_GET_PW";
    protected static final String QUERY_PW_INFO_CMD = "NSCMD_PTN_MPLS_PW_GET_STATE";
    protected static final String QUERY_MPLS_TUNNEL_ID_CMD = "NSCMD_CFG_MPLS_GET_TUNNEL";
    protected static final String QUERY_IP_TUNNEL_ID_CMD = "NSCMD_CFG_IP_TNL_GET_TUNNEL";
    protected static final String QUERY_GRE_TUNNEL_ID_CMD = "NSCMD_CFG_GRE_TNL_GET_TUNNEL";
    protected static final String QUERY_STATIC_TUNNEL_CMD = "NSCMD_CFG_MPLS_GET_STATICTUNNEL";
    protected static final String NSCMD_PTN_MPLS_PW_GET_EGRESS_TNL = "NSCMD_PTN_MPLS_PW_GET_EGRESS_TNL";
    protected static final String NSCMD_PTN_MPLS_PW_GET_CES_EMULPARA = "NSCMD_PTN_MPLS_PW_GET_CES_EMULPARA";
    protected static final int QUERY_PW_INFO_CMD_INDEX = 0;
    protected static final int QUERY_TUNNEL_ID_CMD_INDEX = 1;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        ArrayList secOperNameList = this.getSecOperNameList(neid);
        ArrayList tempSecOperList = TEDataConverter.convertToOperation((SubFunc)subfunc, (Datainterface)this.inputData, (int)neid, (ArrayList)secOperNameList);
        Operation queryPWInfoOper = (Operation)tempSecOperList.get(0);
        ArrayList<Object> secOperList = new ArrayList<Object>();
        Operation oper = null;
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            oper = (Operation)operationList.get(i);
            if (oper.getName().indexOf(QUERY_PW_CMD) == -1) continue;
            Output[] output = oper.getOutput();
            for (int j = 0; j < output.length; ++j) {
                String pwIndex;
                String errCode = output[j].getFault()[0].getCode();
                if (!errCode.equals(String.valueOf(0)) || (pwIndex = output[j].getPartValue("pwIndex")) == null || pwIndex.equals("")) continue;
                queryPWInfoOper.getInput().setPartValue("pwIndex", pwIndex);
                secOperList.add(queryPWInfoOper.clone());
                this.fillQueryTunnelOper(output[j], secOperList, tempSecOperList.subList(1, tempSecOperList.size()), pwIndex);
            }
        }
        if (!secOperList.isEmpty()) {
            TENEBatchSendMessageBean batcher = new TENEBatchSendMessageBean();
            if (secOperList.size() < 50) {
                batcher.setTimeout(this.getTimeOut());
            } else {
                batcher.setTimeout(60);
            }
            int result = batcher.sendMessageBatch(neid, secOperList, 800);
            if (result == 0) {
                this.handleTunnelId(operationList, secOperList);
                operationList.addAll(secOperList);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
        }
        super.handleMessage(neid, operationList, subfunc);
    }

    protected void fillQueryTunnelOper(Output output, List secOperList, List queryTunnelOperList, String pwIndex) {
        String tunnelCountStr = output.getPartValue("tunnelCount");
        if (tunnelCountStr == null || tunnelCountStr.equals("")) {
            return;
        }
        Operation queryTunnelOper = null;
        int tunnelCount = Integer.parseInt(tunnelCountStr);
        String tunnelIndexListStr = output.getPartValue("tunnelIndexList");
        for (int i = 0; i < tunnelCount; ++i) {
            String tunnelIndex = tunnelIndexListStr.substring(8 * i, 8 * i + 8);
            if (tunnelIndex == null || tunnelIndex.equals("")) continue;
            Long tunnelIndexLongValue = Long.parseLong(tunnelIndex, 16);
            int n = queryTunnelOperList.size();
            for (int j = 0; j < n; ++j) {
                queryTunnelOper = (Operation)queryTunnelOperList.get(j);
                queryTunnelOper.getInput().setPartValue("tunnelindex", String.valueOf(tunnelIndexLongValue));
                secOperList.add(queryTunnelOper.clone());
            }
            Part part = new Part();
            part.setName("tunnelid");
            part.setValue(String.valueOf(tunnelIndexLongValue));
            output.addPart(part);
            part = new Part();
            part.setName("tunneltype");
            part.setValue("");
            output.addPart(part);
        }
    }

    protected void handleTunnelId(ArrayList operationList, ArrayList secOperList) {
        int i;
        HashMap<String, String> tempMap = new HashMap<String, String>();
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        Output output = null;
        Operation oper = null;
        Part vPart = null;
        int errCode = 0;
        int size = secOperList.size();
        for (i = 0; i < size; ++i) {
            oper = (Operation)secOperList.get(i);
            output = oper.getOutput(0);
            errCode = Integer.valueOf(output.getFault(0).getCode());
            if (oper.getName().equals(QUERY_PW_INFO_CMD) && 0 != errCode) continue;
            String tunnelIndex = output.getPartValue("tunnelindex");
            String tunnelId = output.getPartValue("tunnelid");
            vPart = output.getPart("tunnelid");
            output.removePart(vPart);
            vPart = output.getPart("tunneltype");
            output.removePart(vPart);
            tempMap.put(tunnelIndex, tunnelId);
            tmpMap.put(tunnelIndex, oper.getName());
        }
        this.deleteRedundantCmd(secOperList, tempMap);
        size = operationList.size();
        for (i = 0; i < size; ++i) {
            oper = (Operation)operationList.get(i);
            if (oper.getName().indexOf(QUERY_PW_CMD) == -1) continue;
            Output[] outputes = oper.getOutput();
            for (int j = 0; j < outputes.length; ++j) {
                String tunnelid;
                output = outputes[j];
                errCode = Integer.valueOf(output.getFault(0).getCode());
                if (0 != errCode || (tunnelid = output.getPartValue("tunnelid")) == null || tunnelid.equals("")) continue;
                output.setPartValue("tunnelid", (String)tempMap.get(tunnelid));
                output.setPartValue("tunneltype", "MPLS");
            }
        }
    }

    protected void deleteRedundantCmd(ArrayList operList, Map<String, String> tunnelMap) {
        Part part = null;
        Input input = null;
        Operation oper = null;
        int errCode = 0;
        Iterator iter = operList.iterator();
        while (iter.hasNext()) {
            oper = (Operation)iter.next();
            input = oper.getInput();
            part = input.getPart("tunnelindex");
            if (null == part || !tunnelMap.containsKey(part.getValue()) || 0 == (errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode()).intValue())) continue;
            iter.remove();
        }
    }

    protected abstract ArrayList getSecOperNameList(int var1);

    protected abstract String getTunneltype(Map<String, String> var1, String var2);
}

