/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpls;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEGetTunnelAvailablePorts
extends TENEExplorerBean {
    protected static final int INVALID_SLOT = 65535;
    protected static final int INVALID_SUB_SLOT = 255;
    private static final int LAYER_3 = 3;
    private static final int MPLS_ENABLE = 1;
    private boolean isFilter = true;
    protected List<PortObj> availablePorts = new ArrayList<PortObj>();
    private TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        Param param = inputData.getBussinessParams().getRowParams(0).getParam("isfilter");
        if (null != param) {
            this.isFilter = Integer.valueOf(param.getValue()) != 0;
        }
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        this.getPhysicsPorts();
        this.getLogicPorts();
        this.filterPorts();
        Collections.sort(this.availablePorts);
        PortObj portObj = null;
        RowParams rowParams = null;
        int m = this.availablePorts.size();
        for (int i = 0; i < m; ++i) {
            portObj = this.availablePorts.get(i);
            rowParams = new RowParams();
            rowParams.addParam("slotid", String.valueOf(portObj.slotId));
            rowParams.addParam("boardname", String.valueOf(portObj.boardName));
            rowParams.addParam("portid", String.valueOf(portObj.portId));
            rowParams.addParam("portname", String.valueOf(portObj.portName));
            rowParams.addParam("portmode", String.valueOf(portObj.portMode));
            rowParams.addParam("mplsen", String.valueOf(portObj.mplsEn));
            rowParams.addParam("portenable", String.valueOf(portObj.portEnable));
            rowParams.addParam("encaptype", String.valueOf(portObj.encapType));
            rowParams.addParam("workmode", String.valueOf(portObj.workMode));
            rowParams.addParam("tag", String.valueOf(portObj.tag));
            rowParams.addParam("ip", String.valueOf(portObj.ipAddr));
            rowParams.addParam("mask", String.valueOf(portObj.ipMask));
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
        return this.outputData;
    }

    protected void getPhysicsPorts() {
        ArrayList portList = null;
        TEPort port = null;
        TEBoard board = null;
        int slotId = -1;
        int boardType = -1;
        int portId = -1;
        Vector boardVec = this.cfgMgr.getNE(this.neid).getClonedBoardList();
        int m = boardVec.size();
        for (int i = 0; i < m; ++i) {
            portList = new ArrayList();
            board = (TEBoard)boardVec.get(i);
            slotId = board.getSlotID();
            boardType = board.getBoardType();
            if (this.cfgMgr.isIFboard(boardType)) {
                portList.addAll(this.cfgMgr.getPortList(this.neid, slotId, 1802));
            } else {
                portList.addAll(this.cfgMgr.getPortList(this.neid, slotId, 1799));
            }
            ArrayList locicPrtlist = this.cfgMgr.getLogicPortList(this.neid, slotId);
            int n = portList.size();
            for (int j = 0; j < n; ++j) {
                port = (TEPort)portList.get(j);
                portId = port.getPortNo();
                if (!locicPrtlist.contains(portId)) continue;
                this.availablePorts.add(new PortObj(slotId, boardType, board.getBoardName(), portId, this.cfgMgr.getPortNameForPTN(this.neid, slotId, boardType, portId)));
            }
        }
    }

    private void getLogicPorts() {
        this.operationList = new ArrayList();
        this.operationList.add(TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_PORT_GET_VPORT"));
        this.operationList.add(TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_MLPPP_GET_MP"));
        PortObj portObj = null;
        int result = this.sendMessage(this.neid);
        if (0 == result) {
            int errCode = 0;
            Operation oper = null;
            Output output = null;
            Part part = null;
            int m = this.operationList.size();
            for (int i = 0; i < m; ++i) {
                oper = (Operation)this.operationList.get(i);
                errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
                if (0 != errCode) continue;
                int n = oper.getOutputCount();
                for (int j = 0; j < n; ++j) {
                    portObj = new PortObj();
                    output = oper.getOutput(j);
                    part = output.getPart("groupno");
                    if (null != part) {
                        portObj.portId = Integer.valueOf(part.getValue());
                        portObj.boardName = "ML-PPP";
                    } else {
                        portObj.portId = Integer.valueOf(output.getPartValue("port"));
                        portObj.boardName = "Virtual Ethernet";
                    }
                    portObj.portName = this.cfgMgr.getPortNameForPTN(this.neid, portObj.slotId, portObj.boardType, portObj.portId);
                    if (this.availablePorts.contains(portObj)) continue;
                    this.availablePorts.add(portObj);
                }
            }
        }
    }

    protected void filterPorts() {
        int result;
        this.operationList.clear();
        Operation oper1 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTNETY_GET_LEVELMODE");
        Input input1 = oper1.getInput();
        input1.setPartValue("subslotid", String.valueOf(255));
        Operation oper2 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_L3_GET_MPLSEN");
        Input input2 = oper2.getInput();
        input2.setPartValue("subslotid", String.valueOf(255));
        Operation oper3 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME");
        Input input3 = oper3.getInput();
        input3.setPartValue("subslotid", String.valueOf(255));
        Operation oper4 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTNETH_GET_ENABLE");
        Input input4 = oper4.getInput();
        input4.setPartValue("subslotid", String.valueOf(255));
        Operation oper5 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_L2PORTBASE_GET_ENCAPTYPE");
        Input input5 = oper5.getInput();
        input5.setPartValue("subslotid", String.valueOf(255));
        Operation oper6 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTNETY_GET_WORKMODE");
        Input input6 = oper6.getInput();
        input6.setPartValue("subslotid", String.valueOf(255));
        Operation oper7 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTNETH_GET_TAG");
        Input input7 = oper7.getInput();
        input7.setPartValue("subslotid", String.valueOf(255));
        Operation oper8 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_L3_GET_IPPARA");
        Input input8 = oper8.getInput();
        input8.setPartValue("subslotid", String.valueOf(255));
        int slotId = -1;
        int portId = -1;
        PortObj portObj = null;
        int m = this.availablePorts.size();
        for (int i = 0; i < m; ++i) {
            portObj = this.availablePorts.get(i);
            slotId = portObj.slotId;
            portId = portObj.portId;
            input1.setPartValue("slotid", String.valueOf(slotId));
            input1.setPartValue("port", String.valueOf(portId));
            this.operationList.add(oper1.clone());
            input2.setPartValue("slotid", String.valueOf(slotId));
            input2.setPartValue("port", String.valueOf(portId));
            this.operationList.add(oper2.clone());
            input3.setPartValue("slotid", String.valueOf(slotId));
            input3.setPartValue("port", String.valueOf(portId));
            this.operationList.add(oper3.clone());
            input4.setPartValue("slotid", String.valueOf(slotId));
            input4.setPartValue("port", String.valueOf(portId));
            this.operationList.add(oper4.clone());
            input5.setPartValue("slotid", String.valueOf(slotId));
            input5.setPartValue("port", String.valueOf(portId));
            this.operationList.add(oper5.clone());
            input6.setPartValue("slotid", String.valueOf(slotId));
            input6.setPartValue("port", String.valueOf(portId));
            this.operationList.add(oper6.clone());
            input7.setPartValue("slotid", String.valueOf(slotId));
            input7.setPartValue("port", String.valueOf(portId));
            this.operationList.add(oper7.clone());
            input8.setPartValue("slotid", String.valueOf(slotId));
            input8.setPartValue("port", String.valueOf(portId));
            this.operationList.add(oper8.clone());
        }
        if (this.operationList.size() > 0 && 0 == (result = this.sendMessage(this.neid))) {
            this.handleFilterPorts();
        }
    }

    protected void handleFilterPorts() {
        Operation oper = null;
        Output output = null;
        int portMode = -1;
        int mplsEn = 0;
        int slotId = -1;
        int portId = -1;
        int errCode = 0;
        int m = this.operationList.size();
        for (int i = 0; i < m; i += 8) {
            oper = (Operation)this.operationList.get(i);
            output = oper.getOutput(0);
            errCode = Integer.valueOf(output.getFault(0).getCode());
            if (0 != errCode) continue;
            portMode = Integer.valueOf(output.getPartValue("PTNIF_PORT_ATTR_MODE"));
            slotId = Integer.valueOf(output.getPartValue("slotid"));
            portId = Integer.valueOf(output.getPartValue("port"));
            if (!this.isFilter) {
                this.setPortAttr(slotId, portId, i);
                continue;
            }
            if (3 != portMode) {
                this.availablePorts.remove(new PortObj(slotId, portId));
                continue;
            }
            oper = (Operation)this.operationList.get(i + 1);
            output = oper.getOutput(0);
            errCode = Integer.valueOf(output.getFault(0).getCode());
            if (0 != errCode) continue;
            mplsEn = Integer.valueOf(output.getPartValue("PTNIF_PORT_ATTR_MPLSEN"));
            if (1 != mplsEn) {
                this.availablePorts.remove(new PortObj(slotId, portId));
                continue;
            }
            this.setPortAttr(slotId, portId, i);
        }
    }

    private void setPortAttr(int slotId, int portId, int start) {
        PortObj portObj = new PortObj(slotId, portId);
        int index = this.availablePorts.indexOf(portObj);
        if (index < 0) {
            return;
        }
        portObj = this.availablePorts.get(index);
        this.setPortComAttr(portObj, "PTNIF_PORT_ATTR_MODE", (Operation)this.operationList.get(start));
        this.setPortComAttr(portObj, "PTNIF_PORT_ATTR_MPLSEN", (Operation)this.operationList.get(start + 1));
        this.setLogicPortName(portObj, (Operation)this.operationList.get(start + 2));
        this.setPortComAttr(portObj, "ATTR_ETHOVERPTN_MAC_ENABLE", (Operation)this.operationList.get(start + 3));
        this.setPortComAttr(portObj, "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE", (Operation)this.operationList.get(start + 4));
        this.setPortComAttr(portObj, "ATTR_ETHOVERPTN_MAC_WORKMODE", (Operation)this.operationList.get(start + 5));
        this.setPortComAttr(portObj, "ATTR_ETHOVERPTN_MAC_TAG", (Operation)this.operationList.get(start + 6));
        this.setPortIP(portObj, (Operation)this.operationList.get(start + 7));
    }

    private void setLogicPortName(PortObj portObj, Operation oper) {
        String name;
        Output output;
        int errCode;
        if (65535 == portObj.slotId && 0 == (errCode = Integer.valueOf((output = oper.getOutput(0)).getFault(0).getCode()).intValue()) && null != (name = IOStreamConvertor.replaceSpecialStr((String)output.getPartValue("PTNIF_PORT_ATTR_PORTNAME"))) && !"".equals(name.trim())) {
            String portName = portObj.portName;
            portObj.portName = portName = portName.substring(0, portName.indexOf("-") + 1) + name + ")";
        }
    }

    private void setPortComAttr(PortObj portObj, String attrType, Operation oper) {
        Output output = oper.getOutput(0);
        int errCode = Integer.valueOf(output.getFault(0).getCode());
        if (0 == errCode) {
            int attrValue = Integer.valueOf(output.getPartValue(attrType));
            if ("PTNIF_PORT_ATTR_MODE".equals(attrType)) {
                portObj.portMode = attrValue;
            } else if ("PTNIF_PORT_ATTR_MPLSEN".equals(attrType)) {
                portObj.mplsEn = attrValue;
            } else if ("ATTR_ETHOVERPTN_MAC_ENABLE".equals(attrType)) {
                portObj.portEnable = attrValue;
            } else if ("ATTR_ETHOVERPTN_MAC_ENCAP_TYPE".equals(attrType)) {
                portObj.encapType = attrValue;
            } else if ("ATTR_ETHOVERPTN_MAC_WORKMODE".equals(attrType)) {
                portObj.workMode = attrValue;
            } else if ("ATTR_ETHOVERPTN_MAC_TAG".equals(attrType)) {
                portObj.tag = attrValue;
            }
        }
    }

    private void setPortIP(PortObj portObj, Operation oper) {
        Output output = oper.getOutput(0);
        int errCode = Integer.valueOf(output.getFault(0).getCode());
        if (0 == errCode) {
            portObj.ipAddr = TEConvertUtil.ipToString((long)Long.valueOf(output.getPartValue("PTNIF_PORT_ATTR_IPPARA")));
            portObj.ipMask = TEConvertUtil.ipToString((long)Long.valueOf(output.getPartValue("PTNIF_PORT_ATTR_IPPARAT")));
        }
    }

    protected class PortObj
    implements Comparable<PortObj> {
        public int slotId = 65535;
        public int boardType = -1;
        public String boardName = "UNKNOWN";
        public int portId = -1;
        public String portName = "";
        public int portMode = -1;
        public int mplsEn = -1;
        public int portEnable = -1;
        public int encapType = -1;
        public int workMode = -1;
        public int tag = -1;
        public String ipAddr = "";
        public String ipMask = "";

        public PortObj() {
        }

        public PortObj(int slotId, int portId) {
            this.slotId = slotId;
            this.portId = portId;
        }

        public PortObj(int slotId, int boardType, String boardName, int portId, String portName) {
            this.slotId = slotId;
            this.boardType = boardType;
            this.boardName = boardName;
            this.portId = portId;
            this.portName = portName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.slotId;
            result = 31 * result + this.portId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortObj other = (PortObj)obj;
            if (this.slotId != other.slotId) {
                return false;
            }
            return this.portId == other.portId;
        }

        @Override
        public int compareTo(PortObj o) {
            if (this.slotId == o.slotId) {
                return this.portId - o.portId;
            }
            return this.slotId - o.slotId;
        }
    }
}

