/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpgroup;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nelist.model.circuitpack.TESDContianMOCount;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TEGetMPPortRes
extends TENEExplorerBean {
    private static final int GET_IP_PORT = 1;
    private static final int GET_MEMBER_INTERFACE = 2;
    private List<String> usedPorts = new ArrayList<String>();
    private List<String> unusedPorts = new ArrayList<String>();
    private TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        int operType = Integer.valueOf(inputData.getBussinessParams().getRowParams(0).getParam("opertype").getValue());
        if (1 != operType) {
            int result;
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            if (null != this.operationList && this.operationList.size() > 0 && (result = this.sendMessage(neid)) == 0) {
                this.getUsedPorts();
            }
            this.getE1Ports();
            this.getSerialPorts();
            Collections.sort(this.unusedPorts, new SortComparator());
            if (!this.unusedPorts.isEmpty()) {
                RowParams rowParams = new RowParams();
                Param param = new Param("memberinterfaces", "");
                int m = this.unusedPorts.size();
                for (int i = 0; i < m; ++i) {
                    param.addOption(new Option(this.unusedPorts.get(i)));
                }
                rowParams.addParam(param);
                this.outputData.getBussinessParams().addRowParams(rowParams);
            }
        }
        if (2 != operType) {
            this.getIPPortList();
        }
        return this.outputData;
    }

    private void getUsedPorts() {
        Operation oper = (Operation)this.operationList.get(0);
        int errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
        if (0 == errCode) {
            Output output = null;
            int m = oper.getOutputCount();
            for (int i = 0; i < m; ++i) {
                output = oper.getOutput(i);
                this.usedPorts.add(output.getPartValue("slotid") + "-" + output.getPartValue("port"));
            }
        }
    }

    private void getIPPortList() {
        int portId = -1;
        TEBoard board = null;
        this.operationList = new ArrayList();
        Operation operIp = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME");
        Input input = operIp.getInput();
        input.setPartValue("slotid", String.valueOf(65535));
        input.setPartValue("port", "0");
        this.operationList.add(operIp.clone());
        operIp = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_L3_GET_IPPARA");
        input = operIp.getInput();
        Vector bdVec = this.cfgMgr.getNE(this.neid).getClonedBoardList();
        int m = bdVec.size();
        for (int i = 0; i < m; ++i) {
            board = (TEBoard)bdVec.get(i);
            input.setPartValue("slotid", String.valueOf(board.getSlotID()));
            input.setPartValue("port", "0");
            this.operationList.add(operIp.clone());
        }
        input.setPartValue("slotid", String.valueOf(65535));
        input.setPartValue("port", "0");
        this.operationList.add(operIp.clone());
        int result = this.sendMessage(this.neid);
        if (0 == result) {
            String portName = null;
            Output output = null;
            TIntObjectHashMap mpPortNameMap = new TIntObjectHashMap();
            RowParams rowParams = new RowParams();
            Param paramTmp = new Param("borrowedports", "");
            rowParams.addParam(paramTmp);
            int errCode = 0;
            operIp = (Operation)this.operationList.get(0);
            errCode = Integer.valueOf(operIp.getOutput(0).getFault(0).getCode());
            if (0 == errCode) {
                int mn = operIp.getOutputCount();
                for (int k = 0; k < mn; ++k) {
                    output = operIp.getOutput(k);
                    portId = Integer.valueOf(output.getPartValue("port"));
                    portName = IOStreamConvertor.replaceSpecialStr((String)output.getPartValue("PTNIF_PORT_ATTR_PORTNAME"));
                    if ("".equalsIgnoreCase(portName)) continue;
                    mpPortNameMap.put(portId, (Object)portName);
                }
            }
            this.handleIPPortAttr((TIntObjectHashMap<String>)mpPortNameMap, paramTmp);
            if (paramTmp.getOptionCount() > 0) {
                this.outputData.getBussinessParams().addRowParams(rowParams);
            }
        }
    }

    private void handleIPPortAttr(TIntObjectHashMap<String> mpPortNameMap, Param param) {
        int errCode = 0;
        int slotId = 0;
        int portId = 0;
        int boardType = 0;
        String resName = null;
        String portName = null;
        Operation oper = null;
        Output output = null;
        int n = this.operationList.size();
        for (int j = 1; j < n; ++j) {
            oper = (Operation)this.operationList.get(j);
            errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
            if (0 != errCode) continue;
            int mn = oper.getOutputCount();
            for (int k = 0; k < mn; ++k) {
                output = oper.getOutput(k);
                slotId = Integer.valueOf(output.getPartValue("slotid"));
                portId = Integer.valueOf(output.getPartValue("port"));
                if (1 != Integer.valueOf(output.getPartValue("PTNIF_PORT_ATTR_IPPARATYPE")) || 0xFFFFFFFFL == Long.valueOf(output.getPartValue("PTNIF_PORT_ATTR_IPPARA")) || 0xFFFFFFFFL == Long.valueOf(output.getPartValue("PTNIF_PORT_ATTR_IPPARAT"))) continue;
                boardType = this.cfgMgr.getBoardType(this.neid, slotId);
                portName = this.cfgMgr.getPortNameForPTN(this.neid, slotId, boardType, portId);
                if (mpPortNameMap.contains(portId)) {
                    portName = portName.substring(0, portName.indexOf(45) + 1) + (String)mpPortNameMap.get(portId) + ")";
                }
                resName = slotId + "-" + this.cfgMgr.getBoardTypeName(this.neid, boardType) + "-" + portName;
                param.addOption(new Option(resName + "#" + portId));
            }
        }
    }

    private void getE1Ports() {
        TEBoard board = null;
        TIntArrayList portList = null;
        Map.Entry<TEBoard, TIntArrayList> entry2 = null;
        Iterator<Map.Entry<TEBoard, TIntArrayList>> iter = null;
        this.operationList = new ArrayList();
        Operation oper1 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_E1_GET_CHNLMODE");
        Input input1 = oper1.getInput();
        Operation oper2 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_L2PORTBASE_GET_ENCAPTYPE");
        Input input2 = oper2.getInput();
        for (Map.Entry<TEBoard, TIntArrayList> entry2 : this.getPortsByPortType(this.neid, 1797).entrySet()) {
            board = entry2.getKey();
            portList = entry2.getValue();
            int m = portList.size();
            for (int i = 0; i < m; ++i) {
                input1.setPartValue("slotid", String.valueOf(board.getSlotID()));
                input1.setPartValue("port", String.valueOf(portList.get(i)));
                this.operationList.add(oper1.clone());
                input2.setPartValue("slotid", String.valueOf(board.getSlotID()));
                input2.setPartValue("port", String.valueOf(portList.get(i)));
                this.operationList.add(oper2.clone());
            }
        }
        this.queryE1PortAttr();
    }

    private void queryE1PortAttr() {
        if (this.operationList.size() > 0) {
            int slotId = 0;
            int boardType = 0;
            int portId = 0;
            Operation oper = null;
            Output output = null;
            int result = this.sendMessage(this.neid);
            if (0 == result) {
                int n = this.operationList.size();
                for (int j = 0; j < n; j += 2) {
                    oper = (Operation)this.operationList.get(j);
                    output = oper.getOutput(0);
                    if ((0 != Integer.valueOf(output.getFault(0).getCode()) || 0 != Integer.valueOf(output.getPartValue("PTNIF_PORT_ATTR_CHNL"))) && 0 == Integer.valueOf(output.getFault(0).getCode()) || 0 != Integer.valueOf((output = (oper = (Operation)this.operationList.get(j + 1)).getOutput(0)).getFault(0).getCode()) || 5 != Integer.valueOf(output.getPartValue("ATTR_ETHOVERPTN_MAC_ENCAP_TYPE"))) continue;
                    slotId = Integer.valueOf(output.getPartValue("slotid"));
                    boardType = this.cfgMgr.getBoardType(this.neid, slotId);
                    portId = Integer.valueOf(output.getPartValue("port"));
                    if (this.usedPorts.contains(slotId + "-" + portId)) continue;
                    this.unusedPorts.add(slotId + "-" + this.cfgMgr.getBoardTypeName(this.neid, boardType) + "-" + this.cfgMgr.getPortNameForPTN(this.neid, slotId, boardType, portId) + "#" + portId);
                }
            }
        }
    }

    private void getSerialPorts() {
        int result;
        int slotId = -1;
        int boardType = -1;
        TEBoard board = null;
        ArrayList moList = null;
        TESDContianMOCount mo = null;
        this.operationList = new ArrayList();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_PORT_GET_SERIALPORT");
        Input input = oper.getInput();
        TECircuitPackDescription cpds = TECircuitPackDescription.getInstance();
        Vector bdVec = this.cfgMgr.getNE(this.neid).getClonedBoardList();
        int m = bdVec.size();
        block0: for (int i = 0; i < m; ++i) {
            board = (TEBoard)bdVec.get(i);
            slotId = board.getSlotID();
            boardType = this.cfgMgr.getBoardType(this.neid, slotId);
            moList = cpds.getCPContainMO(boardType);
            if (null == moList) continue;
            int n = moList.size();
            for (int j = 0; j < n; ++j) {
                mo = (TESDContianMOCount)moList.get(j);
                if (!"TEPTNSerialGroupContainer".equals(mo.moName)) continue;
                input.setPartValue("slotid", String.valueOf(slotId));
                this.operationList.add(oper.clone());
                continue block0;
            }
        }
        if (this.operationList.size() > 0 && 0 == (result = this.sendMessage(this.neid))) {
            Output output = null;
            ArrayList<Object> operList = new ArrayList<Object>();
            Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_L2PORTBASE_GET_ENCAPTYPE");
            input = operation.getInput();
            int m2 = this.operationList.size();
            for (int i = 0; i < m2; ++i) {
                oper = (Operation)this.operationList.get(i);
                if (0 != Integer.valueOf(oper.getOutput(0).getFault(0).getCode())) continue;
                int n = oper.getOutputCount();
                for (int j = 0; j < n; ++j) {
                    output = oper.getOutput(j);
                    input.setPartValue("slotid", output.getPartValue("slotid"));
                    input.setPartValue("port", output.getPartValue("port"));
                    operList.add(operation.clone());
                }
            }
            this.querySerialPortAttr(operList);
        }
    }

    private void querySerialPortAttr(ArrayList operList) {
        if (!operList.isEmpty()) {
            int slotId = -1;
            int boardType = -1;
            int portId = -1;
            Operation oper = null;
            Output output = null;
            int result = this.sendMessage(this.neid, operList);
            if (0 == result) {
                int n = operList.size();
                for (int j = 0; j < n; ++j) {
                    Part[] parts;
                    oper = (Operation)operList.get(j);
                    output = oper.getOutput(0);
                    if (0 != Integer.valueOf(output.getFault(0).getCode()) || 5 != Integer.valueOf((parts = output.getPart())[parts.length - 1].getValue())) continue;
                    slotId = Integer.valueOf(output.getPartValue("slotid"));
                    boardType = this.cfgMgr.getBoardType(this.neid, slotId);
                    portId = Integer.valueOf(output.getPartValue("port"));
                    if (this.usedPorts.contains(slotId + "-" + portId)) continue;
                    this.unusedPorts.add(slotId + "-" + this.cfgMgr.getBoardTypeName(this.neid, boardType) + "-" + this.cfgMgr.getPortNameForPTN(this.neid, slotId, boardType, portId) + "#" + portId);
                }
            }
        }
    }

    private Map<TEBoard, TIntArrayList> getPortsByPortType(int neid, int portType) {
        HashMap<TEBoard, TIntArrayList> ports = new HashMap<TEBoard, TIntArrayList>();
        int portId = 0;
        TEBoard boardTemp = null;
        TEPortProperty portProperty = null;
        ArrayList portPropertyList = null;
        TIntArrayList tPortList = null;
        Vector boardVec = this.cfgMgr.getNE(neid).getClonedBoardList();
        int m = boardVec.size();
        for (int i = 0; i < m; ++i) {
            tPortList = new TIntArrayList();
            boardTemp = (TEBoard)boardVec.get(i);
            portPropertyList = this.cfgMgr.getBoardPortPropertyList(neid, boardTemp.getBoardType());
            int n = portPropertyList.size();
            for (int jInde = 0; jInde < n; ++jInde) {
                portProperty = (TEPortProperty)portPropertyList.get(jInde);
                portId = portProperty.getPortNo();
                if (portProperty.getPortType() != portType || tPortList.contains(portId)) continue;
                tPortList.add(portId);
            }
            if (tPortList.size() <= 0) continue;
            ports.put((TEBoard)boardTemp.clone(), tPortList);
        }
        return ports;
    }

    class SortComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 7425302267948344976L;

        SortComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            String[] arr1 = o1.split("#");
            String[] arr2 = o2.split("#");
            int slotId1 = Integer.valueOf(arr1[0].split("-")[0]);
            int slotId2 = Integer.valueOf(arr2[0].split("-")[0]);
            int portId1 = Integer.valueOf(arr1[1]);
            int portId2 = Integer.valueOf(arr2[1]);
            if (slotId1 == slotId2) {
                return portId1 - portId2;
            }
            return slotId1 - slotId2;
        }
    }
}

