/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mirrormgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.mirrormgr.TEGetAvailabeService;
import com.huawei.nglct.nemgr.ip.ptn.mirrormgr.TEGetAvailabeUNI;
import com.huawei.nglct.nemgr.ip.ptn.mirrormgr.TEGetPWInfo;
import com.huawei.nglct.nemgr.ip.ptn.portmirror.TEQueryPortMirrorBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;

public class TEQueryMirrorBean
extends TEQueryPortMirrorBean {
    @Override
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (null == this.outputData) {
            return;
        }
        RowParams rowParams = null;
        int size = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < size; ++i) {
            RowParams row;
            Datainterface serviceInfo;
            StringBuffer sb;
            rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowParams.getRowErrorsCount() > 0 && !rowParams.getRowErrors(0).getErrorMessage().getErrorcode().equalsIgnoreCase("0")) continue;
            String mirrorIndex = rowParams.getParam("mirrorServiceIndex").getValue();
            int srcPointType = Integer.parseInt(rowParams.getParam("srcPointType").getValue());
            if (srcPointType == 0) {
                int slotid = Integer.parseInt(rowParams.getParam("srcparam1").getValue());
                String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid);
                TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
                String boardName = board.getBoardName();
                String slotIdStr = String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotid));
                int portid = Integer.parseInt(rowParams.getParam("srcparam3").getValue());
                this.mirrorPortName = slotIdStr + '-' + boardName + '-' + TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, slotid, board.getBoardType(), portid, 16);
                if (!"".equals(subrackName)) {
                    this.mirrorPortName = subrackName + "-" + this.mirrorPortName;
                }
                rowParams.addParam("srcPointName", this.mirrorPortName);
            } else if (srcPointType == 1) {
                String serviceIndex = rowParams.getParam("srcparam1").getValue();
                String uniID = rowParams.getParam("srcparam2").getValue();
                sb = new StringBuffer();
                serviceInfo = this.getServiceInfo(neid, serviceIndex);
                if (serviceInfo.getErrorMessage().getErrorcode().equals("0") && serviceInfo.getBussinessParams().getRowParamsCount() > 0) {
                    row = serviceInfo.getBussinessParams().getRowParams(0);
                    sb.append(row.getParam("serviceID").getValue());
                    Datainterface uniInfo = this.getUniInfo(neid, serviceIndex, uniID);
                    int len = uniInfo.getBussinessParams().getRowParamsCount();
                    for (int j = 0; j < len; ++j) {
                        row = uniInfo.getBussinessParams().getRowParams(j);
                        if (row.getRowErrorsCount() != 0) continue;
                        sb.append('-').append(row.getParam("portname").getValue());
                        sb.append('[');
                        sb.append(row.getParam("tagids").getValue());
                        sb.append(']');
                    }
                }
                this.mirrorPortName = sb.toString();
                rowParams.addParam("srcPointName", this.mirrorPortName);
            } else if (srcPointType == 2) {
                String serviceIndex = rowParams.getParam("srcparam1").getValue();
                String pwIndex = rowParams.getParam("srcparam3").getValue();
                sb = new StringBuffer();
                serviceInfo = this.getServiceInfo(neid, serviceIndex);
                if (serviceInfo.getErrorMessage().getErrorcode().equals("0") && serviceInfo.getBussinessParams().getRowParamsCount() > 0) {
                    row = serviceInfo.getBussinessParams().getRowParams(0);
                    sb.append(row.getParam("serviceID").getValue());
                    String pwID = TEGetPWInfo.getPWID(neid, subfunc, pwIndex);
                    if (!"".equals(pwID)) {
                        sb.append("-PW-").append(pwID);
                    }
                }
                this.mirrorPortName = sb.toString();
                rowParams.addParam("srcPointName", this.mirrorPortName);
            }
            int obsSlotid = Integer.parseInt(rowParams.getParam("obsPointSlotID").getValue());
            String obsSubrackName = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)obsSlotid);
            TEBoard obsBoard = TEConfigurationDataMgr.getInstance().getBoard(neid, obsSlotid);
            String slotIdStr = String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)neid, (int)obsSlotid));
            String obsBoardName = obsBoard.getBoardName();
            int obsportid = Integer.parseInt(rowParams.getParam("obsPointPortID").getValue());
            this.obsPortName = slotIdStr + '-' + obsBoardName + '-' + TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, obsSlotid, obsBoard.getBoardType(), obsportid, 16);
            if (!"".equals(obsSubrackName)) {
                this.obsPortName = obsSubrackName + '-' + this.obsPortName;
            }
            rowParams.addParam("obsPointName", this.obsPortName);
            int srcpointtype = Integer.parseInt(rowParams.getParam("srcPointType").getValue());
            String vlanIDListvar = "-";
            if (srcpointtype == 1) {
                vlanIDListvar = this.getVlanIDList(mirrorIndex);
            }
            rowParams.addParam("vlanIDList", vlanIDListvar);
        }
    }

    private String getVlanIDList(String mirrorIndex) {
        String vlanIDList = "";
        ArrayList<Operation> operations = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_ETHN_GET_MIRRORVLANLIST");
        Input input = operation.getInput();
        input.getPart("mirrorServiceIndex").setValue(mirrorIndex);
        operations.add(operation);
        int result = this.sendMessage(this.neid, operations);
        Output out = null;
        if (result == 0) {
            Operation oper = (Operation)operations.get(0);
            out = oper.getOutput(0);
            if (!out.getFault(0).getCode().equals("0")) {
                return vlanIDList;
            }
            int tagnum = 0;
            String tagList = null;
            int len = oper.getOutputCount();
            for (int i = 0; i < len; ++i) {
                out = oper.getOutput(i);
                tagnum = Integer.parseInt(out.getPartValue("tagnum"));
                tagList = out.getPartValue("taglist");
            }
            if (tagnum > 0) {
                vlanIDList = this.convertVlanList(tagnum, tagList);
            }
        }
        return vlanIDList;
    }

    private String convertVlanList(int tagnum, String taglist) {
        StringBuffer sb = new StringBuffer();
        int perVlanLen = 8;
        int last_1 = -1;
        boolean isSeries = false;
        for (int i = 0; i < tagnum; ++i) {
            int tmpVlan = Integer.parseInt(taglist.substring(i * perVlanLen, perVlanLen * (i + 1)), 16);
            if (i == 0) {
                sb.append(tmpVlan);
                if (i == tagnum - 1) break;
                last_1 = tmpVlan;
                continue;
            }
            if (tmpVlan - last_1 == 1) {
                if (!isSeries) {
                    sb.append('-');
                    if (i == tagnum - 1) {
                        sb.append(tmpVlan);
                        break;
                    }
                    isSeries = true;
                    last_1 = tmpVlan;
                    continue;
                }
                if (i == tagnum - 1) {
                    sb.append(tmpVlan);
                    break;
                }
                last_1 = tmpVlan;
                continue;
            }
            if (tmpVlan - last_1 <= 1) continue;
            if (isSeries) {
                sb.append(last_1).append(',');
                sb.append(tmpVlan);
                if (i == tagnum - 1) break;
                isSeries = false;
                last_1 = tmpVlan;
                continue;
            }
            sb.append(',');
            sb.append(tmpVlan);
            if (i == tagnum - 1) break;
            last_1 = tmpVlan;
        }
        return sb.toString();
    }

    private Datainterface getUniInfo(int neid, String serviceIndex, String uniID) {
        SubFunc tmpSubFunc = null;
        try {
            tmpSubFunc = TECreateObjectFactory.getSubFunc((int)neid, (int)2180140);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("get UNI subFunc exception", (Throwable)e);
        }
        Datainterface tmpInputData = new Datainterface();
        tmpInputData.setBussinessParams(new BussinessParams());
        RowParams row = new RowParams();
        row.addParam("neid", neid + "");
        row.addParam("ethType", "1");
        row.addParam("serviceIndex", serviceIndex);
        row.addParam("vuniID", uniID);
        tmpInputData.getBussinessParams().addRowParams(row);
        TEGetAvailabeUNI getUNIBean = new TEGetAvailabeUNI();
        return getUNIBean.performBussinessProcess(neid, tmpSubFunc, tmpInputData, this.memeryData, this.user, this.ipAddress);
    }

    private Datainterface getServiceInfo(int neid, String serviceIndex) {
        SubFunc tmpSubFunc = null;
        try {
            tmpSubFunc = TECreateObjectFactory.getSubFunc((int)neid, (int)2180139);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("get Service subFunc exception", (Throwable)e);
        }
        Datainterface tmpInputData = new Datainterface();
        tmpInputData.setBussinessParams(new BussinessParams());
        RowParams row = new RowParams();
        row.addParam("neid", neid + "");
        row.addParam("serviceIndex", serviceIndex);
        tmpInputData.getBussinessParams().addRowParams(row);
        TEGetAvailabeService getServiceBean = new TEGetAvailabeService();
        return getServiceBean.performBussinessProcess(neid, tmpSubFunc, tmpInputData, this.memeryData, this.user, this.ipAddress);
    }

    @Override
    public ArrayList getFilterErrorCodeList() {
        ArrayList filterCode = super.getFilterErrorCodeList();
        filterCode.add(44226);
        return filterCode;
    }

    protected String operationDescribtion() {
        StringBuffer operDesc = new StringBuffer();
        StringBuffer filePath = new StringBuffer(40);
        filePath.append("ip").append(File.separator).append("ptn").append(File.separator).append("res").append(File.separator).append("portmirror_ptn").append(File.separator).append("portmirrorres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        if (!this.mirrorPortName.isEmpty() && !this.obsPortName.isEmpty()) {
            operDesc.append(res.getString("mirrorport")).append(':').append(this.mirrorPortName).append(", ").append(res.getString("obsmirrorport")).append(':').append(this.obsPortName);
        } else {
            operDesc.append(res.getString("mirrorNull"));
        }
        return operDesc.toString();
    }
}

