/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mirrormgr;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.eline.LogicInf;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.eline.TECompareElineService;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.eline.TEElineServiceData;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TEGetAvailabeService
extends TENEExplorerBean {
    private Map servicemap = new HashMap();
    public static final String NSERR_CFG_GET_NULL = "38662";
    public static final String NSERR_UNI_NOTEXIST = "44402";
    private static final String CARRIER_TYPE_1 = "1";
    private static final String CARRIER_TYPE_3 = "3";
    private static final String CARRIER_TYPE_4 = "4";
    private boolean isLogFlag = true;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        RowParams row = inputData.getBussinessParams().getRowParams(0);
        this.outputData = new Datainterface();
        this.operationList = new ArrayList();
        Operation operation = null;
        String QxName = subFunc.getQxMapping(0).getContent();
        operation = TECreateObjectFactory.getOperation((int)neid, (String)QxName);
        Input input = operation.getInput();
        input.setPartValue("serviceIndex", row.getParam("serviceIndex").getValue());
        this.operationList.add(operation);
        int resCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, (List)this.operationList, this.TIME_OUT);
        if (null != result) {
            resCode = result.retCode;
        }
        if (resCode == 0) {
            Operation oper = (Operation)this.operationList.get(0);
            int count = oper.getOutputCount();
            for (int i = 0; i < count; ++i) {
                String errorCode = oper.getOutput(i).getFault(0).getCode();
                if (!String.valueOf(0).equals(errorCode)) continue;
                Output output = oper.getOutput(i);
                String serviceIndex = output.getPartValue("serviceIndex");
                String serviceID = output.getPartValue("serviceID").trim();
                String serviceName = output.getPartValue("serviceName").trim();
                int maxPackageLen = Integer.parseInt(output.getPartValue("maxPackageLen").trim());
                String bpdu = output.getPartValue("bpdu");
                int logicInfNumber = Integer.parseInt(output.getPartValue("logicInfNum"));
                if (logicInfNumber == 0) continue;
                ArrayList<LogicInf> logicInfList = new ArrayList<LogicInf>();
                String[] logicInfString = new String[logicInfNumber];
                String logicInf = output.getPartValue("logicInfData");
                int lens = logicInf.length() / 8;
                int index = 0;
                for (int j = 0; j < lens; ++j) {
                    int logicInflength = 8;
                    logicInfString[j] = logicInf.substring(index, index + logicInflength);
                    index += logicInflength;
                }
                for (int k = 0; k < logicInfString.length; ++k) {
                    logicInfList.add(this.parseLogicInfData(logicInfString[k]));
                }
                TEElineServiceData serviceData = new TEElineServiceData(serviceIndex, serviceName, serviceID, maxPackageLen, logicInfNumber, logicInfList);
                serviceData.setBpdu(bpdu);
                this.servicemap.put(serviceData.serviceIndex, serviceData);
            }
            ArrayList secOperList = this.getVuniVnniInfoOperationList(subFunc);
            if (!secOperList.isEmpty()) {
                resCode = 0;
                result = TENECommMgr.getInstance().sendCommand(neid, (List)secOperList, this.TIME_OUT);
                if (null != result) {
                    resCode = result.retCode;
                }
                this.operationList.addAll(secOperList);
                if (resCode == 0) {
                    this.handleSecOperList(secOperList);
                }
            }
            ArrayList<Integer> filterList = new ArrayList<Integer>();
            filterList.add(Integer.valueOf(NSERR_CFG_GET_NULL));
            filterList.add(Integer.valueOf(NSERR_UNI_NOTEXIST));
            filterList.add(38737);
            this.handleMessage(neid, this.operationList, subFunc, filterList);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)resCode));
        }
        return this.outputData;
    }

    private void handleSecOperList(List secOperationList) {
        int size = secOperationList.size();
        for (int i = 0; i < size; ++i) {
            int j;
            LogicInf logicInf;
            TEElineServiceData svcData;
            String vuniid;
            String index;
            int outputs;
            Operation tempOper = (Operation)secOperationList.get(i);
            if ("NSCMD_SERVICE_GET_ETHVUNI_EX".equals(tempOper.getName())) {
                outputs = tempOper.getOutputCount();
                for (int jIndex = 0; jIndex < outputs; ++jIndex) {
                    if (!tempOper.getOutput(jIndex).getFault(0).getCode().equals(String.valueOf(0))) continue;
                    index = tempOper.getOutput(jIndex).getPartValue("serviceIndex");
                    vuniid = tempOper.getOutput(jIndex).getPartValue("vuniID");
                    int slotid = Integer.parseInt(tempOper.getOutput(jIndex).getPartValue("slotid"));
                    int subslotid = Integer.parseInt(tempOper.getOutput(jIndex).getPartValue("subslotid"));
                    int portid = Integer.parseInt(tempOper.getOutput(jIndex).getPartValue("portid"));
                    svcData = (TEElineServiceData)this.servicemap.get(index);
                    logicInf = svcData.getLogicInfFromList(1, vuniid);
                    logicInf.logicInfName = this.getPortNameForPTN(slotid, subslotid, portid);
                }
                continue;
            }
            if ("NSCMD_SERVICE_GET_ETHVUNIPLUS".equals(tempOper.getName())) {
                outputs = tempOper.getOutputCount();
                for (j = 0; j < outputs; ++j) {
                    if (!tempOper.getOutput(j).getFault(0).getCode().equals(String.valueOf(0))) continue;
                    index = tempOper.getOutput(j).getPartValue("serviceIndex");
                    vuniid = tempOper.getOutput(j).getPartValue("vuniID");
                    int slotid = Integer.parseInt(tempOper.getOutput(j).getPartValue("slotid"));
                    int subslotid = Integer.parseInt(tempOper.getOutput(j).getPartValue("subslotid"));
                    int portid = Integer.parseInt(tempOper.getOutput(j).getPartValue("portid"));
                    svcData = (TEElineServiceData)this.servicemap.get(index);
                    logicInf = svcData.getLogicInfFromList(1, vuniid);
                    logicInf.logicInfName = this.getPortNameForPTN(slotid, subslotid, portid);
                }
                continue;
            }
            if (!"NSCMD_SERVICE_GET_EVNNI_EX".equals(tempOper.getName())) continue;
            outputs = tempOper.getOutputCount();
            for (j = 0; j < outputs; ++j) {
                if (!tempOper.getOutput(j).getFault(0).getCode().equals(String.valueOf(0))) continue;
                index = tempOper.getOutput(j).getPartValue("serviceIndex");
                String vnniid = tempOper.getOutput(j).getPartValue("vnniID");
                String carrierType = tempOper.getOutput(j).getPartValue("carrierType");
                String carrier1 = tempOper.getOutput(j).getPartValue("carrierID1");
                String carrier2 = tempOper.getOutput(j).getPartValue("carrierID2");
                String carrier3 = tempOper.getOutput(j).getPartValue("carrierID3");
                TEElineServiceData svcData2 = (TEElineServiceData)this.servicemap.get(index);
                LogicInf logicInf2 = svcData2.getLogicInfFromList(2, vnniid);
                if (CARRIER_TYPE_1.equals(carrierType)) {
                    logicInf2.logicInfName = this.getPWName(carrier3, secOperationList);
                    svcData2.setBearerIndex(carrier3);
                    continue;
                }
                if (CARRIER_TYPE_3.equals(carrierType)) {
                    logicInf2.logicInfName = this.getPortNameForPTN(Integer.parseInt(carrier1), Integer.parseInt(carrier2), Integer.parseInt(carrier3));
                    continue;
                }
                if (!CARRIER_TYPE_4.equals(carrierType)) continue;
                logicInf2.logicInfName = this.getVnniQinqLinkName(carrier3);
            }
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        boolean isSuccess = true;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        ArrayList services = new ArrayList(this.servicemap.entrySet());
        Collections.sort(services, new TECompareElineService());
        int len = services.size();
        for (int i = 0; i < len; ++i) {
            TEElineServiceData serviceData = (TEElineServiceData)services.get(i).getValue();
            RowParams rParams = new RowParams();
            Param param = null;
            param = new Param("serviceName", serviceData.serviceName);
            rParams.addParam(param);
            param = new Param("servicetagrole", serviceData.servicetagrole);
            rParams.addParam(param);
            param = new Param("serviceIndex", serviceData.serviceIndex);
            rParams.addParam(param);
            param = new Param("serviceID", serviceData.serviceID);
            rParams.addParam(param);
            param = new Param("maxPackageLen", String.valueOf(serviceData.maxPackageLength));
            rParams.addParam(param);
            LogicInf logicInf0 = serviceData.getLogicInfByIndex(0);
            LogicInf logicInf1 = serviceData.getLogicInfByIndex(1);
            if (null != logicInf0 && null != logicInf1 && logicInf0.logicInfType == 2 && logicInf1.logicInfType == 1) {
                param = new Param("sourceNode", logicInf1.logicInfName);
                rParams.addParam(param);
                param = new Param("sinkNode", logicInf0.logicInfName);
                rParams.addParam(param);
            } else {
                if (null != logicInf0) {
                    param = new Param("sourceNode", logicInf0.logicInfName);
                    rParams.addParam(param);
                }
                if (null != logicInf1) {
                    param = new Param("sinkNode", logicInf1.logicInfName);
                    rParams.addParam(param);
                }
            }
            param = new Param("bpdu", serviceData.bpdu);
            rParams.addParam(param);
            param = new Param("bearerindex", serviceData.bearerindex);
            rParams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rParams);
        }
        int errCodeInfo = 0;
        Operation oper = null;
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            oper = (Operation)operationList.get(i);
            int rowLen = oper.getOutputCount();
            for (int j = 0; j < rowLen; ++j) {
                Output output = oper.getOutput(j);
                errCodeInfo = Integer.parseInt(output.getFault(0).getCode());
                if (errCodeInfo == 0 || filterErrorCodeList.contains(errCodeInfo)) continue;
                isSuccess = false;
                break;
            }
            if (!isSuccess) break;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)(isSuccess ? 0 : errCodeInfo)));
    }

    public LogicInf parseLogicInfData(String logicInfStr) {
        String[] logic = new String[2];
        int lens = logicInfStr.length() / 4;
        int index = 0;
        for (int j = 0; j < lens; ++j) {
            int logicInflength = 4;
            logic[j] = logicInfStr.substring(index, index + logicInflength);
            index += logicInflength;
        }
        int logicType = Integer.parseInt(logic[0], 16);
        int logicID = Integer.parseInt(logic[1], 16);
        LogicInf logicInf = new LogicInf(logicType, String.valueOf(logicID));
        return logicInf;
    }

    public ArrayList getVuniVnniInfoOperationList(SubFunc func) {
        ArrayList<Object> operList = new ArrayList<Object>();
        Operation operation = null;
        Input input = null;
        String qxName1 = func.getQxMapping(1).getContent();
        String qxName2 = func.getQxMapping(2).getContent();
        String qxName3 = "NSCMD_SERVICE_GET_ETHVUNIPLUS";
        String qxName4 = "NSCMD_PTN_MPLS_PW_GET_PW";
        for (Map.Entry element : this.servicemap.entrySet()) {
            TEElineServiceData serviceData = (TEElineServiceData)element.getValue();
            List logicInfList = serviceData.logicInfList;
            int size = logicInfList.size();
            for (int j = 0; j < size; ++j) {
                LogicInf logic = (LogicInf)logicInfList.get(j);
                if (logic.logicInfType == 1) {
                    operation = TECreateObjectFactory.getOperation((int)this.neid, (String)qxName1);
                    input = operation.getInput();
                    input.setPartValue("ethType", CARRIER_TYPE_1);
                    input.setPartValue("serviceIndex", serviceData.serviceIndex);
                    input.setPartValue("vuniID", logic.logicInfID);
                    operList.add(operation.clone());
                    operation = TECreateObjectFactory.getOperation((int)this.neid, (String)qxName3);
                    input = operation.getInput();
                    input.setPartValue("ethType", CARRIER_TYPE_1);
                    input.setPartValue("serviceIndex", serviceData.serviceIndex);
                    input.setPartValue("vuniID", logic.logicInfID);
                    operList.add(operation.clone());
                    continue;
                }
                if (logic.logicInfType != 2) continue;
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)qxName2);
                input = operation.getInput();
                input.setPartValue("ethType", CARRIER_TYPE_1);
                input.setPartValue("serviceIndex", serviceData.serviceIndex);
                input.setPartValue("vnniID", logic.logicInfID);
                operList.add(operation.clone());
            }
        }
        operation = TECreateObjectFactory.getOperation((int)this.neid, (String)qxName4);
        operation.getInput().setPartValue("pwIndex", "0");
        operList.add(operation.clone());
        return operList;
    }

    public String getPortNameForPTN(int slotid, int subslotid, int portid) {
        String portName;
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        Vector boardList = neObj.getClonedBoardList();
        int boardType = 0;
        int subBoardType = 0;
        int len = boardList.size();
        block0: for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int boardSlot = board.getSlotID();
            if (boardSlot != slotid) continue;
            if (subslotid == 255) {
                boardType = board.getBoardType();
                continue;
            }
            List subBoardList = board.getSubBoardList();
            int size = subBoardList.size();
            for (int k = 0; k < size; ++k) {
                TESubBoard subBoard = (TESubBoard)subBoardList.get(k);
                int subBoardId = subBoard.getSubSlotID();
                if (subBoardId != subslotid) continue;
                subBoardType = subBoard.getSubBoardType();
                continue block0;
            }
        }
        if (subBoardType == 0) {
            portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neid, slotid, boardType, portid);
            portName = slotid + "-" + TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardType) + "-" + portName;
        } else {
            portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neid, slotid, subBoardType, portid);
        }
        return portName;
    }

    public String getVnniQinqLinkName(String qinqLinkID) {
        return "QinQ Link ID-" + qinqLinkID;
    }

    private String getPWName(String pwindex, List secOperationList) {
        Operation oper = null;
        String pwID = "/";
        String temppwindex = "";
        int size = secOperationList.size();
        for (int i = 0; i < size; ++i) {
            oper = (Operation)secOperationList.get(i);
            if (!"NSCMD_PTN_MPLS_PW_GET_PW".equals(oper.getName())) continue;
            int outputs = oper.getOutputCount();
            for (int j = 0; j < outputs; ++j) {
                if (!String.valueOf(0).equals(oper.getOutput(j).getFault(0).getCode()) || !pwindex.equals(temppwindex = oper.getOutput(j).getPartValue("pwIndex"))) continue;
                pwID = oper.getOutput(j).getPartValue("pwID");
                return "PW-" + pwID;
            }
        }
        return "PW-" + pwID;
    }
}

