/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mirrormgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.mirrormgr.TEModifyMirrorBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TECreateMirrorBean
extends TENEExplorerBean {
    protected int slotID = -1;
    protected int mirrorPort = -1;
    protected int upPort = -1;
    protected String operObj = "";
    private ArrayList storyOperation = null;
    private int srcPointType = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Datainterface vlanData;
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        Param[] paramArr = rowParams[0].getParam();
        int len = paramArr.length;
        for (int i = 1; i < len; ++i) {
            String name = paramArr[i].getName();
            String value = paramArr[i].getValue();
            if (name.equalsIgnoreCase("slotID")) {
                this.slotID = Integer.parseInt(value);
            }
            if (name.equalsIgnoreCase("obsPointPortID")) {
                this.mirrorPort = Integer.parseInt(value);
            }
            if (name.equalsIgnoreCase("srcparam3")) {
                this.upPort = Integer.parseInt(value);
            }
            if (!name.equalsIgnoreCase("srcPointType")) continue;
            this.srcPointType = Integer.parseInt(value);
        }
        super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        if (this.srcPointType == 1 && this.outputData.getErrorMessage().getErrorcode().equals("0") && !(vlanData = this.setVlanList(neid, subFunc, inputData, memeryData, user, ipAddress)).getErrorMessage().getErrorcode().equals("0")) {
            this.outputData.getBussinessParams().addRowParams(vlanData.getBussinessParams().getRowParams(0));
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        }
        return this.outputData;
    }

    private Datainterface setVlanList(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Operation opr = (Operation)this.storyOperation.get(1);
        String mirrorServiceIndex = opr.getOutput(0).getPartValue("mirrorServiceIndex");
        String taglist = inputData.getBussinessParams().getRowParams(0).getParam("taglist").getValue();
        SubFunc tmpSubFunc = null;
        try {
            tmpSubFunc = TECreateObjectFactory.getSubFunc((int)neid, (int)2180141);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("set vlanlist subFunc exception", (Throwable)e);
        }
        Datainterface tmpInputData = new Datainterface();
        tmpInputData.setBussinessParams(new BussinessParams());
        RowParams row = new RowParams();
        row.addParam("neid", neid + "");
        row.addParam("mirrorServiceIndex", mirrorServiceIndex);
        row.addParam("taglist", taglist);
        tmpInputData.getBussinessParams().addRowParams(row);
        TEModifyMirrorBean setVlanBean = new TEModifyMirrorBean();
        return setVlanBean.performBussinessProcess(neid, tmpSubFunc, tmpInputData, memeryData, user, ipAddress);
    }

    public int sendMessage(int neid, ArrayList operationList) {
        int retCode = 0;
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, operationList, this.getTimeOut(), this.subfunc);
        if (null != result) {
            retCode = result.retCode;
        }
        this.storyOperation = (ArrayList)operationList.clone();
        return retCode;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int i;
            TENE neObj;
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1090646019) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo log = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            this.operObj = null == (neObj = TENEListMgr.getInstance().getNE(neid)) ? String.valueOf(neid) : neObj.getNEName();
            if (errorCode == 0) {
                log = new TELogInfo();
                log.setResult(0);
                log.setErrCode(0);
                log.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(log);
            } else if (errorCode == 2 || errorCode == 1) {
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    int size = rowErrors.length;
                    for (int j = 0; j < size; ++j) {
                        log = new TELogInfo();
                        log.setResult(2);
                        log.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                        log.setErrInfo(rowErrors[j].getErrorMessage().getErrorinfo());
                        loginfoList.add(log);
                    }
                }
            } else {
                log = new TELogInfo();
                log.setResult(2);
                log.setErrCode(errorCode);
                log.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(log);
            }
            int size = loginfoList.size();
            for (i = 0; i < size; ++i) {
                log = (TELogInfo)loginfoList.get(i);
                log.setCmdID(subfunc.getCode());
                log.setLocation(ipAddress);
                log.setUserID(userID);
                log.setUserName(TESysManagerBean.getInstance().getSysUser());
                log.setOperateName(subfunc.getSubFuncDes(neid));
                log.setOperateObject(this.operObj);
                log.setOperateDesc(this.getOperDesc());
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
        catch (IndexOutOfBoundsException e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    protected String getOperDesc() {
        StringBuffer operDesc = new StringBuffer();
        int boardType = TEConfigurationDataMgr.getInstance().getBoard(this.neid, this.slotID).getBoardType();
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardType);
        String mirrorPortName = "";
        mirrorPortName = 32768 > this.mirrorPort ? "PORT" + this.mirrorPort : "VCTRUNK" + (this.mirrorPort - 32768);
        String upPortName = "";
        upPortName = this.srcPointType == 0 ? (this.upPort == -1 ? "/" : (32768 > this.upPort ? "PORT" + this.upPort : "VCTRUNK" + (this.upPort - 32768))) : String.valueOf(this.upPort);
        StringBuffer sb = new StringBuffer(40);
        sb.append("ip").append(File.separator).append("ptn").append(File.separator).append("res").append(File.separator).append("portmirror_ptn").append(File.separator).append("portmirrorres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)sb);
        operDesc.append(this.operObj).append('-').append(this.slotID).append('-').append(boardName).append(": ").append(res.getString("mirrorport")).append(':').append(upPortName).append(", ").append(res.getString("obsmirrorport")).append(':').append(mirrorPortName);
        return operDesc.toString();
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList<Object> operList = new ArrayList<Object>();
        try {
            ArrayList templist = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid);
            if (null != templist && !templist.isEmpty()) {
                subFunc.setTransSupport(false);
                Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_TransBegin");
                operList.add(oper.clone());
                operList.addAll(templist);
                oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_Transend");
                operList.add(oper.clone());
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            operList = null;
        }
        return operList;
    }
}

