/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.lptmanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.datamgr.TEPortModelConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryPorts
implements TENEMgrInterface {
    private Datainterface datainterface = null;
    int neID = 0;
    int slotID = 0;
    int subslotID = 0;
    int querytype = 0;
    boolean isConnect = false;
    private static final int TN81ETFC = 1133;
    private static final int TN81D12 = 1135;
    private static final int TN81D75 = 1137;
    private static final int LAST_E1_PORTID = 32;
    private static final int LAST_FE_PORTID = 12;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
        this.slotID = Integer.parseInt(slotidParam.getValue());
        Param subSlotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"subslotid");
        this.subslotID = Integer.parseInt(subSlotidParam.getValue());
        Param queryTypeParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"querytype");
        Param isConnectParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"isconnect");
        if (queryTypeParam != null) {
            this.querytype = Integer.parseInt(queryTypeParam.getValue());
        }
        if (isConnectParam != null && "1".equals(isConnectParam.getValue())) {
            this.isConnect = true;
        }
        this.datainterface = this.querytype == 0 ? this.constructBoardListData() : this.constructEthPortData();
        if (null != this.datainterface && null != this.datainterface.getBussinessParams()) {
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            this.log.error("Get BoardInfo Fail!\n");
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        }
        return this.datainterface;
    }

    public Datainterface constructEthPortData() {
        Datainterface data = new Datainterface();
        RowParams rParams = null;
        BussinessParams bParams = new BussinessParams();
        String portLists = "";
        Param param = null;
        if (this.subslotID == 0) {
            int boardType = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getBoardType();
            List<Integer> boardPortList = this.getPortList(this.slotID, boardType);
            ArrayList logicPortlist = TEConfigurationDataMgr.getInstance().getLogicPortList(this.neID, this.slotID);
            List notSupportPorts = TESpecialAttrMgr.getInstance().getCPAttrListValue(this.neID, this.slotID, "TE_FUNC_CFG_ETH_LPT", "LPT_ATTR_NOTSUPPORT_PORT");
            List supportPorts = null;
            if (this.isConnect) {
                supportPorts = TESpecialAttrMgr.getInstance().getCPAttrListValue(this.neID, this.slotID, "TE_FUNC_CFG_ETH_LPT", "LPT_ATTR_SUPPORT_POOL");
            }
            int len = boardPortList.size();
            for (int j = 0; j < len; ++j) {
                int portID = boardPortList.get(j);
                if (!logicPortlist.contains(portID) || (1135 == boardType || 1137 == boardType) && 0 == this.slotID % 2 && 32 == portID || 1133 == boardType && 2 == this.slotID % 4 && 12 == portID || boardType == 2102 && portID != 10 || boardType == 2439 && portID != 8 || notSupportPorts.contains(String.valueOf(portID)) || supportPorts != null && !supportPorts.isEmpty() && !supportPorts.contains(String.valueOf(portID))) continue;
                rParams = new RowParams();
                String portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neID, this.slotID, boardType, portID);
                portLists = portName + "," + portID;
                param = new Param("portList", portLists);
                rParams.addParam(param);
                param = new Param("slotid", this.slotID + "");
                rParams.addParam(param);
                param = new Param("portid", portID + "");
                rParams.addParam(param);
                param = new Param("subslotid", "0");
                rParams.addParam(param);
                bParams.addRowParams(rParams);
            }
        } else {
            List subBoardList = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getSubBoardList();
            int isize = subBoardList.size();
            for (int k = 0; k < isize; ++k) {
                TESubBoard subBoards = (TESubBoard)subBoardList.get(k);
                int subBoardType = subBoards.getSubBoardType();
                int subBoardSlot = subBoards.getSubSlotID();
                ArrayList subBoardPortList = TEConfigurationDataMgr.getInstance().getETHVCTrunkPort(this.neID, subBoardType);
                int len = subBoardPortList.size();
                for (int j = 0; j < len; ++j) {
                    int portID = (Integer)subBoardPortList.get(j);
                    rParams = new RowParams();
                    String portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neID, subBoardSlot, subBoardType, portID);
                    portLists = portName + "," + portID;
                    param = new Param("portList", portLists);
                    rParams.addParam(param);
                    param = new Param("slotid", this.slotID + "");
                    rParams.addParam(param);
                    param = new Param("portid", portID + "");
                    rParams.addParam(param);
                    param = new Param("subslotid", subBoardSlot + "");
                    rParams.addParam(param);
                    bParams.addRowParams(rParams);
                }
            }
        }
        data.setBussinessParams(bParams);
        return data;
    }

    public Datainterface constructBoardListData() {
        Datainterface data = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        String portLists = "";
        Param param = null;
        if (this.subslotID == 0) {
            int boardType = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getBoardType();
            List<Integer> boardPortList = this.getPortList(this.slotID, boardType);
            int len = boardPortList.size();
            for (int j = 0; j < len; ++j) {
                int portID = boardPortList.get(j);
                if ((1135 == boardType || 1137 == boardType) && 0 == this.slotID % 2 && 32 == portID || 1133 == boardType && 2 == this.slotID % 4 && 12 == portID) continue;
                String portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neID, this.slotID, boardType, portID);
                portLists = portName + "," + portID;
                param = new Param("portList", portLists);
                RowParams rParams = new RowParams();
                rParams.addParam(param);
                bParams.addRowParams(rParams);
            }
        } else {
            List subBoardList = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getSubBoardList();
            int isize = subBoardList.size();
            for (int k = 0; k < isize; ++k) {
                TESubBoard subBoards = (TESubBoard)subBoardList.get(k);
                int subBoardType = subBoards.getSubBoardType();
                int subBoardSlot = subBoards.getSubSlotID();
                ArrayList subBoardPortList = TEConfigurationDataMgr.getInstance().getBoardPortList(this.neID, subBoardType);
                int len = subBoardPortList.size();
                for (int j = 0; j < len; ++j) {
                    int portID = (Integer)subBoardPortList.get(j);
                    String portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neID, subBoardSlot, subBoardType, portID);
                    portLists = portName + "," + portID;
                    param = new Param("portList", portLists);
                    RowParams rParams = new RowParams();
                    rParams.addParam(param);
                    bParams.addRowParams(rParams);
                }
            }
        }
        data.setBussinessParams(bParams);
        return data;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private List<Integer> getPortList(int slotid, int boardType) {
        ArrayList<Integer> existPortList = null;
        ArrayList allPortList = TEPortModelConfigurationDataMgr.getInstance().getLogicPortList(this.neID, slotid);
        if (TEConfigurationDataMgr.getInstance().isIFboard(boardType)) {
            ArrayList portList = (ArrayList)TEConfigurationDataMgr.getInstance().getPortList(this.neID, slotid, 1802);
            portList.addAll(TEConfigurationDataMgr.getInstance().getPortList(this.neID, slotid, 1799));
            existPortList = new ArrayList<Integer>();
            int size = portList.size();
            for (int i = 0; i < size; ++i) {
                int portid = ((TEPort)portList.get(i)).getPortNo();
                if (existPortList.contains(portid)) continue;
                existPortList.add(portid);
            }
        }
        if (null == existPortList || existPortList.isEmpty()) {
            return allPortList;
        }
        return existPortList;
    }
}

