/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.lldpmgr;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ip.ptn.lldpmgr.SortComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TEQueryLLDPNeighborInfoBean
extends TENEExplorerBean {
    private String VALID_STR = "-1";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        if (null != this.outputData.getBussinessParams() && this.outputData.getBussinessParams().getRowParamsCount() > 0) {
            ArrayList tmpList = this.outputData.getBussinessParams().getRowParamList();
            Collections.sort(tmpList, new SortComparator());
        }
        return this.outputData;
    }

    protected void modifyInputParams() {
        ArrayList allLogicPortList;
        int slotId;
        TEPort port = null;
        TEBoard board = null;
        ArrayList portList = new ArrayList();
        Vector boardVec = TEConfigurationDataMgr.getInstance().getNE(this.neid).getClonedBoardList();
        int m = boardVec.size();
        for (int i = 0; i < m; ++i) {
            board = (TEBoard)boardVec.get(i);
            if (board.getBoardType() == 2102 || board.getBoardType() == 2439) continue;
            slotId = board.getSlotID();
            List allEthPortList = TEConfigurationDataMgr.getInstance().getPortList(this.neid, slotId, 1799);
            allLogicPortList = TEConfigurationDataMgr.getInstance().getLogicPortList(this.neid, slotId);
            int size = allEthPortList.size();
            for (int j = 0; j < size; ++j) {
                port = (TEPort)allEthPortList.get(j);
                if (!allLogicPortList.contains(port.getPortNo())) continue;
                portList.add(allEthPortList.get(j));
            }
        }
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        List boardList = TESpecialAttrMgr.getInstance().getSupportSlotList(this.neid, "TE_FUNC_CFG_LLDP", "IPPTN_ATTR_SUPPORT_LLDPMGR");
        if (boardList.size() > 0 && (ne.getNEType() == 60 || ne.getNEType() == 55)) {
            int tmpPortID = -1;
            List tmpPortList = null;
            int k = boardList.size();
            for (int j = 0; j < k; ++j) {
                slotId = (Integer)boardList.get(j);
                tmpPortList = TESpecialAttrMgr.getInstance().getCPAttrListValue(this.neid, slotId, "TE_FUNC_CFG_LLDP", "IPPTN_ATTR_SUPPORT_LLDPMGR");
                allLogicPortList = TEConfigurationDataMgr.getInstance().getLogicPortList(this.neid, slotId);
                int size = tmpPortList.size();
                for (int s = 0; s < size; ++s) {
                    tmpPortID = Integer.parseInt((String)tmpPortList.get(s));
                    if (!allLogicPortList.contains(tmpPortID)) continue;
                    TEPort tmpPort = new TEPort();
                    tmpPort.setSlotID(slotId);
                    tmpPort.setPortNo(tmpPortID);
                    portList.add(tmpPort);
                }
            }
        }
        if (null != portList && !portList.isEmpty()) {
            this.inputData.getBussinessParams().clearRowParams();
            RowParams row = null;
            int len = portList.size();
            for (int i = 0; i < len; ++i) {
                port = (TEPort)portList.get(i);
                row = new RowParams();
                row.addParam("neid", String.valueOf(this.neid));
                row.addParam("slotid", String.valueOf(port.getSlotID()));
                row.addParam("subslotid", String.valueOf("255"));
                row.addParam("portid", String.valueOf(port.getPortNo()));
                row.addParam("isLogFlag", "0");
                this.inputData.getBussinessParams().addRowParams(row);
            }
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc);
        BussinessParams bussiness = this.outputData.getBussinessParams();
        RowParams rowparam = null;
        HashMap<String, HashMap<String, String>> portParaMap = new HashMap<String, HashMap<String, String>>();
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparam = bussiness.getRowParams(i);
            if (rowparam.getParam("slotid") == null) continue;
            String slotid = rowparam.getParam("slotid").getValue();
            String portid = rowparam.getParam("portid").getValue();
            String neighborid = rowparam.getParam("neighborid").getValue();
            String workmode = rowparam.getParam("workmode").getValue();
            rowparam.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, Integer.parseInt(slotid), Integer.parseInt(portid)));
            rowparam.addParam("neighbornodeinfo", "");
            String slotPortString = slotid + "-" + portid;
            if (portParaMap.keySet().contains(slotPortString)) continue;
            HashMap<String, String> portPara = new HashMap<String, String>();
            portPara.put(rowparam.getParam("slotid").getName(), slotid);
            portPara.put(rowparam.getParam("subslotid").getName(), rowparam.getParam("subslotid").getValue());
            portPara.put(rowparam.getParam("portid").getName(), portid);
            portPara.put(rowparam.getParam("boardname").getName(), rowparam.getParam("boardname").getValue());
            portPara.put("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, Integer.parseInt(slotid), Integer.parseInt(portid)));
            portPara.put(rowparam.getParam("workmode").getName(), workmode);
            portPara.put(rowparam.getParam("vlanid").getName(), rowparam.getParam("vlanid").getValue());
            portPara.put(rowparam.getParam("vlanpri").getName(), rowparam.getParam("vlanpri").getValue());
            portPara.put(rowparam.getParam("destaddrgroup").getName(), rowparam.getParam("destaddrgroup").getValue());
            portPara.put(rowparam.getParam("neighborid").getName(), neighborid);
            portPara.put(rowparam.getParam("lasttime").getName(), rowparam.getParam("lasttime").getValue());
            portPara.put(rowparam.getParam("remaintime").getName(), rowparam.getParam("remaintime").getValue());
            if (null != rowparam.getParam("curmsg")) {
                portPara.put(rowparam.getParam("curmsg").getName(), rowparam.getParam("curmsg").getValue());
                portPara.put(rowparam.getParam("sendmsg").getName(), rowparam.getParam("sendmsg").getValue());
                portPara.put(rowparam.getParam("lostmsg").getName(), rowparam.getParam("lostmsg").getValue());
                portPara.put(rowparam.getParam("errmsg").getName(), rowparam.getParam("errmsg").getValue());
                portPara.put(rowparam.getParam("ageneighbor").getName(), rowparam.getParam("ageneighbor").getValue());
                portPara.put(rowparam.getParam("losttlv").getName(), rowparam.getParam("losttlv").getValue());
                portPara.put(rowparam.getParam("unknowtlv").getName(), rowparam.getParam("unknowtlv").getValue());
            }
            portPara.put("neighbornodeinfo", "");
            portParaMap.put(slotPortString, portPara);
        }
        this.processInfoForjs(portParaMap);
    }

    private void processInfoForjs(Map<String, HashMap<String, String>> portParaMap) {
        BussinessParams bussiness = this.outputData.getBussinessParams();
        RowParams rowparam = null;
        Iterator<Map.Entry<String, HashMap<String, String>>> portParaItor = portParaMap.entrySet().iterator();
        for (int i = bussiness.getRowParamsCount() - 1; i >= 0; --i) {
            rowparam = bussiness.getRowParams(i);
            if (rowparam.getParam("slotid") == null) continue;
            bussiness.removeRowParams(i);
        }
        while (portParaItor.hasNext()) {
            rowparam = new RowParams();
            Map.Entry<String, HashMap<String, String>> portParaEntry = portParaItor.next();
            Map portMap = portParaEntry.getValue();
            if (portMap.get("slotid") != null) {
                rowparam.addParam("slotid", (String)portMap.get("slotid"));
            } else {
                rowparam.addParam("slotid", this.VALID_STR);
            }
            if (portMap.get("subslotid") != null) {
                rowparam.addParam("subslotid", (String)portMap.get("subslotid"));
            } else {
                rowparam.addParam("subslotid", this.VALID_STR);
            }
            if (portMap.get("portid") != null) {
                rowparam.addParam("portid", (String)portMap.get("portid"));
            } else {
                rowparam.addParam("portid", this.VALID_STR);
            }
            if (portMap.get("boardname") != null) {
                rowparam.addParam("boardname", (String)portMap.get("boardname"));
            } else {
                rowparam.addParam("boardname", this.VALID_STR);
            }
            if (portMap.get("portname") != null) {
                rowparam.addParam("portname", (String)portMap.get("portname"));
            } else {
                rowparam.addParam("portname", this.VALID_STR);
            }
            if (portMap.get("workmode") != null) {
                rowparam.addParam("workmode", (String)portMap.get("workmode"));
            } else {
                rowparam.addParam("workmode", this.VALID_STR);
            }
            if (portMap.get("vlanid") != null) {
                rowparam.addParam("vlanid", (String)portMap.get("vlanid"));
            } else {
                rowparam.addParam("vlanid", this.VALID_STR);
            }
            if (portMap.get("vlanpri") != null) {
                rowparam.addParam("vlanpri", (String)portMap.get("vlanpri"));
            } else {
                rowparam.addParam("vlanpri", "-1");
            }
            if (portMap.get("destaddrgroup") != null) {
                rowparam.addParam("destaddrgroup", (String)portMap.get("destaddrgroup"));
            } else {
                rowparam.addParam("destaddrgroup", "-1");
            }
            if (portMap.get("neighborid") != null) {
                rowparam.addParam("neighborid", (String)portMap.get("neighborid"));
            } else {
                rowparam.addParam("neighborid", "-1");
            }
            if (portMap.get("lasttime") != null) {
                rowparam.addParam("lasttime", (String)portMap.get("lasttime"));
            } else {
                rowparam.addParam("lasttime", "-1");
            }
            if (portMap.get("remaintime") != null) {
                rowparam.addParam("remaintime", (String)portMap.get("remaintime"));
            } else {
                rowparam.addParam("remaintime", "-1");
            }
            if (portMap.get("neighbornodeinfo") != null) {
                rowparam.addParam("neighbornodeinfo", (String)portMap.get("neighbornodeinfo"));
            } else {
                rowparam.addParam("neighbornodeinfo", "");
            }
            if (portMap.get("curmsg") != null && !((String)portMap.get("curmsg")).isEmpty()) {
                rowparam.addParam("curmsg", (String)portMap.get("curmsg"));
            } else {
                rowparam.addParam("curmsg", "-");
            }
            if (portMap.get("sendmsg") != null && !((String)portMap.get("sendmsg")).isEmpty()) {
                rowparam.addParam("sendmsg", (String)portMap.get("sendmsg"));
            } else {
                rowparam.addParam("sendmsg", "-");
            }
            if (portMap.get("lostmsg") != null && !((String)portMap.get("lostmsg")).isEmpty()) {
                rowparam.addParam("lostmsg", (String)portMap.get("lostmsg"));
            } else {
                rowparam.addParam("lostmsg", "-");
            }
            if (portMap.get("errmsg") != null && !((String)portMap.get("errmsg")).isEmpty()) {
                rowparam.addParam("errmsg", (String)portMap.get("errmsg"));
            } else {
                rowparam.addParam("errmsg", "-");
            }
            if (portMap.get("ageneighbor") != null && !((String)portMap.get("ageneighbor")).isEmpty()) {
                rowparam.addParam("ageneighbor", (String)portMap.get("ageneighbor"));
            } else {
                rowparam.addParam("ageneighbor", "-");
            }
            if (portMap.get("losttlv") != null && !((String)portMap.get("losttlv")).isEmpty()) {
                rowparam.addParam("losttlv", (String)portMap.get("losttlv"));
            } else {
                rowparam.addParam("losttlv", "-");
            }
            if (portMap.get("unknowtlv") != null && !((String)portMap.get("unknowtlv")).isEmpty()) {
                rowparam.addParam("unknowtlv", (String)portMap.get("unknowtlv"));
            } else {
                rowparam.addParam("unknowtlv", "-");
            }
            bussiness.addRowParams(rowparam);
        }
    }

    public ArrayList<Integer> getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(37898);
        errorList.add(15106);
        errorList.add(38662);
        errorList.add(57651);
        errorList.add(37926);
        errorList.add(37126);
        errorList.add(37889);
        return errorList;
    }
}

