/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.lldpmgr;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TEQueryLLDPNeighborDetailBean
extends TENEExplorerBean {
    private StringBuffer filePathBuffer = new StringBuffer("ip").append(File.separator).append("ptn").append(File.separator).append("res").append(File.separator).append("lldpmgr").append(File.separator).append("lldpres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
    private TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)this.filePathBuffer);
    private String VALID_VALUE = "-";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc);
        BussinessParams bussiness = this.outputData.getBussinessParams();
        RowParams rowparam = null;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparam = bussiness.getRowParams(i);
            if (rowparam.getParam("slotid") == null) continue;
            String type = rowparam.getParam("tlvtype").getValue();
            String subType = rowparam.getParam("subtlvtype").getValue();
            String oui = rowparam.getParam("ouilowbyte").getValue();
            int tvlLegth = Integer.parseInt(rowparam.getParam("paramlength").getValue());
            String tmpInfo = IOStreamConvertor.replaceSpecialStr((String)rowparam.getParam("paramvalue").getValue());
            String info = tmpInfo.length() > tvlLegth * 2 ? tmpInfo.substring(0, tvlLegth).trim() : tmpInfo;
            rowparam.getParam("destaddrindex").setValue(this.getAddressString(rowparam.getParam("destaddrindex").getValue()));
            rowparam.getParam("tlvtype").setValue(this.processTlvTypeName(type));
            rowparam.getParam("subtlvtype").setValue(this.processTlvSubTypeName(type, subType, oui));
            rowparam.getParam("paramvalue").setValue(info);
        }
    }

    private String getAddressString(String address) {
        String addressString = this.VALID_VALUE;
        switch (Integer.parseInt(address)) {
            case 1: {
                addressString = this.res.getString("neigthborAddress1");
                break;
            }
            case 2: {
                addressString = this.res.getString("neigthborAddress2");
                break;
            }
            case 4: {
                addressString = this.res.getString("neigthborAddress3");
                break;
            }
        }
        return addressString;
    }

    private String processTlvSubTypeName(String tlvType2, String tlvSubType, String oui) {
        String subTlvTYpe = this.VALID_VALUE;
        if (tlvType2.equals("1")) {
            subTlvTYpe = this.processTlvSubTypeNameFormain1(tlvSubType);
        } else if (tlvType2.equals("2")) {
            subTlvTYpe = this.processTlvSubTypeNameFormain2(tlvSubType);
        } else if (tlvType2.equals("8")) {
            subTlvTYpe = this.processTlvSubTypeNameFormain8(tlvSubType);
        } else if (tlvType2.equals("127")) {
            subTlvTYpe = this.processTlvSubTypeNameFormain127(tlvSubType, oui);
        }
        return subTlvTYpe;
    }

    private String processTlvSubTypeNameFormain127(String tlvSubType, String oui) {
        String subTlvTYpe = this.VALID_VALUE;
        if (oui.equals("194")) {
            switch (Integer.parseInt(tlvSubType)) {
                case 1: {
                    subTlvTYpe = this.res.getString("subtlvtype1forC2");
                    break;
                }
                case 2: {
                    subTlvTYpe = this.res.getString("subtlvtype2forC2");
                    break;
                }
                case 3: {
                    subTlvTYpe = this.res.getString("subtlvtype3forC2");
                    break;
                }
                case 4: {
                    subTlvTYpe = this.res.getString("subtlvtype4forC2");
                    break;
                }
                case 5: {
                    subTlvTYpe = this.res.getString("subtlvtype5forC2");
                    break;
                }
                case 6: {
                    subTlvTYpe = this.res.getString("subtlvtype6forC2");
                    break;
                }
                case 7: {
                    subTlvTYpe = this.res.getString("subtlvtype7forC2");
                    break;
                }
            }
        } else if (oui.equals("15")) {
            switch (Integer.parseInt(tlvSubType)) {
                case 1: {
                    subTlvTYpe = this.res.getString("subtlvtype1for0F");
                    break;
                }
                case 2: {
                    subTlvTYpe = this.res.getString("subtlvtype2for0F");
                    break;
                }
                case 4: {
                    subTlvTYpe = this.res.getString("subtlvtype4for0F");
                    break;
                }
            }
        }
        return subTlvTYpe;
    }

    private String processTlvSubTypeNameFormain8(String tlvSubType) {
        String subTlvTYpe = this.VALID_VALUE;
        switch (Integer.parseInt(tlvSubType)) {
            case 1: {
                subTlvTYpe = this.res.getString("subtlvtype1formain8");
                break;
            }
            case 6: {
                subTlvTYpe = this.res.getString("subtlvtype6formain8");
                break;
            }
        }
        return subTlvTYpe;
    }

    private String processTlvSubTypeNameFormain2(String tlvSubType) {
        String subTlvTYpe = this.VALID_VALUE;
        switch (Integer.parseInt(tlvSubType)) {
            case 1: {
                subTlvTYpe = this.res.getString("subtlvtype1formain2");
                break;
            }
            case 2: {
                subTlvTYpe = this.res.getString("subtlvtype2formain2");
                break;
            }
            case 3: {
                subTlvTYpe = this.res.getString("subtlvtype3formain2");
                break;
            }
            case 4: {
                subTlvTYpe = this.res.getString("subtlvtype4formain2");
                break;
            }
            case 5: {
                subTlvTYpe = this.res.getString("subtlvtype5formain2");
                break;
            }
            case 6: {
                subTlvTYpe = this.res.getString("subtlvtype6formain2");
                break;
            }
            case 7: {
                subTlvTYpe = this.res.getString("subtlvtype7formain2");
                break;
            }
        }
        return subTlvTYpe;
    }

    private String processTlvSubTypeNameFormain1(String tlvSubType) {
        String subTlvTYpe = this.VALID_VALUE;
        switch (Integer.parseInt(tlvSubType)) {
            case 1: {
                subTlvTYpe = this.res.getString("subtlvtype1formain1");
                break;
            }
            case 2: {
                subTlvTYpe = this.res.getString("subtlvtype2formain1");
                break;
            }
            case 3: {
                subTlvTYpe = this.res.getString("subtlvtype3formain1");
                break;
            }
            case 4: {
                subTlvTYpe = this.res.getString("subtlvtype4formain1");
                break;
            }
            case 5: {
                subTlvTYpe = this.res.getString("subtlvtype5formain1");
                break;
            }
            case 6: {
                subTlvTYpe = this.res.getString("subtlvtype6formain1");
                break;
            }
            case 7: {
                subTlvTYpe = this.res.getString("subtlvtype7formain1");
                break;
            }
        }
        return subTlvTYpe;
    }

    private String processTlvTypeName(String tlvType2) {
        String tlvTYpe = this.VALID_VALUE;
        if (tlvType2.equals("")) {
            return tlvTYpe;
        }
        switch (Integer.parseInt(tlvType2)) {
            case 1: {
                tlvTYpe = this.res.getString("tlvtype1");
                break;
            }
            case 2: {
                tlvTYpe = this.res.getString("tlvtype2");
                break;
            }
            case 3: {
                tlvTYpe = this.res.getString("tlvtype3");
                break;
            }
            case 4: {
                tlvTYpe = this.res.getString("tlvtype4");
                break;
            }
            case 5: {
                tlvTYpe = this.res.getString("tlvtype5");
                break;
            }
            case 6: {
                tlvTYpe = this.res.getString("tlvtype6");
                break;
            }
            case 7: {
                tlvTYpe = this.res.getString("tlvtype7");
                break;
            }
            case 8: {
                tlvTYpe = this.res.getString("tlvtype8");
                break;
            }
            case 127: {
                tlvTYpe = this.res.getString("tlvtype127");
                break;
            }
        }
        return tlvTYpe;
    }

    public ArrayList<Integer> getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(37898);
        errorList.add(15106);
        errorList.add(38662);
        errorList.add(57651);
        return errorList;
    }
}

