/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ipping;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.List;

public class TEQueryArpTableBean
extends TECommonWriteLogBean {
    private static final int PROTOTYPE_IP_LONG = 8;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        List<String> ipList = this.parseOperationList(operationList);
        this.outputData = this.createOutput(neid, ipList);
    }

    private List<String> parseOperationList(List<Operation> operationList) {
        String ipstr = "";
        String macstr = "";
        Operation oper = null;
        ArrayList<String> ipList = new ArrayList<String>();
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            oper = operationList.get(i);
            if (!oper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
            int lenj = oper.getOutputCount();
            for (int j = 0; j < lenj; ++j) {
                ipstr = oper.getOutput(j).getPartValue("ip");
                ipList.add(IPAddressUtil.convertIPPrototypeToStr((String)ipstr));
                macstr = oper.getOutput(j).getPartValue("mac");
                ipList.add(TEConvertUtil.strToMAC((String)macstr));
            }
        }
        return ipList;
    }

    private Datainterface createOutput(int neid, List<String> ipList) {
        int slotid = Integer.parseInt(this.inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        int port = Integer.parseInt(this.inputData.getBussinessParams().getRowParams(0).getParam("port").getValue());
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        TEConfigurationDataMgr dataMgr = TEConfigurationDataMgr.getInstance();
        RowParams rowparams = null;
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid);
        int boardType = dataMgr.getBoardType(neid, slotid);
        String boardName = dataMgr.getBoardName(neid, slotid);
        String portName = dataMgr.getPortName(neid, slotid, boardType, port);
        int len = ipList.size();
        for (int i = 0; i < len - 1; i += 2) {
            rowparams = new RowParams();
            rowparams.addParam("neid", String.valueOf(neid));
            if (subrackName != null && !subrackName.equals("")) {
                rowparams.addParam("subrackname", subrackName);
            }
            rowparams.addParam("slotid", String.valueOf(slotid));
            rowparams.addParam("boardname", boardName);
            rowparams.addParam("portid", String.valueOf(port));
            rowparams.addParam("portname", portName);
            rowparams.addParam("index", String.valueOf(i / 2 + 1));
            rowparams.addParam("ip", ipList.get(i));
            rowparams.addParam("mac", ipList.get(i + 1));
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        return outputData;
    }

    private List<String> parseIPString(int num, String strIP) {
        ArrayList<String> ipList = new ArrayList<String>();
        int perLength = 8;
        for (int i = 0; i < num; ++i) {
            ipList.add(IPAddressUtil.convertIPPrototypeToStr((String)strIP.substring(i * perLength, (i + 1) * perLength)));
        }
        return ipList;
    }
}

