/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ipping;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ptn.ipping.TEIPPingBean;
import com.huawei.nglct.nemgr.ip.ptn.ipping.TEIPPingProcess;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

public class TEIPPingTestBean
extends TECommonWriteLogBean {
    private static Map<Integer, TEIPPingProcess> reportMap = new Hashtable<Integer, TEIPPingProcess>();
    public static final int START_IPPING = 1;
    public static final int STOP_IPPING = 2;
    public static final int REFRESH_IPPING = 3;
    private int configKey;
    private boolean finish = false;
    public static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String RESFILE = "ip" + File.separator + "ptn" + File.separator + "res" + File.separator + "ipping" + File.separator + "ippingres_" + LANGUAGE + ".ini";
    public static TEResourceUtil resourceUtil = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        resourceUtil = TEGetFilePath.getResource((int)neid, (String)RESFILE);
        ArrayList<TEIPPingBean> ipPingList = new ArrayList<TEIPPingBean>();
        int rowCount = inputData.getBussinessParams().getRowParamsCount();
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        for (int i = 0; i < rowCount; ++i) {
            TEIPPingBean ippingkey = new TEIPPingBean();
            ippingkey.setNeid(neid);
            ippingkey.setDestipAddress(rParams[i].getParam("TargetIP").getValue());
            ippingkey.setDirection(rParams[i].getParam("direction").getValue());
            ippingkey.setSlotid(rParams[i].getParam("slotid").getValue());
            ippingkey.setSubslotid(rParams[i].getParam("subslotid").getValue());
            ippingkey.setPort(rParams[i].getParam("port").getValue());
            ipPingList.add(ippingkey);
        }
        TEIPPingProcess process = TEIPPingTestBean.getIPPingProcess(neid);
        this.configKey = Integer.valueOf(rParams[0].getParam("configKey").getValue());
        if (this.configKey == 1) {
            if (!process.isRegisterd()) {
                process.registerListener();
            }
            process.initStartCurrPing((TEIPPingBean)ipPingList.get(0));
        }
        if (3 == this.configKey) {
            this.handleMessage(neid, ipPingList, this.operationList, this.subfunc);
            return this.outputData;
        }
        this.outputData = super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        if (this.configKey == 1) {
            if (this.outputData.getErrorMessage().getErrorcode().equals(String.valueOf(0))) {
                process.refreshIPPingNum(1);
            } else {
                process.clearCurdata((TEIPPingBean)ipPingList.get(0));
            }
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList ipPingList, ArrayList operationList, SubFunc subfunc) {
        switch (this.configKey) {
            case 1: {
                this.outputData = new Datainterface();
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)43043));
                break;
            }
            case 3: {
                this.outputData = new Datainterface();
                TEIPPingProcess process = TEIPPingTestBean.getIPPingProcess(neid);
                BussinessParams bussiness = new BussinessParams();
                block4: for (int i = process.getIpPingList().size() - 1; i >= 0; --i) {
                    TEIPPingBean ippingBean = process.getIpPingList().get(i);
                    int count = ipPingList.size();
                    for (int j = 0; j < count; ++j) {
                        if (!ippingBean.equals(ipPingList.get(j))) continue;
                        this.addIppingData(neid, ippingBean, bussiness);
                        if (!ippingBean.isPingStoped()) continue block4;
                        process.clearCurdata(ippingBean);
                        continue block4;
                    }
                }
                this.outputData.setBussinessParams(bussiness);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                break;
            }
            default: {
                super.handleMessage(neid, operationList, subfunc);
            }
        }
    }

    private void addIppingData(int neid, TEIPPingBean ipPingBean, BussinessParams bussiness) {
        RowParams rowdata = new RowParams();
        Param param = new Param();
        param.setName("ippingkey");
        param.setValue(ipPingBean.getIpPingKeyStr());
        rowdata.addParam(param);
        Integer totalNum = ipPingBean.getStrDataCount();
        param = new Param();
        param.setName("totalDataNum");
        param.setValue(totalNum.toString());
        rowdata.addParam(param);
        Integer curNum = ipPingBean.getStrCurDataNum();
        param = new Param();
        param.setName("curDataNum");
        param.setValue(curNum.toString());
        rowdata.addParam(param);
        String str = ipPingBean.getStrData();
        param = new Param();
        param.setName("content");
        param.setValue(str);
        rowdata.addParam(param);
        param = new Param();
        param.setName("endFlg");
        param.setValue("0");
        if (ipPingBean.isPingStoped()) {
            param.setValue("1");
            TELogFactory.getNormalLogger().error("IP Ping Test refresh successful, NE ID:" + ipPingBean.getDestipAddress() + ", finish:" + this.finish);
        }
        rowdata.addParam(param);
        bussiness.addRowParams(rowdata);
    }

    public static synchronized TEIPPingProcess getIPPingProcess(int neid) {
        TEIPPingProcess ptr = null;
        if (!reportMap.containsKey(neid)) {
            ptr = new TEIPPingProcess(neid);
            reportMap.put(neid, ptr);
        } else {
            ptr = reportMap.get(neid);
        }
        return ptr;
    }
}

