/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ipping;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nemgr.ip.ptn.ipping.TEIPPingBean;
import com.huawei.nglct.nemgr.ip.ptn.ipping.TEIPPingTestBean;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEIPPingProcess {
    public static final int START_IPPING = 1;
    public static final int STOP_IPPING = 2;
    private ArrayList<TEIPPingBean> ipPingList = new ArrayList();
    private TEIPPingTestNoticeHandler ipPingTestNotice = null;
    private int neid;
    private int ippingnum = 0;
    public static final int START_IPPING_NUM = 1;
    public static final int STOP_IPPING_NUM = -1;
    private Object lock = new Object();
    private boolean isRegister = false;
    private static final String NSEVT_PTN_IPPING_RESPONSE_BYIP = "NSEVT_PTN_IPPING_RESPONSE_BYIP";
    private static final String NSEVT_PTN_IPPING_OVERTIME_BYIP = "NSEVT_PTN_IPPING_OVERTIME_BYIP";
    private static final String NSEVT_PTN_ROUTE_IPPING_STATISTIC_BYIP = "NSEVT_PTN_ROUTE_IPPING_STATISTIC_BYIP";

    public ArrayList<TEIPPingBean> getIpPingList() {
        return this.ipPingList;
    }

    public void setIpPingList(ArrayList<TEIPPingBean> ipPingList) {
        this.ipPingList = ipPingList;
    }

    public void setNeid(int neid) {
        this.neid = neid;
    }

    public synchronized void refreshIPPingNum(int ippingnum) {
        this.ippingnum += ippingnum;
    }

    public synchronized int getIPPingNum() {
        return this.ippingnum;
    }

    public TEIPPingProcess(int neid) {
        this.neid = neid;
        this.ipPingList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener() {
        if (this.isRegister) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.ipPingTestNotice = new TEIPPingTestNoticeHandler();
            try {
                TELogFactory.getNormalLogger().error("IP Ping Test register NE ID:" + this.neid);
                TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)NSEVT_PTN_IPPING_RESPONSE_BYIP), (NoticeHandler)this.ipPingTestNotice);
                TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)NSEVT_PTN_IPPING_OVERTIME_BYIP), (NoticeHandler)this.ipPingTestNotice);
                TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)NSEVT_PTN_ROUTE_IPPING_STATISTIC_BYIP), (NoticeHandler)this.ipPingTestNotice);
                this.isRegister = true;
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEIPPingTestProcess registerListener error!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(int neid) {
        Object object = this.lock;
        synchronized (object) {
            TELogFactory.getNormalLogger().error("IP Ping Test unregister NE ID:" + neid);
            TENECommMgr.getInstance().unregisterListener(TECreateObjectFactory.getOperation((int)neid, (String)NSEVT_PTN_IPPING_RESPONSE_BYIP), (NoticeHandler)this.ipPingTestNotice);
            TENECommMgr.getInstance().unregisterListener(TECreateObjectFactory.getOperation((int)neid, (String)NSEVT_PTN_IPPING_OVERTIME_BYIP), (NoticeHandler)this.ipPingTestNotice);
            TENECommMgr.getInstance().unregisterListener(TECreateObjectFactory.getOperation((int)neid, (String)NSEVT_PTN_ROUTE_IPPING_STATISTIC_BYIP), (NoticeHandler)this.ipPingTestNotice);
            this.isRegister = false;
        }
    }

    public boolean isRegisterd() {
        return this.isRegister;
    }

    public synchronized void initStartCurrPing(TEIPPingBean ippingkey) {
        TEIPPingBean ippingbean = this.findCurIpPingBean(ippingkey);
        if (null != ippingbean) {
            ippingbean.intStartData();
        } else {
            ippingbean = ippingkey;
            ippingbean.intStartData();
            this.ipPingList.add(ippingbean);
        }
    }

    public synchronized void clearAlldata() {
        this.ipPingList.clear();
    }

    public synchronized void clearCurdata(TEIPPingBean ippingkey) {
        this.ipPingList.remove(ippingkey);
        ippingkey = null;
    }

    public TEIPPingBean findCurIpPingBean(TEIPPingBean ippingkey) {
        int len = this.ipPingList.size();
        for (int i = 0; i < len; ++i) {
            TEIPPingBean ippingbean = this.ipPingList.get(i);
            if (!ippingbean.equals(ippingkey)) continue;
            return ippingbean;
        }
        return null;
    }

    class TEIPPingTestNoticeHandler
    implements NoticeHandler {
        TEIPPingTestNoticeHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNotice(int cmdkey, int neID, Operation operation) {
            String operName = operation.getName().trim();
            TELogFactory.getNormalLogger().info("IP Ping Test operName : " + operName + ", NE ID:" + neID);
            Object object = TEIPPingProcess.this.lock;
            synchronized (object) {
                if (TEIPPingProcess.NSEVT_PTN_IPPING_RESPONSE_BYIP.equals(operName)) {
                    this.processIPPingRsp(neID, operation);
                } else if (TEIPPingProcess.NSEVT_PTN_IPPING_OVERTIME_BYIP.equals(operName)) {
                    this.processIPPingOutTime(neID, operation);
                } else if (TEIPPingProcess.NSEVT_PTN_ROUTE_IPPING_STATISTIC_BYIP.equals(operName)) {
                    this.processIPPingStat(neID, operation);
                } else {
                    TELogFactory.getNormalLogger().error("IP Ping Test operName : " + operName + ", NE ID:" + neID);
                }
            }
        }

        private void processIPPingRsp(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                String destipAddress = outputArr[i].getPart("destipAddress").getValue();
                String packageSeq = outputArr[i].getPart("packageSeq").getValue();
                String delayTime = outputArr[i].getPart("delayTime").getValue();
                TEIPPingBean ippingkey = new TEIPPingBean();
                ippingkey.setNeid(neid);
                ippingkey.setDestipAddress(destipAddress);
                ippingkey.setDirection(outputArr[i].getPart("direction").getValue());
                ippingkey.setSlotid(outputArr[i].getPart("slotid").getValue());
                ippingkey.setSubslotid(outputArr[i].getPart("subslotid").getValue());
                ippingkey.setPort(outputArr[i].getPart("port").getValue());
                TEIPPingBean ippingbean = TEIPPingProcess.this.findCurIpPingBean(ippingkey);
                if (null == ippingbean) continue;
                ippingbean.setStrData(this.addRespDataStr(packageSeq, delayTime));
            }
        }

        private void processIPPingOutTime(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                String destipAddress = outputArr[i].getPart("destipAddress").getValue();
                String packageSeq = outputArr[i].getPart("packageSeq").getValue();
                TEIPPingBean ippingkey = new TEIPPingBean();
                ippingkey.setNeid(neid);
                ippingkey.setDestipAddress(destipAddress);
                ippingkey.setDirection(outputArr[i].getPart("direction").getValue());
                ippingkey.setSlotid(outputArr[i].getPart("slotid").getValue());
                ippingkey.setSubslotid(outputArr[i].getPart("subslotid").getValue());
                ippingkey.setPort(outputArr[i].getPart("port").getValue());
                TEIPPingBean ippingbean = TEIPPingProcess.this.findCurIpPingBean(ippingkey);
                if (null == ippingbean) continue;
                ippingbean.setStrData(this.addTimeOutDataStr(packageSeq));
            }
        }

        private void processIPPingStat(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                String destipAddress = outputArr[i].getPart("destipAddress").getValue();
                String txnum = outputArr[i].getPart("txnum").getValue();
                String rxnum = outputArr[i].getPart("rxnum").getValue();
                String lossrate = outputArr[i].getPart("lossrate").getValue();
                TEIPPingBean ippingkey = new TEIPPingBean();
                ippingkey.setNeid(neid);
                ippingkey.setDestipAddress(destipAddress);
                ippingkey.setDirection(outputArr[i].getPart("direction").getValue());
                ippingkey.setSlotid(outputArr[i].getPart("slotid").getValue());
                ippingkey.setSubslotid(outputArr[i].getPart("subslotid").getValue());
                ippingkey.setPort(outputArr[i].getPart("port").getValue());
                TEIPPingBean ippingbean = TEIPPingProcess.this.findCurIpPingBean(ippingkey);
                if (null != ippingbean) {
                    ippingbean.setStrData(this.addStatDataStr(txnum, rxnum, lossrate));
                    ippingbean.setPingStoped(true);
                    TEIPPingProcess.this.refreshIPPingNum(-1);
                }
                TELogFactory.getNormalLogger().error("IP Ping Test getDestipAddress : " + ippingkey.getDestipAddress() + ", NE ID:" + neid);
            }
        }

        public String addTimeOutDataStr(String packageseq) {
            StringBuilder res = new StringBuilder("");
            res.append("[").append(TEIPPingTestBean.resourceUtil.getString("pingtestouttime")).append("]");
            res.append(TEIPPingTestBean.resourceUtil.getString("PackageSeq")).append(" ").append(packageseq).append("\n");
            return res.toString();
        }

        public String addRespDataStr(String packageseq, String delayTime) {
            StringBuilder res = new StringBuilder("");
            res.append("[").append(TEIPPingTestBean.resourceUtil.getString("pingtestrsp")).append("]");
            res.append(TEIPPingTestBean.resourceUtil.getString("PackageSeq")).append(" ").append(packageseq).append(" ");
            res.append(TEIPPingTestBean.resourceUtil.getString("DelayTime")).append(" ").append(delayTime).append("(ms)").append("\n");
            return res.toString();
        }

        public String addStatDataStr(String txNum, String rxNum, String lossRate) {
            StringBuilder res = new StringBuilder("");
            res.append("[").append(TEIPPingTestBean.resourceUtil.getString("pingteststatistic")).append("]");
            res.append(TEIPPingTestBean.resourceUtil.getString("txnum")).append(" ").append(txNum).append(" ");
            res.append(TEIPPingTestBean.resourceUtil.getString("rxnum")).append(" ").append(rxNum).append(" ");
            res.append(TEIPPingTestBean.resourceUtil.getString("lossrate")).append(" ").append(lossRate).append("\n");
            return res.toString();
        }
    }
}

