/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ipgretunnel;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nemgr.ip.ptn.ipgretunnel.PortObj;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEGetTunnelRes
extends TENEExplorerBean {
    private static final int INVALID_SLOT = 65535;
    private static final int INVALID_SUB_SLOT = 255;
    private static final int LAYER_3 = 3;
    private static final int MPLS_ENABLE = 1;
    private static final int MIN_MP_PORT = 4096;
    private static final int MAX_MP_PORT = 6143;
    private static final int MIN_VETH_PORT = 10240;
    private static final int MAX_VETH_PORT = 12287;
    private TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        List<PortObj> portList = this.getPortsByPortType(neid, 1799);
        this.operationList = new ArrayList();
        this.operationList.add(TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PORT_GET_VPORT"));
        this.operationList.add(TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_MLPPP_GET_MP"));
        PortObj portObj = null;
        int result = this.sendMessage(neid);
        if (0 == result) {
            int errCode = 0;
            Operation oper = null;
            Output output = null;
            Part part = null;
            int m = this.operationList.size();
            for (int i = 0; i < m; ++i) {
                oper = (Operation)this.operationList.get(i);
                errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
                if (0 != errCode) continue;
                int n = oper.getOutputCount();
                for (int j = 0; j < n; ++j) {
                    output = oper.getOutput(j);
                    part = output.getPart("groupno");
                    portObj = null != part ? new PortObj(65535, Integer.valueOf(part.getValue())) : new PortObj(Integer.valueOf(output.getPartValue("slotid")), Integer.valueOf(output.getPartValue("port")));
                    if (portList.contains(portObj)) continue;
                    portList.add(portObj);
                }
            }
        }
        this.queryPortAttr(portList);
        return this.outputData;
    }

    private void queryPortAttr(List<PortObj> portList) {
        if (null != portList && portList.size() > 0) {
            Collections.sort(portList);
            Operation oper1 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTNETY_GET_LEVELMODE");
            Input input1 = oper1.getInput();
            input1.setPartValue("subslotid", String.valueOf(255));
            Operation oper2 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_L3_GET_MPLSEN");
            Input input2 = oper2.getInput();
            input2.setPartValue("subslotid", String.valueOf(255));
            Operation oper3 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME");
            Input input3 = oper3.getInput();
            input3.setPartValue("subslotid", String.valueOf(255));
            PortObj portObj = null;
            this.operationList.clear();
            int mn = portList.size();
            for (int k = 0; k < mn; ++k) {
                portObj = portList.get(k);
                input1.setPartValue("slotid", String.valueOf(portObj.slotId));
                input1.setPartValue("port", String.valueOf(portObj.portId));
                this.operationList.add(oper1.clone());
                input2.setPartValue("slotid", String.valueOf(portObj.slotId));
                input2.setPartValue("port", String.valueOf(portObj.portId));
                this.operationList.add(oper2.clone());
                input3.setPartValue("slotid", String.valueOf(portObj.slotId));
                input3.setPartValue("port", String.valueOf(portObj.portId));
                this.operationList.add(oper3.clone());
            }
            int result = this.sendMessage(this.neid);
            if (0 == result) {
                this.handleMessage(this.neid, this.operationList, this.subfunc);
            }
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int errCode = 0;
        Operation oper = null;
        Output output = null;
        int portMode = -1;
        int mplsEn = 0;
        int slotId = -1;
        int boardType = -1;
        int portId = -1;
        String portName = null;
        StringBuilder sb = null;
        Param param = new Param("portres", "");
        RowParams rowParams = new RowParams();
        rowParams.addParam(param);
        this.outputData.getBussinessParams().addRowParams(rowParams);
        int m = operationList.size();
        for (int i = 0; i < m; i += 3) {
            oper = (Operation)operationList.get(i);
            output = oper.getOutput(0);
            errCode = Integer.valueOf(output.getFault(0).getCode());
            if (0 != errCode || 3 != (portMode = Integer.valueOf(output.getPartValue("PTNIF_PORT_ATTR_MODE")).intValue()) || 0 != (errCode = Integer.valueOf((output = (oper = (Operation)operationList.get(i + 1)).getOutput(0)).getFault(0).getCode()).intValue()) || 1 != (mplsEn = Integer.valueOf(output.getPartValue("PTNIF_PORT_ATTR_MPLSEN")).intValue())) continue;
            slotId = Integer.valueOf(output.getPartValue("slotid"));
            portId = Integer.valueOf(output.getPartValue("port"));
            boardType = this.cfgMgr.getBoardType(neid, slotId);
            sb = new StringBuilder();
            sb.append(slotId).append("-");
            sb.append(this.cfgMgr.getBoardTypeName(neid, boardType)).append("-");
            oper = (Operation)operationList.get(i + 2);
            portName = this.getPortName(oper, slotId, boardType, portId);
            sb.append(portName).append("#").append(portId);
            param.addOption(new Option(sb.toString()));
        }
    }

    private String getPortName(Operation oper, int slotId, int boardType, int portId) {
        String name;
        StringBuilder sb = new StringBuilder();
        Output output = oper.getOutput(0);
        int errCode = Integer.valueOf(output.getFault(0).getCode());
        if (0 == errCode && null != (name = IOStreamConvertor.replaceSpecialStr((String)output.getPartValue("PTNIF_PORT_ATTR_PORTNAME"))) && !"".equals(name.trim())) {
            if (portId >= 4096 && portId <= 6143) {
                sb.append(portId - 4096).append("(").append("MP-").append(name).append(")");
                return sb.toString();
            }
            if (portId >= 10240 && portId <= 12287) {
                sb.append(portId - 10240).append("(").append("VEther-").append(name).append(")");
                return sb.toString();
            }
        }
        return this.cfgMgr.getPortNameForPTN(this.neid, slotId, boardType, portId);
    }

    private List<PortObj> getPortsByPortType(int neid, int portType) {
        ArrayList<PortObj> portList = new ArrayList<PortObj>();
        int portId = 0;
        TEBoard board = null;
        TEPortProperty portProperty = null;
        ArrayList portPropertyList = null;
        PortObj portObj = null;
        Vector boardVec = this.cfgMgr.getNE(neid).getClonedBoardList();
        int m = boardVec.size();
        for (int i = 0; i < m; ++i) {
            board = (TEBoard)boardVec.get(i);
            portPropertyList = this.cfgMgr.getBoardPortPropertyList(neid, board.getBoardType());
            int n = portPropertyList.size();
            for (int j = 0; j < n; ++j) {
                portProperty = (TEPortProperty)portPropertyList.get(j);
                portId = portProperty.getPortNo();
                portObj = new PortObj(board.getSlotID(), portId);
                if (portProperty.getPortType() != portType || portList.contains(portObj)) continue;
                portList.add(portObj);
            }
        }
        return portList;
    }
}

