/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.imamgr;

import com.huawei.nglct.nemgr.ip.ptn.atm.TEE1TrunckMbr;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEFranE1TrunckMbr;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEImamgrUtils;
import com.huawei.nglct.nemgr.ip.ptn.atm.TETrunckMbr;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEVC12TrunckMbr;
import com.huawei.nglct.nemgr.ip.ptn.imamgr.TEQxTrunckMbr;

public class TETrunckMbrFactory {
    private static TETrunckMbrFactory instance = null;

    private TETrunckMbrFactory() {
    }

    public static synchronized TETrunckMbrFactory getInstance() {
        if (instance == null) {
            instance = new TETrunckMbrFactory();
        }
        return instance;
    }

    public TETrunckMbr createTrunckMbr(int neid, int slotid, int trunckid, String levelIma, String direction) {
        if (levelIma.equalsIgnoreCase("E1")) {
            return new TEE1TrunckMbr(neid, slotid, trunckid, levelIma, direction);
        }
        if (levelIma.equalsIgnoreCase("Fractional E1")) {
            return new TEFranE1TrunckMbr(neid, slotid, trunckid, levelIma, direction);
        }
        return new TEVC12TrunckMbr(neid, slotid, trunckid, levelIma, direction);
    }

    public TETrunckMbr createTrunckMbr(TEQxTrunckMbr qxmbrima, int neid) {
        String level = null;
        if (qxmbrima.boundportid == 65535) {
            level = "E1";
            if (qxmbrima.linktable.size() > 0 && qxmbrima.linktable.get(0) > 6144 && qxmbrima.linktable.get(0) < 8191) {
                level = "Fractional E1";
            }
        } else {
            level = "VC12-xv";
        }
        if ("E1".equals(level)) {
            return new TEE1TrunckMbr(neid, qxmbrima.slotid, qxmbrima.trunckid, level, TEImamgrUtils.parserDirection(qxmbrima.direction), qxmbrima.boundslotid, qxmbrima.linktable);
        }
        if ("Fractional E1".equals(level)) {
            return new TEFranE1TrunckMbr(neid, qxmbrima.slotid, qxmbrima.trunckid, level, TEImamgrUtils.parserDirection(qxmbrima.direction), qxmbrima.boundslotid, qxmbrima.linktable);
        }
        return new TEVC12TrunckMbr(neid, qxmbrima.slotid, qxmbrima.trunckid, level, TEImamgrUtils.parserDirection(qxmbrima.direction), qxmbrima.boundslotid, qxmbrima.boundportid, qxmbrima.bounduppath, qxmbrima.linktable);
    }
}

