/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.imamgr;

import com.huawei.nglct.nemgr.ip.ptn.atm.TEImamgrUtils;
import com.huawei.nglct.nemgr.ip.ptn.atm.TETrunckMbr;
import java.util.ArrayList;
import java.util.Hashtable;

public class TETrunckCache {
    private Hashtable<Integer, ArrayList<TETrunckMbr>> bindTrunckCache = new Hashtable();

    public void clearCache() {
        this.bindTrunckCache.clear();
    }

    public void addTETrunckMbr(int neid, TETrunckMbr trunckMbr) {
        if (this.bindTrunckCache.containsKey(neid)) {
            ArrayList<TETrunckMbr> tempTrunck = this.bindTrunckCache.get(neid);
            if (!tempTrunck.contains(trunckMbr)) {
                tempTrunck.add(trunckMbr);
            }
        } else {
            ArrayList<TETrunckMbr> tempTrunck = new ArrayList<TETrunckMbr>();
            tempTrunck.add(trunckMbr);
            this.bindTrunckCache.put(neid, tempTrunck);
        }
    }

    public ArrayList<TETrunckMbr> getTrunkMbrByTrunckid(int neid, int slotid, int trunckid) {
        ArrayList<TETrunckMbr> trunks = new ArrayList<TETrunckMbr>();
        if (this.bindTrunckCache.containsKey(neid)) {
            ArrayList<TETrunckMbr> tempTrunck = this.bindTrunckCache.get(neid);
            for (int i = 0; i < tempTrunck.size(); ++i) {
                if (!tempTrunck.get((int)i).vctrunck.equalsIgnoreCase(TEImamgrUtils.getTrunckName(neid, slotid, trunckid))) continue;
                trunks.add(tempTrunck.get(i));
            }
        }
        return trunks;
    }

    public ArrayList<TETrunckMbr> getTrunkMbrsByTrunckid(int neid, int slotid, int trunckid, String level) {
        ArrayList<TETrunckMbr> trunks = new ArrayList<TETrunckMbr>();
        if (this.bindTrunckCache.containsKey(neid)) {
            ArrayList<TETrunckMbr> tempTrunck = this.bindTrunckCache.get(neid);
            for (int i = 0; i < tempTrunck.size(); ++i) {
                if (!tempTrunck.get((int)i).vctrunck.equalsIgnoreCase(TEImamgrUtils.getTrunckName(neid, slotid, trunckid)) || !tempTrunck.get((int)i).level.equalsIgnoreCase(level)) continue;
                trunks.add(tempTrunck.get(i));
            }
        }
        return trunks;
    }

    public TETrunckMbr getTrunkMbrByTrunckid(int neid, int slotid, int trunckid, String level) {
        if (this.bindTrunckCache.containsKey(neid)) {
            ArrayList<TETrunckMbr> tempTrunck = this.bindTrunckCache.get(neid);
            for (int i = 0; i < tempTrunck.size(); ++i) {
                if (!tempTrunck.get((int)i).vctrunck.equalsIgnoreCase(TEImamgrUtils.getTrunckName(neid, slotid, trunckid)) || !tempTrunck.get((int)i).level.equalsIgnoreCase(level)) continue;
                return tempTrunck.get(i);
            }
        }
        return null;
    }

    public TETrunckMbr getTrunkMbrByTrunckid(int neid, TETrunckMbr trunkMbr) {
        if (this.bindTrunckCache.containsKey(neid)) {
            ArrayList<TETrunckMbr> tempTrunck = this.bindTrunckCache.get(neid);
            for (int i = 0; i < tempTrunck.size(); ++i) {
                if (!tempTrunck.get(i).isEqualTrunck(trunkMbr)) continue;
                return tempTrunck.get(i);
            }
        }
        return null;
    }

    public void deleteTrunk(int neid, TETrunckMbr trunkMbr) {
        if (this.bindTrunckCache.containsKey(neid)) {
            ArrayList<TETrunckMbr> tempTrunck = this.bindTrunckCache.get(neid);
            for (int i = 0; i < tempTrunck.size(); ++i) {
                if (!tempTrunck.get((int)i).vctrunck.equalsIgnoreCase(trunkMbr.vctrunck)) continue;
                tempTrunck.remove(i);
                return;
            }
        }
    }

    public boolean isContainTrunck(int neid, int slotid, int portid) {
        if (this.bindTrunckCache.containsKey(neid)) {
            ArrayList<TETrunckMbr> tempTrunck = this.bindTrunckCache.get(neid);
            for (int i = 0; i < tempTrunck.size(); ++i) {
                if (!tempTrunck.get(i).isEqualPort(slotid, portid, 0)) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList<Integer> getCacheContainVC12TimeSlot(int neid, int slotid, int portid, int upportid, int trunkid) {
        if (this.bindTrunckCache.containsKey(neid)) {
            ArrayList<TETrunckMbr> tempTrunck = this.bindTrunckCache.get(neid);
            for (int i = 0; i < tempTrunck.size(); ++i) {
                if (!tempTrunck.get(i).isEqualPort(slotid, portid, upportid) || tempTrunck.get((int)i).trunckid != trunkid) continue;
                return tempTrunck.get((int)i).boundPaths;
            }
        }
        return null;
    }
}

