/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.imamgr;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgCommon;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEImamgrUtils;
import com.huawei.nglct.nemgr.ip.ptn.imamgr.TEImaGroupStateBean;
import com.huawei.nglct.nemgr.ip.ptn.imamgr.TEQxTrunckMbr;
import com.huawei.nglct.nemgr.ip.ptn.imamgr.TETrunckMbrFactory;
import com.huawei.nglct.nemgr.ip.ptn.imamgr.TrunckID;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.List;

public class TEImaTrunkStateBean
extends TEImaGroupStateBean {
    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        List boardList = TEGenCfgCommon.getAttrSupportCPs((int)neid, (String)"PTNCP_ATTR_IMAGROUP");
        this.inputData.getBussinessParams().clearRowParams();
        for (int i = 0; i < boardList.size(); ++i) {
            RowParams rowParas = new RowParams();
            rowParas.addParam("slotid", String.valueOf(((TEBoard)boardList.get(i)).getSlotID()));
            rowParas.addParam("childslotid", "0");
            rowParas.addParam("trunckid", "0");
            this.inputData.getBussinessParams().addRowParams(rowParas);
        }
        this.outputData = new Datainterface();
        this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
        if (null == this.operationList || this.operationList.isEmpty()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        ArrayList<Operation> operListTmp = new ArrayList<Operation>();
        int resultCode = this.getEnableTrunck(neid, operListTmp);
        if (0 == resultCode) {
            if (this.enableTrunckList.isEmpty()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            this.inputData.getBussinessParams().clearRowParams();
            for (int i = 0; i < this.enableTrunckList.size(); ++i) {
                TrunckID truncktmp = (TrunckID)this.enableTrunckList.get(i);
                RowParams row = new RowParams();
                row.addParam("slotid", String.valueOf(truncktmp.slotid));
                row.addParam("childslotid", "255");
                row.addParam("trunckid", String.valueOf(truncktmp.trunckid));
                this.inputData.getBussinessParams().addRowParams(row);
            }
            this.operationList.clear();
            this.operationList = this.getOperation(neid, subFunc, this.inputData, memeryData);
            operListTmp.clear();
            Operation oper = null;
            for (int i = 0; i < this.operationList.size(); ++i) {
                oper = (Operation)this.operationList.get(i);
                if (oper.getCmdid() != 33907) continue;
                operListTmp.add((Operation)oper.clone());
            }
            resultCode = this.sendMessage(neid, operListTmp);
            if (resultCode == 0) {
                this.handleMessage(neid, operListTmp, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)resultCode));
            }
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)resultCode));
        }
        this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        return this.outputData;
    }

    @Override
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        RowParams[] rowParas = this.outputData.getBussinessParams().getRowParams();
        for (int i = rowParas.length - 1; i >= 0; --i) {
            String boardInfo;
            if (rowParas[i].getRowErrorsCount() != 0 && !rowParas[i].getRowErrors(0).getErrorMessage().getErrorcode().equals("0") || (boardInfo = this.buildVctrunk(rowParas[i])) == null) continue;
            rowParas[i].getParam("vctrunk").setValue(boardInfo);
            String boundPathInfo = this.buildBoundInfo(rowParas[i]);
            if (boundPathInfo == null) continue;
            rowParas[i].getParam("e1link").setValue(boundPathInfo);
        }
    }

    protected String buildBoundInfo(RowParams row) {
        Param slotidParam = row.getParam("slotid");
        int slotid = 0;
        try {
            slotid = Integer.parseInt(slotidParam.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
        Param bindSlotidParam = row.getParam("e1slotid");
        int bindSlotid = 0;
        try {
            bindSlotid = Integer.parseInt(bindSlotidParam.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
        Param e1uppathidParam = row.getParam("e1uppathid");
        int e1uppathid = 0;
        try {
            e1uppathid = Integer.parseInt(e1uppathidParam.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
        Param e1mbridParam = row.getParam("e1mbrid");
        int e1mbrid = 0;
        try {
            e1mbrid = Integer.parseInt(e1mbridParam.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
        ArrayList<Integer> linktable = new ArrayList<Integer>();
        linktable.add(e1mbrid);
        TEQxTrunckMbr qxmbr = new TEQxTrunckMbr(slotid, 0, 0, bindSlotid, e1uppathid, e1uppathid, linktable);
        return TETrunckMbrFactory.getInstance().createTrunckMbr(qxmbr, this.neid).buildBoundPathString();
    }

    protected String buildVctrunk(RowParams rowParas) {
        Param slotidPara = rowParas.getParam("slotid");
        int slotid = 0;
        try {
            slotid = Integer.parseInt(slotidPara.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
        Param trunckidPara = rowParas.getParam("trunckid");
        int trunckid = 0;
        try {
            trunckid = Integer.parseInt(trunckidPara.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
        return TEImamgrUtils.getTrunckName(this.neid, slotid, trunckid);
    }
}

