/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.imamgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEImamgrUtils;
import com.huawei.nglct.nemgr.ip.ptn.atm.TrunckInfo;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TEImaTrunckMgrBean
extends TENEExplorerBean {
    protected static Logger log = TELogFactory.getNormalLogger();

    protected void modifyInputParams() {
        RowParams[] rows = this.inputData.getBussinessParams().getRowParams();
        for (int i = rows.length - 1; i >= 0; --i) {
            Param trunckParam = rows[i].getParam("vctrunck");
            if (trunckParam != null) {
                if (trunckParam.getValue() == null) {
                    return;
                }
            } else {
                return;
            }
            TrunckInfo trunckinfo = TEImamgrUtils.getTrunckInfo(trunckParam.getValue());
            rows[i].addParam("slotid", String.valueOf(trunckinfo.slotid));
            rows[i].addParam("trunckid", String.valueOf(trunckinfo.trunckid + 8192));
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        for (int i = rows.length - 1; i >= 0; --i) {
            String boardInfo;
            if (rows[i].getRowErrorsCount() != 0 && !rows[i].getRowErrors(0).getErrorMessage().getErrorcode().equals("0")) continue;
            Param slotidParam = rows[i].getParam("slotid");
            int slotid = 0;
            try {
                slotid = Integer.parseInt(slotidParam.getValue());
            }
            catch (NumberFormatException e) {
                slotid = -1;
            }
            if (slotid == -1) continue;
            Param trunckidParam = rows[i].getParam("trunckid");
            int trunckid = 0;
            try {
                trunckid = Integer.parseInt(trunckidParam.getValue());
            }
            catch (NumberFormatException e) {
                trunckid = -1;
            }
            if (trunckid == -1 || (boardInfo = TEImamgrUtils.getTrunckName(neid, slotid, trunckid)) == null) continue;
            rows[i].getParam("vctrunck").setValue(boardInfo);
        }
    }

    public ArrayList<Integer> getFilterErrorCodeList() {
        ArrayList list = super.getFilterErrorCodeList();
        list.add(38662);
        list.add(40640);
        list.add(40625);
        return list;
    }
}

