/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.imamgr;

import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgCommon;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEImamgrUtils;
import com.huawei.nglct.nemgr.ip.ptn.imamgr.TEImaTrunckMgrBean;
import java.util.ArrayList;
import java.util.List;

public class TEImaIntefaceMgrBean
extends TEImaTrunckMgrBean {
    @Override
    protected void modifyInputParams() {
        List boardList = TEGenCfgCommon.getAttrSupportCPs((int)this.neid, (String)"PTNCP_ATTR_IMAGROUP");
        this.inputData.getBussinessParams().clearRowParams();
        for (int i = 0; i < boardList.size(); ++i) {
            List portid = TEImamgrUtils.getQxTrunckID(this.neid, ((TEBoard)boardList.get(i)).getBoardType());
            for (int j = 0; j < portid.size(); ++j) {
                RowParams row = new RowParams();
                row.addParam("slotid", String.valueOf(((TEBoard)boardList.get(i)).getSlotID()));
                row.addParam("childslotid", "255");
                int trunckid = (Integer)portid.get(j);
                row.addParam("trunckid", String.valueOf(trunckid));
                this.inputData.getBussinessParams().addRowParams(row);
            }
        }
    }

    @Override
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        for (int i = rows.length - 1; i >= 0; --i) {
            if (rows[i].getRowErrorsCount() != 0 && !rows[i].getRowErrors(0).getErrorMessage().getErrorcode().equals("0")) continue;
            rows[i].addParam("minvpi", "-");
            rows[i].addParam("minvci", "-");
            if (rows[i].getParam("maxvpi") == null) {
                rows[i].addParam("maxvpi", "-");
                rows[i].addParam("maxvci", "-");
                rows[i].addParam("supportvcc", "-");
                continue;
            }
            int maxvpi = this.getPowerByRow("maxvpi", rows[i]);
            if (maxvpi == -1) continue;
            rows[i].getParam("maxvpi").setValue(String.valueOf(maxvpi));
            int maxvci = this.getPowerByRow("maxvci", rows[i]);
            if (maxvci == -1) continue;
            rows[i].getParam("maxvci").setValue(String.valueOf(maxvci));
        }
    }

    public int getPowerByRow(String name, RowParams row) {
        Param maxvpiParam = row.getParam(name);
        int maxvpi = 0;
        try {
            maxvpi = Integer.parseInt(maxvpiParam.getValue());
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return maxvpi;
    }
}

