/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.imamgr;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEImamgrUtils;
import com.huawei.nglct.nemgr.ip.ptn.imamgr.AvailPort;
import com.huawei.nglct.nemgr.ip.ptn.imamgr.TEImaBindMgrBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TEImaGetAvailableResBean
extends TENEExplorerBean {
    private String level;
    private List allSupportPortList = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        RowParams row = this.inputData.getBussinessParams().getRowParams(0);
        Param levelParam = row.getParam("level");
        if (levelParam == null) return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        this.level = levelParam.getValue();
        if (levelParam.getValue().equalsIgnoreCase("E1") || levelParam.getValue().equalsIgnoreCase("Fractional E1")) {
            Param porttypeParam = row.getParam("porttype");
            if (porttypeParam == null) return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
            this.allSupportPortList = TEConfigurationDataMgr.getInstance().getPortList(neid, TEImamgrUtils.parserIntParam(row, "slotid"), 1797);
            return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        } else {
            if (!levelParam.getValue().equalsIgnoreCase("VC12-xv")) return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
            return this.performVC12BussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        }
    }

    private Datainterface performVC12BussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        RowParams row = this.inputData.getBussinessParams().getRowParams(0);
        int opticalPortID = TEImamgrUtils.parserIntParam(row, "opticalport");
        int slotID = TEImamgrUtils.parserIntParam(row, "slotid");
        int portLevel = TEConfigurationDataMgr.getInstance().getPort(neid, slotID, opticalPortID).getLevel();
        int trunkid = TEImamgrUtils.parserIntParam(row, "trunkid");
        int vc4num = 1;
        this.outputData = new Datainterface();
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        BussinessParams bussinessParams = new BussinessParams();
        for (int i = 0; i < vc4num; ++i) {
            RowParams rowparams;
            int j;
            ArrayList<Integer> timeSlots = TEImaBindMgrBean.getCacheContainVC12TimeSlot(neid, slotID, opticalPortID, i + 1, trunkid);
            if (timeSlots != null && timeSlots.size() > 0) {
                for (j = 1; j < 64; ++j) {
                    if (timeSlots.contains(j)) continue;
                    rowparams = new RowParams();
                    rowparams.addParam("encapType", String.valueOf(portLevel));
                    rowparams.addParam("timeSlot", String.valueOf(j));
                    rowparams.addParam("availablePortID", String.valueOf(i + 1));
                    bussinessParams.addRowParams(rowparams);
                }
                continue;
            }
            for (j = 0; j < 63; ++j) {
                rowparams = new RowParams();
                rowparams.addParam("encapType", String.valueOf(portLevel));
                rowparams.addParam("timeSlot", String.valueOf(j + 1));
                rowparams.addParam("availablePortID", String.valueOf(i + 1));
                bussinessParams.addRowParams(rowparams);
            }
        }
        this.outputData.setBussinessParams(bussinessParams);
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        int i;
        ArrayList<AvailPort> atmPort = new ArrayList<AvailPort>();
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        ArrayList<RowParams> errorParams = new ArrayList<RowParams>();
        for (i = rows.length - 1; i >= 0; --i) {
            if (rows[i].getRowErrorsCount() == 0 || rows[i].getRowErrors(0).getErrorMessage().getErrorcode().equals("0")) {
                Param encapTypeParam = rows[i].getParam("encapType");
                if (encapTypeParam == null || !encapTypeParam.getValue().equalsIgnoreCase("4")) continue;
                Param slotidParam = rows[i].getParam("slotid");
                int slotid = 0;
                try {
                    slotid = Integer.parseInt(slotidParam.getValue());
                }
                catch (NumberFormatException e) {
                    slotid = -1;
                }
                if (slotid == -1) continue;
                Param portidParam = rows[i].getParam("port");
                int portid = 0;
                try {
                    portid = Integer.parseInt(portidParam.getValue());
                }
                catch (NumberFormatException e) {
                    portid = -1;
                }
                if (portid == -1) continue;
                if (this.level.equalsIgnoreCase("E1")) {
                    if (portid > 2048) continue;
                    AvailPort port = new AvailPort();
                    port.portName = TEImamgrUtils.getPortName(this.neid, slotid, portid);
                    port.portid = portid;
                    if (TEImaBindMgrBean.isCacheContainBindPort(this.neid, slotid, portid)) {
                        port.isBound = true;
                    }
                    atmPort.add(port);
                    continue;
                }
                if (!this.level.equalsIgnoreCase("Fractional E1") || portid < 6144 || portid > 8192) continue;
                String portName = TEImamgrUtils.getPortName(this.neid, slotid, portid);
                AvailPort port = new AvailPort();
                port.portName = portName;
                port.portid = portid;
                if (TEImaBindMgrBean.isCacheContainBindPort(this.neid, slotid, portid)) {
                    port.isBound = true;
                }
                atmPort.add(port);
                continue;
            }
            errorParams.add(rows[i]);
        }
        this.outputData.getBussinessParams().clearRowParams();
        for (i = 0; i < errorParams.size(); ++i) {
            this.outputData.getBussinessParams().addRowParams((RowParams)errorParams.get(i));
        }
        atmPort = this.addAllLevelPort(atmPort);
        Collections.sort(atmPort);
        for (i = 0; i < atmPort.size(); ++i) {
            RowParams row = new RowParams();
            row.addParam("availablePort", atmPort.get((int)i).portName);
            row.addParam("isbound", String.valueOf(atmPort.get((int)i).isBound));
            row.addParam("availablePortID", String.valueOf(atmPort.get((int)i).portid));
            row.addParam("usedTimeSlot", "0");
            row.addParam("slotid", "0");
            row.addParam("subslotid", "0");
            row.addParam("port", "0");
            row.addParam("encapType", "0");
            this.outputData.getBussinessParams().addRowParams(row);
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private ArrayList<AvailPort> addAllLevelPort(ArrayList<AvailPort> atmPort) {
        if (this.allSupportPortList != null) {
            for (int i = 0; i < this.allSupportPortList.size(); ++i) {
                TEPort port = (TEPort)this.allSupportPortList.get(i);
                AvailPort avPort = new AvailPort();
                avPort.portid = port.getPortNo();
                avPort.portName = TEImamgrUtils.getPortName(this.neid, port.getSlotID(), avPort.portid);
                if (atmPort.contains(avPort)) continue;
                atmPort.add(avPort);
            }
        }
        return atmPort;
    }
}

