/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.imamgr;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.gencfg.TEGenCfgBoardAttr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallCPPortRecord;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEImamgrUtils;
import com.huawei.nglct.nemgr.ip.ptn.imamgr.PortInfo;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.List;

public class TEImaBoundResource
extends TEGenCfgBoardAttr {
    public void convertToOutPutData(List<TEBoard> boardList) {
        this.outputData = new Datainterface();
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        BussinessParams bussinessParams = new BussinessParams();
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = boardList.get(i);
            String boardType = this.getBoardImaType(board.getBoardType());
            ArrayList<PortInfo> portinfos = this.getPortList(board.getSlotID(), board.getBoardType());
            for (int j = 0; j < portinfos.size(); ++j) {
                RowParams rowparams = new RowParams();
                int slotid = board.getSlotID();
                String boardName = board.getBoardTypeName();
                rowparams.addParam("slotid", String.valueOf(slotid));
                rowparams.addParam("boradName", slotid + "-" + boardName);
                rowparams.addParam("boardtype", boardType);
                rowparams.addParam("portName", portinfos.get((int)j).portName);
                rowparams.addParam("portID", String.valueOf(portinfos.get((int)j).portId));
                bussinessParams.addRowParams(rowparams);
            }
        }
        this.outputData.setBussinessParams(bussinessParams);
    }

    private TEInstallCPPortRecord getBoardOpticalPort(int boardType) {
        if (boardType == 1624 || boardType == 2469) {
            List portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(boardType);
            for (int j = 0; j < portRecordList.size(); ++j) {
                if (((TEInstallCPPortRecord)portRecordList.get((int)j)).interfaceLevel != 6401) continue;
                return (TEInstallCPPortRecord)portRecordList.get(j);
            }
        }
        return null;
    }

    private String getBoardImaType(int boardType) {
        List portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(boardType);
        for (int j = 0; j < portRecordList.size(); ++j) {
            if (((TEInstallCPPortRecord)portRecordList.get((int)j)).interfaceLevel != 6401) continue;
            return "VC12-xv";
        }
        return "E1";
    }

    private ArrayList<PortInfo> getPortList(int slotid, int boardType) {
        ArrayList<PortInfo> portInfos = new ArrayList<PortInfo>();
        List trunkids = TEImamgrUtils.getQxTrunckID(this.neID, boardType);
        for (int i = 0; i < trunkids.size(); ++i) {
            int trunkId = (Integer)trunkids.get(i);
            String trunkName = TEImamgrUtils.getTrunckName(this.neID, slotid, trunkId);
            portInfos.add(new PortInfo(trunkName, trunkId));
        }
        TEInstallCPPortRecord boardRecord = this.getBoardOpticalPort(boardType);
        if (boardRecord != null) {
            for (int j = 0; j < boardRecord.getPortIDList().size(); ++j) {
                Integer portid = (Integer)boardRecord.getPortIDList().get(j);
                String name = TEImamgrUtils.getOldPortName(this.neID, slotid, portid);
                portInfos.add(new PortInfo(name, portid));
            }
        }
        return portInfos;
    }
}

