/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.imamgr;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgCommon;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEImamgrUtils;
import com.huawei.nglct.nemgr.ip.ptn.atm.TETrunckMbr;
import com.huawei.nglct.nemgr.ip.ptn.imamgr.TEImaTrunckMgrBean;
import com.huawei.nglct.nemgr.ip.ptn.imamgr.TEQxTrunckMbr;
import com.huawei.nglct.nemgr.ip.ptn.imamgr.TETrunckCache;
import com.huawei.nglct.nemgr.ip.ptn.imamgr.TETrunckMbrFactory;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TEImaBindMgrBean
extends TEImaTrunckMgrBean {
    private static TETrunckCache bindTrunckCache = new TETrunckCache();
    private ArrayList<TEQxTrunckMbr> trunckMbrs = new ArrayList();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams[] rows = inputData.getBussinessParams().getRowParams();
        Param slotidParam = rows[0].getParam("slotid");
        Param trunckidParam = rows[0].getParam("trunckid");
        if (slotidParam == null || trunckidParam == null) {
            return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        }
        int slotID = TEImamgrUtils.parserIntParam(rows[0], "slotid");
        int trunckid = TEImamgrUtils.parserIntParam(rows[0], "trunckid");
        if (slotID == -1 || trunckid == -1) {
            return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        }
        String level = rows[0].getParam("level").getValue();
        TETrunckMbr trunckmbr = bindTrunckCache.getTrunkMbrByTrunckid(neid, slotID, trunckid, level);
        this.outputData = new Datainterface();
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        if (trunckmbr != null) {
            BussinessParams bussinessParams = new BussinessParams();
            bussinessParams.addRowParams(trunckmbr.parserTrunckMbrToRowParams());
            this.outputData.setBussinessParams(bussinessParams);
        }
        return this.outputData;
    }

    @Override
    protected void modifyInputParams() {
        switch (this.subfunc.getCode()) {
            case 2105492: {
                this.modifyGetVctrunckBindInputParams();
                break;
            }
        }
        super.modifyInputParams();
    }

    private void modifyGetVctrunckBindInputParams() {
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        List boardList = null;
        if (null != neObj) {
            boardList = TEGenCfgCommon.getAttrSupportCPs((int)this.neid, (String)"PTNCP_ATTR_IMAGROUP");
        } else {
            log.error("NE object not exist!");
        }
        if (boardList == null) {
            return;
        }
        this.inputData.getBussinessParams().clearRowParams();
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            RowParams rowparams = new RowParams();
            rowparams.addParam("neid", String.valueOf(this.neid));
            int slotid = ((TEBoard)boardList.get(i)).getSlotID();
            rowparams.addParam("slotID", String.valueOf(slotid));
            rowparams.addParam("trunckid", "0");
            this.inputData.getBussinessParams().addRowParams(rowparams);
        }
    }

    @Override
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.trunckMbrs.clear();
        switch (this.subfunc.getCode()) {
            case 2105492: {
                bindTrunckCache.clearCache();
                this.modifyGetVctrunckBindOutputParams(filterErrorCodeList);
                break;
            }
        }
    }

    private void modifyGetVctrunckBindOutputParams(ArrayList filterErrorCodeList) {
        int i;
        this.outputData = TEDataConverter.convertToDatainterface((int)this.neid, (SubFunc)this.subfunc, (ArrayList)this.operationList, (ArrayList)filterErrorCodeList);
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        ArrayList<RowParams> errorParams = new ArrayList<RowParams>();
        for (i = rows.length - 1; i >= 0; --i) {
            if (rows[i].getRowErrorsCount() == 0 || rows[i].getRowErrors(0).getErrorMessage().getErrorcode().equals("0")) {
                int bounduppath;
                int boundportid;
                int boundslotid;
                int direction;
                int trunckid;
                int slotid = TEImamgrUtils.parserIntParam(rows[i], "slotid");
                if (slotid == -1 || (trunckid = TEImamgrUtils.parserIntParam(rows[i], "trunckid")) == -1 || (direction = TEImamgrUtils.parserIntParam(rows[i], "direction")) == -1 || (boundslotid = TEImamgrUtils.parserIntParam(rows[i], "boundslotid")) == -1 || (boundportid = TEImamgrUtils.parserIntParam(rows[i], "boundportid")) == -1 || (bounduppath = TEImamgrUtils.parserIntParam(rows[i], "bounduppath")) == -1) continue;
                ArrayList<Integer> linktable = TEImamgrUtils.parserIntListParam(rows[i], "linktable", 16);
                TEQxTrunckMbr qxmbr = new TEQxTrunckMbr(slotid, trunckid, direction, boundslotid, boundportid, bounduppath, linktable);
                this.trunckMbrs.add(qxmbr);
                continue;
            }
            errorParams.add(rows[i]);
        }
        this.outputData.getBussinessParams().clearRowParams();
        for (i = 0; i < errorParams.size(); ++i) {
            this.outputData.getBussinessParams().addRowParams((RowParams)errorParams.get(i));
        }
        if (this.trunckMbrs.size() > 0) {
            do {
                TEQxTrunckMbr head = this.trunckMbrs.get(0);
                this.trunckMbrs.remove(0);
                TETrunckMbr trunckMbr = this.joinTrunckMbr(this.trunckMbrs, head);
                this.outputData.getBussinessParams().addRowParams(trunckMbr.parserTrunckMbrToRowParams());
                bindTrunckCache.addTETrunckMbr(this.neid, trunckMbr);
            } while (this.trunckMbrs.size() != 0);
        }
    }

    private TETrunckMbr joinTrunckMbr(ArrayList<TEQxTrunckMbr> qxTrunckList, TEQxTrunckMbr todoQxtrunckMbr) {
        TETrunckMbr trunckMbr = TETrunckMbrFactory.getInstance().createTrunckMbr(todoQxtrunckMbr, this.neid);
        Iterator<TEQxTrunckMbr> qxiter = qxTrunckList.iterator();
        while (qxiter.hasNext()) {
            TEQxTrunckMbr tempQxMbr = qxiter.next();
            if (todoQxtrunckMbr.equalsWithoutDirection(tempQxMbr)) {
                trunckMbr.direction = TEImamgrUtils.parserDirection(0);
                todoQxtrunckMbr.direction = 0;
                qxiter.remove();
                continue;
            }
            if (!todoQxtrunckMbr.equalsWithoutPath(tempQxMbr)) continue;
            if (trunckMbr.boundPaths.containsAll(tempQxMbr.linktable)) {
                if (trunckMbr.direction.equalsIgnoreCase("BIDIRECTIONAL") && !trunckMbr.direction.equalsIgnoreCase(TEImamgrUtils.parserDirection(tempQxMbr.direction))) {
                    trunckMbr.direction = "BIDIRECTIONAL";
                }
            } else {
                trunckMbr.boundPaths.addAll(tempQxMbr.linktable);
            }
            qxiter.remove();
        }
        return trunckMbr;
    }

    public static boolean isCacheContainBindPort(int neid, int slotid, int portid) {
        return bindTrunckCache.isContainTrunck(neid, slotid, portid);
    }

    public static ArrayList<Integer> getCacheContainVC12TimeSlot(int neid, int slotid, int portid, int upportid, int trunkid) {
        return bindTrunckCache.getCacheContainVC12TimeSlot(neid, slotid, portid, upportid, trunkid);
    }

    public static TETrunckMbr getCacheContainTrunck(int neid, int slotid, int trunckid, String level) {
        return bindTrunckCache.getTrunkMbrByTrunckid(neid, slotid, trunckid, level);
    }

    public static TETrunckMbr getCacheContainTrunck(int neid, TETrunckMbr trunk) {
        return bindTrunckCache.getTrunkMbrByTrunckid(neid, trunk);
    }

    public static ArrayList<TETrunckMbr> getCacheContainTrunck(int neid, int slotid, int trunckid) {
        return bindTrunckCache.getTrunkMbrByTrunckid(neid, slotid, trunckid);
    }

    public static ArrayList<TETrunckMbr> getCacheContainTrunks(int neid, int slotid, int trunckid, String level) {
        return bindTrunckCache.getTrunkMbrsByTrunckid(neid, slotid, trunckid, level);
    }

    public static void deleteTrunkFromCache(int neid, TETrunckMbr trunk) {
        bindTrunckCache.deleteTrunk(neid, trunk);
    }

    @Override
    public ArrayList<Integer> getFilterErrorCodeList() {
        ArrayList<Integer> list = super.getFilterErrorCodeList();
        list.add(38662);
        list.add(40640);
        list.add(40625);
        list.add(42372);
        return list;
    }
}

