/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.foqosmanagement;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TESetWredCfgBean
extends TECommonWriteLogBean {
    private static final String NSCMD_PTN_QOS_SET_WRED_DROP = "NSCMD_PTN_QOS_SET_WRED_DROP";
    private static final String NSCMD_PTN_QOS_CRT_WRED = "NSCMD_PTN_QOS_CRT_WRED ";
    private String wredID;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            boolean createSucFlag = true;
            int satrtIndex = 1;
            RowParams[] rows = inputData.getBussinessParams().getRowParams();
            String oprationType = rows[1].getParam("oprationType").getValue();
            if (oprationType.equals("createWred")) {
                createSucFlag = this.processCreateWredCommand(neid, rows[1]);
            }
            if (createSucFlag) {
                for (int i = ++satrtIndex; i < rows.length; ++i) {
                    this.operationList = this.getOneRowOperation(neid, subFunc, rows[i], memeryData);
                    if (null == this.operationList || this.operationList.size() == 0) continue;
                    int resultParam = this.sendMessage(neid);
                    if (resultParam == 0) {
                        this.handleMessage(neid, this.operationList, subFunc);
                    } else {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)resultParam));
                    }
                    Param isLogFlagPara = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
                    if (isLogFlagPara != null && isLogFlagPara.getValue().equals("0")) {
                        this.isLogFlag = false;
                    }
                    if (!this.isLogFlag || !this.isNeedOperationlog()) continue;
                    this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    private boolean processCreateWredCommand(int neid, RowParams rowParams) {
        Operation opertion = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PTN_QOS_CRT_WRED);
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        operationList.add(opertion);
        if (!operationList.isEmpty()) {
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operationList, this.TIME_OUT);
            if (result.retCode != 0) {
                TELogFactory.getNormalLogger().info("create wred fail!result=" + result.retCode);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result.retCode));
                Param isLogFlagParam = this.inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
                if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                    this.isLogFlag = false;
                }
                if (this.isLogFlag && this.isNeedOperationlog()) {
                    this.writeLog(neid, this.subfunc, this.inputData, this.user, this.ipAddress, this.outputData);
                }
                return false;
            }
            Operation oper = null;
            int len = operationList.size();
            for (int i = 0; i < len; ++i) {
                oper = (Operation)operationList.get(i);
                if (!oper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
                int lenj = oper.getOutputCount();
                for (int j = 0; j < lenj; ++j) {
                    Output outPut = oper.getOutput(j);
                    this.wredID = outPut.getPartValue("policyId");
                }
            }
            return true;
        }
        return false;
    }

    private ArrayList getOneRowOperation(int neid, SubFunc subFunc, RowParams row, Datainterface memeryData) {
        ArrayList operaList = new ArrayList();
        BussinessParams bus = new BussinessParams();
        bus.addRowParams(row);
        String oprationType = row.getParam("oprationType").getValue();
        if (null == oprationType || oprationType.isEmpty()) {
            return new ArrayList();
        }
        if (oprationType.equals("modifyWred")) {
            this.processSetWredCommand(neid, row, operaList);
        }
        return operaList;
    }

    private void processSetWredCommand(int neid, RowParams row, ArrayList operaList) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PTN_QOS_SET_WRED_DROP);
        this.buildSetWredCmd(oper.getInput(), row);
        operaList.add(oper);
    }

    private void buildSetWredCmd(Input input, RowParams row) {
        input.setPartValue("wredType", row.getParam("wredType").getValue());
        input.setPartValue("isAuto", row.getParam("isAuto").getValue());
        input.setPartValue("policyId", this.wredID);
        input.setPartValue("color", row.getParam("color").getValue());
        input.setPartValue("dropLow", row.getParam("dropLow").getValue());
        input.setPartValue("dropHigh", row.getParam("dropHigh").getValue());
        input.setPartValue("probability", row.getParam("probability").getValue());
    }
}

