/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.foqosmanagement;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TEPortModelConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TESetPortQosBean
extends TECommonWriteLogBean {
    private static final String NSCMD_PTN_QOS_SET_APPLYCOSPRIMAP = "NSCMD_PTN_QOS_SET_APPLYCOSPRIMAP";
    private static final String NSCMD_CFG_PTN_QOS_SET_PORT_QUEUE = "NSCMD_CFG_PTN_QOS_SET_PORT_QUEUE";
    private static final String NSCMD_CFG_PTN_QOS_CRT_PORT_QUEUE = "NSCMD_CFG_PTN_QOS_CRT_PORT_QUEUE";
    private static final String NSCMD_CFG_PTN_QOS_DEL_PORT_QUEUE = "NSCMD_CFG_PTN_QOS_DEL_PORT_QUEUE";
    private static final String NSCMD_PTN_QOS_SET_PORT_QOSPOLICY = "NSCMD_PTN_QOS_SET_PORT_QOSPOLICY";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            RowParams[] rows = inputData.getBussinessParams().getRowParams();
            this.operationList = this.getOneRowOperation(neid, subFunc, rows, memeryData);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int resultFlag = this.sendMessage(neid);
            if (resultFlag == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)resultFlag));
            }
            Param isLogFlag_Param = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlag_Param != null && isLogFlag_Param.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (IndexOutOfBoundsException e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    public ArrayList getOneRowOperation(int neid, SubFunc subFunc, RowParams[] rows, Datainterface memeryData) {
        ArrayList operaList = new ArrayList();
        RowParams row2 = null;
        for (RowParams row2 : rows) {
            String oprationType = row2.getParam("oprationType").getValue();
            if (null == oprationType || oprationType.isEmpty()) continue;
            if (oprationType.equals("setQos")) {
                this.processSetCosCommand(neid, row2, operaList);
                continue;
            }
            if (oprationType.equals("setpacket")) {
                this.processSetPacketCommand(neid, row2, operaList);
                continue;
            }
            if (oprationType.equals("deleteqos")) {
                this.processSetPacketCommand(neid, row2, operaList);
                this.processDeleteQosCommand(neid, row2, operaList);
                continue;
            }
            if (oprationType.equals("modifyqos")) {
                this.processSetPacketCommand(neid, row2, operaList);
                this.processModifyQosCommand(neid, row2, operaList);
                continue;
            }
            if (!oprationType.equals("createqos")) continue;
            this.processSetPacketCommand(neid, row2, operaList);
            this.processCreateQosCommand(neid, row2, operaList);
        }
        return operaList;
    }

    private void processCreateQosCommand(int neid, RowParams row, ArrayList operationList) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_CFG_PTN_QOS_CRT_PORT_QUEUE);
        this.buildCreateQosCmd(oper.getInput(), row);
        operationList.add(oper);
    }

    private void buildCreateQosCmd(Input input, RowParams row) {
        input.setPartValue("slotid", row.getParam("slotid").getValue());
        input.setPartValue("subBaordid", row.getParam("subBaordid").getValue());
        input.setPartValue("port", row.getParam("port").getValue());
        input.setPartValue("dir", row.getParam("dir").getValue());
        input.setPartValue("cir", row.getParam("cir").getValue());
        input.setPartValue("cbs", row.getParam("cbs").getValue());
        input.setPartValue("pir", row.getParam("pir").getValue());
        input.setPartValue("pbs", row.getParam("pbs").getValue());
    }

    private void processModifyQosCommand(int neid, RowParams row, ArrayList operationList) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_CFG_PTN_QOS_SET_PORT_QUEUE);
        this.buildModifyQosCmd(oper.getInput(), row);
        operationList.add(oper);
    }

    private void buildModifyQosCmd(Input input, RowParams row) {
        input.setPartValue("slotid", row.getParam("slotid").getValue());
        input.setPartValue("subBaordid", row.getParam("subBaordid").getValue());
        input.setPartValue("port", row.getParam("port").getValue());
        input.setPartValue("dir", row.getParam("dir").getValue());
        input.setPartValue("cir", row.getParam("cir").getValue());
        input.setPartValue("cbs", row.getParam("cbs").getValue());
        input.setPartValue("pir", row.getParam("pir").getValue());
        input.setPartValue("pbs", row.getParam("pbs").getValue());
    }

    private void processDeleteQosCommand(int neid, RowParams row, ArrayList operationList) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_CFG_PTN_QOS_DEL_PORT_QUEUE);
        this.buildDeleteQosCmd(oper.getInput(), row);
        operationList.add(oper);
    }

    private void buildDeleteQosCmd(Input input, RowParams row) {
        input.setPartValue("slotid", row.getParam("slotid").getValue());
        input.setPartValue("subBaordid", row.getParam("subBaordid").getValue());
        input.setPartValue("port", row.getParam("port").getValue());
        input.setPartValue("dir", row.getParam("dir").getValue());
    }

    private void processSetCosCommand(int neid, RowParams row, ArrayList operationList) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PTN_QOS_SET_PORT_QOSPOLICY);
        this.buildSetCosCmd(oper.getInput(), row);
        operationList.add(oper);
    }

    private void buildSetCosCmd(Input input, RowParams row) {
        input.setPartValue("slotId", row.getParam("slotid").getValue());
        input.setPartValue("subSlotId", row.getParam("subBaordid").getValue());
        input.setPartValue("portId", row.getParam("port").getValue());
        input.setPartValue("isAuto", row.getParam("isAuto").getValue());
        input.setPartValue("policyId", row.getParam("policyId").getValue());
    }

    private void processSetPacketCommand(int neid, RowParams row, ArrayList operationList) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PTN_QOS_SET_APPLYCOSPRIMAP);
        this.buildSetPacketCmd(oper.getInput(), row);
        operationList.add(oper);
    }

    private void buildSetPacketCmd(Input input, RowParams row) {
        input.setPartValue("slotid", row.getParam("slotid").getValue());
        input.setPartValue("subBaordid", row.getParam("subBaordid").getValue());
        input.setPartValue("port", row.getParam("port").getValue());
        input.setPartValue("cosID", row.getParam("cosID").getValue());
        input.setPartValue("cosType", row.getParam("cosType").getValue());
    }

    public String getDetailInfo(RowParams[] rParamsArr) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("ip").append(File.separator).append("ptn").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("foqosmanagement").append(File.separator).append("qosmanagement_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (String)filePath.toString());
        StringBuffer operDesc = new StringBuffer();
        RowParams rowparams = rParamsArr[0];
        String oprationType = rowparams.getParam("oprationType").getValue();
        if ("setQos".equals(oprationType) && rowparams.getParam("oprationFlag") != null) {
            String oprationFlag = rowparams.getParam("oprationFlag").getValue();
            if ("create".equals(oprationFlag)) {
                operDesc.append(res.getString("createPortQos")).append(" ").append(res.getString("port")).append(":").append(this.getPortName(rowparams));
            } else if ("delete".equals(oprationFlag)) {
                operDesc.append(res.getString("deletePortQos")).append(" ").append(res.getString("port")).append(":").append(this.getPortName(rowparams));
            }
        }
        if ("setpacket".equals(oprationType)) {
            operDesc.append(res.getString("setpacket")).append(" ").append(res.getString("port")).append(":").append(this.getPortName(rowparams)).append(",").append(res.getString("cosType")).append(":").append(res.getString("cosType" + rowparams.getParam("cosType").getValue()));
        }
        if ("createqos".equals(oprationType)) {
            operDesc.append(res.getString("createqos")).append(" ").append(res.getString("port")).append(":").append(this.getPortName(rowparams)).append(",").append(res.getString("pir")).append(":").append(rowparams.getParam("pir").getValue()).append(",").append(res.getString("pbs")).append(":").append(rowparams.getParam("pbs").getValue());
        }
        if ("deleteqos".equals(oprationType)) {
            operDesc.append(res.getString("deleteqos")).append(" ").append(res.getString("port")).append(":").append(this.getPortName(rowparams));
        }
        if ("modifyqos".equals(oprationType)) {
            operDesc.append(res.getString("modifyqos")).append(" ").append(res.getString("port")).append(":").append(this.getPortName(rowparams)).append(",").append(res.getString("pir")).append(":").append(rowparams.getParam("pir").getValue()).append(",").append(res.getString("pbs")).append(":").append(rowparams.getParam("pbs").getValue());
        }
        return operDesc.toString();
    }

    public String getPortName(RowParams rowparams) {
        int slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
        int portid = Integer.parseInt(rowparams.getParam("port").getValue());
        int boardType = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid).getBoardType();
        String boardName = TEConfigurationDataMgr.getInstance().getBoardName(this.neid, slotid);
        String portName = TEPortModelConfigurationDataMgr.getInstance().getPortName(this.neid, slotid, boardType, portid);
        return slotid + "-" + boardName + "-" + portName;
    }
}

