/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.foqosmanagement;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ptn.foqosmanagement.TEPortQosTableData;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TESetCosCfgBean
extends TECommonWriteLogBean {
    private static final String NSCMD_CFG_PTN_QOS_SET_POLICY_QUEUE_SCHEDULE = "NSCMD_CFG_PTN_QOS_SET_POLICY_QUEUE_SCHEDULE";
    private static final String NSCMD_CFG_PTN_QOS_SET_WRRSCHEDULE_WEIGHT = "NSCMD_CFG_PTN_QOS_SET_WRRSCHEDULE_WEIGHT";
    private static final String NSCMD_PTN_QOS_SET_POLICY_QUEUE_DROP = "NSCMD_PTN_QOS_SET_POLICY_QUEUE_DROP";
    private static final String NSCMD_PTN_QOS_CRT_POLICY_QUEUE = "NSCMD_PTN_QOS_CRT_POLICY_QUEUE";
    private static final String NSCMD_PTN_QOS_SET_POLICY_QUEUE_BANDWIDTH = "NSCMD_PTN_QOS_SET_POLICY_QUEUE_BANDWIDTH ";
    private static final String NSCMD_PTN_QOS_DEL_POLICY_QUEUE = "NSCMD_PTN_QOS_DEL_POLICY_QUEUE";
    private static final String NSCMD_PTN_QOS_CRT_WRED = "NSCMD_PTN_QOS_CRT_WRED";
    private static final int ROW_COUNT = 8;
    private String[] arrRowDataForType = new String[]{"ROWQUEUETYPE_CS7", "ROWQUEUETYPE_CS6", "ROWQUEUETYPE_EF", "ROWQUEUETYPE_AF4", "ROWQUEUETYPE_AF3", "ROWQUEUETYPE_AF2", "ROWQUEUETYPE_AF1", "ROWQUEUETYPE_BE"};
    private String[] arrRowDataForValue = new String[]{"CS7", "CS6", "EF", "AF4", "AF3", "AF2", "AF1", "BE"};
    private String[] arrSortRowData;
    private Map<String, TEPortQosTableData> portQosDataMap = null;
    private static final String CS7_TYPE = "ROWQUEUETYPE_CS7";
    private static final String CS6_TYPE = "ROWQUEUETYPE_CS6";
    private static final String EF_TYPE = "ROWQUEUETYPE_EF";
    private static final String AF1_TYPE = "ROWQUEUETYPE_AF1";
    private static final String AF2_TYPE = "ROWQUEUETYPE_AF2";
    private static final String AF3_TYPE = "ROWQUEUETYPE_AF3";
    private static final String AF4_TYPE = "ROWQUEUETYPE_AF4";
    private static final String BE_TYPE = "ROWQUEUETYPE_BE";
    private static final String CS7_VALUE = "CS7";
    private static final String CS6_VALUE = "CS6";
    private static final String EF_VALUE = "EF";
    private static final String AF1_VALUE = "AF1";
    private static final String AF2_VALUE = "AF2";
    private static final String AF3_VALUE = "AF3";
    private static final String AF4_VALUE = "AF4";
    private static final String BE_VALUE = "BE";
    private static final String SOLIDUS_TYPE = "/";
    private static final String DEFAULT_0xFFFFFFFF_VALUE = "4294967295";
    private static final String DEFAULT_0xFFFF_VALUE = "65535";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            RowParams[] rows = inputData.getBussinessParams().getRowParams();
            this.operationList = this.getOneRowOperation(neid, subFunc, rows, memeryData);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.initTableRowData();
                this.fillTableRowData();
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (IndexOutOfBoundsException e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    private ArrayList getOneRowOperation(int neid, SubFunc subFunc, RowParams[] rows, Datainterface memeryData) {
        ArrayList operaList = new ArrayList();
        RowParams row = null;
        for (int i = 0; i < rows.length; ++i) {
            row = rows[i];
            String oprationType = row.getParam("oprationType").getValue();
            if (null == oprationType || oprationType.isEmpty()) continue;
            if (oprationType.equals("modifyWRR")) {
                this.processSetwrrCommand(neid, row, operaList);
                continue;
            }
            if (oprationType.equals("modifyWeight")) {
                this.processSetWeightCommand(neid, row, operaList);
                continue;
            }
            if (oprationType.equals("createBW")) {
                this.processCreateBwCommand(neid, row, operaList);
                continue;
            }
            if (oprationType.equals("modifyBW")) {
                this.processModifyBwCommand(neid, row, operaList);
                continue;
            }
            if (oprationType.equals("deleteBW")) {
                this.processDeleteBwCommand(neid, row, operaList);
                continue;
            }
            if (!oprationType.equals("setdrop")) continue;
            this.processSetDropCommand(neid, row, operaList);
        }
        return operaList;
    }

    private String processCrtWdCommand(int neid, RowParams row, ArrayList operaList) {
        Operation opertion = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PTN_QOS_CRT_WRED);
        Input input = opertion.getInput();
        input.setPartValue("wredType", row.getParam("wredType").getValue());
        input.setPartValue("isAuto", row.getParam("isAuto").getValue());
        input.setPartValue("policyId", row.getParam("policyId").getValue());
        input.setPartValue("policyName", row.getParam("policyName").getValue());
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        operationList.add(opertion);
        if (!operationList.isEmpty()) {
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operationList, this.TIME_OUT);
            if (result.retCode != 0) {
                TELogFactory.getNormalLogger().info("getSupportSlotPortList fail!result=" + result.retCode);
                return "";
            }
            return this.parseOperationList(operationList);
        }
        return "";
    }

    private String parseOperationList(List<Operation> operationList) {
        Operation oper = null;
        Output output = null;
        String wredID = "";
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            oper = operationList.get(i);
            if (!oper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
            int lenj = oper.getOutputCount();
            for (int j = 0; j < lenj; ++j) {
                output = oper.getOutput(j);
                wredID = output.getPartValue("policyId");
            }
        }
        return wredID;
    }

    private void processDeleteBwCommand(int neid, RowParams row, ArrayList operaList) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PTN_QOS_DEL_POLICY_QUEUE);
        this.buildDeleteBwCmd(oper.getInput(), row);
        operaList.add(oper);
    }

    private void buildDeleteBwCmd(Input input, RowParams row) {
        input.setPartValue("policyType", row.getParam("policyType").getValue());
        input.setPartValue("policyId_delqueue", row.getParam("policyId_delqueue").getValue());
        input.setPartValue("type_delqueue", row.getParam("type_delqueue").getValue());
    }

    private void processModifyBwCommand(int neid, RowParams row, ArrayList operaList) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PTN_QOS_SET_POLICY_QUEUE_BANDWIDTH);
        this.buildModifyBwCmd(oper.getInput(), row);
        operaList.add(oper);
    }

    private void buildModifyBwCmd(Input input, RowParams row) {
        input.setPartValue("policyType", row.getParam("policyType").getValue());
        input.setPartValue("auto_setqueue", row.getParam("auto_setqueue").getValue());
        input.setPartValue("policyId_setqueue", row.getParam("policyId_setqueue").getValue());
        input.setPartValue("type_setqueue", row.getParam("type_setqueue").getValue());
        input.setPartValue("cir_setqueue", row.getParam("cir_setqueue").getValue());
        input.setPartValue("cbs_setqueue", row.getParam("cbs_setqueue").getValue());
        input.setPartValue("pir_setqueue", row.getParam("pir_setqueue").getValue());
        input.setPartValue("pbs_setqueue", row.getParam("pbs_setqueue").getValue());
    }

    private void processCreateBwCommand(int neid, RowParams row, ArrayList operaList) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PTN_QOS_CRT_POLICY_QUEUE);
        this.buildCreateBwCmd(oper.getInput(), row);
        operaList.add(oper);
    }

    private void buildCreateBwCmd(Input input, RowParams row) {
        input.setPartValue("policyType", row.getParam("policyType").getValue());
        input.setPartValue("auto_crtqueue", row.getParam("auto_crtqueue").getValue());
        input.setPartValue("policyId_crtqueue", row.getParam("policyId_crtqueue").getValue());
        input.setPartValue("type_crtqueue", row.getParam("type_crtqueue").getValue());
        input.setPartValue("cir_crtqueue", row.getParam("cir_crtqueue").getValue());
        input.setPartValue("cbs_crtqueue", row.getParam("cbs_crtqueue").getValue());
        input.setPartValue("pir_crtqueue", row.getParam("pir_crtqueue").getValue());
        input.setPartValue("pbs_crtqueue", row.getParam("pbs_crtqueue").getValue());
    }

    private void processSetDropCommand(int neid, RowParams row, ArrayList operaList) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PTN_QOS_SET_POLICY_QUEUE_DROP);
        this.buildSetDropCmd(oper.getInput(), row);
        operaList.add(oper);
    }

    private void buildSetDropCmd(Input input, RowParams row) {
        input.setPartValue("policyType", row.getParam("policyType").getValue());
        input.setPartValue("auto_setqueue", row.getParam("auto_setqueue").getValue());
        input.setPartValue("policyId_setdrop", row.getParam("policyId_setdrop").getValue());
        input.setPartValue("type_setdrop", row.getParam("type_setdrop").getValue());
        input.setPartValue("dropTail", row.getParam("dropTail").getValue());
        input.setPartValue("auto_setdrop", row.getParam("auto_setdrop").getValue());
        input.setPartValue("dropWred", row.getParam("dropWred").getValue());
    }

    private void processSetWeightCommand(int neid, RowParams row, ArrayList operaList) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_CFG_PTN_QOS_SET_WRRSCHEDULE_WEIGHT);
        this.buildSetWeightCmd(oper.getInput(), row);
        operaList.add(oper);
    }

    private void buildSetWeightCmd(Input input, RowParams row) {
        input.setPartValue("isAuto", row.getParam("isAuto").getValue());
        input.setPartValue("policyId", row.getParam("policyId").getValue());
        input.setPartValue("cs7sweight", row.getParam("cs7sweight").getValue());
        input.setPartValue("cs6sweight", row.getParam("cs6sweight").getValue());
        input.setPartValue("efsweight", row.getParam("efsweight").getValue());
        input.setPartValue("af4sweight", row.getParam("af4sweight").getValue());
        input.setPartValue("af3sweight", row.getParam("af3sweight").getValue());
        input.setPartValue("af2sweight", row.getParam("af2sweight").getValue());
        input.setPartValue("af1sweight", row.getParam("af1sweight").getValue());
        input.setPartValue("besweight", row.getParam("besweight").getValue());
    }

    private void processSetwrrCommand(int neid, RowParams row, ArrayList operaList) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_CFG_PTN_QOS_SET_POLICY_QUEUE_SCHEDULE);
        this.buildSetwrrCmd(oper.getInput(), row);
        operaList.add(oper);
    }

    private void buildSetwrrCmd(Input input, RowParams row) {
        input.setPartValue("policyType", row.getParam("policyType").getValue());
        input.setPartValue("auto", row.getParam("auto").getValue());
        input.setPartValue("policyId", row.getParam("policyId").getValue());
        input.setPartValue("cs7", row.getParam("cs7").getValue());
        input.setPartValue("cs6", row.getParam("cs6").getValue());
        input.setPartValue("ef", row.getParam("ef").getValue());
        input.setPartValue("af1", row.getParam("af1").getValue());
        input.setPartValue("af2", row.getParam("af2").getValue());
        input.setPartValue("af3", row.getParam("af3").getValue());
        input.setPartValue("af4", row.getParam("af4").getValue());
        input.setPartValue("be", row.getParam("be").getValue());
    }

    protected boolean isSingletonLog() {
        return true;
    }

    public String getSinleDetailInfo(RowParams[] rParamsArr) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("ip").append(File.separator).append("ptn").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("foqosmanagement").append(File.separator).append("qosmanagement_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (String)filePath.toString());
        StringBuffer oneRowLog = new StringBuffer();
        for (String queueType : this.arrSortRowData) {
            oneRowLog.append(this.getOneRowLogInfo(res, this.portQosDataMap.get(queueType)));
            oneRowLog.append("\n");
        }
        String result = oneRowLog.toString();
        if (result.endsWith("\n")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private String getOneRowLogInfo(TEResourceUtil res, TEPortQosTableData portQosData) {
        String result;
        StringBuffer strBuf = new StringBuffer();
        if (portQosData.getQueueType() != null) {
            strBuf.append(res.getString("queueType")).append(":");
            strBuf.append(portQosData.getQueueType()).append(",");
        }
        if (portQosData.getWrrId() != -1) {
            strBuf.append(res.getString("wrrId")).append(":");
            strBuf.append(res.getString("wrrId" + portQosData.getWrrId())).append(",");
        }
        if (portQosData.getPolicyRate() != -1) {
            strBuf.append(res.getString("policyRate")).append(":");
            strBuf.append(portQosData.getPolicyRate()).append(",");
        }
        if (portQosData.getCongest() != -1) {
            strBuf.append(res.getString("congest")).append(":");
            strBuf.append(res.getString("congest" + portQosData.getCongest())).append(",");
        }
        if (portQosData.getDropTail() != null) {
            strBuf.append(res.getString("dropTail")).append(":");
            strBuf.append(portQosData.getDropTail()).append(",");
        }
        if (portQosData.getDropWred() != null) {
            strBuf.append(res.getString("dropWred")).append(":");
            strBuf.append(portQosData.getDropWred()).append(",");
        }
        if (portQosData.getBwEnable() != -1) {
            strBuf.append(res.getString("bwEnable")).append(":");
            strBuf.append(res.getString("bwEnable" + portQosData.getBwEnable())).append(",");
        }
        if (portQosData.getPir() != null) {
            strBuf.append(res.getString("pir")).append(":");
            strBuf.append(portQosData.getPir()).append(",");
        }
        if (portQosData.getPbs() != null) {
            strBuf.append(res.getString("pbs")).append(":");
            strBuf.append(portQosData.getPbs());
        }
        if ((result = strBuf.toString()).endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private void initTableRowData() {
        this.portQosDataMap = new HashMap<String, TEPortQosTableData>();
        TEPortQosTableData portQosData = null;
        for (int i = 0; i < 8; ++i) {
            portQosData = new TEPortQosTableData();
            portQosData.setQueueType(this.arrRowDataForValue[i]);
            this.portQosDataMap.put(this.arrRowDataForType[i], portQosData);
        }
    }

    private void fillTableRowData() {
        RowParams[] rows = this.inputData.getBussinessParams().getRowParams();
        RowParams row = null;
        this.arrSortRowData = new String[8];
        for (int i = 0; i < rows.length; ++i) {
            row = rows[i];
            String oprationType = row.getParam("oprationType").getValue();
            if (null == oprationType || oprationType.isEmpty()) continue;
            if (oprationType.equals("modifyWRR")) {
                this.fillWrrCommand(row);
                continue;
            }
            if (oprationType.equals("modifyWeight")) {
                this.fillWeightCommand(row);
                continue;
            }
            if (oprationType.equals("modifyBW")) {
                this.fillModifyBwCommand(row);
                continue;
            }
            if (!oprationType.equals("setdrop")) continue;
            this.fillSetDropCommand(row);
        }
    }

    private void fillSetDropCommand(RowParams row) {
        Param[] params = row.getParam();
        Param param = null;
        String paramName = null;
        int iParamValue = 0;
        TEPortQosTableData portQosData = null;
        for (int i = 0; i < params.length; ++i) {
            param = params[i];
            paramName = param.getName();
            if (!paramName.equals("type_setdrop")) continue;
            try {
                iParamValue = Integer.parseInt(param.getValue());
            }
            catch (Exception e) {
                iParamValue = 1;
            }
            portQosData = this.portQosDataMap.get(this.arrRowDataForType[iParamValue - 1]);
        }
        String paramValue = null;
        for (int i = 0; i < params.length; ++i) {
            param = params[i];
            paramName = param.getName();
            paramValue = param.getValue();
            if (paramName.equals("dropTail")) {
                if (paramValue.equals(DEFAULT_0xFFFF_VALUE)) {
                    paramValue = SOLIDUS_TYPE;
                }
                portQosData.setDropTail(paramValue);
                continue;
            }
            if (!paramName.equals("dropWred")) continue;
            if (paramValue.equals(DEFAULT_0xFFFFFFFF_VALUE)) {
                paramValue = SOLIDUS_TYPE;
            }
            portQosData.setDropWred(paramValue);
        }
    }

    private void fillModifyBwCommand(RowParams row) {
        Param[] params = row.getParam();
        Param param = null;
        String paramName = null;
        int iParamValue = 0;
        TEPortQosTableData portQosData = null;
        for (int i = 0; i < params.length; ++i) {
            param = params[i];
            paramName = param.getName();
            if (!paramName.equals("type_setqueue")) continue;
            try {
                iParamValue = Integer.parseInt(param.getValue());
            }
            catch (Exception e) {
                iParamValue = 1;
            }
            portQosData = this.portQosDataMap.get(this.arrRowDataForType[iParamValue - 1]);
        }
        String paramValue = null;
        for (int i = 0; i < params.length; ++i) {
            param = params[i];
            paramName = param.getName();
            paramValue = param.getValue();
            if (paramName.equals("pir_setqueue")) {
                if (paramValue.equals(DEFAULT_0xFFFFFFFF_VALUE)) {
                    portQosData.setBwEnable(0);
                    paramValue = SOLIDUS_TYPE;
                } else {
                    portQosData.setBwEnable(1);
                }
                portQosData.setPir(paramValue);
                continue;
            }
            if (!paramName.equals("pbs_setqueue")) continue;
            if (paramValue.equals(DEFAULT_0xFFFFFFFF_VALUE)) {
                paramValue = SOLIDUS_TYPE;
            }
            portQosData.setPbs(paramValue);
        }
    }

    private void fillWeightCommand(RowParams row) {
        Param[] params = row.getParam();
        Param param = null;
        String paramName = null;
        int paramValue = -1;
        int rowIndex = -1;
        for (int i = 0; i < params.length; ++i) {
            param = params[i];
            paramName = param.getName();
            try {
                paramValue = Integer.parseInt(param.getValue());
            }
            catch (Exception e) {
                paramValue = 0;
            }
            if (paramName.equals("cs7sweight")) {
                this.arrSortRowData[++rowIndex] = CS7_TYPE;
                this.portQosDataMap.get(CS7_TYPE).setPolicyRate(paramValue);
                continue;
            }
            if (paramName.equals("cs6sweight")) {
                this.arrSortRowData[++rowIndex] = CS6_TYPE;
                this.portQosDataMap.get(CS6_TYPE).setPolicyRate(paramValue);
                continue;
            }
            if (paramName.equals("efsweight")) {
                this.arrSortRowData[++rowIndex] = EF_TYPE;
                this.portQosDataMap.get(EF_TYPE).setPolicyRate(paramValue);
                continue;
            }
            if (paramName.equals("af1sweight")) {
                this.arrSortRowData[++rowIndex] = AF1_TYPE;
                this.portQosDataMap.get(AF1_TYPE).setPolicyRate(paramValue);
                continue;
            }
            if (paramName.equals("af2sweight")) {
                this.arrSortRowData[++rowIndex] = AF2_TYPE;
                this.portQosDataMap.get(AF2_TYPE).setPolicyRate(paramValue);
                continue;
            }
            if (paramName.equals("af3sweight")) {
                this.arrSortRowData[++rowIndex] = AF3_TYPE;
                this.portQosDataMap.get(AF3_TYPE).setPolicyRate(paramValue);
                continue;
            }
            if (paramName.equals("af4sweight")) {
                this.arrSortRowData[++rowIndex] = AF4_TYPE;
                this.portQosDataMap.get(AF4_TYPE).setPolicyRate(paramValue);
                continue;
            }
            if (!paramName.equals("besweight")) continue;
            this.arrSortRowData[++rowIndex] = BE_TYPE;
            this.portQosDataMap.get(BE_TYPE).setPolicyRate(paramValue);
        }
    }

    private void fillWrrCommand(RowParams row) {
        Param[] params = row.getParam();
        Param param = null;
        String paramName = null;
        int paramValue = -1;
        for (int i = 0; i < params.length; ++i) {
            param = params[i];
            paramName = param.getName();
            try {
                paramValue = Integer.parseInt(param.getValue());
            }
            catch (Exception e) {
                paramValue = 0;
            }
            if (paramName.equals("cs7")) {
                this.portQosDataMap.get(CS7_TYPE).setWrrId(paramValue);
                continue;
            }
            if (paramName.equals("cs6")) {
                this.portQosDataMap.get(CS6_TYPE).setWrrId(paramValue);
                continue;
            }
            if (paramName.equals("ef")) {
                this.portQosDataMap.get(EF_TYPE).setWrrId(paramValue);
                continue;
            }
            if (paramName.equals("af1")) {
                this.portQosDataMap.get(AF1_TYPE).setWrrId(paramValue);
                continue;
            }
            if (paramName.equals("af2")) {
                this.portQosDataMap.get(AF2_TYPE).setWrrId(paramValue);
                continue;
            }
            if (paramName.equals("af3")) {
                this.portQosDataMap.get(AF3_TYPE).setWrrId(paramValue);
                continue;
            }
            if (paramName.equals("af4")) {
                this.portQosDataMap.get(AF4_TYPE).setWrrId(paramValue);
                continue;
            }
            if (!paramName.equals("be")) continue;
            this.portQosDataMap.get(BE_TYPE).setWrrId(paramValue);
        }
    }
}

