/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.foqosmanagement;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TEPortModelConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.foqosmanagement.TEPortQos;
import com.huawei.nglct.nemgr.ip.ptn.shaping.TEGetShapingBoardsBean;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TEGetPortQosBean
extends TECommonWriteLogBean {
    private static final String NSCMD_GET_PORTQOSINFO = "NSCMD_CFG_PTN_QOS_GET_PORT_QOSINFO_02";
    private static final String QOS_STATUS_CONFIGURATED = "1";
    private static final String QOS_STATUS_UNCONFIGURATED = "0";
    private static final String BW_BANDWIDTH_ENABLE = "1";
    private static final String BW_BANDWIDTH_DISABLE = "0";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc);
        BussinessParams bussiness = this.outputData.getBussinessParams();
        List<TEPortQos> shappingList = this.getPortShapping();
        RowParams row = null;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() > 0) continue;
            Param slotParam = row.getParam("slotid");
            Param portParam = row.getParam("port");
            if (slotParam == null || slotParam.getValue() == null || portParam == null || portParam.getValue() == null) continue;
            int slotID = Integer.parseInt(slotParam.getValue());
            int portID = Integer.parseInt(portParam.getValue());
            Param portNameParam = row.getParam("portname");
            int boardType = TEConfigurationDataMgr.getInstance().getBoard(neid, slotID).getBoardType();
            portNameParam.setValue(TEPortModelConfigurationDataMgr.getInstance().getPortName(neid, slotID, boardType, portID));
            int size = shappingList.size();
            for (int j = 0; j < size; ++j) {
                TEPortQos portQos = shappingList.get(j);
                if (slotID != portQos.getSlotId() || portID != portQos.getPortId()) continue;
                if (portQos.getPolicyId() == Long.parseLong("4294967295")) {
                    row.addParam("qosConfigStatus", "0");
                    row.addParam("qosstatus", "0");
                } else {
                    row.addParam("qosConfigStatus", "1");
                    row.addParam("qosstatus", "1");
                }
                row.addParam("bandWidth", String.valueOf(0));
                String pir = String.valueOf(portQos.getPir());
                row.addParam("pir", pir);
                String pbs = String.valueOf(portQos.getPbs());
                row.addParam("pbs", pbs);
                if ((pir.equals("4294967295") || pir.equals("")) && (pbs.equals("4294967295") || pbs.equals(""))) {
                    row.addParam("bandWidth", "0");
                    row.addParam("opratetype", "0");
                } else {
                    row.addParam("bandWidth", "1");
                    row.addParam("opratetype", "1");
                }
                row.addParam("policyid", String.valueOf(portQos.getPolicyId()));
            }
        }
    }

    private List<TEPortQos> getPortShapping() {
        Operation opertion = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_GET_PORTQOSINFO);
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = null;
        Vector logBoardList = TENEListMgr.getInstance().getNE(this.neid).getBoardList();
        int len = logBoardList.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)logBoardList.get(i);
            if (!TEGetShapingBoardsBean.isPortPolicySuppBoard(this.neid, board.getSlotID(), board.getBoardType())) continue;
            oper = (Operation)opertion.clone();
            oper.getInput().setPartValue("slotid", String.valueOf(board.getSlotID()));
            operationList.add(oper);
        }
        if (!operationList.isEmpty()) {
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList, this.TIME_OUT);
            if (result.retCode != 0) {
                TELogFactory.getNormalLogger().info("getSupportSlotPortList fail!result=" + result.retCode);
                return null;
            }
            return this.parseOperationList(operationList);
        }
        return null;
    }

    private List<TEPortQos> parseOperationList(List<Operation> operationList) {
        Operation oper = null;
        Output output = null;
        ArrayList<TEPortQos> listResult = new ArrayList<TEPortQos>();
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            oper = operationList.get(i);
            if (!oper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
            int lenj = oper.getOutputCount();
            for (int j = 0; j < lenj; ++j) {
                output = oper.getOutput(j);
                TEPortQos portQos = new TEPortQos(Integer.parseInt(output.getPartValue("slotid")), Integer.parseInt(output.getPartValue("port")), Long.parseLong(output.getPartValue("pir")), Long.parseLong(output.getPartValue("pbs")), Long.parseLong(output.getPartValue("policyid")));
                listResult.add(portQos);
            }
        }
        return listResult;
    }
}

