/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.foqosmanagement;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class TEGetFoDiffservBean
extends TECommonWriteLogBean {
    private static final int SERVICE_LEVEL_COUNT = 16;
    private static final int CVLAN = 1;
    private static final int SVLAN = 2;
    private static final int IP_DSCP = 4;
    private static final int MPLS_EXP = 5;
    private static final String AF12_COSID = "3";
    private static final String AF22_COSID = "6";
    private static final String AF32_COSID = "9";
    private static final String AF42_COSID = "12";
    private static final int OPRATE_SUCCESS = 0;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int i;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (ne.getLogStatus() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)37926));
            return;
        }
        this.outputData.setBussinessParams(new BussinessParams());
        Operation operation = null;
        Output outputTemp = null;
        RowParams rowparams = null;
        Param param = null;
        boolean allSuccess = true;
        boolean allFault = true;
        ArrayList<RowErrors> rowErrorList = new ArrayList<RowErrors>();
        String tempStr = "";
        for (i = 1; i <= 16; ++i) {
            rowparams = new RowParams();
            param = new Param("cvlan", "");
            rowparams.addParam(param);
            param = new Param("svlan", "");
            rowparams.addParam(param);
            param = new Param("ipdscp", "");
            rowparams.addParam(param);
            param = new Param("mplsexp", "");
            rowparams.addParam(param);
            param = new Param("cos", "" + i);
            rowparams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(i - 1, rowparams);
        }
        int len = operationList.size();
        for (int iIndex = 0; iIndex < len; ++iIndex) {
            operation = (Operation)operationList.get(iIndex);
            int size = operation.getOutputCount();
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                outputTemp = operation.getOutput(rowIndex);
                Fault[] faultArr = outputTemp.getFault();
                int code = 0;
                for (Fault fault : faultArr) {
                    code = Integer.parseInt(fault.getCode());
                    if (0 == code) continue;
                    TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)neid, (int)code));
                    allSuccess = false;
                    RowErrors rowError = new RowErrors();
                    Param errorParam = new Param("nename", TENEListMgr.getInstance().getNE(neid).getNEName());
                    rowError.addParam(errorParam);
                    rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)code));
                    rowErrorList.add(rowError);
                    break;
                }
                if (false != code) continue;
                allFault = false;
                int cos = Integer.parseInt(outputTemp.getPartValue("cos"));
                int cosMapType = Integer.parseInt(outputTemp.getPartValue("cosMapType"));
                rowparams = this.outputData.getBussinessParams().getRowParams(cos - 1);
                switch (cosMapType) {
                    case 1: {
                        param = rowparams.getParam("cvlan");
                        break;
                    }
                    case 2: {
                        param = rowparams.getParam("svlan");
                        break;
                    }
                    case 4: {
                        param = rowparams.getParam("ipdscp");
                        break;
                    }
                    case 5: {
                        param = rowparams.getParam("mplsexp");
                        break;
                    }
                    default: {
                        TELogFactory.getNormalLogger().info("TEQueryIngressBean.handleMessage() cosMapType:" + cosMapType + " not in case!");
                    }
                }
                tempStr = param.getValue();
                param.setValue(tempStr + outputTemp.getPartValue("encapsValue") + ",");
            }
        }
        for (i = 0; i < 16; ++i) {
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            param = rowparams.getParam("cvlan");
            param.setValue(this.parseEncapsValueList(param));
            param = rowparams.getParam("svlan");
            param.setValue(this.parseEncapsValueList(param));
            param = rowparams.getParam("ipdscp");
            param.setValue(this.parseEncapsValueList(param));
            param = rowparams.getParam("mplsexp");
            param.setValue(this.parseEncapsValueList(param));
        }
        int size = rowErrorList.size();
        for (i = 0; i < size; ++i) {
            RowParams rParam = new RowParams();
            RowErrors rError = (RowErrors)rowErrorList.get(i);
            rParam.addRowErrors(rError);
            this.outputData.getBussinessParams().addRowParams(rParam);
        }
        this.processErrInfo(neid, allSuccess, allFault);
        if (ne.getNEType() == 92) {
            this.processUnsupportCos();
        }
    }

    private void processErrInfo(int neid, boolean allSuccess, boolean allFault) {
        this.outputData.setErrorMessage(new ErrorMessage());
        if (allSuccess && !allFault) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!allSuccess && allFault) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
    }

    private void processUnsupportCos() {
        RowParams[] rowParas = this.outputData.getBussinessParams().getRowParams();
        for (int i = 0; i < rowParas.length; ++i) {
            String cosIdString;
            Param cosPara = rowParas[i].getParam("cos");
            if (null == cosPara || !AF12_COSID.equals(cosIdString = cosPara.getValue()) && !AF22_COSID.equals(cosIdString) && !AF32_COSID.equals(cosIdString) && !AF42_COSID.equals(cosIdString)) continue;
            this.outputData.getBussinessParams().removeRowParams(i);
            rowParas = this.outputData.getBussinessParams().getRowParams();
            --i;
        }
    }

    private String parseEncapsValueList(Param param) {
        if (param.getValue().equals("")) {
            return "";
        }
        String[] stringArray = param.getValue().split(",");
        int[] intArray = new int[stringArray.length];
        int len = stringArray.length;
        for (int j = 0; j < len; ++j) {
            intArray[j] = Integer.parseInt(stringArray[j]);
        }
        Arrays.sort(intArray);
        ArrayList<String> encapsValue = new ArrayList<String>();
        int len2 = stringArray.length;
        for (int j = 0; j < len2; ++j) {
            encapsValue.add(intArray[j] + "");
        }
        String result = "";
        if (encapsValue.size() >= 2) {
            Iterator it = encapsValue.iterator();
            int curNum = Integer.parseInt((String)it.next());
            int offset = 0;
            StringBuffer temp = new StringBuffer(String.valueOf(curNum));
            int tmpNum = -1;
            while (it.hasNext()) {
                int nextNum = Integer.parseInt((String)it.next());
                if (nextNum != curNum + offset + 1) {
                    if (offset != 0) {
                        tmpNum = curNum + offset;
                        temp.append("-").append(tmpNum);
                        temp.append(",").append(nextNum);
                    } else {
                        temp.append(",").append(nextNum);
                    }
                    offset = 0;
                    curNum = nextNum;
                    continue;
                }
                ++offset;
            }
            if (offset > 0) {
                tmpNum = curNum + offset;
                temp.append("-").append(tmpNum);
            }
            result = temp.toString();
        } else if (encapsValue.size() == 1) {
            result = encapsValue.get(0).toString();
        }
        return result;
    }
}

