/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.vunigroup;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TEQueryVuniGroupInterfaceBean
extends TENEExplorerBean {
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        HashSet<String> serviceIndexs = new HashSet<String>();
        ArrayList<Operation> queryUniList = new ArrayList<Operation>();
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Operation operation = (Operation)operationList.get(i);
            if (!String.valueOf(0).equals(operation.getOutput(0).getFault(0).getCode())) continue;
            int lenj = operation.getOutputCount();
            for (int j = 0; j < lenj; ++j) {
                Output output = operation.getOutput(j);
                String serviceIndex = output.getPartValue("serviceIndex");
                String vuniID = output.getPartValue("vuniID");
                queryUniList.add(this.getQueryVUniOper(serviceIndex, vuniID));
                if (serviceIndexs.contains(serviceIndex)) continue;
                serviceIndexs.add(serviceIndex);
                queryUniList.addAll(this.getQueryServiceOperList(serviceIndex));
            }
        }
        if (!queryUniList.isEmpty()) {
            TENECommMgr.getInstance().sendCommand(neid, queryUniList, this.TIME_OUT);
        }
        operationList.addAll(queryUniList);
        Map<String, String> existServiceMap = this.parseServiceOperList(operationList);
        super.handleMessage(neid, operationList, subfunc);
        int rowLen = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < rowLen; ++i) {
            RowParams row = this.outputData.getBussinessParams().getRowParams(i);
            if (row.getRowErrorsCount() > 0) continue;
            int slotid = Integer.parseInt(row.getParam("slotid").getValue());
            int portid = Integer.parseInt(row.getParam("portid").getValue());
            int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            String serviceIndex = row.getParam("serviceIndex").getValue();
            if (existServiceMap.containsKey(serviceIndex)) {
                row.addParam(new Param("serviceID", existServiceMap.get(serviceIndex)));
            }
            row.addParam(new Param("portname", TEConfigurationDataMgr.getInstance().getPortNameForNARTN(neid, slotid, boardtype, portid)));
        }
    }

    private Map<String, String> parseServiceOperList(List<Operation> queryService) {
        HashMap<String, String> serviceMap = new HashMap<String, String>();
        for (int i = queryService.size() - 1; i >= 0; --i) {
            Operation oper = queryService.get(i);
            Output output = oper.getOutput(0);
            if (!oper.getName().equals("NSCMD_SERVICE_GET_ELINEINFO") && !oper.getName().equals("NSCMD_SERVICE_GET_ELANINFO_EX") && !oper.getName().equals("NSCMD_SERVICE_GET_EAGGRINFO")) continue;
            if (String.valueOf(0).equals(output.getFault(0).getCode())) {
                serviceMap.put(output.getPartValue("serviceIndex"), output.getPartValue("serviceID"));
            }
            queryService.remove(i);
        }
        return serviceMap;
    }

    private Operation getQueryVUniOper(String serviceIndex, String vuniID) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_ETHVUNI_EX");
        oper.getInput().setPartValue("ethType", "0");
        oper.getInput().setPartValue("serviceIndex", serviceIndex);
        oper.getInput().setPartValue("vuniID", vuniID);
        return oper;
    }

    private List<Operation> getQueryServiceOperList(String serviceIndex) {
        ArrayList<Operation> queryServiceList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_ELINEINFO");
        oper.getInput().setPartValue("serviceIndex", serviceIndex);
        queryServiceList.add(oper);
        oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_ELANINFO_EX");
        oper.getInput().setPartValue("serviceIndex", serviceIndex);
        queryServiceList.add(oper);
        oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_EAGGRINFO");
        oper.getInput().setPartValue("serviceIndex", serviceIndex);
        queryServiceList.add(oper);
        return queryServiceList;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodes = new ArrayList<Integer>();
        errorCodes.add(38662);
        errorCodes.add(42322);
        return errorCodes;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

