/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.vunigroup;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TEQueryAvailableResBean
extends TENEExplorerBean {
    private static final String ETH_TYPE_ELINE = "1";
    private static final String ETH_TYPE_ELAN = "2";
    private static final int NMS_SLOT = 65535;
    private static final int NMS_PORT_MIN = 36865;
    private static final int NMS_PORT_MAX = 37119;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        String serviceIndex;
        HashSet<String> serviceIndexs = new HashSet<String>();
        ArrayList<Operation> queryService = new ArrayList<Operation>();
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Operation operation = (Operation)operationList.get(i);
            if (!String.valueOf(0).equals(operation.getOutput(0).getFault(0).getCode())) continue;
            int lenj = operation.getOutputCount();
            for (int j = 0; j < lenj; ++j) {
                Output output = operation.getOutput(j);
                String ethType = output.getPartValue("ethType");
                serviceIndex = output.getPartValue("serviceIndex");
                if (serviceIndexs.contains(serviceIndex)) continue;
                serviceIndexs.add(serviceIndex);
                Operation oper = this.getQueryServiceOperList(serviceIndex, ethType);
                if (oper == null) continue;
                queryService.add(oper);
            }
        }
        if (!queryService.isEmpty()) {
            TENECommMgr.getInstance().sendCommand(neid, queryService, this.TIME_OUT);
        }
        Map<String, String> serviceMap = this.parseServiceOperList(queryService);
        super.handleMessage(neid, operationList, subfunc);
        int rowLen = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = rowLen - 1; i >= 0; --i) {
            RowParams row = this.outputData.getBussinessParams().getRowParams(i);
            if (row.getRowErrorsCount() > 0) continue;
            int slotid = Integer.parseInt(row.getParam("slotid").getValue());
            int portid = Integer.parseInt(row.getParam("portid").getValue());
            if (slotid == 65535 && portid >= 36865 && portid <= 37119) {
                this.outputData.getBussinessParams().removeRowParams(i);
                continue;
            }
            int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            serviceIndex = row.getParam("serviceIndex").getValue();
            if (serviceMap.containsKey(serviceIndex)) {
                row.addParam(new Param("serviceID", serviceMap.get(serviceIndex)));
            }
            row.addParam(new Param("portname", TEConfigurationDataMgr.getInstance().getPortNameForNARTN(neid, slotid, boardtype, portid)));
        }
    }

    private Map<String, String> parseServiceOperList(List<Operation> queryService) {
        HashMap<String, String> serviceMap = new HashMap<String, String>();
        int len = queryService.size();
        for (int i = 0; i < len; ++i) {
            Operation oper = queryService.get(i);
            Output output = oper.getOutput(0);
            if (!String.valueOf(0).equals(output.getFault(0).getCode())) continue;
            serviceMap.put(output.getPartValue("serviceIndex"), output.getPartValue("serviceID"));
        }
        return serviceMap;
    }

    private Operation getQueryServiceOperList(String serviceIndex, String ethType) {
        Operation oper = null;
        if (ethType.equals(ETH_TYPE_ELINE)) {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_ELINEINFO");
            oper.getInput().setPartValue("serviceIndex", serviceIndex);
        } else if (ethType.equals(ETH_TYPE_ELAN)) {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_ELANINFO_EX");
            oper.getInput().setPartValue("serviceIndex", serviceIndex);
        } else {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_EAGGRINFO");
            oper.getInput().setPartValue("serviceIndex", serviceIndex);
        }
        return oper;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodes = new ArrayList<Integer>();
        errorCodes.add(38662);
        return errorCodes;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

