/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.qinqlink;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEGetQinQLinkBean
extends TENEExplorerBean {
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData.setBussinessParams(new BussinessParams());
        boolean isSucc = true;
        Operation operation = (Operation)operationList.get(0);
        int len = operation.getOutputCount();
        for (int i = 0; i < len; ++i) {
            Output output = operation.getOutput(i);
            RowParams newRowParams = new RowParams();
            this.outputData.getBussinessParams().addRowParams(newRowParams);
            int errCode = Integer.parseInt(output.getFault(0).getCode());
            if (errCode != 0) {
                if (errCode == 38662) continue;
                isSucc = false;
                newRowParams.addRowErrors(this.constructRowErrors(errCode));
                continue;
            }
            int slotid = Integer.parseInt(output.getPartValue("slotid"));
            int portid = Integer.parseInt(output.getPartValue("portid"));
            newRowParams.addParam(this.constructParam("linkid", output.getPartValue("linkid")));
            newRowParams.addParam(this.constructParam("slotid", output.getPartValue("slotid")));
            newRowParams.addParam(this.constructParam("boardname", TEConfigurationDataMgr.getInstance().getBoardName(neid, slotid)));
            newRowParams.addParam(this.constructParam("portid", output.getPartValue("portid")));
            newRowParams.addParam(this.constructParam("portname", TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, slotid, portid)));
            newRowParams.addParam(this.constructParam("svlanid", output.getPartValue("svlanid")));
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)(isSucc ? 0 : 2)));
    }

    private Param constructParam(String paramKey, String paramValue) {
        Param param = new Param();
        param.setName(paramKey);
        param.setValue(paramValue);
        return param;
    }

    private RowErrors constructRowErrors(int errorCode) {
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode(String.valueOf(errorCode));
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        rowError.setErrorMessage(errorMessage);
        rowError.addParam(this.constructParam("neid", String.valueOf(this.neid)));
        rowError.addParam(this.constructParam("nename", TENEListMgr.getInstance().getNE(this.neid).getNEName()));
        return rowError;
    }

    public ArrayList getFilterErrorCodeList() {
        if (null == this.subfunc) {
            return new ArrayList();
        }
        return this.subfunc.getFilterErrCodeList();
    }
}

