/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.ethoam;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.mdp.TEFInterfaceUtils;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.f_interface.ptn.oam.ethoam.AsnMAInfo;
import com.huawei.nglct.nemgr.f_interface.ptn.oam.ethoam.AsnMDElementInfo;
import com.huawei.nglct.nemgr.f_interface.ptn.oam.ethoam.AsnMDInfo;
import com.huawei.nglct.nemgr.f_interface.ptn.oam.ethoam.AsnMEPInfo;
import com.huawei.nglct.nemgr.f_interface.ptn.oam.ethoam.AsnMEPInfoList;
import com.huawei.nglct.nemgr.f_interface.ptn.oam.ethoam.AsnMaMepInfo;
import com.huawei.nglct.nemgr.f_interface.ptn.oam.ethoam.AsnQueryMDElementReq;
import com.huawei.nglct.nemgr.f_interface.ptn.oam.ethoam.AsnQueryMDElementRsp;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;

public class TEQueryEthOAMInterBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.ipAddress = ipAddress;
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.user = user;
        RowParams row = inputData.getBussinessParams().getRowParams(0);
        String queryType = row.getParam("queryType").getValue();
        boolean bFromNE = false;
        if (null != row.getParam("isFromNE") && "true".equals(row.getParam("isFromNE").getValue())) {
            bFromNE = true;
        }
        Datainterface output = null;
        if ("MAMEP".equals(queryType)) {
            output = this.queryMAMEPFromNMS(neid, Integer.parseInt(user), bFromNE, inputData);
        } else if ("MA".equals(queryType)) {
            output = this.queryMAFromNMS(neid, Integer.parseInt(user), bFromNE, inputData);
        } else if ("MEP".equals(queryType)) {
            output = this.queryMEPFromNMS(neid, Integer.parseInt(user), bFromNE, inputData);
        }
        return output;
    }

    private Datainterface queryMAMEPFromNMS(int neid, int userid, boolean bFromNE, Datainterface inputData) {
        RowParams row = inputData.getBussinessParams().getRowParams(0);
        long serviceIndex = Long.parseLong(row.getParam("serviceIndex").getValue());
        AsnQueryMDElementRsp mdElementRsp = this.queryMDElementFromNMS(neid, userid, bFromNE);
        Datainterface output = new Datainterface();
        output.setBussinessParams(new BussinessParams());
        int result = 0;
        if (mdElementRsp.result.isSuccess) {
            AsnMDElementInfo mdElement = null;
            AsnMaMepInfo mamep = null;
            BussinessParams bussiness = output.getBussinessParams();
            int len = mdElementRsp.mdElementInfoList.size();
            for (int i = 0; i < len; ++i) {
                mdElement = (AsnMDElementInfo)mdElementRsp.mdElementInfoList.get(i);
                int lenj = mdElement.maMepInfoList.size();
                for (int j = 0; j < lenj; ++j) {
                    mamep = (AsnMaMepInfo)mdElement.maMepInfoList.get(j);
                    if (mamep.maInfo.serviceIndex.longValue() != serviceIndex) continue;
                    this.appendMaMepRowParams(bussiness, mdElement.mdInfo, mamep.maInfo, mamep.mepInfoList);
                }
            }
        } else if (mdElementRsp.result.retCode != null) {
            result = mdElementRsp.result.retCode.intValue();
        }
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        return output;
    }

    private Datainterface queryMAFromNMS(int neid, int userid, boolean bFromNE, Datainterface inputData) {
        RowParams row = inputData.getBussinessParams().getRowParams(0);
        long serviceIndex = Long.parseLong(row.getParam("serviceIndex").getValue());
        AsnQueryMDElementRsp mdElementRsp = this.queryMDElementFromNMS(neid, userid, bFromNE);
        Datainterface output = new Datainterface();
        output.setBussinessParams(new BussinessParams());
        int result = 0;
        if (mdElementRsp.result.isSuccess) {
            AsnMDElementInfo mdElement = null;
            AsnMaMepInfo mamep = null;
            RowParams rowParam = null;
            int len = mdElementRsp.mdElementInfoList.size();
            for (int i = 0; i < len; ++i) {
                mdElement = (AsnMDElementInfo)mdElementRsp.mdElementInfoList.get(i);
                int lenj = mdElement.maMepInfoList.size();
                for (int j = 0; j < lenj; ++j) {
                    mamep = (AsnMaMepInfo)mdElement.maMepInfoList.get(j);
                    if (mamep.maInfo.serviceIndex.longValue() != serviceIndex) continue;
                    rowParam = new RowParams();
                    rowParam.addParam("mdid", mdElement.mdInfo.mdIndex.toString());
                    rowParam.addParam("mdname", new String(mdElement.mdInfo.name));
                    rowParam.addParam("mdlevel", mdElement.mdInfo.mdLevel.toString());
                    rowParam.addParam("maname", new String(mamep.maInfo.name));
                    rowParam.addParam("maid", mamep.maInfo.maIndex.toString());
                    rowParam.addParam("ccperiod", mamep.maInfo.ccPeriod.toString());
                    rowParam.addParam("serviceid", mamep.maInfo.serviceIndex.toString());
                    rowParam.addParam("rmmepnum", mamep.maInfo.rmepNum.toString());
                    output.getBussinessParams().addRowParams(rowParam);
                }
            }
        } else if (mdElementRsp.result.retCode != null) {
            result = mdElementRsp.result.retCode.intValue();
        }
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        return output;
    }

    private Datainterface queryMEPFromNMS(int neid, int userid, boolean bFromNE, Datainterface inputData) {
        RowParams row = inputData.getBussinessParams().getRowParams(0);
        int mdindex = Integer.parseInt(row.getParam("mdid").getValue());
        int maindex = Integer.parseInt(row.getParam("maid").getValue());
        AsnQueryMDElementRsp mdElementRsp = this.queryMDElementFromNMS(neid, userid, bFromNE);
        Datainterface output = new Datainterface();
        output.setBussinessParams(new BussinessParams());
        int result = 0;
        if (mdElementRsp.result.isSuccess) {
            AsnMaMepInfo mamep;
            AsnMDElementInfo mdElement = this.getMDElement(mdElementRsp, mdindex);
            if (null != mdElement && null != (mamep = this.getMaMepInfo(mdElement, maindex))) {
                this.appendMaMepRowParams(output.getBussinessParams(), mdElement.mdInfo, mamep.maInfo, mamep.mepInfoList);
            }
        } else if (mdElementRsp.result.retCode != null) {
            result = mdElementRsp.result.retCode.intValue();
        }
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        return output;
    }

    private void appendMaMepRowParams(BussinessParams bussiness, AsnMDInfo mdinfo, AsnMAInfo mainfo, AsnMEPInfoList meplist) {
        RowParams rowParam = null;
        AsnMEPInfo mepinfo = null;
        int lenj = meplist.size();
        for (int j = 0; j < lenj; ++j) {
            mepinfo = (AsnMEPInfo)meplist.get(j);
            rowParam = this.constructMEPParam(mepinfo);
            rowParam.addParam("maname", new String(mainfo.name));
            rowParam.addParam("mdname", new String(mdinfo.name));
            rowParam.addParam("mdlevel", mdinfo.mdLevel.toString());
            rowParam.addParam("ccperiod", mainfo.ccPeriod.toString());
            bussiness.addRowParams(rowParam);
        }
    }

    private AsnMaMepInfo getMaMepInfo(AsnMDElementInfo mdElement, int maindex) {
        AsnMaMepInfo mamep = null;
        AsnMaMepInfo mamepTemp = null;
        int len = mdElement.maMepInfoList.size();
        for (int i = 0; i < len; ++i) {
            mamepTemp = (AsnMaMepInfo)mdElement.maMepInfoList.get(i);
            if (mamepTemp.maInfo.maIndex.intValue() != maindex) continue;
            mamep = mamepTemp;
            break;
        }
        return mamep;
    }

    private RowParams constructMEPParam(AsnMEPInfo mepinfo) {
        RowParams rowParam = null;
        rowParam = new RowParams();
        rowParam.addParam("mdid", mepinfo.mdIndex.toString());
        rowParam.addParam("maid", mepinfo.maIndex.toString());
        rowParam.addParam("mepid", mepinfo.mepID.toString());
        rowParam.addParam("vid", mepinfo.vlan.toString());
        rowParam.addParam("direction", mepinfo.direction.toString());
        if (null != mepinfo.ccStatus) {
            rowParam.addParam("ccstatus", mepinfo.ccStatus.toString());
        }
        if (null != mepinfo.aisStatus) {
            rowParam.addParam("aisstatus", mepinfo.aisStatus.toString());
        }
        if (null != mepinfo.aisLevel) {
            rowParam.addParam("clientlevel", mepinfo.aisLevel.toString());
        }
        if (null != mepinfo.aisPeriod) {
            rowParam.addParam("aisperiod", mepinfo.aisPeriod.toString());
        }
        rowParam.addParam("porttype", mepinfo.logicPortType.toString());
        rowParam.addParam("niid", mepinfo.logicPortID.toString());
        rowParam.addParam("node", TEFInterfaceUtils.getNodeName((int)this.neid, (int)mepinfo.slotID.intValue(), (int)mepinfo.portID.intValue()));
        return rowParam;
    }

    private AsnMDElementInfo getMDElement(AsnQueryMDElementRsp rsp, int mdid) {
        AsnMDElementInfo mdElement = null;
        AsnMDElementInfo mdElementTemp = null;
        int len = rsp.mdElementInfoList.size();
        for (int i = 0; i < len; ++i) {
            mdElementTemp = (AsnMDElementInfo)rsp.mdElementInfoList.get(i);
            if (mdElementTemp.mdInfo.mdIndex.intValue() != mdid) continue;
            mdElement = mdElementTemp;
            break;
        }
        return mdElement;
    }

    private AsnQueryMDElementRsp queryMDElementFromNMS(int neid, int userid, boolean queryNE) {
        AsnQueryMDElementReq req = new AsnQueryMDElementReq();
        req.neID = BigInteger.valueOf(neid);
        req.userID = BigInteger.valueOf(userid);
        AsnQueryMDElementRsp rsp = new AsnQueryMDElementRsp();
        int cmdcode = queryNE ? 2106289 : 2106288;
        int result = TEFInterfaceUtils.sendCommand((String)this.ipAddress, (int)neid, (FStruct)req, (FStruct)rsp, (int)cmdcode);
        if (result != 0) {
            rsp.result.retCode = BigInteger.valueOf(result);
        }
        return rsp;
    }
}

