/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.ethoam;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.ethoam.TELBOutTime;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.ethoam.TELBResponse;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.ethoam.TELBStat;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;

public class TELBTestProcess {
    private static TELBTestProcess instance = null;
    private List resList = new ArrayList();
    private List outTimeList = new ArrayList();
    private List statList = new ArrayList();
    private int neid;

    public void setNeid(int neid) {
        this.neid = neid;
    }

    private TELBTestProcess() {
    }

    public synchronized List getResData() {
        return this.resList;
    }

    public synchronized List getOutTimeData() {
        return this.outTimeList;
    }

    public synchronized List getStatData() {
        return this.statList;
    }

    public static synchronized TELBTestProcess getInstance(int neid) {
        if (instance == null) {
            instance = new TELBTestProcess();
            instance.setNeid(neid);
            instance.registerListener();
        }
        return instance;
    }

    private void registerListener() {
        TELBTestNoticeHandler LBTestNotice = new TELBTestNoticeHandler();
        try {
            TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)"NSEVT_ETHN_ETHSRVOAM_LBRSP"), (NoticeHandler)LBTestNotice);
            TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)"NSEVT_ETHN_ETHSRVOAM_LBSTATISTIC"), (NoticeHandler)LBTestNotice);
            TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)"NSEVT_ETHN_ETHSRVOAM_LBRSPOVERTIME"), (NoticeHandler)LBTestNotice);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TELBTestProcess registerListener error!", (Throwable)e);
        }
    }

    public void clear() {
        this.resList.clear();
        this.outTimeList.clear();
        this.statList.clear();
    }

    static class TELBTestNoticeHandler
    implements NoticeHandler {
        TELBTestNoticeHandler() {
        }

        public void handleNotice(int cmdkey, int neID, Operation operation) {
            String operName = operation.getName();
            if ("NSEVT_ETHN_ETHSRVOAM_LBRSP".equals(operName)) {
                this.processLBRsp(neID, operation);
            } else if ("NSEVT_ETHN_ETHSRVOAM_LBSTATISTIC".equals(operName)) {
                this.processLBStat(neID, operation);
            } else if ("NSEVT_ETHN_ETHSRVOAM_LBRSPOVERTIME".equals(operName)) {
                this.processLBOutTime(neID, operation);
            }
        }

        private void processLBRsp(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            TELBTestProcess instance = TELBTestProcess.getInstance(neid);
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TELBResponse data = new TELBResponse();
                data.setMdid(Long.valueOf(outputArr[i].getPart("mdid").getValue()));
                data.setMaid(Long.valueOf(outputArr[i].getPart("maid").getValue()));
                data.setMepid(Integer.valueOf(outputArr[i].getPart("mepid").getValue()));
                data.setSinkType(Integer.valueOf(outputArr[i].getPart("sinkmtype").getValue()));
                data.setSinkMac(outputArr[i].getPart("addrr").getValue());
                data.setDelay(Integer.valueOf(outputArr[i].getPart("delay").getValue()));
                instance.getResData().add(data);
            }
        }

        private void processLBOutTime(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            TELBTestProcess instance = TELBTestProcess.getInstance(neid);
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TELBOutTime data = new TELBOutTime();
                data.setMdid(Long.valueOf(outputArr[i].getPart("mdid").getValue()));
                data.setMaid(Long.valueOf(outputArr[i].getPart("maid").getValue()));
                data.setMepid(Integer.valueOf(outputArr[i].getPart("mepid").getValue()));
                instance.getOutTimeData().add(data);
            }
        }

        private void processLBStat(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            TELBTestProcess instance = TELBTestProcess.getInstance(neid);
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TELBStat data = new TELBStat();
                data.setMdid(Long.valueOf(outputArr[i].getPart("mdid").getValue()));
                data.setMaid(Long.valueOf(outputArr[i].getPart("maid").getValue()));
                data.setMepid(Integer.valueOf(outputArr[i].getPart("mepid").getValue()));
                data.setSinkType(Integer.valueOf(outputArr[i].getPart("sinkmtype").getValue()));
                data.setSinkMac(outputArr[i].getPart("addrr").getValue());
                data.setSendNum(Integer.valueOf(outputArr[i].getPart("tsframenum").getValue()));
                data.setRecieveNum(Integer.valueOf(outputArr[i].getPart("rsframenum").getValue()));
                data.setLosRate(Integer.valueOf(outputArr[i].getPart("loserate").getValue()));
                data.setMaxDelay(Integer.valueOf(outputArr[i].getPart("maxDelay").getValue()).intValue());
                data.setMinDelay(Integer.valueOf(outputArr[i].getPart("minDelay").getValue()).intValue());
                data.setCgDelay(Integer.valueOf(outputArr[i].getPart("curDelay").getValue()).intValue());
                instance.getStatData().add(data);
            }
        }
    }
}

