/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.ethoam;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.eline.TELogInfQinq;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.ethoam.TEEthOAMUtils;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.ethoam.TEVUNIPort;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class TEGetCreateMepPortResource
extends TENEExplorerBean {
    private static final int NMS_SLOT = 65535;
    private static final int NMS_PORT_MIN = 36865;
    private static final int NMS_PORT_MAX = 37119;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Map<String, TELogInfQinq> qinqmap = TEEthOAMUtils.getQinqLink(neid);
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.getBussinessParams().clearRowParams();
        int size = operationList.size();
        ArrayList<TEVUNIPort> uniPortList = new ArrayList<TEVUNIPort>();
        for (int i = 0; i < size; ++i) {
            Operation operation = (Operation)operationList.get(i);
            Output[] outputs = operation.getOutput();
            for (int j = 0; j < outputs.length; ++j) {
                if (outputs[j].getFault(0).getCode().equals("0")) {
                    TEVUNIPort uniport;
                    String portName;
                    String boardName;
                    String tag;
                    String value;
                    StringBuilder sb;
                    int portid;
                    int slotid;
                    if (operation.getName().equals("NSCMD_SERVICE_GET_ETHVUNI_EX")) {
                        String vuniid = outputs[j].getPartValue("vuniID");
                        slotid = Integer.valueOf(outputs[j].getPartValue("slotid"));
                        portid = Integer.valueOf(outputs[j].getPartValue("portid"));
                        int tagNum = Integer.valueOf(outputs[j].getPartValue("tagNum"));
                        if (slotid == 65535 && portid >= 36865 && portid <= 37119) continue;
                        sb = new StringBuilder();
                        int tagidlength = 8;
                        value = outputs[j].getPartValue("tagID");
                        int index = 0;
                        for (int k = 0; k < tagNum; ++k) {
                            int vlanid = Integer.parseInt(value.substring(index, index + tagidlength), 16);
                            index += tagidlength;
                            sb.append(vlanid).append(",");
                        }
                        tag = "";
                        if (tagNum != 0) {
                            tag = sb.substring(0, sb.length() - 1);
                        }
                        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                        boardName = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid).getBoardName();
                        portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, slotid, boardType, portid);
                        uniport = new TEVUNIPort();
                        uniport.slotId = slotid;
                        uniport.boardName = boardName;
                        uniport.portId = portid;
                        uniport.portName = portName;
                        uniport.logicinftype = "1";
                        uniport.vuniid = vuniid;
                        uniport.vlan = tag;
                        uniPortList.add(uniport);
                    } else if (operation.getName().equals("NSCMD_SERVICE_GET_EVNNI_EX")) {
                        TELogInfQinq qinq;
                        String carrierType = outputs[j].getPartValue("carrierType");
                        slotid = -1;
                        portid = -1;
                        String vlan = "";
                        String linkid = "";
                        String vnniid = outputs[j].getPartValue("vnniID");
                        if ("3".equals(carrierType)) {
                            slotid = Integer.valueOf(outputs[j].getPartValue("carrierID1"));
                            portid = Integer.valueOf(outputs[j].getPartValue("carrierID3"));
                        } else if ("4".equals(carrierType) && (qinq = qinqmap.get(linkid = outputs[j].getPartValue("carrierID3"))) != null) {
                            slotid = qinq.getSlotid();
                            portid = qinq.getPortid();
                            vlan = String.valueOf(qinq.getSvlanid());
                        }
                        if (slotid != -1 && portid != -1) {
                            if (slotid == 65535 && portid >= 36865 && portid <= 37119) continue;
                            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                            String boardName2 = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid).getBoardName();
                            String portName2 = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, slotid, boardType, portid);
                            TEVUNIPort uniport2 = new TEVUNIPort();
                            uniport2.slotId = slotid;
                            uniport2.boardName = boardName2;
                            uniport2.portId = portid;
                            uniport2.portName = portName2;
                            uniport2.logicinftype = "2";
                            uniport2.vuniid = vnniid;
                            uniport2.vlan = vlan;
                            uniport2.linkid = vlan;
                            uniPortList.add(uniport2);
                        }
                    } else if (operation.getName().equals("NSCMD_CFG_SERVICE_GET_ETHPBVUNI_EX")) {
                        String vuniid = outputs[j].getPartValue("vuniID");
                        int slotId = Integer.valueOf(outputs[j].getPartValue("slotid"));
                        int portId = Integer.valueOf(outputs[j].getPartValue("portid"));
                        int tagNumber = Integer.valueOf(outputs[j].getPartValue("tagNum"));
                        if (slotId == 65535 && portId >= 36865 && portId <= 37119) continue;
                        sb = new StringBuilder();
                        int tagidlength = 8;
                        value = outputs[j].getPartValue("tagID");
                        int index = 0;
                        for (int k = 0; k < tagNumber; ++k) {
                            int vlanid = Integer.parseInt(value.substring(index, index + tagidlength), 16);
                            index += tagidlength;
                            sb.append(vlanid).append(",");
                        }
                        tag = "";
                        if (tagNumber != 0) {
                            tag = sb.substring(0, sb.length() - 1);
                        }
                        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotId);
                        boardName = TEConfigurationDataMgr.getInstance().getBoard(neid, slotId).getBoardName();
                        portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, slotId, boardType, portId);
                        uniport = new TEVUNIPort();
                        uniport.slotId = slotId;
                        uniport.boardName = boardName;
                        uniport.portId = portId;
                        uniport.portName = portName;
                        uniport.logicinftype = "1";
                        uniport.vuniid = vuniid;
                        uniport.vlan = tag;
                        uniPortList.add(uniport);
                    }
                } else {
                    int errorcode = Integer.parseInt(outputs[j].getFault(0).getCode());
                    if (errorcode != 38662) {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errorcode));
                        return;
                    }
                }
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            }
        }
        Comparator<TEVUNIPort> uniCompara = new Comparator<TEVUNIPort>(){

            @Override
            public int compare(TEVUNIPort o1, TEVUNIPort o2) {
                if (o1.slotId == o2.slotId) {
                    return o1.portId - o2.portId;
                }
                return o1.slotId - o2.slotId;
            }
        };
        Collections.sort(uniPortList, uniCompara);
        if (!uniPortList.isEmpty()) {
            for (int i = 0; i < uniPortList.size(); ++i) {
                this.outputData.getBussinessParams().addRowParams(((TEVUNIPort)uniPortList.get(i)).getRowParams());
            }
        }
    }
}

