/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.ethoam;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.mdp.TEFInterfaceUtils;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.f_interface.ptn.oam.ethoam.AsnGetOamLogicPortReq;
import com.huawei.nglct.nemgr.f_interface.ptn.oam.ethoam.AsnGetOamLogicPortRsp;
import com.huawei.nglct.nemgr.f_interface.ptn.oam.ethoam.AsnMASlotInfo;
import com.huawei.nglct.nemgr.f_interface.ptn.oam.ethoam.AsnOamLogicPort;
import com.huawei.nglct.nemgr.f_interface.ptn.oam.ethoam.AsnOamSlotInfo;
import com.huawei.nglct.nemgr.f_interface.ptn.oam.ethoam.AsnOamVlanList;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;

public class TEGetCreateMepPortResInter
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.ipAddress = ipAddress;
        RowParams row = inputData.getBussinessParams().getRowParams(0);
        AsnGetOamLogicPortReq req = new AsnGetOamLogicPortReq();
        req.neID = BigInteger.valueOf(neid);
        req.userID = BigInteger.valueOf(Long.parseLong(user));
        req.serviceIndex = TEFInterfaceUtils.convertParam2BigInt((Param)row.getParam("serviceIndex"));
        AsnGetOamLogicPortRsp rsp = new AsnGetOamLogicPortRsp();
        int result = TEFInterfaceUtils.sendCommand((String)this.ipAddress, (int)neid, (FStruct)req, (FStruct)rsp, (int)2106297);
        Datainterface output = new Datainterface();
        output.setBussinessParams(new BussinessParams());
        if (result == 0) {
            if (rsp.result.isSuccess) {
                if (!rsp.maPortList.isEmpty()) {
                    AsnMASlotInfo maslot = (AsnMASlotInfo)rsp.maPortList.get(0);
                    AsnOamSlotInfo oamslot = null;
                    AsnOamLogicPort oamport = null;
                    RowParams rowParams = null;
                    int len = maslot.maSlotList.size();
                    for (int i = 0; i < len; ++i) {
                        oamslot = (AsnOamSlotInfo)maslot.maSlotList.get(i);
                        int lenj = oamslot.logicPortList.size();
                        for (int j = 0; j < lenj; ++j) {
                            oamport = (AsnOamLogicPort)oamslot.logicPortList.get(j);
                            rowParams = this.convertRowParams(neid, oamport);
                            output.getBussinessParams().addRowParams(rowParams);
                        }
                    }
                }
            } else if (rsp.result.retCode != null) {
                result = rsp.result.retCode.intValue();
            }
        }
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        return output;
    }

    public RowParams convertRowParams(int neid, AsnOamLogicPort port) {
        RowParams rowParams = new RowParams();
        rowParams.addParam("slotid", port.slotID.toString());
        rowParams.addParam("boardname", TEConfigurationDataMgr.getInstance().getBoardName(neid, port.slotID.intValue()));
        int portid = TEConfigurationDataMgr.getPortRelativeID((int)port.portID.intValue());
        rowParams.addParam("portid", String.valueOf(portid));
        rowParams.addParam("port", TEFInterfaceUtils.getNodeName((int)neid, (int)port.slotID.intValue(), (int)portid));
        rowParams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, port.slotID.intValue(), portid));
        rowParams.addParam("logicinftype", port.logicPortType.toString());
        rowParams.addParam("vuniid", port.logicPortID.toString());
        rowParams.addParam("vlan", this.convertVLAN2Str(port.vlanList));
        return rowParams;
    }

    private String convertVLAN2Str(AsnOamVlanList vlanlist) {
        StringBuffer vlansb = new StringBuffer();
        String sp = "";
        int len = vlanlist.size();
        for (int i = 0; i < len; ++i) {
            vlansb.append(sp).append(vlanlist.get(i));
            sp = ",";
        }
        return vlansb.toString();
    }
}

