/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.PortRes;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEBatchOperations;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEOutbackRowProducer;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEUsableResource;
import com.huawei.nglct.nemgr.necommon.rtn.pla.TERtnPlaFilter;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.command.TESMsgUtil;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TEEthUtil {
    private static final String NSCMD_PTN_CFG_GET_RADIO_1J1PG = "NSCMD_PTN_CFG_GET_RADIO_1J1PG";
    public static final long MAX_ETH_INDEX = 0xFFFFFFFEL;
    public static final long MAX_VUNI_ID = 65535L;
    static long ethIndexSeed = 1L;
    static int vuniIDSeed = 0;
    static int vnniIDSeed = 0;
    static int vlanIDSeed = 0;
    public static final String DELETE_OPERATION = "delete";
    public static final String ALTER_OPERATION = "alter";
    public static final String CREATE_OPERATION = "create";
    public static final String RES_FILE_PATH = "ip" + File.separator + "ptn" + File.separator + "res" + File.separator + File.separator + "ethservice" + File.separator + "eline" + File.separator + "elinemgrres_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private static final String ENCAP_TYPE_NULL = "0";
    private static final String ENCAP_TYPE_8021Q = "1";
    private static final String SVC_TAG_TYPE_NULL = "0";
    public static final int TAG_NUM_LIMIT = 127;
    public static final int ETH_SRV_TAG_BYTE_LEN = 512;

    private TEEthUtil() {
    }

    public static long nextEthIndex() {
        if (ethIndexSeed >= 0xFFFFFFFEL) {
            ethIndexSeed = 1L;
        }
        return ethIndexSeed++;
    }

    public static int nextUniID() {
        if ((long)vuniIDSeed >= 65535L) {
            vuniIDSeed = 0;
        }
        if ((long)(vuniIDSeed + 1) == ethIndexSeed && (long)(vuniIDSeed + 1) <= 65535L) {
            ++vuniIDSeed;
        }
        return vuniIDSeed++;
    }

    public static int nextNniID() {
        if ((long)vnniIDSeed >= 65535L) {
            vnniIDSeed = 0;
        }
        if ((long)(vnniIDSeed + 1) == ethIndexSeed && (long)(vnniIDSeed + 1) <= 65535L) {
            ++vnniIDSeed;
        }
        return vnniIDSeed++;
    }

    public static int nextVLanID() {
        if ((long)vlanIDSeed >= 65535L) {
            vlanIDSeed = 0;
        }
        return vlanIDSeed++;
    }

    public static long getRealIndex(Map<Long, Operation> mapping, long tmpIndex) {
        Operation oper = mapping.get(tmpIndex);
        Output output = oper.getOutput(0);
        Part part = output.getPart(0);
        return Long.parseLong(part.getValue());
    }

    public static int getRealID(Map<Integer, Operation> mapping, int tmpIndex) {
        Operation oper = mapping.get(tmpIndex);
        Output output = oper.getOutput(0);
        Part part = output.getPart(0);
        return Integer.parseInt(part.getValue());
    }

    public static List<TEBatchOperations> creatQosSettingOpers(int neID, Datainterface inputData) {
        ArrayList<TEBatchOperations> batches = new ArrayList<TEBatchOperations>();
        BussinessParams businessparams = inputData.getBussinessParams();
        List rows = TESMsgUtil.getParamRows((BussinessParams)businessparams, (String)"NSCMD_PTN_QOS_SET_VUNI_FORWARDTYPE");
        Operation oper1 = TECreateObjectFactory.getOperation((int)neID, (int)32567);
        Operation oper2 = TECreateObjectFactory.getOperation((int)neID, (int)32568);
        int iSize = rows.size();
        for (int i = 0; i < iSize; ++i) {
            RowParams row = (RowParams)rows.get(i);
            List<RowParams> splideds = TEEthUtil.splitQosRow(row, oper1, oper2);
            TEBatchOperations oneTransac = new TEBatchOperations(true);
            int jSize = splideds.size();
            for (int j = 0; j < jSize; ++j) {
                RowParams splided = splideds.get(j);
                Operation oper = TESMsgUtil.createOperation((RowParams)splided, (int)neID, (String)(i % 2 == 0 ? "NSCMD_PTN_QOS_SET_VUNI_FORWARDTYPE" : "NSCMD_PTN_QOS_SET_VUNI_QOSPOLICY"));
                if (oper == null) continue;
                oneTransac.operations.add(oper);
            }
            batches.add(oneTransac);
        }
        return batches;
    }

    public static void filterDynPort(int neid, List<List<RowParams>> ports) {
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        int len = ports.size();
        for (int i = 0; i < len; ++i) {
            List<RowParams> avaiPorts = ports.get(i);
            Iterator<RowParams> iter = avaiPorts.iterator();
            while (iter.hasNext()) {
                RowParams row = iter.next();
                int tmpslotid = Integer.parseInt(row.getParam("slotid").getValue());
                Option[] ops = row.getParam("portid").getOption();
                Option[] opNames = row.getParam("portname").getOption();
                int portCount = ops.length;
                if (tmpslotid == 65535) continue;
                TEBoard tmpBoard = mgr.getBoard(neid, tmpslotid);
                if (mgr.isDynPortBoardType(neid, tmpBoard.getBoardType())) {
                    ArrayList portlist = mgr.getLogicPortList(neid, tmpBoard.getSlotID());
                    for (int k = portCount - 1; k >= 0; --k) {
                        Option tmpOp = ops[k];
                        Option tmpOpName = opNames[k];
                        int tmpPortID = Integer.parseInt(tmpOp.getValue());
                        if (portlist.contains(tmpPortID)) continue;
                        row.getParam("portid").removeOption(tmpOp);
                        row.getParam("portname").removeOption(tmpOpName);
                    }
                }
                if (row.getParam("portid").getOptionCount() != 0) continue;
                iter.remove();
            }
        }
    }

    public static List<RowParams> createBlock(int neID, TEOutbackRowProducer producer, boolean needFlag, Operation oper, Operation ... opers) {
        RowParams row;
        int outCnt = oper.getOutputCount();
        String cmdName = oper.getName();
        ArrayList<RowParams> rows = new ArrayList<RowParams>(outCnt);
        for (int i = 0; i < outCnt; ++i) {
            row = producer.createRow(neID, oper.getOutput(i), opers);
            if (row == null) continue;
            rows.add(row);
        }
        if (needFlag && !rows.isEmpty()) {
            row = (RowParams)rows.get(0);
            Param param = new Param("block", cmdName);
            row.addParam(0, param);
        }
        return rows;
    }

    public static String findPortAttr(Output[] outputs, String slot, String subCard, String portNum) {
        for (int i = 0; i < outputs.length; ++i) {
            if (!String.valueOf(0).equals(outputs[i].getFault(0).getCode()) || !slot.equals(outputs[i].getPart(0).getValue().trim()) || !subCard.equals(outputs[i].getPart(1).getValue().trim()) || !portNum.equals(outputs[i].getPart(2).getValue().trim())) continue;
            return outputs[i].getPart(3).getValue().trim();
        }
        return "";
    }

    public static String findPortAttr(Output[] outputs, String slot, String subCard, String portNum, String attrName) {
        for (int i = 0; i < outputs.length; ++i) {
            if (!String.valueOf(0).equals(outputs[i].getFault(0).getCode()) || !slot.equals(outputs[i].getPart(0).getValue().trim()) || !subCard.equals(outputs[i].getPart(1).getValue().trim()) || !portNum.equals(outputs[i].getPart(2).getValue().trim())) continue;
            return outputs[i].getPartValue(attrName).trim();
        }
        return "";
    }

    public static List<List<RowParams>> splitVUniVNniRows(BussinessParams bp) {
        ArrayList<List<RowParams>> rows = new ArrayList<List<RowParams>>();
        ArrayList<RowParams> vuniRows = new ArrayList<RowParams>();
        ArrayList<RowParams> vnniRows = new ArrayList<RowParams>();
        rows.add(vuniRows);
        rows.add(vnniRows);
        if (bp == null) {
            return rows;
        }
        int count = bp.getRowParamsCount();
        for (int i = 0; i < count; ++i) {
            RowParams row = bp.getRowParams(i);
            Param param = row.getParam(0);
            int vniType = Integer.parseInt(param.getValue().trim());
            if (vniType == 1) {
                vuniRows.add(row);
                continue;
            }
            if (vniType != 2) continue;
            vnniRows.add(row);
        }
        return rows;
    }

    public static List<List<RowParams>> splitDelSetAddRows(List<RowParams> oriRows) {
        ArrayList<List<RowParams>> rows = new ArrayList<List<RowParams>>();
        ArrayList<RowParams> delRows = new ArrayList<RowParams>();
        ArrayList<RowParams> setRows = new ArrayList<RowParams>();
        ArrayList<RowParams> addRows = new ArrayList<RowParams>();
        rows.add(delRows);
        rows.add(setRows);
        rows.add(addRows);
        if (oriRows == null) {
            return rows;
        }
        int size = oriRows.size();
        for (int i = 0; i < size; ++i) {
            RowParams row = oriRows.get(i);
            Param param = row.getParam(1);
            String type = param.getValue().trim();
            if (DELETE_OPERATION.equals(type)) {
                delRows.add(row);
                continue;
            }
            if (ALTER_OPERATION.equals(type)) {
                setRows.add(row);
                continue;
            }
            if (!CREATE_OPERATION.equals(type)) continue;
            addRows.add(row);
        }
        return rows;
    }

    public static boolean addOneParam(RowParams oriRow, RowParams row, String paramName) {
        if (oriRow == null || row == null || paramName == null) {
            return false;
        }
        Param oriParam = oriRow.getParam(paramName);
        Param param = new Param(paramName, oriParam.getValue());
        row.addParam(param);
        return true;
    }

    public static List<Operation> createSetPortAttriOpers(int neID, List<RowParams> rows) {
        int size = rows.size();
        ArrayList<Operation> opers = new ArrayList<Operation>(size);
        for (int i = 0; i < size; ++i) {
            RowParams row = rows.get(i);
            Operation oper = TESMsgUtil.createOperation((RowParams)row, (int)neID, (String)"NSCMD_PTNETH_SET_ENABLE_EX");
            if (oper != null) {
                opers.add(oper);
            }
            if ((oper = TESMsgUtil.createOperation((RowParams)row, (int)neID, (String)"NSCMD_PTNETY_SET_WORKMODE_EX")) != null) {
                opers.add(oper);
            }
            if ((oper = TESMsgUtil.createOperation((RowParams)row, (int)neID, (String)"NSCMD_L2PORTBASE_SET_ENCAPTYPE_EX")) == null) continue;
            opers.add(oper);
            String encapType = oper.getInput().getPart("encapType").getValue();
            if (encapType.equals("0") || (oper = TESMsgUtil.createOperation((RowParams)row, (int)neID, (String)"NSCMD_PTNETH_SET_TAG_EX")) == null) continue;
            opers.add(oper);
            if (!encapType.equals(ENCAP_TYPE_8021Q) || (oper = TESMsgUtil.createOperation((RowParams)row, (int)neID, (String)"NSCMD_PTNETH_SET_DEFVLANID_EX")) == null) continue;
            opers.add(oper);
        }
        return opers;
    }

    public static List<TEUsableResource> getEthPorts(int neID) {
        ArrayList<PortRes> portLists;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        Vector boards = ne.getBoardList();
        ArrayList<TEUsableResource> usables = new ArrayList<TEUsableResource>();
        if (boards == null) {
            return usables;
        }
        TEConfigurationDataMgr dataMgr = TEConfigurationDataMgr.getInstance();
        TEPort port = null;
        int subBdId = 255;
        String subBdName = "";
        int size = boards.size();
        for (int i = 0; i < size; ++i) {
            String portName;
            int portID;
            ArrayList tmpPorts;
            int j;
            TEBoard board = (TEBoard)boards.get(i);
            int slotID = board.getSlotID();
            int bdType = board.getBoardType();
            String bdName = board.getBoardName();
            List subBoards = board.getSubBoardList();
            int subBdCnt = subBoards.size();
            if (subBdCnt > 0) {
                for (j = 0; j < subBdCnt; ++j) {
                    TEUsableResource usableRes;
                    TESubBoard subBoard = (TESubBoard)subBoards.get(j);
                    subBdId = subBoard.getSubSlotID();
                    int subBdType = subBoard.getSubBoardType();
                    tmpPorts = new ArrayList();
                    tmpPorts.addAll(dataMgr.getPortListFromPortType(neID, subBdType, 1799));
                    portLists = new ArrayList(tmpPorts.size());
                    int leng = tmpPorts.size();
                    for (int k = 0; k < leng; ++k) {
                        port = (TEPort)tmpPorts.get(k);
                        portID = port.getPortNo();
                        portName = dataMgr.getPortNameForPTN(neID, slotID, subBdType, portID);
                        PortRes portres = new PortRes(portID, portName);
                        portLists.add(portres);
                    }
                    if (portLists.isEmpty() || usables.contains(usableRes = new TEUsableResource(slotID, bdName, subBdId, subBdName = dataMgr.getBoardTypeName(neID, subBdType), portLists))) continue;
                    usables.add(usableRes);
                }
                continue;
            }
            tmpPorts = TEEthUtil.getPorts(neID, slotID, bdType);
            portLists = new ArrayList(tmpPorts.size());
            int leng = tmpPorts.size();
            for (j = 0; j < leng; ++j) {
                TEUsableResource usableRes;
                portID = (Integer)tmpPorts.get(j);
                portName = dataMgr.getPortNameForPTN(neID, slotID, bdType, portID);
                PortRes portres = new PortRes(portID, portName);
                portLists.add(portres);
                if (portLists.isEmpty() || usables.contains(usableRes = new TEUsableResource(slotID, bdName, subBdId, subBdName, portLists))) continue;
                usables.add(usableRes);
            }
        }
        boolean isSupport = TESpecialAttrMgr.getInstance().isNESupport(neID, "TE_FUNC_MSTP_CFG_ETHER_ELAN", "PTN_ATTR_SUPPORT_NMSPORT");
        if (isSupport) {
            PortRes portres = new PortRes(36865, "");
            portLists = new ArrayList<PortRes>(1);
            portLists.add(portres);
            TEUsableResource usableRes = new TEUsableResource(65535, "NMS-1", 255, "", portLists);
            usables.add(usableRes);
        }
        return usables;
    }

    public static Operation createQueryVniOper(int neID, String qxID) {
        Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)qxID);
        Input input = oper.getInput();
        Part part = input.getPart("ethType");
        part.setValue("0");
        part = input.getPart("serviceIndex");
        part.setValue("0");
        part = "NSCMD_SERVICE_GET_ETHVUNI_EX".equals(qxID) || "NSCMD_CFG_SERVICE_GET_ETHPBVUNI_EX".equals(qxID) ? input.getPart("vuniID") : input.getPart("vnniID");
        part.setValue("0");
        return oper;
    }

    public static Operation createQueryQosPolicyOper(int neID, int type) {
        Operation oper = TECreateObjectFactory.getOperation((int)neID, (int)32544);
        Input input = oper.getInput();
        Part part = input.getPart("policyType");
        part.setValue(Integer.toString(type));
        part = input.getPart("policyScope");
        part.setValue(Integer.toString(type));
        return oper;
    }

    public static List<RowParams> onQueryAlvailableQosPolicy(int neID, int ethType, SubFunc subFunc, Datainterface inputData) {
        ArrayList<Operation> opers = new ArrayList<Operation>(1);
        Operation oper = TEEthUtil.createQueryVniOper(neID, "NSCMD_SERVICE_GET_EVNNI_EX");
        opers.add(oper);
        TECommuNEMgr.getInstance().sendCommand(neID, opers, 50, subFunc);
        int size = oper.getOutputCount();
        ArrayList<RowParams> qoses = new ArrayList<RowParams>(size);
        for (int i = 0; i < size; ++i) {
            Output output = oper.getOutput(i);
            RowParams qos = new RowParams();
            qoses.add(qos);
            Part part = output.getPart("policyType");
            Param param = new Param("policyType", part.getValue());
            qos.addParam(param);
            part = output.getPart("policyScope");
            param = new Param("policyScope", part.getValue());
            qos.addParam(param);
            part = output.getPart("streamShareType");
            param = new Param("streamShareType", part.getValue());
            qos.addParam(param);
            part = output.getPart("wfqID");
            param = new Param("wfqID", part.getValue());
            qos.addParam(param);
            part = output.getPart("policyDesc");
            param = new Param("policyDesc", part.getValue());
            qos.addParam(param);
        }
        return qoses;
    }

    public static List<List<RowParams>> onQueryAlvailablePorts(int neID, int ethType, SubFunc subFunc, Datainterface inputData) {
        Part part;
        Output output;
        int i;
        int size;
        ArrayList<List<RowParams>> filtered = new ArrayList<List<RowParams>>(2);
        ArrayList<TEUsableResource> availables = new ArrayList<TEUsableResource>();
        ArrayList<TEUsableResource> uniAvailables = new ArrayList<TEUsableResource>();
        ArrayList<Operation> opers = new ArrayList<Operation>(3);
        availables.addAll(TEEthUtil.getEthPorts(neID));
        TEEthUtil.removeNmsPort(inputData, neID, availables);
        Operation vuni = TEEthUtil.createQueryVniOper(neID, "NSCMD_SERVICE_GET_ETHVUNI_EX");
        Operation vnni = TEEthUtil.createQueryVniOper(neID, "NSCMD_SERVICE_GET_EVNNI_EX");
        Operation nj1Oper = TECreateObjectFactory.getOperation((int)neID, (String)NSCMD_PTN_CFG_GET_RADIO_1J1PG);
        if (nj1Oper != null) {
            opers.add(nj1Oper);
        }
        opers.add(vuni);
        opers.add(vnni);
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(neID, opers, 50, subFunc);
        if (null != result && result.retCode != 0) {
            filtered.add(new ArrayList(0));
            filtered.add(new ArrayList(0));
            return filtered;
        }
        if (nj1Oper != null) {
            size = nj1Oper.getOutputCount();
            for (i = 0; i < size; ++i) {
                output = nj1Oper.getOutput(i);
                if (!output.getFault(0).getCode().equals(String.valueOf(0))) continue;
                int slot = TEEthUtil.getIntParamValue(output.getPart("protectionSlotId"));
                int subSlot = TEEthUtil.getIntParamValue(output.getPart("protectionSubSlotId"));
                int portNum = TEEthUtil.getIntParamValue(output.getPart("protectionPortId"));
                TEEthUtil.removePort(availables, slot, subSlot, portNum);
            }
        }
        size = vnni.getOutputCount();
        for (i = 0; i < size; ++i) {
            output = vnni.getOutput(i);
            if (!output.getFault(0).getCode().equals(String.valueOf(0))) continue;
            part = output.getPart("role");
            int role = Integer.parseInt(part.getValue());
            part = output.getPart("carrierType");
            int portType = Integer.parseInt(part.getValue());
            if (role == 1 && portType != 3 || role == 2 && portType == 1) continue;
            TEEthUtil.removePort(availables, output);
        }
        int iSize = vuni.getOutputCount();
        for (i = 0; i < iSize; ++i) {
            output = vuni.getOutput(i);
            if (!output.getFault(0).getCode().equals("0")) continue;
            part = output.getPart("tagNum");
            if (Integer.parseInt(part.getValue()) == 0) {
                TEEthUtil.removeVuniPort(availables, output);
            }
            part = output.getPart("ethType");
        }
        TEEthUtil.addPort(uniAvailables, availables);
        TEEthUtil.comparePortList(uniAvailables);
        TEEthUtil.comparePortList(availables);
        List port = TERtnPlaFilter.getInstance().getPLASlaveUsedPortList(neID);
        int len = uniAvailables.size();
        for (int i2 = 0; i2 < len; ++i2) {
            TEUsableResource temp = (TEUsableResource)uniAvailables.get(i2);
            int slotid = temp.getSlotID();
            int subslotid = temp.getSubslotID();
            List portList = temp.getPortLists();
            for (int j = 0; j < portList.size(); ++j) {
                int portId = ((PortRes)portList.get(j)).getPortid();
                if (!TERtnPlaFilter.getInstance().isPortUseable(port, String.valueOf(slotid), String.valueOf(portId))) continue;
                TEEthUtil.removePort(uniAvailables, slotid, subslotid, portId);
            }
        }
        filtered.add(TEEthUtil.convert(uniAvailables));
        filtered.add(TEEthUtil.convert(availables));
        return filtered;
    }

    public static void removeNmsPort(Datainterface inputData, int neID, List<TEUsableResource> availables) {
        boolean isFromElanFunction = false;
        Param param = inputData.getBussinessParams().getRowParams(0).getParam("function_origin");
        if (param != null && "elan".equals(param.getValue())) {
            isFromElanFunction = true;
        }
        boolean containSupportElanSCCBoard = false;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        for (TEBoard bd : ne.getBoardList()) {
            if (bd.getBoardType() != 2546 && bd.getBoardType() != 2994 && bd.getBoardType() != 2995 && bd.getBoardType() != 3058) continue;
            containSupportElanSCCBoard = true;
        }
        if (!(isFromElanFunction && TESpecialAttrMgr.getInstance().isNESupport(neID, "TE_FUNC_MSTP_CFG_ETHER_ELAN", "ETHER_ELAN_NMSPORT_SUPPORT_CREATEVLAN") && containSupportElanSCCBoard)) {
            Iterator<TEUsableResource> iterator = availables.iterator();
            while (iterator.hasNext()) {
                TEUsableResource nextObj = iterator.next();
                if (nextObj.getSlotID() != 65535) continue;
                iterator.remove();
            }
        }
    }

    public static void addPort(List<TEUsableResource> uniAvailables, List<TEUsableResource> availables) {
        ArrayList<TEUsableResource> templist = new ArrayList<TEUsableResource>();
        if (uniAvailables.isEmpty()) {
            templist.addAll(availables);
        }
        int size = uniAvailables.size();
        for (int i = 0; i < size; ++i) {
            TEUsableResource existed = uniAvailables.get(i);
            int len = availables.size();
            for (int j = 0; j < len; ++j) {
                TEUsableResource temp = availables.get(j);
                if (existed.getSlotID() == temp.getSlotID() && existed.getSubslotID() == temp.getSubslotID()) {
                    existed.getPortLists().addAll(temp.getPortLists());
                    continue;
                }
                if (TEEthUtil.isBoardExist(uniAvailables, temp) || TEEthUtil.isBoardExist(templist, temp)) continue;
                templist.add(temp);
            }
        }
        uniAvailables.addAll(templist);
    }

    public static void comparePortList(List<TEUsableResource> reseources) {
        int size = reseources.size();
        for (int i = 0; i < size; ++i) {
            TEUsableResource resource = reseources.get(i);
            Collections.sort(resource.getPortLists());
        }
    }

    public static boolean isBoardExist(List<TEUsableResource> uniAvailables, TEUsableResource resource) {
        int size = uniAvailables.size();
        for (int i = 0; i < size; ++i) {
            TEUsableResource existed = uniAvailables.get(i);
            if (existed.getSlotID() != resource.getSlotID() || existed.getSubslotID() != resource.getSubslotID()) continue;
            return true;
        }
        return false;
    }

    public static List<RowParams> convert(List<TEUsableResource> availables) {
        ArrayList<RowParams> rows = new ArrayList<RowParams>();
        if (availables == null) {
            return rows;
        }
        Collections.sort(availables);
        int size = availables.size();
        for (int i = 0; i < size; ++i) {
            Option option;
            int j;
            int m;
            TEUsableResource available = availables.get(i);
            RowParams row = new RowParams();
            Param param = new Param("slotid", Integer.toString(available.getSlotID()));
            row.addParam(param);
            param = new Param("boardName", available.getBoardName());
            row.addParam(param);
            param = new Param("subslotid", Integer.toString(available.getSubslotID()));
            row.addParam(param);
            param = new Param("subBoardName", available.getSubboardName());
            row.addParam(param);
            List templist = available.getPortLists();
            ArrayList<Integer> portIDs = new ArrayList<Integer>();
            int msize = templist.size();
            for (m = 0; m < msize; ++m) {
                portIDs.add(((PortRes)templist.get(m)).getPortid());
            }
            param = portIDs.isEmpty() ? new Param("portid", "0") : new Param("portid", ((Integer)portIDs.get(0)).toString());
            row.addParam(param);
            int leng = portIDs.size();
            for (j = 0; j < leng; ++j) {
                option = new Option(((Integer)portIDs.get(j)).toString());
                param.addOption(option);
            }
            ArrayList<String> portNames = new ArrayList<String>();
            msize = templist.size();
            for (m = 0; m < msize; ++m) {
                portNames.add(((PortRes)templist.get(m)).getPortNameForPTN());
            }
            param = portNames.isEmpty() ? new Param("portname", "portname") : new Param("portname", portNames.get(0).toString());
            row.addParam(param);
            leng = portNames.size();
            for (j = 0; j < leng; ++j) {
                option = new Option(portNames.get(j).toString());
                param.addOption(option);
            }
            rows.add(row);
        }
        return rows;
    }

    public static TEUsableResource removePort(List<TEUsableResource> availabes, Output output) {
        Part part = output.getPart("carrierID1");
        int slot = Integer.parseInt(part.getValue());
        part = output.getPart("carrierID2");
        int subSlot = Integer.parseInt(part.getValue());
        part = output.getPart("carrierID3");
        int portNum = Integer.parseInt(part.getValue());
        return TEEthUtil.removePort(availabes, slot, subSlot, portNum);
    }

    public static TEUsableResource removeVuniPort(List<TEUsableResource> availabes, Output output) {
        Part part = output.getPart("slotid");
        int slot = Integer.parseInt(part.getValue());
        part = output.getPart("subslotid");
        int subSlot = Integer.parseInt(part.getValue());
        part = output.getPart("portid");
        int portNum = Integer.parseInt(part.getValue());
        return TEEthUtil.removePort(availabes, slot, subSlot, portNum);
    }

    public static TEUsableResource removePort(List<TEUsableResource> availables, int slot, int subSlot, int portNum) {
        TEUsableResource usable = new TEUsableResource(-1, null, -1, null, null);
        if (availables == null) {
            return usable;
        }
        for (int i = availables.size() - 1; i >= 0; --i) {
            List portLists;
            TEUsableResource available = availables.get(i);
            if (available.getSlotID() != slot || available.getSubslotID() != subSlot || (portLists = available.getPortLists()) == null) continue;
            for (int j = portLists.size() - 1; j >= 0; --j) {
                if (portNum != Integer.valueOf(((PortRes)portLists.get(j)).getPortid())) continue;
                ArrayList tempPortLists = new ArrayList();
                tempPortLists.add(portLists.remove(j));
                usable = new TEUsableResource(slot, available.getBoardName(), subSlot, available.getSubboardName(), tempPortLists);
                return usable;
            }
            if (portLists.isEmpty()) {
                availables.remove(i);
            }
            return usable;
        }
        return usable;
    }

    public static List<TEBatchOperations> createQueryPortAttrsOpers(int neID, Operation oper, boolean isVUni) {
        ArrayList<TEBatchOperations> batches = new ArrayList<TEBatchOperations>();
        int count = oper.getOutputCount();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            String portID;
            String subSlot;
            String slot;
            ArrayList<Operation> opers = new ArrayList<Operation>();
            Output out = oper.getOutput(i);
            if (!out.getFault(0).getCode().equals("0")) continue;
            if (isVUni) {
                slot = out.getPart("slotid").getValue();
                subSlot = out.getPart("subslotid").getValue();
                portID = out.getPart("portid").getValue();
                opers.add(TEEthUtil.createQueryPortAttrsOper(neID, "NSCMD_PTNETH_GET_ENABLE_EX", slot, subSlot, portID));
                opers.add(TEEthUtil.createQueryPortAttrsOper(neID, "NSCMD_PTNETY_GET_WORKMODE_EX", slot, subSlot, portID));
                opers.add(TEEthUtil.createQueryPortAttrsOper(neID, "NSCMD_L2PORTBASE_GET_ENCAPTYPE_EX", slot, subSlot, portID));
                opers.add(TEEthUtil.createQueryPortAttrsOper(neID, "NSCMD_PTNETH_GET_TAG_EX", slot, subSlot, portID));
                opers.add(TEEthUtil.createQueryPortAttrsOper(neID, "NSCMD_PTNETH_GET_DEFVLANID_EX", slot, subSlot, portID));
                builder.setLength(0);
                builder.append(slot);
                builder.append(":");
                builder.append(subSlot);
                builder.append(":");
                builder.append(portID);
            } else {
                Part part = out.getPart(4);
                if (Integer.parseInt(part.getValue()) == 3) {
                    slot = out.getPart("carrierID1").getValue();
                    subSlot = out.getPart("carrierID2").getValue();
                    portID = out.getPart("carrierID3").getValue();
                    opers.add(TEEthUtil.createQueryPortAttrsOper(neID, "NSCMD_PTNETH_GET_ENABLE_EX", slot, subSlot, portID));
                    opers.add(TEEthUtil.createQueryPortAttrsOper(neID, "NSCMD_PTNETY_GET_WORKMODE_EX", slot, subSlot, portID));
                    opers.add(TEEthUtil.createQueryPortAttrsOper(neID, "NSCMD_L2PORTBASE_GET_ENCAPTYPE_EX", slot, subSlot, portID));
                    opers.add(TEEthUtil.createQueryPortAttrsOper(neID, "NSCMD_PTNETH_GET_TAG_EX", slot, subSlot, portID));
                    opers.add(TEEthUtil.createQueryPortAttrsOper(neID, "NSCMD_PTNETH_GET_DEFVLANID_EX", slot, subSlot, portID));
                    builder.setLength(0);
                    builder.append(slot);
                    builder.append(":");
                    builder.append(subSlot);
                    builder.append(":");
                    builder.append(portID);
                }
                if (Integer.parseInt(part.getValue()) == 1) {
                    String pwIndex = out.getPart("carrierID3").getValue();
                    opers.add(TEEthUtil.createQueryPwOper(neID, "NSCMD_PTN_MPLS_PW_GET_PW", pwIndex));
                    opers.add(TEEthUtil.createQueryPwOper(neID, "NSCMD_PTN_MPLS_PW_GET_ETH_TPID", pwIndex));
                    opers.add(TEEthUtil.createQueryPwOper(neID, "NSCMD_PTN_QOS_GET_PW_QOSINFO", pwIndex));
                    opers.add(TEEthUtil.createQueryPwOper(neID, "NSCMD_PTN_MPLS_PW_GET_ENABLE", pwIndex));
                    opers.add(TEEthUtil.createQueryPwOper(neID, "NSCMD_PTN_MPLS_PW_GET_EGRESS_TNL", pwIndex));
                    builder.setLength(0);
                    builder.append(pwIndex);
                }
            }
            batches.add(new TEBatchOperations(false, opers, builder.toString()));
        }
        return batches;
    }

    public static List<TEBatchOperations> createQueryPwOpers(int neID, Operation oper, boolean isVUni) {
        ArrayList<TEBatchOperations> batches = new ArrayList<TEBatchOperations>();
        int count = oper.getOutputCount();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            Part part;
            ArrayList<Operation> opers = new ArrayList<Operation>();
            Output out = oper.getOutput(i);
            if (!out.getFault(0).getCode().equals("0") || isVUni || Integer.parseInt((part = out.getPart(4)).getValue()) != 1) continue;
            String pwIndex = out.getPart("carrierID3").getValue();
            opers.add(TEEthUtil.createQueryPwOper(neID, "NSCMD_PTN_MPLS_PW_GET_PW", pwIndex));
            opers.add(TEEthUtil.createQueryPwOper(neID, "NSCMD_PTN_MPLS_PW_GET_ETH_TPID", pwIndex));
            opers.add(TEEthUtil.createQueryPwOper(neID, "NSCMD_PTN_QOS_GET_PW_QOSINFO", pwIndex));
            opers.add(TEEthUtil.createQueryPwOper(neID, "NSCMD_PTN_MPLS_PW_GET_ENABLE", pwIndex));
            opers.add(TEEthUtil.createQueryPwOper(neID, "NSCMD_PTN_MPLS_PW_GET_EGRESS_TNL", pwIndex));
            builder.setLength(0);
            builder.append(pwIndex);
            batches.add(new TEBatchOperations(false, opers, builder.toString()));
        }
        return batches;
    }

    private static Operation createQueryPwOper(int neID, String qxID, String pwIndex) {
        Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)qxID);
        Input input = oper.getInput();
        Part part = input.getPart("pwIndex");
        part.setValue(pwIndex);
        if ("NSCMD_PTN_QOS_GET_PW_QOSINFO".equals(qxID)) {
            part = input.getPart("direction");
            part.setValue("0");
        }
        return oper;
    }

    public static Operation createQueryPortAttrsOper(int neID, String qxID, String slot, String subSlot, String port) {
        Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)qxID);
        Input input = oper.getInput();
        Part part = input.getPart("slotid");
        part.setValue(slot);
        part = input.getPart("subslotid");
        part.setValue(subSlot);
        part = input.getPart("portid");
        if (null == part) {
            part = input.getPart("port");
        }
        part.setValue(port);
        return oper;
    }

    public static TEBatchOperations findBatch(List<TEBatchOperations> batches, String name) {
        if (batches == null || name == null) {
            return null;
        }
        int size = batches.size();
        for (int i = 1; i < size; ++i) {
            TEBatchOperations batch = batches.get(i);
            if (batch.name == null || !name.equals(batch.name)) continue;
            return batch;
        }
        return null;
    }

    private static List<RowParams> splitQosRow(RowParams row, Operation oper1, Operation oper2) {
        ArrayList<RowParams> rows = new ArrayList<RowParams>();
        Param[] params = row.getParam();
        Input input1 = oper1.getInput();
        Input input2 = oper2.getInput();
        int start = 0;
        RowParams row1 = TEEthUtil.createOneRow(input1, params, start);
        RowParams row2 = TEEthUtil.createOneRow(input2, params, start += input1.getPartCount());
        RowParams row3 = TEEthUtil.createOneRow(input1, params, start += input2.getPartCount());
        RowParams row4 = TEEthUtil.createOneRow(input2, params, start += input1.getPartCount());
        if (row1 != null) {
            rows.add(row1);
        }
        if (row2 != null) {
            rows.add(row2);
        }
        if (row3 != null) {
            rows.add(row3);
        }
        if (row4 != null) {
            rows.add(row4);
        }
        return rows;
    }

    private static RowParams createOneRow(Input input, Param[] params, int start) {
        if (start + input.getPartCount() > params.length) {
            return null;
        }
        RowParams tmpRow = new RowParams();
        int size = input.getPartCount();
        for (int i = start; i < size && i >= 0; ++i) {
            tmpRow.addParam(params[i]);
        }
        return tmpRow;
    }

    private static List getPorts(int neID, int slotid, int boardType) {
        TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
        ArrayList portList = new ArrayList();
        portList.addAll(cfgMgr.getPortList(neID, slotid, 1802));
        portList.addAll(cfgMgr.getPortList(neID, slotid, 1799));
        if (TEVirtualPortUtil.isMSOTNBoard((int)neID, (int)slotid)) {
            portList.addAll(cfgMgr.getLogicPortList(neID, slotid, 63213));
        }
        ArrayList<Integer> existPortList = new ArrayList<Integer>();
        int m = portList.size();
        for (int i = 0; i < m; ++i) {
            existPortList.add(((TEPort)portList.get(i)).getPortNo());
        }
        return existPortList;
    }

    public static void addTo(List<TEUsableResource> availables, TEUsableResource available) {
        if (available.getSlotID() != -1) {
            int size = availables.size();
            for (int i = 0; i < size; ++i) {
                TEUsableResource existed = availables.get(i);
                if (existed.getSlotID() != available.getSlotID() || existed.getSubslotID() != available.getSubslotID()) continue;
                existed.getPortLists().addAll(available.getPortLists());
                return;
            }
            availables.add(available);
        }
    }

    public static void removePortTagSetOperation(List<Operation> opers, String svcTagType) {
        if (opers == null || opers.isEmpty() || svcTagType == null || !"0".equals(svcTagType)) {
            return;
        }
        Iterator<Operation> it = opers.iterator();
        while (it.hasNext()) {
            Operation operation = it.next();
            if (!"NSCMD_PTNETH_SET_TAG_EX".equals(operation.getName())) continue;
            it.remove();
        }
    }

    public static String convertVuniTagList(String tagListString) {
        if (tagListString.equals("")) {
            return "00000000";
        }
        StringBuffer tagID = new StringBuffer();
        String orgTagID = tagListString.trim();
        String[] tagIDs = orgTagID.split(",");
        if (tagIDs.length == 1 && tagIDs[0].isEmpty()) {
            tagIDs[0] = "0";
        }
        for (int i = 0; i < tagIDs.length; ++i) {
            int tmpIntId = Integer.parseInt(tagIDs[i]);
            String tmpID = Integer.toHexString(tmpIntId);
            String addstr = "0";
            int len = 8 - tmpID.length();
            for (int j = 1; j < len; ++j) {
                addstr = addstr + "0";
            }
            tagID.append(addstr).append(tmpID);
        }
        return tagID.toString();
    }

    public static String getProtectPwIndexByWorkPwIndex(int neid, String workPwIndex) {
        String protectPwIndex = null;
        ArrayList<Operation> opers = TEEthUtil.createPWAPSPtGpOpers(neid);
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, opers, 20, null);
        boolean isexist = false;
        if (result.retCode == 0) {
            int len = opers.size();
            block0: for (int i = 0; i < len && !isexist; ++i) {
                Operation oper = opers.get(i);
                if (!oper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
                int jlen = oper.getOutputCount();
                for (int j = 0; j < jlen; ++j) {
                    Output output = oper.getOutput(j);
                    if (!workPwIndex.equals(output.getPartValue("workpw"))) continue;
                    protectPwIndex = output.getPartValue("protectpw");
                    isexist = true;
                    continue block0;
                }
            }
        }
        return protectPwIndex;
    }

    private static ArrayList<Operation> createPWAPSPtGpOpers(int neid) {
        Operation apsPairOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PWAPS_GET_APSPAIR");
        Operation pwApsOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PWAPS_GET_APSPG");
        ArrayList<Operation> opers = new ArrayList<Operation>();
        opers.add(apsPairOper);
        opers.add(pwApsOper);
        return opers;
    }

    public static String getApsIDByPwIndex(int neid, String workPwIndex, String protectPwIndex) {
        String apsId = null;
        ArrayList<Operation> opers = TEEthUtil.createPWAPSPtGpOpers(neid);
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, opers, 20, null);
        boolean isexist = false;
        if (result.retCode == 0) {
            int len = opers.size();
            block0: for (int i = 0; i < len && !isexist; ++i) {
                Operation oper = opers.get(i);
                if (!oper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
                int jlen = oper.getOutputCount();
                for (int j = 0; j < jlen; ++j) {
                    Output output = oper.getOutput(j);
                    if (!workPwIndex.equals(output.getPartValue("workpw")) || !protectPwIndex.equals(output.getPartValue("protectpw"))) continue;
                    apsId = output.getPartValue("apsid");
                    isexist = true;
                    continue block0;
                }
            }
        }
        return apsId;
    }

    public static String findPwAttr(Output[] outputs, String pwAttr) {
        for (int i = 0; i < outputs.length; ++i) {
            if (!String.valueOf(0).equals(outputs[i].getFault(0).getCode()) || null == outputs[i].getPart(pwAttr) || !pwAttr.equals(outputs[i].getPart(pwAttr).getName().trim())) continue;
            return outputs[i].getPart(pwAttr).getValue().trim();
        }
        return "-";
    }

    public static String findAttr(Output output, String pwAttr) {
        if (null != output.getPart(pwAttr) && pwAttr.equals(output.getPart(pwAttr).getName().trim())) {
            return output.getPart(pwAttr).getValue().trim();
        }
        return "";
    }

    public static List getExistPorts(int neID, int slotid) {
        try {
            ArrayList<Operation> opers = new ArrayList<Operation>(1);
            Operation oper = TECreateObjectFactory.getOperation((int)neID, (int)28719);
            Input input = oper.getInput();
            Part part = input.getPart("slotid");
            part.setValue(String.valueOf(slotid));
            input.setPartValue("subslotid", Integer.toString(255));
            input.setPartValue("port", "0");
            opers.add(oper);
            ArrayList<Integer> rets = new ArrayList<Integer>();
            if (opers.isEmpty()) {
                return rets;
            }
            int result = TENECommMgr.getInstance().sendCommand((int)neID, opers, (int)10).retCode;
            if (result == 0) {
                Output[] outputs = oper.getOutput();
                int len = outputs.length;
                for (int i = 0; i < len; ++i) {
                    if (!String.valueOf(0).equals(outputs[i].getFault()[0].getCode())) continue;
                    String portId = outputs[i].getPartValue("port");
                    rets.add(Integer.valueOf(portId));
                }
            }
            return rets;
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }

    private static ArrayList buildDispatchVlanFilterOper(int neID, RowParams vlanFilterRow, String qxID) {
        String setCMD = "NSCMD_SERVICE_SET_ETHVUNITAG";
        String addCMD = "NSCMD_SERVICE_ADD_ETHVUNITAG";
        ArrayList<Object> operList = new ArrayList<Object>();
        if (vlanFilterRow == null) {
            return operList;
        }
        int vlanNum = 0;
        String orgVlanID = "";
        if ("NSCMD_SERVICE_SET_ETHVUNITAG".endsWith(qxID)) {
            setCMD = "NSCMD_SERVICE_SET_ETHVUNITAG";
            addCMD = "NSCMD_SERVICE_ADD_ETHVUNITAG";
            vlanNum = Integer.parseInt(vlanFilterRow.getParam("tagNum").getValue());
            orgVlanID = vlanFilterRow.getParam("tagID").getValue().trim();
        } else {
            setCMD = "NSCMD_SERVICE_SET_VLANFILTER";
            addCMD = "NSCMD_SERVICE_ADD_VLANFILTER";
            vlanNum = Integer.parseInt(vlanFilterRow.getParam("vlanNum").getValue());
            orgVlanID = vlanFilterRow.getParam("vlanID").getValue().trim();
        }
        Operation vlanFliterOper = TECreateObjectFactory.getOperation((int)neID, (String)setCMD);
        ArrayList tagIDs = new ArrayList();
        TEStringUtils.strToNumList((String)orgVlanID, tagIDs);
        vlanNum = tagIDs.size();
        int tmpIntId = 0;
        StringBuffer vlanIDBuffer = new StringBuffer();
        for (int i = 0; i < vlanNum; ++i) {
            tmpIntId = (Integer)tagIDs.get(i);
            vlanIDBuffer.append(TEEthUtil.getHexString(tmpIntId, 8));
        }
        String vlanID = vlanIDBuffer.toString();
        Input vlanFliterInput = vlanFliterOper.getInput();
        if (vlanNum <= 127) {
            vlanFliterInput.setPartValue("serviceIndex", vlanFilterRow.getParam("serviceIndex").getValue());
            vlanFliterInput.setPartValue("vuniID", vlanFilterRow.getParam("vuniID").getValue());
            if ("NSCMD_SERVICE_SET_ETHVUNITAG".endsWith(qxID)) {
                vlanFliterInput.setPartValue("tagNum", String.valueOf(vlanNum));
                vlanFliterInput.setPartValue("tagID", vlanID);
            } else {
                vlanFliterInput.setPartValue("vlanNum", String.valueOf(vlanNum));
                vlanFliterInput.setPartValue("vlanID", vlanID);
            }
            operList.add(vlanFliterOper.clone());
            return operList;
        }
        vlanFliterInput.setPartValue("serviceIndex", vlanFilterRow.getParam("serviceIndex").getValue());
        vlanFliterInput.setPartValue("vuniID", vlanFilterRow.getParam("vuniID").getValue());
        if ("NSCMD_SERVICE_SET_ETHVUNITAG".endsWith(qxID)) {
            vlanFliterInput.setPartValue("tagNum", String.valueOf(127));
            vlanFliterInput.setPartValue("tagID", TEEthUtil.getSplitVlanFilter(vlanID, 0, 127));
        } else {
            vlanFliterInput.setPartValue("vlanNum", String.valueOf(127));
            vlanFliterInput.setPartValue("vlanID", TEEthUtil.getSplitVlanFilter(vlanID, 0, 127));
        }
        operList.add(vlanFliterOper.clone());
        int count = 1;
        vlanFliterOper = TECreateObjectFactory.getOperation((int)neID, (String)addCMD);
        vlanFliterInput = vlanFliterOper.getInput();
        while (vlanNum > 127 * count) {
            vlanFliterInput.setPartValue("serviceIndex", vlanFilterRow.getParam("serviceIndex").getValue());
            vlanFliterInput.setPartValue("vuniID", vlanFilterRow.getParam("vuniID").getValue());
            if (vlanNum > 127 * (count + 1)) {
                if ("NSCMD_SERVICE_SET_ETHVUNITAG".endsWith(qxID)) {
                    vlanFliterOper.getInput().setPartValue("tagNum", String.valueOf(127));
                    vlanFliterOper.getInput().setPartValue("tagID", TEEthUtil.getSplitVlanFilter(vlanID, 127 * count, 127));
                } else {
                    vlanFliterOper.getInput().setPartValue("vlanNum", String.valueOf(127));
                    vlanFliterOper.getInput().setPartValue("vlanID", TEEthUtil.getSplitVlanFilter(vlanID, 127 * count, 127));
                }
                operList.add(vlanFliterOper.clone());
            } else {
                if ("NSCMD_SERVICE_SET_ETHVUNITAG".endsWith(qxID)) {
                    vlanFliterOper.getInput().setPartValue("tagNum", String.valueOf(vlanNum - 127 * count));
                    vlanFliterOper.getInput().setPartValue("tagID", TEEthUtil.getSplitVlanFilter(vlanID, 127 * count, vlanNum - 127 * count));
                } else {
                    vlanFliterOper.getInput().setPartValue("vlanNum", String.valueOf(vlanNum - 127 * count));
                    vlanFliterOper.getInput().setPartValue("vlanID", TEEthUtil.getSplitVlanFilter(vlanID, 127 * count, vlanNum - 127 * count));
                }
                operList.add(vlanFliterOper.clone());
            }
            ++count;
        }
        return operList;
    }

    public static String getLimitNumTagStr(List<Integer> tagIDs, int numLimit) {
        StringBuffer vlanIDBuffer = new StringBuffer();
        int tmpIntId = 0;
        for (int i = 0; i < numLimit; ++i) {
            tmpIntId = tagIDs.get(i);
            vlanIDBuffer.append(TEEthUtil.getHexString(tmpIntId, 8));
        }
        String vlanID = vlanIDBuffer.toString();
        return TEEthUtil.getSplitVlanFilter(vlanID, 0, numLimit);
    }

    public static String getSplitVlanFilter(String valn, int startPos, int lenth) {
        return valn.substring(startPos * 8, (startPos + lenth) * 8);
    }

    public static int setVlanFilter(int neID, List<RowParams> vlanFilterRowList) {
        int retCode = 0;
        ArrayList<Object> operList = new ArrayList<Object>();
        int m = vlanFilterRowList.size();
        for (int i = 0; i < m; ++i) {
            RowParams rowParams = vlanFilterRowList.get(i);
            ArrayList oneRowOperList = TEEthUtil.buildVlanFilterTagOper(neID, rowParams, "NSCMD_SERVICE_SET_VLANFILTER");
            operList.addAll(oneRowOperList);
        }
        int timeout = 50;
        if (operList.size() > 20 && operList.size() < 30) {
            timeout = 90;
        } else if (operList.size() > 30) {
            timeout = 120;
        }
        if (null != operList && !operList.isEmpty()) {
            Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_CFG_TRANSACTION_BEGIN");
            operList.add(0, oper.clone());
            oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_CFG_TRANSACTION_END");
            operList.add(oper.clone());
            OperationResult result = TENECommMgr.getInstance().sendCommand(neID, operList, null, timeout, false);
            if (null != result && result.retCode != 0) {
                retCode = result.retCode;
                return retCode;
            }
            Operation lastOper = (Operation)operList.get(operList.size() - 1);
            for (Output output : lastOper.getOutput()) {
                for (Fault fault : output.getFault()) {
                    String code = fault.getCode();
                    if (Integer.parseInt(code) == 0) continue;
                    retCode = Integer.parseInt(code);
                    return retCode;
                }
            }
        }
        return retCode;
    }

    public static int setVlanTag(int neID, List<RowParams> vlanTagRowList) {
        int retCode = 0;
        ArrayList<Object> operList = new ArrayList<Object>();
        int m = vlanTagRowList.size();
        for (int i = 0; i < m; ++i) {
            RowParams rowParams = vlanTagRowList.get(i);
            ArrayList oneRowOperList = TEEthUtil.buildVlanFilterTagOper(neID, rowParams, "NSCMD_SERVICE_SET_ETHVUNITAG");
            operList.addAll(oneRowOperList);
        }
        int timeout = 50;
        if (operList.size() > 20 && operList.size() < 30) {
            timeout = 90;
        } else if (operList.size() > 30) {
            timeout = 120;
        }
        if (null != operList && !operList.isEmpty()) {
            Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_CFG_TRANSACTION_BEGIN");
            operList.add(0, oper.clone());
            oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_CFG_TRANSACTION_END");
            operList.add(oper.clone());
            OperationResult result = TENECommMgr.getInstance().sendCommand(neID, operList, null, timeout, false);
            if (null != result && result.retCode != 0) {
                retCode = result.retCode;
                return retCode;
            }
            Operation lastOper = (Operation)operList.get(operList.size() - 1);
            for (Output output : lastOper.getOutput()) {
                for (Fault fault : output.getFault()) {
                    String code = fault.getCode();
                    if (Integer.parseInt(code) == 0) continue;
                    retCode = Integer.parseInt(code);
                    return retCode;
                }
            }
        }
        return retCode;
    }

    public static ArrayList buildVlanFilterTagOper(int neID, RowParams vlanFilterRow, String qxID) {
        if (TEEthUtil.isSupportCmdWithBit(neID)) {
            return TEEthUtil.buildVlanFilterOperWithBit(neID, vlanFilterRow, qxID);
        }
        return TEEthUtil.buildDispatchVlanFilterOper(neID, vlanFilterRow, qxID);
    }

    public static boolean isSupportCmdWithBit(int neID) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        int neType = ne.getNEType();
        int ulVersion = TEConvertUtil.convertVerStrToInt((String)ne.getHostVersion());
        if ((76 == neType || 77 == neType) && ulVersion >= TEConvertUtil.neVersion((int)5, (int)76, (int)5, (int)20)) {
            return true;
        }
        if (83 == neType && ulVersion >= TEConvertUtil.neVersion((int)5, (int)83, (int)5, (int)20)) {
            return true;
        }
        if (92 == neType && ulVersion >= TEConvertUtil.neVersion((int)5, (int)92, (int)1, (int)10)) {
            return true;
        }
        if (115 == neType && ulVersion >= TEConvertUtil.neVersion((int)5, (int)115, (int)1, (int)10)) {
            return true;
        }
        if (95 == neType && ulVersion >= TEConvertUtil.neVersion((int)5, (int)95, (int)5, (int)20)) {
            return true;
        }
        return 114 == neType && ulVersion >= TEConvertUtil.neVersion((int)5, (int)114, (int)5, (int)20);
    }

    public static String getUniTagWithBit(String tagValue) {
        BitSet vlanSet = new BitSet(4096);
        if (tagValue == null || tagValue.isEmpty()) {
            StringBuffer defaultBuffer = new StringBuffer();
            for (int i = 0; i < 512; ++i) {
                defaultBuffer.append("00");
            }
            return defaultBuffer.toString();
        }
        StringBuffer bitTagBuffer = new StringBuffer();
        ArrayList tagIDs = new ArrayList();
        TEStringUtils.strToNumList((String)tagValue, tagIDs);
        int tagNums = tagIDs.size();
        int tmpIntId = 0;
        for (int k = 0; k < tagNums; ++k) {
            tmpIntId = (Integer)tagIDs.get(k);
            vlanSet.set(tmpIntId - 1, true);
        }
        for (int i = 0; i < 512; ++i) {
            int byteValue = 0;
            for (int j = 0; j < 8; ++j) {
                byteValue += (vlanSet.get(8 * i + j) ? 1 : 0) << 7 - j;
            }
            String tmpID = TEEthUtil.getHexString(byteValue, 2);
            bitTagBuffer.append(tmpID);
        }
        return bitTagBuffer.toString();
    }

    public static String getHexString(int intValue, int paddingLen) {
        String tmpID = Integer.toHexString(intValue);
        StringBuffer tagbuffer = new StringBuffer();
        String paddingdstr = "0";
        int len = paddingLen - tmpID.length();
        for (int j = 0; j < len; ++j) {
            tagbuffer.append(paddingdstr);
        }
        tagbuffer.append(tmpID);
        return tagbuffer.toString();
    }

    private static ArrayList buildVlanFilterOperWithBit(int neID, RowParams vlanFilterRow, String qxID) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        if (vlanFilterRow == null) {
            return operList;
        }
        String setCMD = "NSCMD_SERVICE_SET_ETHVUNITAG_EXT";
        setCMD = "NSCMD_SERVICE_SET_ETHVUNITAG".endsWith(qxID) ? "NSCMD_SERVICE_SET_ETHVUNITAG_EXT" : "NSCMD_SERVICE_SET_VLANFILTER_EXT";
        Operation vlanFliterOper = TECreateObjectFactory.getOperation((int)neID, (String)setCMD);
        Input vlanFliterInput = vlanFliterOper.getInput();
        vlanFliterInput.setPartValue("serviceIndex", vlanFilterRow.getParam("serviceIndex").getValue());
        vlanFliterInput.setPartValue("vuniID", vlanFilterRow.getParam("vuniID").getValue());
        if ("NSCMD_SERVICE_SET_ETHVUNITAG".endsWith(qxID)) {
            String vlanID = vlanFilterRow.getParam("tagID").getValue();
            ArrayList tagIDs = new ArrayList();
            TEStringUtils.strToNumList((String)vlanID, tagIDs);
            vlanFliterInput.setPartValue("tagNum", String.valueOf(tagIDs.size()));
            vlanFliterInput.setPartValue("tagID", TEEthUtil.getUniTagWithBit(vlanID));
        } else {
            String vlanID = vlanFilterRow.getParam("vlanID").getValue();
            ArrayList tagIDs = new ArrayList();
            TEStringUtils.strToNumList((String)vlanID, tagIDs);
            vlanFliterInput.setPartValue("vlanNum", String.valueOf(tagIDs.size()));
            vlanFliterInput.setPartValue("vlanID", TEEthUtil.getUniTagWithBit(vlanID));
        }
        operList.add(vlanFliterOper);
        return operList;
    }

    public static int getIntParamValue(Part param) {
        int result = -1;
        if (null != param && null != param.getValue() && !param.getValue().isEmpty()) {
            result = Integer.parseInt(param.getValue());
        }
        return result;
    }
}

