/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.eaggr.TEEAggrUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.List;

public class TEEthPWUtil {
    public static final int TIME_OUT = 60;
    private static final String PROTECT_PAIRS = "2";

    private TEEthPWUtil() {
    }

    public static int createPWPairProtectGroup(RowParams protectGroupParams, int neid, List<String> pwIndexList, boolean isMgr) {
        Operation apsPairOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PWAPS_ADD_APSPAIR");
        apsPairOper.getInput().setPartValue("autoassign", "0");
        apsPairOper.getInput().setPartValue("apsid", protectGroupParams.getParam("apsid").getValue());
        apsPairOper.getInput().setPartValue("workpw", pwIndexList.get(0));
        apsPairOper.getInput().setPartValue("protectpw", pwIndexList.get(1));
        apsPairOper.getInput().setPartValue("extendargs", "0000");
        ArrayList<Operation> operList = new ArrayList<Operation>();
        operList.add(apsPairOper);
        int retCode = TENECommMgr.getInstance().sendCommand((int)neid, operList, null, (int)60, (boolean)false).retCode;
        if (0 != retCode) {
            return retCode;
        }
        for (Operation oper : operList) {
            int size = oper.getOutputCount();
            for (int row = 0; row < size; ++row) {
                int result = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
                if (0 == result) continue;
                if (!isMgr) {
                    TEEthPWUtil.setPWOAMDisable(neid, pwIndexList.get(0));
                    pwIndexList.remove(0);
                }
                TEEAggrUtil.batchDelPW(neid, pwIndexList);
                return result;
            }
        }
        return 0;
    }

    public static int createAPSProtectGroup(RowParams protectGroupParams, int neid, List<String> pwIndexList, boolean isMgr) {
        if (protectGroupParams == null) {
            return 0;
        }
        if (null != protectGroupParams.getParam("protype") && protectGroupParams.getParam("protype").getValue().equals(PROTECT_PAIRS)) {
            return TEEthPWUtil.createPWPairProtectGroup(protectGroupParams, neid, pwIndexList, isMgr);
        }
        ArrayList<Object> operList = new ArrayList<Object>();
        protectGroupParams.addParam("workpw", pwIndexList.get(0));
        protectGroupParams.addParam("protectpw", pwIndexList.get(1));
        Operation addAPSPGOper1 = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PWAPS_ADD_APSPG");
        operList.add(addAPSPGOper1.clone());
        Operation setSwitchModeOper1 = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PWAPS_SET_SWMOODE");
        operList.add(setSwitchModeOper1.clone());
        Operation setREvertiveModeOper1 = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PWAPS_SET_RVTMOODE");
        operList.add(setREvertiveModeOper1.clone());
        Operation setREvertiveTimeOper1 = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PWAPS_SET_WTRTIME");
        operList.add(setREvertiveTimeOper1.clone());
        Operation setHoldoffOper1 = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PWAPS_SET_HOLDOFFTIME");
        operList.add(setHoldoffOper1.clone());
        Operation apsProtocolOper1 = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PWAPS_SET_APSEN");
        operList.add(apsProtocolOper1.clone());
        int iSize = operList.size();
        for (int i = 0; i < iSize; ++i) {
            Operation operation = (Operation)operList.get(i);
            Input input = operation.getInput();
            int partlen = input.getPartCount();
            for (int part = 0; part < partlen; ++part) {
                Param para = protectGroupParams.getParam(input.getPart(part).getName());
                if (para == null || input.getPart(part) == null) continue;
                input.getPart(part).setValue(para.getValue());
            }
        }
        TEEAggrUtil.addTransaction(neid, operList);
        int retCode = TENECommMgr.getInstance().sendCommand((int)neid, operList, null, (int)60, (boolean)false).retCode;
        if (0 != retCode) {
            return retCode;
        }
        for (Operation operation : operList) {
            int size = operation.getOutputCount();
            for (int row = 0; row < size; ++row) {
                int result = Integer.valueOf(operation.getOutput(0).getFault(0).getCode());
                if (0 == result) continue;
                if (!isMgr) {
                    TEEthPWUtil.setPWOAMDisable(neid, pwIndexList.get(0));
                    pwIndexList.remove(0);
                }
                TEEAggrUtil.batchDelPW(neid, pwIndexList);
                return result;
            }
        }
        return retCode;
    }

    public static void setPWOAMDisable(int neid, String pwIndex) {
        ArrayList<Object> operList = new ArrayList<Object>();
        Operation setPWOAMOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PWOAM_SET_ENABLE");
        operList.add(setPWOAMOper.clone());
        Input input = setPWOAMOper.getInput();
        input.setPartValue("unknown", "0");
        input.setPartValue("pwindex", pwIndex);
        input.setPartValue("enablestate", "0");
        TENECommMgr.getInstance().sendCommand(neid, operList, null, 60, false);
    }
}

