/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.eline_u2kv1r3c00;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEBatchOperations;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;

public class TEEthUtil {
    private TEEthUtil() {
    }

    public static List<TEBatchOperations> createQueryPortAttrsOpers(int neID, Operation oper, boolean isVUni) {
        ArrayList<TEBatchOperations> batches = new ArrayList<TEBatchOperations>();
        int count = oper.getOutputCount();
        StringBuilder strBuilder = new StringBuilder();
        String slot = "0";
        String subSlot = "0";
        String portID = "0";
        for (int i = 0; i < count; ++i) {
            ArrayList<Operation> operations = new ArrayList<Operation>();
            Output out = oper.getOutput(i);
            if (!out.getFault(0).getCode().equals("0")) continue;
            if (isVUni) {
                slot = out.getPart("slotid").getValue();
                subSlot = out.getPart("subslotid").getValue();
                portID = out.getPart("portid").getValue();
                operations.addAll(TEEthUtil.queryPortInfo(neID, slot, subSlot, portID));
            } else {
                Part part = out.getPart("carrierType");
                if (null == part) continue;
                int carryType = Integer.parseInt(part.getValue());
                if (3 == carryType) {
                    slot = out.getPart("carrierID1").getValue();
                    subSlot = out.getPart("carrierID2").getValue();
                    portID = out.getPart("carrierID3").getValue();
                    operations.addAll(TEEthUtil.queryPortInfo(neID, slot, subSlot, portID));
                } else if (1 == carryType) {
                    portID = out.getPart("carrierID3").getValue();
                    operations.addAll(TEEthUtil.queryPWInfo(portID, neID));
                }
            }
            operations.add(TEEthUtil.createQueryPortAttrsOper(neID, "NSCMD_PTNETH_GET_DEFVLANID_EX", slot, subSlot, portID));
            strBuilder.setLength(0);
            strBuilder.append(slot);
            strBuilder.append(":");
            strBuilder.append(subSlot);
            strBuilder.append(":");
            strBuilder.append(portID);
            batches.add(new TEBatchOperations(false, operations, strBuilder.toString()));
        }
        return batches;
    }

    public static Operation createQueryPortAttrsOper(int neID, String qxID, String slot, String subSlot, String port) {
        Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)qxID);
        Input input = oper.getInput();
        Part part = input.getPart("slotid");
        part.setValue(slot);
        part = input.getPart("subslotid");
        part.setValue(subSlot);
        part = input.getPart("portid");
        if (null == part) {
            part = input.getPart("port");
        }
        part.setValue(port);
        return oper;
    }

    private static List<Operation> queryPortInfo(int neid, String slot, String subSlot, String portID) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        operList.add(TEEthUtil.createQueryPortAttrsOper(neid, "NSCMD_PTNETH_GET_ENABLE_EX", slot, subSlot, portID));
        operList.add(TEEthUtil.createQueryPortAttrsOper(neid, "NSCMD_PTNETY_GET_WORKMODE_EX", slot, subSlot, portID));
        operList.add(TEEthUtil.createQueryPortAttrsOper(neid, "NSCMD_L2PORTBASE_GET_ENCAPTYPE_EX", slot, subSlot, portID));
        operList.add(TEEthUtil.createQueryPortAttrsOper(neid, "NSCMD_PTNETH_GET_TAG_EX", slot, subSlot, portID));
        return operList;
    }

    public static List<Operation> queryPWInfo(String pwIndex, int neid) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        if (null == pwIndex || "".equals(pwIndex)) {
            return operList;
        }
        Operation oper = (Operation)TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_PW").clone();
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        oper = (Operation)TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_CW").clone();
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        oper = (Operation)TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_VCCV").clone();
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        oper = (Operation)TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_STATE").clone();
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        oper = (Operation)TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_ENABLE").clone();
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        oper = (Operation)TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_ETH_TPID").clone();
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        oper = (Operation)TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_ETH_REQVLAN").clone();
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        oper = (Operation)TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_EGRESS_TNL").clone();
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        oper = (Operation)TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PWOAM_GET_ENABLE").clone();
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        oper = (Operation)TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PWOAM_GET_OAMATTR").clone();
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        return operList;
    }
}

