/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.eline_u2kv1r2c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallCPPortRecord;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TEGetResParaBean
extends TENEExplorerBean {
    private static final String INVALID_ATTRI = "/";
    private static final String REGMENT = " ";
    private static final String SDHPORT_ATTR_MODE = "SDHPORT_ATTR_MODE";
    private static final String ATTR_ETHOVERPTN_MAC_ENCAP_TYPE = "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE";
    private static final int MINIMALPARAMCOUNT = 9;
    public static final long INVALID_IP = 0xFFFFFFFFL;
    public static final int IPTYPE_UNSET = 255;
    public static final int BORROWEDIP = 65535;

    protected void modifyInputParams() {
        BussinessParams bussinessParams = this.inputData.getBussinessParams();
        Iterator iterator = bussinessParams.getRowParamList().iterator();
        ArrayList<RowParams> tobeAddList = new ArrayList<RowParams>();
        while (iterator.hasNext()) {
            RowParams row = (RowParams)iterator.next();
            if (null != row.getParam("port") && null != row.getParam("port").getValue() && !row.getParam("port").getValue().equalsIgnoreCase("undefined")) continue;
            int slotid = Integer.parseInt(row.getParam("slotid").getValue());
            int boardType = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid).getBoardType();
            List installPorts = TECircuitPackDescription.getInstance().getInstallCPPort(boardType);
            List<RowParams> newRows = TEGetResParaBean.getInstallPortRowParams(row, installPorts);
            tobeAddList.addAll(newRows);
            iterator.remove();
        }
        if (!tobeAddList.isEmpty()) {
            bussinessParams.getRowParamList().addAll(tobeAddList);
        }
    }

    private static List<RowParams> getInstallPortRowParams(RowParams row, List<TEInstallCPPortRecord> installPorts) {
        ArrayList<RowParams> installPortParam = new ArrayList<RowParams>();
        int portType = -1;
        if (row.getParam("porttype") != null) {
            try {
                portType = Integer.parseInt(row.getParam("porttype").getValue());
            }
            catch (NumberFormatException ex) {
                TELogFactory.getNormalLogger().info(ex.getMessage());
            }
        }
        for (int i = 0; i < installPorts.size(); ++i) {
            if (portType != -1 && installPorts.get((int)i).portType != portType) continue;
            for (int j = 0; j < installPorts.get((int)i).portIDList.size(); ++j) {
                String portid = String.valueOf(installPorts.get((int)i).portIDList.get(j));
                RowParams portRow = (RowParams)row.clone();
                if (portRow.getParam("port") != null) {
                    portRow.getParam("port").setValue(portid);
                } else {
                    portRow.addParam("port", String.valueOf(portid));
                }
                installPortParam.add(portRow);
            }
        }
        return installPortParam;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        Operation tmpOper = null;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            tmpOper = (Operation)operationList.get(i);
            if (!tmpOper.getName().equals("NSCMD_PTNETY_GET_CURRENT_RATE") || tmpOper.getOutputCount() <= 0) continue;
            Output tempOutput = tmpOper.getOutput()[0];
            tmpOper.clearOutput();
            tmpOper.addOutput(tempOutput);
        }
        this.outputData = TEGenCfgDataConvertor.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        this.adjustAttributes();
    }

    private void adjustAttributes() {
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        RowParams[] rowParamses = bussinessParams.getRowParams();
        RowParams rowParams = null;
        String temp = "";
        String portId = "";
        String portName = "";
        long ip = 0L;
        Param param = null;
        for (int i = bussinessParams.getRowParamsCount() - 1; i >= 0; --i) {
            rowParams = rowParamses[i];
            if (rowParams.getParamCount() > 0 && rowParams.getParamCount() <= 9) {
                bussinessParams.removeRowParams(i);
                continue;
            }
            if (null == rowParams.getParam("port")) continue;
            portId = rowParams.getParam("port").getValue();
            if (null != rowParams.getParam("PTNIF_PORT_ATTR_PORTNAME")) {
                portName = rowParams.getParam("PTNIF_PORT_ATTR_PORTNAME").getValue();
            }
            if (!"".equals(portName)) {
                rowParams.getParam("portname").setValue(portId + "(" + portName + ")");
            } else {
                String slotid = null;
                if (null == rowParams.getParam("slotid")) continue;
                slotid = rowParams.getParam("slotid").getValue();
                int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, Integer.parseInt(slotid));
                rowParams.getParam("portname").setValue(TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neid, Integer.parseInt(slotid), boardType, Integer.parseInt(portId)));
            }
            param = rowParams.getParam("ATTR_ETHOVERPTN_MAC_IPADDRESS");
            if (null != param && !INVALID_ATTRI.equals(param.getValue()) && !"".equals(param.getValue())) {
                ip = Long.valueOf(param.getValue());
                if (0xFFFFFFFFL == ip) {
                    rowParams.getParam("ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS").setValue(String.valueOf(255));
                }
                param.setValue(TEConvertUtil.ipToString((long)Long.valueOf(param.getValue())));
                param = rowParams.getParam("ATTR_ETHOVERPTN_MAC_IPMARSK");
                param.setValue(TEConvertUtil.ipToString((long)Long.valueOf(param.getValue())));
            } else {
                rowParams.addParam(new Param("ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS", String.valueOf(255)));
                rowParams.addParam(new Param("ATTR_ETHOVERPTN_MAC_IPADDRESS", String.valueOf(0xFFFFFFFFL)));
                rowParams.addParam(new Param("ATTR_ETHOVERPTN_MAC_IPMARSK", String.valueOf(0xFFFFFFFFL)));
                rowParams.addParam(new Param("ATTR_ETHOVERPTN_MAC_BORROWEDBOARDIPADDR", String.valueOf(65535)));
                rowParams.addParam(new Param("ATTR_ETHOVERPTN_MAC_BORROWEDPORTIPADDR", String.valueOf(65535)));
            }
            if (null != rowParams.getParam("ATTR_ETHOVERPTN_MAC_QINQ_TYPE") && !INVALID_ATTRI.equals(temp = rowParams.getParam("ATTR_ETHOVERPTN_MAC_QINQ_TYPE").getValue())) {
                rowParams.getParam("ATTR_ETHOVERPTN_MAC_QINQ_TYPE").setValue(this.insertToValue(temp, REGMENT, 2));
            }
            if (rowParams.getParam(SDHPORT_ATTR_MODE) == null) {
                rowParams.addParam(SDHPORT_ATTR_MODE, "1");
            } else if (null == rowParams.getParam(SDHPORT_ATTR_MODE).getValue()) {
                rowParams.getParam(SDHPORT_ATTR_MODE).setValue("1");
            }
            if (rowParams.getParam(ATTR_ETHOVERPTN_MAC_ENCAP_TYPE) == null) {
                rowParams.addParam(ATTR_ETHOVERPTN_MAC_ENCAP_TYPE, "0");
                continue;
            }
            if (null != rowParams.getParam(ATTR_ETHOVERPTN_MAC_ENCAP_TYPE).getValue() && !rowParams.getParam(ATTR_ETHOVERPTN_MAC_ENCAP_TYPE).getValue().equalsIgnoreCase(INVALID_ATTRI)) continue;
            rowParams.getParam(ATTR_ETHOVERPTN_MAC_ENCAP_TYPE).setValue("0");
        }
    }

    private String insertToValue(String value, String regment, int intervalcount) {
        StringBuffer temp = new StringBuffer(0);
        for (int i = 0; i < value.length(); i += intervalcount) {
            temp.append(value.substring(i, i + intervalcount)).append(regment);
        }
        if (temp.length() > 1) {
            return temp.toString().substring(0, temp.length() - 1);
        }
        return INVALID_ATTRI;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codeList = new ArrayList<Integer>();
        codeList.add(40004);
        codeList.add(38737);
        codeList.add(38671);
        codeList.add(42693);
        codeList.add(42165);
        codeList.add(37898);
        return codeList;
    }

    public boolean isNeedExpandOperObj(String attrId) {
        return true;
    }
}

