/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.eline_u2kv1r2c01;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.PortRes;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEBatchOperations;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEUsableResource;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TEEthUtil {
    private TEEthUtil() {
    }

    private static List getPorts(int neID, int slotid, int boardType) {
        ArrayList allPorts = TEConfigurationDataMgr.getInstance().getBoardPortList(neID, boardType);
        List existPorts = null;
        if (1171 == boardType || 1125 == boardType || 1134 == boardType || 1554 == boardType) {
            existPorts = com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEEthUtil.getExistPorts(neID, slotid);
        }
        if (existPorts == null || existPorts.isEmpty()) {
            return allPorts;
        }
        return existPorts;
    }

    public static List<TEUsableResource> getEthPorts(int neID) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        Vector boards = ne.getBoardList();
        ArrayList<TEUsableResource> usables = new ArrayList<TEUsableResource>();
        if (boards == null) {
            return usables;
        }
        TEConfigurationDataMgr dataMgr = TEConfigurationDataMgr.getInstance();
        int subBdId = 255;
        String subBdName = "";
        int size = boards.size();
        for (int i = 0; i < size; ++i) {
            String portName;
            int portID;
            ArrayList<PortRes> portLists;
            List tmpPorts;
            int j;
            TEBoard board = (TEBoard)boards.get(i);
            int slotID = board.getSlotID();
            int bdType = board.getBoardType();
            String bdName = board.getBoardName();
            if (bdType != 2088 && bdType != 2087 && bdType != 2083 && bdType != 2082 && bdType != 2417 && bdType != 2418 && bdType != 2455 && bdType != 2268 && bdType != 2079 && bdType != 2080 && bdType != 2266 && bdType != 2267 && bdType != 2474 && bdType != 2475 && bdType != 2468 && bdType != 2265 && bdType != 1410 && bdType != 1411 && bdType != 1607 && bdType != 1608 && bdType != 1413 && bdType != 1414 && bdType != 1415 && bdType != 1416 && bdType != 1404 && bdType != 1592 && bdType != 2416 && bdType != 2102 && bdType != 2471 && bdType != 2488 && bdType != 2489) continue;
            List subBoards = board.getSubBoardList();
            int subBdCnt = subBoards.size();
            if (subBdCnt > 0) {
                for (j = 0; j < subBdCnt; ++j) {
                    TEUsableResource usableRes;
                    TESubBoard subBoard = (TESubBoard)subBoards.get(j);
                    subBdId = subBoard.getSubSlotID();
                    int subBdType = subBoard.getSubBoardType();
                    tmpPorts = dataMgr.getBoardPortList(neID, subBdType);
                    portLists = new ArrayList(tmpPorts.size());
                    int leng = tmpPorts.size();
                    for (int k = 0; k < leng; ++k) {
                        portID = (Integer)tmpPorts.get(k);
                        portName = dataMgr.getPortNameForPTN(neID, slotID, subBdType, portID);
                        PortRes portres = new PortRes(portID, portName);
                        portLists.add(portres);
                    }
                    if (portLists.isEmpty() || usables.contains(usableRes = new TEUsableResource(slotID, bdName, subBdId, subBdName = dataMgr.getBoardTypeName(neID, subBdType), portLists))) continue;
                    usables.add(usableRes);
                }
                continue;
            }
            tmpPorts = TEEthUtil.getPorts(neID, slotID, bdType);
            portLists = new ArrayList<PortRes>(tmpPorts.size());
            int leng = tmpPorts.size();
            for (j = 0; j < leng; ++j) {
                TEUsableResource usableRes;
                portID = (Integer)tmpPorts.get(j);
                if (portID <= 16 && (bdType == 1410 || bdType == 1411 || bdType == 1607 || bdType == 1608) || (bdType == 1135 || bdType == 1137) && slotID % 2 == 0 && 32 == portID || bdType == 1133 && slotID % 4 == 2 && 12 == portID || bdType == 2102 && portID != 10) continue;
                portName = dataMgr.getPortNameForPTN(neID, slotID, bdType, portID);
                PortRes portres = new PortRes(portID, portName);
                portLists.add(portres);
                if (portLists.isEmpty() || usables.contains(usableRes = new TEUsableResource(slotID, bdName, subBdId, subBdName, portLists))) continue;
                usables.add(usableRes);
            }
        }
        return usables;
    }

    public static List<TEBatchOperations> createQueryPortAttrsOpers(int neID, Operation oper, boolean isVUni) {
        ArrayList<TEBatchOperations> batches = new ArrayList<TEBatchOperations>();
        int count = oper.getOutputCount();
        StringBuilder builder = new StringBuilder();
        String slot = "0";
        String subSlot = "0";
        String portID = "0";
        for (int i = 0; i < count; ++i) {
            ArrayList<Operation> opers = new ArrayList<Operation>();
            Output out = oper.getOutput(i);
            if (!out.getFault(0).getCode().equals("0")) continue;
            if (isVUni) {
                slot = out.getPart("slotid").getValue();
                subSlot = out.getPart("subslotid").getValue();
                portID = out.getPart("portid").getValue();
                opers.addAll(TEEthUtil.queryPortInfo(neID, slot, subSlot, portID));
            } else {
                Part part = out.getPart("carrierType");
                if (null == part) continue;
                int carryType = Integer.parseInt(part.getValue());
                if (3 == carryType) {
                    slot = out.getPart("carrierID1").getValue();
                    subSlot = out.getPart("carrierID2").getValue();
                    portID = out.getPart("carrierID3").getValue();
                    opers.addAll(TEEthUtil.queryPortInfo(neID, slot, subSlot, portID));
                } else if (1 == carryType) {
                    portID = out.getPart("carrierID3").getValue();
                    opers.addAll(TEEthUtil.queryPWInfo(portID, neID));
                }
            }
            builder.setLength(0);
            builder.append(slot);
            builder.append(":");
            builder.append(subSlot);
            builder.append(":");
            builder.append(portID);
            batches.add(new TEBatchOperations(false, opers, builder.toString()));
        }
        return batches;
    }

    private static List<Operation> queryPortInfo(int neid, String slot, String subSlot, String portID) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        operList.add(com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEEthUtil.createQueryPortAttrsOper(neid, "NSCMD_PTNETH_GET_ENABLE_EX", slot, subSlot, portID));
        operList.add(com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEEthUtil.createQueryPortAttrsOper(neid, "NSCMD_PTNETY_GET_WORKMODE_EX", slot, subSlot, portID));
        operList.add(com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEEthUtil.createQueryPortAttrsOper(neid, "NSCMD_L2PORTBASE_GET_ENCAPTYPE_EX", slot, subSlot, portID));
        operList.add(com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEEthUtil.createQueryPortAttrsOper(neid, "NSCMD_PTNETH_GET_TAG_EX", slot, subSlot, portID));
        return operList;
    }

    private static List<Operation> queryPWInfo(String pwIndex, int neid) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        if (null == pwIndex || "".equals(pwIndex)) {
            return operList;
        }
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_PW");
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_CW");
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_VCCV");
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_STATE");
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_ENABLE");
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_ETH_TPID");
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_ETH_REQVLAN");
        oper.getInput().setPartValue("pwIndex", pwIndex);
        operList.add(oper);
        return operList;
    }
}

