/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.eline_u2kv1r2c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;

public class TEElineUtil {
    public static final Hashtable<Integer, Set<Long>> ELINEIDLIST_CACHE = new Hashtable();
    private static final long START_ID = 1L;

    public static void refreshElineServiceIDCache(int neid, String paramName, Operation oper) {
        TreeSet<Long> serviceIDSet = new TreeSet<Long>();
        int count = oper.getOutputCount();
        for (int i = 0; i < count; ++i) {
            Output output = oper.getOutput(i);
            Part serviceIDPart = output.getPart(paramName);
            if (serviceIDPart == null || serviceIDPart.getValue() == null) continue;
            try {
                serviceIDSet.add(Long.parseLong(serviceIDPart.getValue()));
                continue;
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Refresh eline id cache failed beacause input error serviceid=" + serviceIDPart.getValue(), (Throwable)e);
                return;
            }
        }
        ELINEIDLIST_CACHE.put(neid, serviceIDSet);
    }

    public static void refreshElanServiceID(int neid) {
        int TIME_OUT = 60;
        Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_GET_ELANINFO_EX");
        Input input = operation.getInput();
        input.setPartValue("serviceIndex", "0");
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        operationList.add(operation);
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operationList, 60);
        if (null != result && result.retCode == 0) {
            Operation oper = (Operation)operationList.get(0);
            TreeSet<Long> serviceIDSet = new TreeSet<Long>();
            int count = oper.getOutputCount();
            for (int i = 0; i < count; ++i) {
                Output output;
                Part serviceIDPart;
                String errorCode = oper.getOutput(i).getFault(0).getCode();
                if (!String.valueOf(0).equals(errorCode) || (serviceIDPart = (output = oper.getOutput(i)).getPart("serviceID")) == null || serviceIDPart.getValue() == null) continue;
                try {
                    serviceIDSet.add(Long.parseLong(serviceIDPart.getValue()));
                    continue;
                }
                catch (NumberFormatException e) {
                    TELogFactory.getNormalLogger().error("Refresh eline id cache failed beacause input error serviceid=" + serviceIDPart.getValue(), (Throwable)e);
                }
            }
            if (ELINEIDLIST_CACHE.containsKey(neid)) {
                TELogFactory.getNormalLogger().info("Add ELAN id to cache!");
                ELINEIDLIST_CACHE.get(neid).addAll(serviceIDSet);
                TELogFactory.getNormalLogger().info("Cache:!" + ELINEIDLIST_CACHE.get(neid).toString());
            }
        }
    }

    public static void refreshEaggrServiceID(int neid) {
        int TIME_OUT = 60;
        Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_GET_EAGGRINFO");
        Input inputEaggr = operation.getInput();
        inputEaggr.setPartValue("serviceIndex", "0");
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        operationList.add(operation);
        OperationResult resultEaggr = TENECommMgr.getInstance().sendCommand(neid, operationList, 60);
        if (null != resultEaggr && resultEaggr.retCode == 0) {
            Operation operEaggr = (Operation)operationList.get(0);
            TreeSet<Long> serviceIDSet = new TreeSet<Long>();
            int count = operEaggr.getOutputCount();
            for (int i = 0; i < count; ++i) {
                Output outputEaggr;
                Part serviceIDPart;
                String errorCode = operEaggr.getOutput(i).getFault(0).getCode();
                if (!String.valueOf(0).equals(errorCode) || (serviceIDPart = (outputEaggr = operEaggr.getOutput(i)).getPart("serviceID")) == null || serviceIDPart.getValue() == null) continue;
                try {
                    serviceIDSet.add(Long.parseLong(serviceIDPart.getValue()));
                    continue;
                }
                catch (NumberFormatException ex) {
                    TELogFactory.getNormalLogger().error("Refresh eaggr id cache failed beacause input error serviceid=" + serviceIDPart.getValue(), (Throwable)ex);
                }
            }
            if (ELINEIDLIST_CACHE.containsKey(neid)) {
                TELogFactory.getNormalLogger().info("Add eaggr id to cache!");
                ELINEIDLIST_CACHE.get(neid).addAll(serviceIDSet);
                TELogFactory.getNormalLogger().info("Cache:!" + ELINEIDLIST_CACHE.get(neid).toString());
            }
        }
    }

    public static String getElineServiceID(int neid, RowParams row) {
        Param isAutoParam = row.getParam("isAuto");
        if (isAutoParam != null) {
            if (isAutoParam.getValue().equalsIgnoreCase("1")) {
                return String.valueOf(TEElineUtil.getAvailableElineID(neid));
            }
        } else {
            Param serviceIDParam = row.getParam("serviceID");
            if (serviceIDParam != null) {
                return serviceIDParam.getValue();
            }
        }
        return null;
    }

    public static synchronized long getAvailableElineID(int neid) {
        if (ELINEIDLIST_CACHE.containsKey(neid)) {
            Set<Long> idset = ELINEIDLIST_CACHE.get(neid);
            for (long i = 1L; i <= 0xFFFFFFFFL; ++i) {
                if (!idset.add(i)) continue;
                return i;
            }
            return -1L;
        }
        TreeSet<Long> idset = new TreeSet<Long>();
        idset.add(1L);
        ELINEIDLIST_CACHE.put(neid, idset);
        return 1L;
    }

    public static void remove(int neid, String serviceID, RowParams row, String serviceIndex, SubFunc subFunc) {
        if (serviceIndex == null) {
            return;
        }
        Param isAutoParam = row.getParam("isAuto");
        if (isAutoParam != null && isAutoParam.getValue().equalsIgnoreCase("1") && ELINEIDLIST_CACHE.containsKey(neid)) {
            ELINEIDLIST_CACHE.get(neid).remove(Long.parseLong(serviceID));
            if (!serviceIndex.isEmpty()) {
                Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_DEL_ETHSERV");
                oper.getInput().setPartValue("serviceIndex", serviceIndex);
                ArrayList<Operation> operList = new ArrayList<Operation>();
                operList.add(oper);
                TECommuNEMgr.getInstance().sendCommand(neid, operList, 20, subFunc);
            }
        }
    }

    public static void clearCache(int neid) {
        if (ELINEIDLIST_CACHE.containsKey(neid)) {
            ELINEIDLIST_CACHE.remove(neid);
        }
    }

    private TEElineUtil() {
    }
}

