/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.eline_fo;

import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.mdp.TEFInterfaceUtils;
import com.huawei.nglct.core.neproxy.TEProxyUtil;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nemgr.f_interface.genasn.AsnContent;
import com.huawei.nglct.nemgr.f_interface.genasn.AsnContentSQ;
import com.huawei.nglct.nemgr.f_interface.ptn.service.comm.AsnEthPtnL2Service;
import com.huawei.nglct.nemgr.f_interface.ptn.service.comm.AsnEthPtnVLANList;
import com.huawei.nglct.nemgr.f_interface.ptn.service.comm.AsnEthPtnVUNI;
import com.huawei.nglct.nemgr.f_interface.ptn.service.line.AsnEthPtnModElineVuniReq;
import com.huawei.nglct.nemgr.f_interface.ptn.service.line.AsnEthPtnModElineVuniRsp;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.eline_fo.TEFOElineUtils;
import com.huawei.nglct.nemgr.necommon.gencfg.InmAsnContent;
import com.huawei.nglct.nemgr.necommon.infconfig.InfUtil;
import com.huawei.nglct.nemgr.necommon.infconfig.TEPTNPort;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;

public class TESetResParaInterBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.user = user;
        this.ipAddress = ipAddress;
        ArrayList<RowErrors> errors = new ArrayList<RowErrors>();
        errors.addAll(this.modifyElineServiceUNI(neid, inputData));
        errors.addAll(this.modifyPortAttribute(neid, inputData));
        return this.constuctDataInterface(errors);
    }

    private Datainterface constuctDataInterface(List<RowErrors> errorList) {
        int result = 0;
        Datainterface output = new Datainterface();
        output.setBussinessParams(new BussinessParams());
        result = 0;
        if (!errorList.isEmpty()) {
            result = 2;
            RowParams errorRow = new RowParams();
            int len = errorList.size();
            for (int i = 0; i < len; ++i) {
                errorRow.addRowErrors(errorList.get(i));
            }
            output.getBussinessParams().addRowParams(errorRow);
        }
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        return output;
    }

    private List<RowErrors> modifyElineServiceUNI(int neid, Datainterface inputData) {
        ArrayList<RowErrors> errorList = new ArrayList<RowErrors>();
        int result = 0;
        AsnEthPtnL2Service service = this.getEthServiceObjFromInput(inputData);
        if (null != service) {
            AsnEthPtnModElineVuniReq req = new AsnEthPtnModElineVuniReq();
            req.neID = BigInteger.valueOf(neid);
            req.userID = BigInteger.valueOf(Long.parseLong(this.user));
            req.eline.service = service;
            AsnEthPtnModElineVuniRsp rsp = new AsnEthPtnModElineVuniRsp();
            result = TEFInterfaceUtils.sendCommand((String)this.ipAddress, (int)neid, (FStruct)req, (FStruct)rsp, (int)2106176);
            if (result == 0 && !rsp.result.isSuccess) {
                RowErrors error = TEFInterfaceUtils.convertRowErrors((int)neid, (int)rsp.result.retCode.intValue());
                error.addParam(new Param("serviceID", service.serviceID.toString()));
                error.addParam(new Param("serviceIndex", service.serviceIndex.toString()));
                errorList.add(error);
            }
        }
        return errorList;
    }

    private AsnEthPtnL2Service getEthServiceObjFromInput(Datainterface inputData) {
        RowParams[] rows = inputData.getBussinessParams().getRowParams();
        AsnEthPtnL2Service service = null;
        RowParams row2 = null;
        for (RowParams row2 : rows) {
            if (null == row2.getParam("serviceIndex") || "".equals(row2.getParam("serviceIndex").getValue())) continue;
            if (null == service) {
                service = new AsnEthPtnL2Service();
                TEFOElineUtils.initPtnLeService(service);
                service.serviceID = TEFInterfaceUtils.convertParam2BigInt((Param)row2.getParam("serviceID"));
                service.serviceIndex = TEFInterfaceUtils.convertParam2BigInt((Param)row2.getParam("serviceIndex"));
                service.serviceName = row2.getParam("serviceName").getValue().getBytes();
                service.bpduTrans = TEFInterfaceUtils.convertParam2BigInt((Param)row2.getParam("bpdu"));
            }
            AsnEthPtnVUNI uni = new AsnEthPtnVUNI();
            TEFOElineUtils.initPtnVUNI(uni);
            uni.role = BigInteger.valueOf(1L);
            uni.slotID = TEFInterfaceUtils.convertParam2BigInt((Param)row2.getParam("slotid"));
            uni.portID = TEFInterfaceUtils.convertPortParam2BigInt((Param)row2.getParam("port"));
            uni.vuniID = TEFInterfaceUtils.convertParam2BigInt((Param)row2.getParam("vuniID"));
            uni.vlanList = this.convertVlan(row2.getParam("tagID"));
            service.vuniList.add((Object)uni);
        }
        return service;
    }

    private List<RowErrors> modifyPortAttribute(int neid, Datainterface inputData) {
        ArrayList<RowErrors> errorList = new ArrayList<RowErrors>();
        RowParams[] rows = inputData.getBussinessParams().getRowParams();
        RowParams row2 = null;
        TEConfigurationDataMgr dataMgr = TEConfigurationDataMgr.getInstance();
        int slotid = 0;
        int portid = 0;
        for (RowParams row2 : rows) {
            slotid = Integer.parseInt(row2.getParam("slotid").getValue());
            portid = Integer.parseInt(row2.getParam("port").getValue());
            if (1802 == dataMgr.getPortType(neid, dataMgr.getBoardType(neid, slotid), portid)) {
                errorList.addAll(this.sendIFPortModify(neid, row2));
                continue;
            }
            errorList.addAll(this.sendEthPortModify(neid, row2));
        }
        return errorList;
    }

    private AsnEthPtnVLANList convertVlan(Param vlanparam) {
        AsnEthPtnVLANList vlanlist = new AsnEthPtnVLANList();
        if (null != vlanparam && !"".equals(vlanparam.getValue())) {
            ArrayList intValues = new ArrayList();
            boolean bResult = TEStringUtils.strToNumList((String)vlanparam.getValue(), intValues);
            if (bResult) {
                int len = intValues.size();
                for (int i = 0; i < len; ++i) {
                    vlanlist.add((Object)BigInteger.valueOf(((Integer)intValues.get(i)).intValue()));
                }
            }
        }
        return vlanlist;
    }

    private List<RowErrors> sendIFPortModify(int neid, RowParams row) {
        AsnContentSQ contentsq;
        InmAsnContent rsp;
        AsnContentSQ operObjectsq;
        ArrayList<RowErrors> erorList = new ArrayList<RowErrors>();
        InmAsnContent req = null;
        int slotid = Integer.parseInt(row.getParam("slotid").getValue());
        int portid = Integer.parseInt(row.getParam("portid").getValue());
        InmAsnContent operObject = null;
        ProcessInfo processInfo = new ProcessInfo();
        int result = TEProxyUtil.getProcessInfoFromNEID((int)neid, (ProcessInfo)processInfo);
        if (result != 0) {
            return erorList;
        }
        Param param = row.getParam("encapType");
        if (null != param && !"".equals(param.getValue())) {
            req = new InmAsnContent();
            req.sendIp = this.ipAddress;
            req.addIntField(65285, Integer.parseInt(this.user));
            operObjectsq = req.addAsnSQField(65296);
            operObject = this.constructAsnContent(neid, slotid, portid);
            operObject.addIntField(401637, Integer.parseInt(param.getValue()));
            operObjectsq.add((Object)operObject);
            if (operObjectsq.size() <= 0) {
                return erorList;
            }
            rsp = req.sendCommand(2172647, 60, processInfo);
            contentsq = rsp.getAsnSQFieldValue(65282);
            if (!contentsq.isEmpty()) {
                erorList.add(TEFInterfaceUtils.convertRowErrors((int)neid, (int)slotid, (int)portid, (int)InfUtil.fetchGenIntValue((AsnContentSQ)contentsq, (int)65280)));
            }
        }
        req = new InmAsnContent();
        req.addIntField(65285, Integer.parseInt(this.user));
        operObjectsq = req.addAsnSQField(65296);
        param = row.getParam("tag");
        if (null != param && !"".equals(param.getValue())) {
            operObject = this.constructAsnContent(neid, slotid, portid);
            operObject.addIntField(401706, Integer.parseInt(param.getValue()));
            operObjectsq.add((Object)operObject);
        }
        if (null != (param = row.getParam("vlanID")) && !"".equals(param.getValue())) {
            operObject = this.constructAsnContent(neid, slotid, portid);
            operObject.addIntField(401707, Integer.parseInt(param.getValue()));
            operObjectsq.add((Object)operObject);
        }
        if (null != (param = row.getParam("vlanPri")) && !"".equals(param.getValue())) {
            operObject = this.constructAsnContent(neid, slotid, portid);
            operObject.addIntField(401708, Integer.parseInt(param.getValue()));
            operObjectsq.add((Object)operObject);
        }
        if (operObjectsq.size() <= 0) {
            return erorList;
        }
        rsp = req.sendCommand(2172653, 60, processInfo);
        contentsq = rsp.getAsnSQFieldValue(65282);
        if (!contentsq.isEmpty()) {
            erorList.add(TEFInterfaceUtils.convertRowErrors((int)neid, (int)slotid, (int)portid, (int)InfUtil.fetchGenIntValue((AsnContentSQ)contentsq, (int)65280)));
        }
        return erorList;
    }

    private InmAsnContent constructAsnContent(int neid, int slotid, int portid) {
        InmAsnContent operObject = new InmAsnContent();
        int[] portobject = new int[]{61443, neid, slotid, TEQueryPortForDataMgr.getAbstractPortID((int)neid, (int)portid)};
        operObject.addIntListField(65283, portobject);
        return operObject;
    }

    private List<RowErrors> sendEthPortModify(int neid, RowParams row) {
        ArrayList<RowErrors> erorList = new ArrayList<RowErrors>();
        InmAsnContent req = new InmAsnContent();
        req.sendIp = this.ipAddress;
        req.addIntField(65281, neid);
        req.addIntField(10, Integer.parseInt(this.user));
        AsnContentSQ sq = req.addAsnSQField(5);
        int slotid = Integer.parseInt(row.getParam("slotid").getValue());
        int portid = Integer.parseInt(row.getParam("portid").getValue());
        TEPTNPort port = new TEPTNPort(neid, slotid, portid);
        InmAsnContent modifiedRowContent = new InmAsnContent();
        InfUtil.savePort((InmAsnContent)modifiedRowContent, (TEPTNPort)port, (int)1799);
        AsnContentSQ attList = modifiedRowContent.addAsnSQField(6);
        Param param = row.getParam("portEnable");
        if (null != param && !"".equals(param.getValue())) {
            attList.add((Object)InfUtil.saveIntAtt((int)1100, (int)Integer.parseInt(param.getValue())));
        }
        if (null != (param = row.getParam("workMode")) && !"".equals(param.getValue())) {
            attList.add((Object)InfUtil.saveIntAtt((int)1101, (int)Integer.parseInt(param.getValue())));
        }
        if (null != (param = row.getParam("encapType")) && !"".equals(param.getValue())) {
            int attrid = 102;
            modifiedRowContent.addAsnContentField(attrid, InfUtil.saveIntAtt((int)attrid, (int)Integer.parseInt(param.getValue())));
        }
        if (null != (param = row.getParam("tag")) && !"".equals(param.getValue())) {
            attList.add((Object)InfUtil.saveIntAtt((int)1301, (int)Integer.parseInt(param.getValue())));
        }
        if (null != (param = row.getParam("vlanID")) && !"".equals(param.getValue())) {
            attList.add((Object)InfUtil.saveIntAtt((int)13021, (int)Integer.parseInt(param.getValue())));
        }
        if (null != (param = row.getParam("vlanPri")) && !"".equals(param.getValue())) {
            attList.add((Object)InfUtil.saveIntAtt((int)13022, (int)Integer.parseInt(param.getValue())));
        }
        sq.add((Object)modifiedRowContent);
        ProcessInfo processInfo = new ProcessInfo();
        int result = TEProxyUtil.getProcessInfoFromNEID((int)neid, (ProcessInfo)processInfo);
        if (modifiedRowContent.size() <= 4 && attList.isEmpty() || result != 0) {
            return erorList;
        }
        InmAsnContent rsp = InfUtil.sendGCFCmd((InmAsnContent)req, (int)2106247, (int)240, (ProcessInfo)processInfo);
        result = null == rsp ? 1090744349 : rsp.getIntFieldValue(11);
        if (result == 0) {
            AsnContentSQ attriList = rsp.getAsnSQFieldValue(5);
            if (!attriList.isEmpty()) {
                InmAsnContent asncontent = new InmAsnContent((AsnContent)attriList.get(0));
                InmAsnContent asn = null;
                int len = TEFOElineUtils.ETH_ATTRIDS.length;
                for (int i = 0; i < len; ++i) {
                    asn = asncontent.getAsnFieldValue(TEFOElineUtils.ETH_ATTRIDS[i]);
                    if (null == asn || (result = asn.getIntFieldValue(11)) == 0) continue;
                    erorList.add(TEFInterfaceUtils.convertRowErrors((int)neid, (int)slotid, (int)portid, (int)result));
                }
            }
        } else {
            erorList.add(TEFInterfaceUtils.convertRowErrors((int)neid, (int)slotid, (int)portid, (int)result));
        }
        return erorList;
    }
}

