/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.eline_fo;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.mdp.TEFInterfaceUtils;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.f_interface.ptn.service.aggregation.AsnEthPtnGetVlanTblReq;
import com.huawei.nglct.nemgr.f_interface.ptn.service.aggregation.AsnEthPtnGetVlanTblRsp;
import com.huawei.nglct.nemgr.f_interface.ptn.service.aggregation.AsnEthPtnVlanFwdEntry;
import com.huawei.nglct.nemgr.f_interface.ptn.service.comm.AsnEthPtnVLANList;
import com.huawei.nglct.nemgr.f_interface.ptn.service.comm.AsnEthPtnVUNI;
import com.huawei.nglct.nemgr.f_interface.ptn.service.comm.AsnEthPtnVUNIList;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;

public class TEQueryFOVlanSwitchTableBean
extends TENEExplorerBean {
    private static final int VUNITYPE = 1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.user = user;
        this.ipAddress = ipAddress;
        RowParams row = inputData.getBussinessParams().getRowParams(0);
        boolean bFromNE = false;
        if (null != row.getParam("isFromNE") && "true".equals(row.getParam("isFromNE").getValue())) {
            bFromNE = true;
        }
        AsnEthPtnGetVlanTblReq req = new AsnEthPtnGetVlanTblReq();
        req.neID = BigInteger.valueOf(neid);
        req.userID = BigInteger.valueOf(Long.parseLong(user));
        req.serviceID = TEFInterfaceUtils.convertParam2BigInt((Param)row.getParam("serviceID"));
        req.srvIdx = TEFInterfaceUtils.convertParam2BigInt((Param)row.getParam("serviceIndex"));
        req.actState = TEFInterfaceUtils.convertParam2BigInt((Param)row.getParam("activestate"));
        int cmdCode = bFromNE ? 2179408 : 2179407;
        AsnEthPtnGetVlanTblRsp rsp = new AsnEthPtnGetVlanTblRsp();
        int result = TEFInterfaceUtils.sendCommand((String)this.ipAddress, (int)neid, (FStruct)req, (FStruct)rsp, (int)cmdCode);
        Datainterface output = new Datainterface();
        if (result == 0) {
            if (rsp.result.isSuccess) {
                BussinessParams bussiness = this.convertListToBussiness(neid, rsp);
                output.setBussinessParams(bussiness);
            } else if (rsp.result.retCode != null) {
                result = 2;
                output.setBussinessParams(TEFInterfaceUtils.convertErrorBussiness((int)neid, (int)rsp.result.retCode.intValue()));
            }
        }
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        return output;
    }

    private BussinessParams convertListToBussiness(int neid, AsnEthPtnGetVlanTblRsp rsp) {
        BussinessParams bussiness = new BussinessParams();
        RowParams row = null;
        AsnEthPtnVlanFwdEntry entry = null;
        if (rsp.vuniList != null) {
            int len = rsp.vuniList.size();
            for (int i = 0; i < len; ++i) {
                AsnEthPtnVUNI uni = (AsnEthPtnVUNI)rsp.vuniList.get(i);
                bussiness.addRowParams(this.convertRowParams(neid, uni));
            }
        }
        if (rsp.vfList != null) {
            int len = rsp.vfList.size();
            for (int i = 0; i < len; ++i) {
                entry = (AsnEthPtnVlanFwdEntry)rsp.vfList.get(i);
                row = new RowParams();
                row.addParam("vlanFwdID", entry.ftbID.toString());
                row.addParam("inLogicInfType", entry.inIFType.toString());
                row.addParam("inLogicInfID", entry.inIFID.toString());
                row.addParam("inVlanID", entry.inVLAN.toString());
                row.addParam("srcPort", this.getPortName(neid, rsp.vuniList, entry.inIFID.intValue()));
                row.addParam("outLogicInfType", entry.outIFType.toString());
                row.addParam("outLogicInfID", entry.outIFID.toString());
                row.addParam("outVlanID", entry.outVLAN.toString());
                row.addParam("sinkPort", this.getPortName(neid, rsp.vuniList, entry.outIFID.intValue()));
                bussiness.addRowParams(row);
            }
        }
        return bussiness;
    }

    private String getPortName(int neid, AsnEthPtnVUNIList uniList, int uniid) {
        String portName = "";
        if (uniList != null) {
            AsnEthPtnVUNI uni = null;
            int len = uniList.size();
            for (int i = 0; i < len; ++i) {
                uni = (AsnEthPtnVUNI)uniList.get(i);
                if (uni.vuniID.intValue() != uniid) continue;
                portName = TEFInterfaceUtils.getNodeName((int)neid, (int)uni.slotID.intValue(), (int)uni.portID.intValue());
                break;
            }
        }
        return portName;
    }

    public RowParams convertRowParams(int neid, AsnEthPtnVUNI uni) {
        RowParams rowParams = new RowParams();
        rowParams.addParam("slotid", uni.slotID.toString());
        rowParams.addParam("boardname", TEConfigurationDataMgr.getInstance().getBoardName(neid, uni.slotID.intValue()));
        int portid = TEConfigurationDataMgr.getPortRelativeID((int)uni.portID.intValue());
        rowParams.addParam("portid", String.valueOf(portid));
        rowParams.addParam("port", TEFInterfaceUtils.getNodeName((int)neid, (int)uni.slotID.intValue(), (int)portid));
        rowParams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, uni.slotID.intValue(), portid));
        rowParams.addParam("logicinftype", String.valueOf(1));
        rowParams.addParam("vuniid", uni.vuniID.toString());
        rowParams.addParam("vlan", this.convertVLAN2Str(uni.vlanList));
        return rowParams;
    }

    private String convertVLAN2Str(AsnEthPtnVLANList vlanlist) {
        StringBuffer vlansb = new StringBuffer();
        String sp = "";
        int len = vlanlist.size();
        for (int i = 0; i < len; ++i) {
            vlansb.append(sp).append(vlanlist.get(i));
            sp = ",";
        }
        return vlansb.toString();
    }
}

