/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.eline_fo;

import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.mdp.TEFInterfaceUtils;
import com.huawei.nglct.core.neproxy.TEProxyUtil;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.f_interface.genasn.AsnContent;
import com.huawei.nglct.nemgr.f_interface.genasn.AsnContentSQ;
import com.huawei.nglct.nemgr.f_interface.ptn.qinqlink.AsnPTNQinqLink;
import com.huawei.nglct.nemgr.f_interface.ptn.service.comm.AsnEthPtnL2Service;
import com.huawei.nglct.nemgr.f_interface.ptn.service.comm.AsnEthPtnVNNI;
import com.huawei.nglct.nemgr.f_interface.ptn.service.comm.AsnEthPtnVUNI;
import com.huawei.nglct.nemgr.ip.ptn.common.TESlotPort;
import com.huawei.nglct.nemgr.necommon.gencfg.InmAsnContent;
import com.huawei.nglct.nemgr.necommon.infconfig.InfUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class TEFOElineUtils {
    private static final String UNI_UNI = "2";
    private static final String UNI_NNI = "1";
    private static final int ACTIVE = 1;
    public static final int ROLE_ROOT = 1;
    public static final int[] ETH_ATTRIDS = new int[]{100, 1100, 1101, 102, 1301, 13021, 13022};
    public static final int[] MW_ATTRIDS = new int[]{401665, 401637, 401706, 401707, 401708};

    private TEFOElineUtils() {
    }

    public static void initPtnLeService(AsnEthPtnL2Service l2Service) {
        if (null != l2Service) {
            l2Service.serviceID = BigInteger.valueOf(-1L);
            l2Service.serviceIndex = BigInteger.valueOf(-1L);
            l2Service.activateState = BigInteger.valueOf(-1L);
            l2Service.mtu = BigInteger.valueOf(-1L);
            l2Service.bpduTrans = BigInteger.valueOf(-1L);
            l2Service.tagRole = BigInteger.valueOf(-1L);
            l2Service.serviceName = new byte[0];
        }
    }

    public static void initPtnVUNI(AsnEthPtnVUNI uni) {
        if (null != uni) {
            uni.slotID = BigInteger.valueOf(-1L);
            uni.portID = BigInteger.valueOf(-1L);
            uni.vuniID = BigInteger.valueOf(-1L);
            uni.role = BigInteger.valueOf(-1L);
            uni.svlanID = BigInteger.valueOf(-1L);
            uni.unknowP2Mchk = BigInteger.valueOf(-1L);
            uni.unknowP2Pchk = BigInteger.valueOf(-1L);
            uni.broadcastchk = BigInteger.valueOf(-1L);
            uni.broadcastenable = BigInteger.valueOf(-1L);
        }
    }

    public static void initPtnVNNI(AsnEthPtnVNNI nni) {
        if (null != nni) {
            nni.vnniID = BigInteger.valueOf(-1L);
            nni.role = BigInteger.valueOf(-1L);
            nni.carrierType = BigInteger.valueOf(-1L);
            nni.carrierIdx1 = BigInteger.valueOf(-1L);
            nni.carrierIdx2 = BigInteger.valueOf(-1L);
        }
    }

    public static RowParams convertObjectToRowParams(int neid, AsnEthPtnL2Service service) {
        RowParams row = new RowParams();
        row.addParam("serviceIndex", TEFInterfaceUtils.convertBigInt2Str((BigInteger)service.serviceIndex));
        row.addParam("serviceID", TEFInterfaceUtils.convertBigInt2Str((BigInteger)service.serviceID));
        row.addParam("serviceName", new String(service.serviceName));
        row.addParam("maxPackageLen", TEFInterfaceUtils.convertBigInt2Str((BigInteger)service.mtu));
        row.addParam("bpdu", TEFInterfaceUtils.convertBigInt2Str((BigInteger)service.bpduTrans));
        row.addParam("beareindex", "0");
        row.addParam("tagrole", TEFInterfaceUtils.convertBigInt2Str((BigInteger)service.tagRole));
        row.addParam("activestate", TEFInterfaceUtils.convertBigInt2Str((BigInteger)service.activateState));
        if (service.vuniList.size() >= 2) {
            row.addParam("direction", UNI_UNI);
            AsnEthPtnVUNI sourceUni = (AsnEthPtnVUNI)service.vuniList.get(0);
            AsnEthPtnVUNI sinkUni = (AsnEthPtnVUNI)service.vuniList.get(1);
            int sroucePort = TEConfigurationDataMgr.getPortRelativeID((int)sourceUni.portID.intValue());
            int sinkPort = TEConfigurationDataMgr.getPortRelativeID((int)sinkUni.portID.intValue());
            row.addParam("sourceNode", TEFInterfaceUtils.getNodeName((int)neid, (int)sourceUni.slotID.intValue(), (int)sroucePort));
            row.addParam("sinkNode", TEFInterfaceUtils.getNodeName((int)neid, (int)sinkUni.slotID.intValue(), (int)sinkPort));
            row.addParam("sourceslot", sourceUni.slotID.toString());
            row.addParam("sinkslot", sinkUni.slotID.toString());
            row.addParam("sourceport", String.valueOf(sroucePort));
            row.addParam("sinkport", String.valueOf(sinkPort));
            row.addParam("sourcevlan", TEFInterfaceUtils.convertVLAN2Str((List)sourceUni.vlanList));
            row.addParam("sinkvlan", TEFInterfaceUtils.convertVLAN2Str((List)sinkUni.vlanList));
            row.addParam("sourcevuniid", sourceUni.vuniID.toString());
            row.addParam("sinkvuniid", sinkUni.vuniID.toString());
        } else if (service.vuniList.size() >= 1 && service.vnniList.size() >= 1) {
            row.addParam("direction", UNI_NNI);
            AsnEthPtnVUNI sourceUni = (AsnEthPtnVUNI)service.vuniList.get(0);
            int sroucePort = TEConfigurationDataMgr.getPortRelativeID((int)sourceUni.portID.intValue());
            row.addParam("sourceNode", TEFInterfaceUtils.getNodeName((int)neid, (int)sourceUni.slotID.intValue(), (int)sroucePort));
            row.addParam("sourceslot", sourceUni.slotID.toString());
            row.addParam("sourceport", String.valueOf(sroucePort));
            row.addParam("sourcevlan", TEFInterfaceUtils.convertVLAN2Str((List)sourceUni.vlanList));
            row.addParam("sourcevuniid", sourceUni.vuniID.toString());
            AsnEthPtnVNNI sinkNni = (AsnEthPtnVNNI)service.vnniList.get(0);
            row.addParam("sinkNode", sinkNni.qinqLnk.lnkID.toString());
            row.addParam("sinkslot", sinkNni.qinqLnk.slotID.toString());
            row.addParam("sinkport", sinkNni.qinqLnk.portID.toString());
            row.addParam("sinkportname", TEFInterfaceUtils.getNodeName((int)neid, (int)sinkNni.qinqLnk.slotID.intValue(), (int)sinkNni.qinqLnk.portID.intValue()));
            row.addParam("sinkvlan", sinkNni.qinqLnk.svlanID.toString());
            row.addParam("sinkvuniid", sinkNni.vnniID.toString());
        }
        return row;
    }

    public static AsnEthPtnL2Service convertRowParamsToObject(Datainterface inputData) {
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        RowParams row = rowParams[0];
        AsnEthPtnL2Service elineService = new AsnEthPtnL2Service();
        TEFOElineUtils.initPtnLeService(elineService);
        elineService.serviceIndex = TEFInterfaceUtils.convertParam2BigInt((Param)row.getParam("serviceIndex"));
        elineService.serviceID = TEFInterfaceUtils.convertParam2BigInt((Param)row.getParam("serviceID"));
        elineService.serviceName = null == row.getParam("serviceName") ? "".getBytes() : row.getParam("serviceName").getValue().getBytes();
        elineService.bpduTrans = TEFInterfaceUtils.convertParam2BigInt((Param)row.getParam("bpdu"));
        elineService.mtu = BigInteger.valueOf(0L);
        elineService.activateState = BigInteger.valueOf(1L);
        elineService.tagRole = BigInteger.valueOf(-1L);
        TEFOElineUtils.appendUNINNIFromRowParam(elineService, rowParams[1]);
        TEFOElineUtils.appendUNINNIFromRowParam(elineService, rowParams[2]);
        return elineService;
    }

    public static void appendUNINNIFromRowParam(AsnEthPtnL2Service elineService, RowParams row) {
        if (null != row.getParam("portType") && "uni".equalsIgnoreCase(row.getParam("portType").getValue())) {
            AsnEthPtnVUNI uni = new AsnEthPtnVUNI();
            TEFOElineUtils.initPtnVUNI(uni);
            uni.slotID = TEFInterfaceUtils.convertParam2BigInt((Param)row.getParam("slotid"));
            uni.portID = TEFInterfaceUtils.convertPortParam2BigInt((Param)row.getParam("portid"));
            uni.vuniID = TEFInterfaceUtils.convertParam2BigInt((Param)row.getParam("vuniID"));
            uni.role = BigInteger.valueOf(1L);
            if (null != row.getParam("tagid") && !row.getParam("tagid").getValue().isEmpty()) {
                ArrayList vlans = new ArrayList();
                TEStringUtils.strToNumList((String)row.getParam("tagid").getValue(), vlans);
                int len = vlans.size();
                for (int i = 0; i < len; ++i) {
                    uni.vlanList.add((Object)BigInteger.valueOf(((Integer)vlans.get(i)).intValue()));
                }
            }
            elineService.vuniList.add((Object)uni);
        }
        if (null != row.getParam("portType") && "nni".equalsIgnoreCase(row.getParam("portType").getValue())) {
            AsnEthPtnVNNI nni = new AsnEthPtnVNNI();
            TEFOElineUtils.initPtnVNNI(nni);
            nni.vnniID = BigInteger.valueOf(0L);
            nni.role = BigInteger.valueOf(1L);
            nni.qinqLnk = TEFOElineUtils.createAsnPTNQinqLink();
            nni.qinqLnk.lnkID = TEFInterfaceUtils.convertParam2BigInt((Param)row.getParam("carrier3"));
            nni.carrierType = TEFInterfaceUtils.convertParam2BigInt((Param)row.getParam("carrierType"));
            nni.carrierIdx1 = TEFInterfaceUtils.convertParam2BigInt((Param)row.getParam("carrier1"));
            nni.carrierIdx2 = TEFInterfaceUtils.convertParam2BigInt((Param)row.getParam("carrier3"));
            elineService.vnniList.add((Object)nni);
        }
    }

    private static AsnPTNQinqLink createAsnPTNQinqLink() {
        AsnPTNQinqLink qinqLink = new AsnPTNQinqLink();
        qinqLink.lnkID = BigInteger.valueOf(-1L);
        qinqLink.portID = BigInteger.valueOf(-1L);
        qinqLink.slotID = BigInteger.valueOf(-1L);
        qinqLink.svlanID = BigInteger.valueOf(-1L);
        return qinqLink;
    }

    private static List<RowParams> parseEthRspObject(int neid, InmAsnContent rsp, List<TESlotPort> ports) {
        ArrayList<RowParams> rowList = new ArrayList<RowParams>();
        RowParams rowparams = null;
        AsnContentSQ attriList = rsp.getAsnSQFieldValue(5);
        if (!attriList.isEmpty()) {
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            int len = attriList.size();
            for (int i = 0; i < len; ++i) {
                int portid;
                AsnContent content = (AsnContent)attriList.get(i);
                InmAsnContent basicAttr = new InmAsnContent(content);
                int slotid = basicAttr.getIntFieldValue(2);
                if (!ports.contains(new TESlotPort(slotid, portid = TEConfigurationDataMgr.getPortRelativeID((int)basicAttr.getIntFieldValue(3)), 1799))) continue;
                AsnContentSQ rowAttriList = basicAttr.getAsnSQFieldValue(6);
                rowparams = new RowParams();
                rowparams.addParam("neid", String.valueOf(neid));
                rowparams.addParam("nename", ne.getNEName());
                rowparams.addParam("slotid", String.valueOf(slotid));
                rowparams.addParam("boardname", TEConfigurationDataMgr.getInstance().getBoardName(neid, slotid));
                rowparams.addParam("portid", String.valueOf(portid));
                Param param = new Param("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, portid));
                String portname = InfUtil.fetchStrValue((AsnContentSQ)rowAttriList, (int)100);
                if (!portname.isEmpty()) {
                    param.setValue(portid + "(" + portname + ")");
                }
                InmAsnContent encapeContent = basicAttr.getAsnFieldValue(102);
                int encapeType = 0;
                encapeType = null != encapeContent ? encapeContent.getIntFieldValue(7) : InfUtil.fetchIntValue((AsnContentSQ)rowAttriList, (int)102);
                rowparams.addParam(param);
                rowparams.addParam("portEnable", String.valueOf(InfUtil.fetchIntValue((AsnContentSQ)rowAttriList, (int)1100)));
                rowparams.addParam("workMode", String.valueOf(InfUtil.fetchIntValue((AsnContentSQ)rowAttriList, (int)1101)));
                rowparams.addParam("encapType", String.valueOf(encapeType));
                rowparams.addParam("tag", String.valueOf(InfUtil.fetchIntValue((AsnContentSQ)rowAttriList, (int)1301)));
                rowparams.addParam("vlanID", String.valueOf(InfUtil.fetchIntValue((AsnContentSQ)rowAttriList, (int)13021)));
                rowparams.addParam("vlanPri", String.valueOf(InfUtil.fetchIntValue((AsnContentSQ)rowAttriList, (int)13022)));
                rowList.add(rowparams);
            }
        }
        return rowList;
    }

    private static List<RowParams> parseIFRspObject(int neid, InmAsnContent rsp, TESlotPort port) {
        ArrayList<RowParams> rowList = new ArrayList<RowParams>();
        AsnContentSQ attriList = rsp.getAsnSQFieldValue(65282);
        RowParams rowparams = null;
        if (!attriList.isEmpty()) {
            int slotid = port.getSlotid();
            int portid = port.getPort();
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            rowparams = new RowParams();
            rowparams.addParam("neid", String.valueOf(neid));
            rowparams.addParam("nename", ne.getNEName());
            rowparams.addParam("slotid", String.valueOf(slotid));
            rowparams.addParam("boardname", TEConfigurationDataMgr.getInstance().getBoardName(neid, slotid));
            rowparams.addParam("portid", String.valueOf(portid));
            Param param = new Param("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, portid));
            String portname = InfUtil.fetchGenStrValue((AsnContentSQ)attriList, (int)401665);
            if (!portname.isEmpty()) {
                param.setValue(portid + "(" + portname + ")");
            }
            rowparams.addParam(param);
            rowparams.addParam("encapType", String.valueOf(InfUtil.fetchGenIntValue((AsnContentSQ)attriList, (int)401637)));
            rowparams.addParam("tag", String.valueOf(InfUtil.fetchGenIntValue((AsnContentSQ)attriList, (int)401706)));
            rowparams.addParam("vlanID", String.valueOf(InfUtil.fetchGenIntValue((AsnContentSQ)attriList, (int)401707)));
            rowparams.addParam("vlanPri", String.valueOf(InfUtil.fetchGenIntValue((AsnContentSQ)attriList, (int)401708)));
            rowList.add(rowparams);
        }
        return rowList;
    }

    public static List<RowParams> queryEthPortAttribute(String ipAddress, int neid, int userid, List<TESlotPort> ports, boolean bFromNE) {
        InmAsnContent rsp;
        ArrayList<RowParams> rsps = new ArrayList<RowParams>();
        ProcessInfo processInfo = new ProcessInfo();
        int result = TEProxyUtil.getProcessInfoFromNEID((int)neid, (ProcessInfo)processInfo);
        if (result != 0 || ports.isEmpty()) {
            return rsps;
        }
        TESlotPort port = ports.get(0);
        InmAsnContent req = new InmAsnContent();
        req.sendIp = ipAddress;
        req.addIntField(10, userid);
        req.addIntField(65281, neid);
        req.addIntField(12, 1799);
        InfUtil.stuffAttrIDs((InmAsnContent)req, (int[])ETH_ATTRIDS, (int)neid, (int)port.getSlotid(), (int)0, (int)1799);
        req.addIntField(2, port.getSlotid());
        int cmdID = 2106248;
        if (bFromNE) {
            cmdID = 2106350;
        }
        if (null != (rsp = InfUtil.sendGCFCmd((InmAsnContent)req, (int)cmdID, (int)60, (ProcessInfo)processInfo))) {
            rsps.addAll(TEFOElineUtils.parseEthRspObject(neid, rsp, ports));
        }
        return rsps;
    }

    public static List<RowParams> queryIFPortAttribute(String ipAddress, int neid, int userid, List<TESlotPort> ports, boolean bFromNE) {
        ArrayList<RowParams> rsps = new ArrayList<RowParams>();
        ProcessInfo processInfo = new ProcessInfo();
        int result = TEProxyUtil.getProcessInfoFromNEID((int)neid, (ProcessInfo)processInfo);
        if (result != 0 || ports.isEmpty()) {
            return rsps;
        }
        TESlotPort port = ports.get(0);
        InmAsnContent req = new InmAsnContent();
        req.addIntField(65285, userid);
        req.sendIp = ipAddress;
        InmAsnContent operObjectField = req.addAsnContentField(65281);
        int[] portobject = new int[]{61442, neid, port.getSlotid()};
        operObjectField.addIntListField(65283, portobject);
        req.addIntListField(65288, MW_ATTRIDS);
        if (bFromNE) {
            req.addIntField(65284, 1);
        } else {
            req.addIntField(65284, 0);
        }
        InmAsnContent rsp = req.sendCommand(2172654, 60, processInfo);
        if (null != rsp) {
            rsps.addAll(TEFOElineUtils.parseIFRspObject(neid, rsp, port));
        }
        return rsps;
    }

    public static Datainterface getPortAttribute(String ipAddress, int neid, int userid, List<TESlotPort> ports, boolean bFromNE) {
        TESlotPort port = null;
        ArrayList<TESlotPort> ifPorts = new ArrayList<TESlotPort>();
        ArrayList<TESlotPort> ethPorts = new ArrayList<TESlotPort>();
        int len = ports.size();
        for (int i = 0; i < len; ++i) {
            port = ports.get(i);
            if (port.getPortType() == 1802) {
                ifPorts.add(port);
                continue;
            }
            ethPorts.add(port);
        }
        ArrayList<RowParams> list = new ArrayList<RowParams>();
        if (!ethPorts.isEmpty()) {
            list.addAll(TEFOElineUtils.queryEthPortAttribute(ipAddress, neid, userid, ethPorts, bFromNE));
        }
        if (!ifPorts.isEmpty()) {
            list.addAll(TEFOElineUtils.queryIFPortAttribute(ipAddress, neid, userid, ifPorts, bFromNE));
        }
        Datainterface output = new Datainterface();
        output.setBussinessParams(new BussinessParams());
        RowParams row = null;
        int len2 = list.size();
        for (int i = 0; i < len2; ++i) {
            row = (RowParams)list.get(i);
            if (null == row) continue;
            output.getBussinessParams().addRowParams(row);
        }
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return output;
    }
}

